/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;
import kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl.DynamicQuotaCalculateImpl;
import kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl.FixedQuotaCalculateImpl;
import kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl.QuotaCalculateServiceImpl;
import kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl.SupermeQuotaCalculateImpl;

public class QuotaStrategyImpl
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuotaStrategyImpl.class);
    private static QuotaCalculateService quotaCalculateService;

    private QuotaStrategyImpl() {
    }

    public static QuotaCalculateService invokeQuotaServiceImpl(String enumType) throws KDBizException {
        if (enumType == null || "".equals(enumType)) {
            quotaCalculateService = new QuotaCalculateServiceImpl();
            log.error("\u8def\u7531\u7c7b\u578b\u4e2d\u4e0d\u5b58\u5728\u8be5\u65b9\u6848\uff1a" + enumType + "\uff0c\u6240\u4ee5\u8fd4\u56de\u4e0d\u8ba1\u7b97\u7684\u7a7a\u5bf9\u8c61\uff01\uff01\uff01");
        } else if ("A".equals(enumType)) {
            quotaCalculateService = new FixedQuotaCalculateImpl();
        } else if ("B".equals(enumType)) {
            quotaCalculateService = new SupermeQuotaCalculateImpl();
        } else if ("C".equals(enumType)) {
            quotaCalculateService = new DynamicQuotaCalculateImpl();
        }
        return quotaCalculateService;
    }

    public static QuotaCalculateService invokeQuotaServiceImpl() throws KDBizException {
        quotaCalculateService = new QuotaCalculateServiceImpl();
        return quotaCalculateService;
    }

    public List<QuotaCalculateResultDTO> quotaCalculateServiceImpl(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        List<QuotaCalculateResultDTO> quotaCalculateServiceImpl = quotaCalculateService.quotaCalculateServiceImpl(quotaCalculateRawdata);
        return quotaCalculateServiceImpl;
    }

    public List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        List<QuotamsOutParamterDTO> quotaCalculateServiceImpl = quotaCalculateService.quotaCalculateMServiceImpl(quotaCalculateRawdata);
        return quotaCalculateServiceImpl;
    }

    @Override
    public void close() throws Exception {
        log.error(System.currentTimeMillis() + "JVM\u81ea\u52a8\u5173\u95ed\u6d41\u51fa\u73b0\u4e86\u5f02\u5e38\u3002");
    }
}

