/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel.pojo;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class DynamicQuotaRateInfo {
    private int rank;
    private BigDecimal surplusRate;
    private DynamicObject supplierid;

    public static DynamicQuotaRateInfo acceptDynamicQuotaRate(DynamicObject supplierid, Integer rank, BigDecimal surplusRate) {
        DynamicQuotaRateInfo dto = new DynamicQuotaRateInfo();
        if (rank != null) {
            dto.setRank(rank);
        }
        if (surplusRate != null) {
            dto.setSurplusRate(surplusRate);
        }
        if (supplierid != null) {
            dto.setSupplierid(supplierid);
        }
        return dto;
    }

    public static List<DynamicQuotaRateInfo> sortDynamicQuota(List<DynamicQuotaRateInfo> listdata) {
        ComparatorChain chain = new ComparatorChain();
        chain.addComparator((Comparator)new BeanComparator("rank"), false);
        chain.addComparator((Comparator)new BeanComparator("surplusRate"), true);
        Collections.sort(listdata, chain);
        return listdata;
    }

    public int getRank() {
        return this.rank;
    }

    private void setRank(int rank) {
        this.rank = rank;
    }

    public BigDecimal getSurplusRate() {
        return this.surplusRate;
    }

    private void setSurplusRate(BigDecimal surplusRate) {
        this.surplusRate = surplusRate;
    }

    public DynamicObject getSupplierid() {
        return this.supplierid;
    }

    private void setSupplierid(DynamicObject supplierid) {
        this.supplierid = supplierid;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DynamicQuotaRateInfo {rank=");
        builder.append(this.rank);
        builder.append(", surplusRate=");
        builder.append(this.surplusRate);
        builder.append(", supplierid=");
        builder.append(this.supplierid);
        builder.append('}');
        return builder.toString();
    }
}

