/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.QuotaCalculImpHelper;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;

public class SupermeQuotaCalculateImpl
extends QuotaCalculateService {
    private static final Log log = LogFactory.getLog(SupermeQuotaCalculateImpl.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String BILLNO = "billno";
    private static final int zero = 0;

    @Override
    public List<QuotaCalculateResultDTO> quotaCalculateServiceImpl(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u5f00\u59cb\u6309\u7167\u6700\u9ad8\u914d\u989d\u8fdb\u884c\u8ba1\u7b97.");
        DynamicObject purApplyEntry = quotaCalculateRawdata.getPurApplyEntry();
        DynamicObject quotaAssign = quotaCalculateRawdata.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        Map<Object, DynamicObject> units = quotaCalculateRawdata.getUnits();
        Date bizTime = quotaCalculateRawdata.getBizTime();
        Long billId = purApplyEntry.getLong("id");
        Long entryId = purApplyEntry.getLong("billentry.id");
        Long orgid = purApplyEntry.getLong("org");
        Long materialId = purApplyEntry.getLong("billentry.material");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        Long unitId = purApplyEntry.getLong("billentry.unit");
        Long baseUnitId = purApplyEntry.getLong("billentry.baseunit");
        Long auxUnitId = purApplyEntry.getLong("billentry.auxunit");
        DynamicObject resultUnit = units.get(unitId);
        DynamicObject baseUnit = units.get(baseUnitId);
        DynamicObject auxUnit = null;
        if (auxUnitId != null && auxUnitId != 0L) {
            auxUnit = units.get(auxUnitId);
        }
        BigDecimal qty = purApplyEntry.getBigDecimal("billentry.qty");
        BigDecimal joinQty = purApplyEntry.getBigDecimal("billentry.joinqty");
        BigDecimal remainQty = qty.subtract(joinQty);
        BigDecimal baseQty = purApplyEntry.getBigDecimal("billentry.baseqty");
        BigDecimal baseJoinQty = purApplyEntry.getBigDecimal("billentry.joinbaseqty");
        BigDecimal baseRemainQty = baseQty.subtract(baseJoinQty);
        BigDecimal auxQty = purApplyEntry.getBigDecimal("billentry.auxqty");
        BigDecimal remainAuxQty = auxQty.multiply(baseRemainQty).divide(baseQty, BillQtyAndUnitHelper.getPrecision(auxUnit), BillQtyAndUnitHelper.getPrecisionType(auxUnit));
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        ArrayList<QuotaCalculateResultDTO> calculateResult = new ArrayList<QuotaCalculateResultDTO>(16);
        block0: for (DynamicObject entry : entries) {
            if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
            int rank = 0;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (i == 0) {
                    rank = subEntry.getInt("supplyrank");
                    continue;
                }
                if (rank <= subEntry.getInt("supplyrank")) continue;
                rank = subEntry.getInt("supplyrank");
            }
            BigDecimal maxRate = ZERO;
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (subEntry.getInt("supplyrank") != rank) continue;
                maxRate = i == 0 ? subEntry.getBigDecimal("quotarate") : maxRate.max(subEntry.getBigDecimal("quotarate"));
            }
            int j = 0;
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (j != 0) continue block0;
                if (subEntry.getInt("supplyrank") != rank || subEntry.getBigDecimal("quotarate").compareTo(maxRate) != 0) continue;
                DynamicObject supplier = subEntry.getDynamicObject("supplier");
                Long supplierid = (Long)supplier.getPkValue();
                QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateQuotaQty(supplierid, orgid, materialId, baseRemainQty, baseUnit, materialmasterid);
                BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                BigDecimal minbillqty = sourceDTO.getMinbillqty();
                BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                BigDecimal quotaQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, quotaBaseQty, resultUnit);
                maxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, maxbillqty, resultUnit);
                minbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, minbillqty, resultUnit);
                if (remainAuxQty.compareTo(ZERO) > 0) {
                    remainAuxQty = QuotaCalculImpHelper.changeAuxQty(material, auxUnit, resultUnit, quotaQty);
                }
                Integer supplyrank = (Integer)subEntry.get("supplyrank");
                QuotaCalculateResultDTO acceptGenerateResult = QuotaCalculateResultDTO.acceptGenerateResult(material, supplier, quotaQty, resultUnit, remainAuxQty, auxUnit, quotaSchema, subEntry.getBigDecimal("quotarate"), supplyrank, remainQty, billId, entryId, quotaBaseQty, maxbillqty, minbillqty, packagebatchqty, baseUnit);
                calculateResult.add(acceptGenerateResult);
                ++j;
            }
        }
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u7ed3\u675f\u6700\u9ad8\u914d\u989d\u8fdb\u884c\u8ba1\u7b97\u3002");
        return calculateResult;
    }

    @Override
    public List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl(QuotaCalculateDTO quotaMSCalculate) throws KDBizException {
        DynamicObject quotaAssign = quotaMSCalculate.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        QuotamsInDetailDTO quotaMSTemplate = quotaMSCalculate.getQuotaMSTemplate();
        Long srcBillId = quotaMSTemplate.getSrcBillId();
        Long srcBillEntryId = quotaMSTemplate.getSrcBillEntryId();
        Long materialId = quotaMSTemplate.getMaterialId();
        BigDecimal remainBaseQty = quotaMSTemplate.getSurplusBaseQty();
        LocalDate quotaTime = quotaMSCalculate.getQuotaTime();
        LocalDateTime todaystart = LocalDateTime.of(quotaTime, LocalTime.MIN);
        Date bizTime = Date.from(todaystart.atZone(ZoneId.systemDefault()).toInstant());
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        Long orgId = quotaMSCalculate.getOrgId();
        DynamicObject baseUnit = quotaMSCalculate.getBaseUnit();
        ArrayList<QuotamsOutParamterDTO> calculateResult = new ArrayList<QuotamsOutParamterDTO>(16);
        Long baseUnitId = (Long)baseUnit.getPkValue();
        Long quotaId = (Long)quotaSchema.getPkValue();
        String quotaPattern = quotaSchema.getString("quotatype");
        block0: for (DynamicObject entry : entries) {
            if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
            int rank = 0;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (i == 0) {
                    rank = subEntry.getInt("supplyrank");
                    continue;
                }
                if (rank <= subEntry.getInt("supplyrank")) continue;
                rank = subEntry.getInt("supplyrank");
            }
            BigDecimal maxRate = ZERO;
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (subEntry.getInt("supplyrank") != rank) continue;
                maxRate = i == 0 ? subEntry.getBigDecimal("quotarate") : maxRate.max(subEntry.getBigDecimal("quotarate"));
            }
            int j = 0;
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                if (j != 0) continue block0;
                if (subEntry.getInt("supplyrank") != rank || subEntry.getBigDecimal("quotarate").compareTo(maxRate) != 0) continue;
                DynamicObject supplier = subEntry.getDynamicObject("supplier");
                Long supplierid = (Long)supplier.getPkValue();
                BigDecimal quotaPercentage = subEntry.getBigDecimal("quotarate");
                QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateMSQuotaQty(supplierid, orgId, materialId, remainBaseQty, baseUnit, bizTime, materialmasterid);
                BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                BigDecimal minbillqty = sourceDTO.getMinbillqty();
                BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                QuotamsOutParamterDTO acceptResult = QuotamsOutParamterDTO.acceptResult(supplierid, orgId, materialId, srcBillId, srcBillEntryId, quotaBaseQty, baseUnitId, remainBaseQty, quotaId, quotaPattern, quotaPercentage, maxbillqty, minbillqty, packagebatchqty);
                calculateResult.add(acceptResult);
                ++j;
            }
        }
        return calculateResult;
    }
}

