/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pmp.business.helper.CurrencyHelper;

public class PurPriceListHelper {
    private static final Log log = LogFactory.getLog(PurPriceListHelper.class);
    private static final String DEFAULT_EXPIRE_DATE = "2099-12-31";
    private static final Long MAX_STAIR_QTY = 9999999999999L;
    private static final String BD_CURRENCY = "bd_currency";
    private static final String MASTERID = "masterid";
    private static final String PURCHASEUNIT = "purchaseunit";
    private static final String ISUSEAUXPTY = "isuseauxpty";
    private static final String BASECURRRENCY = "baseCurrencyID";

    public static void completeBillInfo(DynamicObject bill) {
        Long orgId;
        Map<String, Long> currencyAndExRateMap;
        DynamicObject currency;
        String status;
        if (bill == null) {
            return;
        }
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org == null) {
            return;
        }
        String dataStatus = (String)bill.get("status");
        if (dataStatus == null || dataStatus.isEmpty()) {
            bill.set("status", (Object)StatusEnum.SAVE.getValue());
        }
        if ((status = (String)bill.get("enable")) == null || status.isEmpty()) {
            bill.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        }
        if ((currency = (DynamicObject)bill.get("currency")) == null && !(currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable(orgId = (Long)org.getPkValue())).isEmpty()) {
            Long currencyId = currencyAndExRateMap.get(BASECURRRENCY);
            currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)BD_CURRENCY);
            bill.set("currency", (Object)currency);
        }
        PurPriceListHelper.completePriceEntryInfo(bill);
    }

    private static void completePriceEntryInfo(DynamicObject bill) {
        boolean isTax = bill.getBoolean("istax");
        boolean isStair = bill.getBoolean("isstair");
        DynamicObject supplier = bill.getDynamicObject("supplierid");
        Date today = TimeServiceHelper.today();
        DynamicObjectCollection priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity");
        if (priceEntryEntity.size() > 0) {
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject childEntry;
                int childRow;
                DynamicObject unit;
                Date priceExpiryDate;
                Date priceEffectDate;
                BigDecimal taxRate;
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialPurchaseInfo = entry.getDynamicObject("material");
                DynamicObject material = null;
                DynamicObject purchaseUnit = null;
                if (materialPurchaseInfo != null) {
                    material = materialPurchaseInfo.getDynamicObject(MASTERID);
                    purchaseUnit = materialPurchaseInfo.getDynamicObject(PURCHASEUNIT);
                }
                if ((taxRate = PurPriceListHelper.setTaxRateId(entry, material, supplier)) != null) {
                    BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                    BigDecimal price = entry.getBigDecimal("price");
                    if (isTax) {
                        if (BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax)) {
                            price = priceAndTax.divide(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate)), 10, RoundingMode.HALF_UP);
                            entry.set("price", (Object)price);
                        }
                    } else if (BigDecimalUtil.isNotBlank((BigDecimal)price)) {
                        priceAndTax = price.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate))).setScale(10, RoundingMode.HALF_UP);
                        entry.set("priceandtax", (Object)priceAndTax);
                    }
                }
                if ((priceEffectDate = entry.getDate("priceeffectdate")) == null) {
                    entry.set("priceeffectdate", (Object)today);
                }
                if ((priceExpiryDate = entry.getDate("priceexpirydate")) == null) {
                    Date defaultExpiryDate = PurPriceListHelper.convertStrToDate(DEFAULT_EXPIRE_DATE);
                    entry.set("priceexpirydate", (Object)defaultExpiryDate);
                }
                if (material != null) {
                    Boolean isuseauxpty = material.getBoolean(ISUSEAUXPTY);
                    if (!isuseauxpty.booleanValue()) {
                        entry.set("auxpty", null);
                    }
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    entry.set("baseunit", (Object)baseUnit);
                }
                if ((unit = entry.getDynamicObject("unit")) == null && purchaseUnit != null) {
                    unit = purchaseUnit;
                }
                entry.set("unit", (Object)unit);
                DynamicObjectCollection stairPriceEntity = entry.getDynamicObjectCollection("purstairprice");
                if (!isStair || stairPriceEntity.size() <= 0) continue;
                for (childRow = 0; childRow < stairPriceEntity.size(); ++childRow) {
                    childEntry = (DynamicObject)stairPriceEntity.get(childRow);
                    childEntry.set("unitid", (Object)unit);
                    BigDecimal stairQtyStart = (BigDecimal)childEntry.get("stairqtystart");
                    if (stairQtyStart != null) continue;
                    childEntry.set("stairqtystart", (Object)BigDecimal.ZERO);
                }
                if (stairPriceEntity.size() > 1) {
                    Collections.sort(stairPriceEntity, (p1, p2) -> {
                        BigDecimal a = p1.getBigDecimal("stairqtystart");
                        BigDecimal b = p2.getBigDecimal("stairqtystart");
                        return a.compareTo(b);
                    });
                    DynamicObject lastSalStairPrice = (DynamicObject)stairPriceEntity.get(stairPriceEntity.size() - 1);
                    lastSalStairPrice.set("stairqtyend", (Object)new BigDecimal(MAX_STAIR_QTY));
                }
                for (childRow = 0; childRow < stairPriceEntity.size(); ++childRow) {
                    childEntry = (DynamicObject)stairPriceEntity.get(childRow);
                    childEntry.set("seq", (Object)(childRow + 1));
                }
                entry.set("purstairprice", (Object)stairPriceEntity);
            }
        }
    }

    private static BigDecimal setTaxRateId(DynamicObject entry, DynamicObject material, DynamicObject supplier) {
        DynamicObject taxRateIdObj = entry.getDynamicObject("taxrateid");
        BigDecimal taxRate = entry.getBigDecimal("taxrate");
        if (taxRateIdObj == null) {
            if (material != null && (taxRateIdObj = (DynamicObject)material.get("taxrate")) == null && supplier != null) {
                taxRateIdObj = (DynamicObject)supplier.get("taxrate");
            }
            if (taxRateIdObj != null) {
                taxRateIdObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate, activedate, expdate", (QFilter[])new QFilter[]{new QFilter("id", "=", taxRateIdObj.getPkValue())});
                entry.set("taxrateid", (Object)taxRateIdObj);
            }
        }
        if (taxRateIdObj != null) {
            taxRate = taxRateIdObj.getBigDecimal("taxrate");
            entry.set("taxrate", (Object)taxRate);
        }
        return taxRate;
    }

    public static Date convertStrToDate(String bizDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date bizTime = null;
        try {
            bizTime = simpleDateFormat.parse(bizDate);
        }
        catch (ParseException e) {
            String msg = e.getMessage();
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff01\uff01\uff01" + msg);
        }
        return bizTime;
    }
}

