/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.pm.vmi.business.helper.BotpHelper;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.pojo.GenerateTargetResult;

class GenerateTargetBill {
    String targetEntity;
    String srcEntity;
    String targetEntryEntity;
    String botpId;
    Map<Long, Long> entryIdAndBillIdMap;
    Map<String, String> paramMap;

    public GenerateTargetBill(String srcEntity, String targetEntity, String targetEntryEntity, String botpId, Map<Long, Long> entryIdAndBillIdMap, Map<String, String> paramMap) {
        this.targetEntity = targetEntity;
        this.targetEntryEntity = targetEntryEntity;
        this.botpId = botpId;
        this.entryIdAndBillIdMap = entryIdAndBillIdMap;
        this.paramMap = paramMap;
        this.srcEntity = srcEntity;
    }

    public GenerateTargetResult generateTargetBill() {
        GenerateTargetResult result = new GenerateTargetResult();
        result.setTargetEntity(this.targetEntity);
        result.setSrcEntity(this.srcEntity);
        ArrayList<Object> pushBillIdList = new ArrayList<Object>(10);
        try {
            ConvertOperationResult pushResult = BotpHelper.pushTargetBill(this.entryIdAndBillIdMap, this.srcEntity, this.targetEntity, this.targetEntryEntity, this.botpId, this.paramMap);
            if (!pushResult.isSuccess()) {
                Map<Long, String> billIdAndErrMsg = BotpHelper.botpPushFail(pushResult, this.botpId);
                result.setPushSrcSuccess(false);
                result.setSaveTargetBillSuccess(false);
                result.setPushFailMsgMap(billIdAndErrMsg);
                return result;
            }
            List<DynamicObject> purInBillList = BotpHelper.getTargetBillFromConvertResult(pushResult, this.targetEntity);
            purInBillList.forEach(bill -> pushBillIdList.add(bill.getPkValue()));
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.targetEntity, (DynamicObject[])purInBillList.toArray(new DynamicObject[0]), (OperateOption)OperateHelper.getOperateOption());
            if (!saveResult.isSuccess()) {
                result.setSaveFailTarIds(pushBillIdList);
                Map<Long, String> saveFialMsg = OperateHelper.handleFailInfo("save", saveResult, purInBillList);
                result.setSaveTargetBillSuccess(false);
                result.setSaveFailMsgMap(saveFialMsg);
                return result;
            }
            List successPkIds = saveResult.getSuccessPkIds();
            result.setSaveSuccessTarIds(successPkIds);
        }
        catch (Exception e) {
            String errorMsg = Arrays.toString(e.getStackTrace());
            result.setExceptionMsg(errorMsg);
            result.setSuccess(false);
            result.setSaveFailTarIds(pushBillIdList);
        }
        return result;
    }

    public String toString() {
        return "GenerateTargetBill{targetEntity='" + this.targetEntity + '\'' + ", srcEntity='" + this.srcEntity + '\'' + ", targetEntryEntity='" + this.targetEntryEntity + '\'' + ", botpId='" + this.botpId + '\'' + ", entryIdAndBillIdMap=" + this.entryIdAndBillIdMap + ", paramMap=" + this.paramMap + '}';
    }
}

