/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OperateHelper {
    private static final String BLANK = " ";
    private static final String BILLNO = "billno";

    public static Map<Long, String> handleFailInfo(String op, OperationResult result, List<DynamicObject> billList) {
        HashMap<Long, DynamicObject> billInfos = new HashMap<Long, DynamicObject>(10);
        if (!CommonUtils.isNull(billList)) {
            billList.forEach(bill -> billInfos.put((Long)bill.getPkValue(), (DynamicObject)bill));
        }
        return OperateHelper.handleFailInfo(op, result, billInfos);
    }

    public static Map<Long, String> handleFailInfo(String op, OperationResult result, Map<Long, DynamicObject> billInfos) {
        HashMap<Long, String> failedBillMessage;
        block8: {
            HashMap billNoMap;
            List allErrorOrValidateInfo;
            block7: {
                op = OperateHelper.getOperName(op);
                allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                failedBillMessage = new HashMap<Long, String>(allErrorOrValidateInfo.size());
                billNoMap = new HashMap(10);
                if (!CommonUtils.isNull(billInfos)) {
                    billInfos.entrySet().forEach(entry -> billNoMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString(BILLNO)));
                }
                if (!allErrorOrValidateInfo.isEmpty()) break block7;
                String erroMessage = result.getMessage();
                List successPkIds = result.getSuccessPkIds();
                for (Map.Entry<Long, DynamicObject> billMapEntry : billInfos.entrySet()) {
                    Long billId = billMapEntry.getKey();
                    if (successPkIds.contains(billId)) continue;
                    failedBillMessage.put(billId, OperateHelper.billExecuteOperUnSuccess((String)billNoMap.get(billId), op, erroMessage));
                }
                break block8;
            }
            boolean isNullId = false;
            StringBuilder nullIdFailReason = new StringBuilder();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                if (iOperateInfo == null) continue;
                if (iOperateInfo.getPkValue() == null) {
                    isNullId = true;
                    nullIdFailReason.append(iOperateInfo.getMessage());
                    continue;
                }
                Long billId = Long.valueOf(iOperateInfo.getPkValue().toString());
                String failInfo = (String)failedBillMessage.get(billId);
                if (StringUtils.isEmpty((CharSequence)failInfo)) {
                    failInfo = OperateHelper.billExecuteOperUnSuccess((String)billNoMap.get(billId), op, BLANK);
                    failInfo = StringUtils.isEmpty((CharSequence)result.getMessage()) ? failInfo + iOperateInfo.getMessage() + BLANK : failInfo + result.getMessage() + iOperateInfo.getMessage() + BLANK;
                } else {
                    failInfo = failInfo + BLANK + iOperateInfo.getMessage() + BLANK;
                }
                failedBillMessage.put(billId, failInfo);
            }
            if (!isNullId) break block8;
            for (Long allId : billInfos.keySet()) {
                failedBillMessage.put(allId, OperateHelper.operValiInfoIdIsNull(op, nullIdFailReason.toString()));
            }
        }
        return failedBillMessage;
    }

    public static String operValiInfoIdIsNull(String op, String failInfo) {
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u64cd\u4f5c\u5931\u8d25\uff1a%2$s\u3002", (String)"OperateHelper_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), "operValiInfoIdIsNull", op, failInfo);
    }

    public static String billExecuteOperUnSuccess(String billNo, String op, String msg) {
        return String.format(ResManager.loadKDString((String)"%1$s\u6267\u884c\u201c%2$s\u201d\u64cd\u4f5c\u5931\u8d25\uff1a%3$s\u3002", (String)"OperateHelper_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), billNo, op, msg);
    }

    public static String getOperName(String op) {
        String operation = null;
        switch (op) {
            case "save": {
                operation = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OperateHelper_2", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            case "delete": {
                operation = ResManager.loadKDString((String)"\u5220\u9664", (String)"OperateHelper_3", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            case "submit": {
                operation = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"OperateHelper_4", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                operation = ResManager.loadKDString((String)"\u64a4\u9500", (String)"OperateHelper_5", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                operation = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"OperateHelper_6", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                operation = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"OperateHelper_7", (String)"scmc-pm-vmi", (Object[])new Object[0]);
                break;
            }
            default: {
                operation = op;
            }
        }
        return operation;
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        option.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("needlog", String.valueOf(true));
        option.setVariableValue("vmioperate", Boolean.TRUE.toString());
        return option;
    }

    public static OperateOption getBFTrackerOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", Boolean.TRUE.toString());
        return option;
    }

    public static OperationResult invokeBillOp(String operationKey, String entityNumber, Object[] billIds) {
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])billIds, (OperateOption)OperateHelper.getOperateOption());
    }

    public static OperationResult merageOpR(OperationResult result, OperationResult opR) {
        result.setSuccess(result.isSuccess() && opR.isSuccess());
        result.getSuccessPkIds().addAll(opR.getSuccessPkIds());
        result.setBillCount(result.getBillCount() + opR.getBillCount());
        result.getBillNos().putAll(opR.getBillNos());
        List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && allErrorOrValidateInfo.size() < 100) {
            List allErrorInfo = result.getAllErrorInfo();
            allErrorInfo.addAll(opR.getAllErrorInfo());
            if (allErrorInfo.size() > 100) {
                allErrorInfo.subList(0, 100);
                result.setAllErrorInfo(allErrorInfo);
                return result;
            }
            Iterator var2 = opR.getValidateResult().getValidateErrors().iterator();
            for (int size = allErrorInfo.size(); var2.hasNext() && size <= 100; ++size) {
                ValidateResult vResult = (ValidateResult)var2.next();
                result.getValidateResult().addValidateError(vResult.getValidatorKey(), vResult);
            }
        }
        return result;
    }
}

