/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.vmi.common.enums.VMISettleExcutedStatusEnum;

public class TransferBillHelper {
    private static final Log log = LogFactory.getLog(TransferBillHelper.class);

    public static void changeTransferBillExcutedStatusAndQty(Set<Long> transferBillEntryIds, VMISettleExcutedStatusEnum status, Map<Long, Map<String, BigDecimal>> qtyParam) {
        DynamicObject[] load;
        if (transferBillEntryIds == null || transferBillEntryIds.isEmpty() || status == null) {
            return;
        }
        log.info("update transferbill transferBillEntryIds : " + transferBillEntryIds);
        log.info("update transferbill status : " + (Object)((Object)status));
        log.info("update transferbill qtyParam : " + qtyParam);
        for (DynamicObject bill : load = BusinessDataServiceHelper.load((String)"pm_transferbill", (String)"id,billentry.id,billentry.excutedstatus,billentry.excutedqty,billentry.excutedbaseqty,billentry.excutedauxqty", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", transferBillEntryIds)})) {
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Map<String, BigDecimal> oneRowQtyMap;
                Long entryPkValue = (Long)entry.getPkValue();
                if (!transferBillEntryIds.contains(entryPkValue)) continue;
                entry.set("excutedstatus", (Object)status.getValue());
                if (qtyParam == null || (oneRowQtyMap = qtyParam.get(entryPkValue)) == null || oneRowQtyMap.isEmpty()) continue;
                for (Map.Entry<String, BigDecimal> qty : oneRowQtyMap.entrySet()) {
                    String key = qty.getKey();
                    BigDecimal value = qty.getValue() == null ? BigDecimal.ZERO : qty.getValue();
                    BigDecimal excutedQty = entry.getBigDecimal(key);
                    BigDecimal result = excutedQty.add(value);
                    entry.set(key, (Object)result);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }
}

