/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleLogInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMISettleLogHelper {
    private static int batchSize = 1000;

    public static void save(final List<VMISettleLogInfo> logInfoList) {
        if (logInfoList == null || logInfoList.isEmpty()) {
            return;
        }
        for (VMISettleLogInfo info : logInfoList) {
            List<Map<String, Object>> stepCostTime = info.getStepCostTime();
            if (stepCostTime == null || stepCostTime.isEmpty()) continue;
            Map<String, Object> frist = stepCostTime.get(0);
            frist.remove("endtime");
            frist.remove("costtime");
            if (stepCostTime.size() <= 1) continue;
            Map<String, Object> last = stepCostTime.get(stepCostTime.size() - 1);
            last.put("endtime", last.remove("begintime"));
            last.remove("costtime");
        }
        ThreadPools.executeOnce((String)VMISettleLogHelper.class.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                List logs = VMISettleLogHelper.infoConvert2DynamicObject(logInfoList);
                SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
            }
        });
    }

    private static List<DynamicObject> infoConvert2DynamicObject(List<VMISettleLogInfo> logInfoList) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        MainEntityType vmiSettleLogMeta = MetadataServiceHelper.getDataEntityType((String)"pm_vmisettlelog");
        Date now = TimeServiceHelper.now();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        for (VMISettleLogInfo logInfo : logInfoList) {
            DynamicObject logObj = new DynamicObject((DynamicObjectType)vmiSettleLogMeta);
            logObj.set("datetime", (Object)now);
            logObj.set("settleuser_id", (Object)currentUserId);
            logObj.set("settledate", (Object)logInfo.getSettleDate());
            logObj.set("settletype", (Object)logInfo.getSettleType());
            logObj.set("settleop", (Object)logInfo.getSettleOp());
            logObj.set("issuccess", (Object)logInfo.getSettleResult());
            logObj.set("settlelogtag_tag", (Object)logInfo.getSettleLogTag());
            logObj.set("settlelogtag", (Object)VMISettleLogHelper.getShortMsg(logInfo.getSettleLogTag()));
            logObj.set("settleparam", (Object)VMISettleLogHelper.getShortMsg(logInfo.getSettleParamJson()));
            logObj.set("settleparam_tag", (Object)logInfo.getSettleParamJson());
            String progress = SerializationUtils.toJsonString(logInfo.getStepCostTime());
            logObj.set("progressjson", (Object)VMISettleLogHelper.getShortMsg(progress));
            logObj.set("progressjson_tag", (Object)progress);
            DynamicObjectCollection entryentity = logObj.getDynamicObjectCollection("entryentity");
            Map<String, Long> transferBillNoAndBillIdMap = logInfo.getTransferBillNoAndBillIdMap();
            if (transferBillNoAndBillIdMap != null && !transferBillNoAndBillIdMap.isEmpty()) {
                int seq = 1;
                for (Map.Entry<String, Long> entry : transferBillNoAndBillIdMap.entrySet()) {
                    DynamicObject oneRow = entryentity.addNew();
                    String transferBillNO = entry.getKey();
                    Long transferBillID = entry.getValue();
                    oneRow.set("entrytransferid", (Object)transferBillID);
                    oneRow.set("entrytransferno", (Object)transferBillNO);
                    oneRow.set("seq", (Object)seq++);
                }
            }
            logs.add(logObj);
        }
        return logs;
    }

    private static String getShortMsg(String largeMsg) {
        if (CommonUtils.isNull((Object)largeMsg)) {
            return "";
        }
        return largeMsg.length() > 512 ? largeMsg.substring(0, 512) : largeMsg;
    }

    public static VMISettleLogInfo buildLogInfoBySettleParam(VMISettleParam settleParam, VMISettleOpEnum settleOp) {
        String settledate;
        VMISettleTypeEnum settleType = settleParam.getSettleType();
        Date settleDate = new Date();
        Map<String, String> paramMap = settleParam.getParam();
        if (paramMap != null && (settledate = paramMap.get("settledate")) != null) {
            settleDate = new Date(Long.parseLong(settledate));
        }
        VMISettleLogInfo logInfo = new VMISettleLogInfo(settleDate, settleType.getValue(), settleOp.getValue(), SerializationUtils.toJsonString((Object)settleParam));
        return logInfo;
    }

    public static void addTransferBillInfo(VMISettleLogInfo settleLogInfo, DynamicObject[] settleBills) {
        HashMap<String, Long> transferInfo = new HashMap<String, Long>(10);
        if (settleBills != null && settleBills.length > 0) {
            for (int i = 0; i < settleBills.length; ++i) {
                DynamicObject bill = settleBills[i];
                transferInfo.put(bill.getString("billno"), bill.getLong("id"));
            }
        }
        settleLogInfo.setTransferBillNoAndBillIdMap(transferInfo);
    }

    public static VMISettleLogInfo buildSettleLog(String[] settleLotNos, DynamicObject[] records) {
        HashMap<String, Long> transferBillNoAndIdMap = new HashMap<String, Long>(10);
        String settleType = null;
        if (!CommonUtils.isNull((Object)records)) {
            for (DynamicObject bill : records) {
                DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
                settleType = bill.getString("settletype");
                for (int i = 0; i < billEntrys.size(); ++i) {
                    DynamicObject row = (DynamicObject)billEntrys.get(i);
                    String billNo = row.getString("srcbillnumber");
                    long billId = row.getLong("srcbillid");
                    transferBillNoAndIdMap.put(billNo, billId);
                }
            }
        }
        String paramString = SerializationUtils.toJsonString((Object)settleLotNos);
        VMISettleLogInfo settleLogInfo = new VMISettleLogInfo(new Date(), settleType, VMISettleOpEnum.REVERSE.getValue(), paramString);
        settleLogInfo.setTransferBillNoAndBillIdMap(transferBillNoAndIdMap);
        return settleLogInfo;
    }

    public static void addStepBegin(VMISettleLogInfo settleLogInfo, String stepName, Date beginTime) {
        Map<Object, Object> map;
        List<Map<String, Object>> stepCostTime = settleLogInfo.getStepCostTime();
        if (stepCostTime == null) {
            stepCostTime = new ArrayList<Map<String, Object>>(10);
        }
        if (stepCostTime.size() > 1 && !(map = stepCostTime.get(stepCostTime.size() - 1)).containsKey("endTime")) {
            Date endTime = new Date();
            map.put("endTime", endTime);
            Date begintime = (Date)map.get("begintime");
            long costTime = endTime.getTime() - begintime.getTime();
            map.put("costtime", BigDecimal.valueOf(costTime).divide(BigDecimal.valueOf(1000L), 1, 4));
        }
        map = new HashMap<String, String>(8);
        map.put("stepname", stepName);
        map.put("begintime", beginTime);
        stepCostTime.add(map);
        settleLogInfo.setStepCostTime(stepCostTime);
    }

    public static void addStepEnd(VMISettleLogInfo settleLogInfo, Date endTime) {
        List<Map<String, Object>> stepCostTime = settleLogInfo.getStepCostTime();
        Map<String, Object> map = stepCostTime.get(stepCostTime.size() - 1);
        map.put("endTime", endTime);
        Date begintime = (Date)map.get("begintime");
        long costTime = endTime.getTime() - begintime.getTime();
        map.put("costtime", BigDecimal.valueOf(costTime).divide(BigDecimal.valueOf(1000L), 1, 4));
        stepCostTime.set(stepCostTime.size() - 1, map);
        settleLogInfo.setStepCostTime(stepCostTime);
    }
}

