/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;

public class VMISettleModelHelper {
    public static VMISettleModelInfo getVMISettleModelInfo(String VMISettleSrcBill) {
        if (StringUtils.isBlank((CharSequence)VMISettleSrcBill)) {
            return null;
        }
        ArrayList<String> VMISettleSrcBills = new ArrayList<String>(16);
        VMISettleSrcBills.add(VMISettleSrcBill);
        Map<String, VMISettleModelInfo> vmiSettleModelInfoMap = VMISettleModelHelper.getVMISettleModelInfoMap(VMISettleSrcBills);
        if (vmiSettleModelInfoMap != null) {
            return vmiSettleModelInfoMap.get(VMISettleSrcBill);
        }
        return null;
    }

    public static Map<String, VMISettleModelInfo> getVMISettleModelInfoMap(List<String> VMISettleSrcBills) {
        if (VMISettleSrcBills == null || VMISettleSrcBills.isEmpty()) {
            return null;
        }
        Map<Object, DynamicObject> loadFromCache = VMISettleModelHelper.querySettleModel(VMISettleSrcBills);
        int size = VMISettleSrcBills.size();
        HashMap<String, VMISettleModelInfo> VMISettleModelInfoMap = new HashMap<String, VMISettleModelInfo>(size);
        if (loadFromCache == null || loadFromCache.isEmpty()) {
            return VMISettleModelInfoMap;
        }
        return VMISettleModelHelper.convertModelInfo(loadFromCache.values());
    }

    public static Map<Object, DynamicObject> querySettleModel(List<String> VMISettleSrcBills) {
        if (VMISettleSrcBills == null || VMISettleSrcBills.isEmpty()) {
            return null;
        }
        QFilter q1 = new QFilter("enable", "=", (Object)"1");
        QFilter q2 = new QFilter("vmisettlesrcbill.number", "in", VMISettleSrcBills);
        QFilter q3 = new QFilter("status", "=", (Object)"C");
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_vmisettlemodel", (String)"vmisettlesrcbill,transferbill,purinbill,totransferbillrule,topurinbillrule,tovmisettlesrcbillrule,plugin,isquoteprice,iscoverprice", (QFilter[])new QFilter[]{q1, q2, q3});
        return loadFromCache;
    }

    public static Map<String, VMISettleModelInfo> convertModelInfo(Collection<DynamicObject> dyms) {
        HashMap<String, VMISettleModelInfo> VMISettleModelInfoMap = new HashMap<String, VMISettleModelInfo>(10);
        if (dyms == null || dyms.isEmpty()) {
            return VMISettleModelInfoMap;
        }
        for (DynamicObject dyn : dyms) {
            if (dyn == null) continue;
            VMISettleModelInfo info = new VMISettleModelInfo();
            String VMISettleSrcBill = dyn.getString("vmisettlesrcbill.number");
            info.setVMISettleSrcBillEntity(VMISettleSrcBill);
            info.setTransferBillEntity(dyn.getString("transferbill.number"));
            info.setPurInBillEntity(dyn.getString("purinbill.number"));
            info.setToTransferBillRuleID(dyn.getString("totransferbillrule.id"));
            info.setToPurInBillRuleID(dyn.getString("topurinbillrule.id"));
            info.setToVMISettleSrcBillRuleID(dyn.getString("tovmisettlesrcbillrule.id"));
            info.setPlugin(dyn.getString("plugin"));
            info.setIsQuotePrice(dyn.getBoolean("isquoteprice"));
            VMISettleModelInfoMap.put(VMISettleSrcBill, info);
        }
        return VMISettleModelInfoMap;
    }
}

