/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.TransferBillHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.common.enums.VMISettleExcutedStatusEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

class RetrySettleHandler {
    private Map<Long, VMISettleRecordInfo> oneSettleLogRecords;
    private Set<Long> billIds;
    private Set<Long> billEntryIds;
    private String purInEntity;
    private String invInEntity;
    private HashSet<Long> allSubmitInvBillIDs = new HashSet(10);
    private HashSet<Long> allSubmitPurInBillIDs = new HashSet(10);

    public RetrySettleHandler(Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        this.oneSettleLogRecords = oneSettleLogRecords;
    }

    public OperationResult retry() {
        ArrayList<VMISettleRecordInfo> recordInfoList = new ArrayList<VMISettleRecordInfo>(this.oneSettleLogRecords.values());
        this.init(recordInfoList);
        if (!this.checkVirBillIsCouple()) {
            this.updateAndSaveRecord();
            return this.buildOpResult(this.oneSettleLogRecords);
        }
        Map<String, HashSet<Long>> param = VMISettleRecordHelper.buildEntityAndVBillIds(recordInfoList);
        HashSet<Long> purInBillIds = param.get(this.purInEntity) == null ? new HashSet(10) : param.get(this.purInEntity);
        HashSet<Long> invBIllIds = param.get(this.invInEntity) == null ? new HashSet(10) : param.get(this.invInEntity);
        ArrayList<DynamicObject> purInBillList = new ArrayList<DynamicObject>(10);
        if (!CommonUtils.isNull(purInBillIds)) {
            DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)this.purInEntity, (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", purInBillIds)});
            purInBillList = new ArrayList<DynamicObject>(Arrays.asList(purInBills));
        }
        ArrayList<DynamicObject> invBillsList = new ArrayList<DynamicObject>(10);
        if (!CommonUtils.isNull(invBIllIds)) {
            DynamicObject[] invBills = BusinessDataServiceHelper.load((String)this.invInEntity, (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invBIllIds)});
            invBillsList = new ArrayList<DynamicObject>(Arrays.asList(invBills));
        }
        List<Long> invalidPurInIds = this.checkIdValid(purInBillIds, purInBillList);
        List<Long> invalidInvIds = this.checkIdValid(invBIllIds, invBillsList);
        if (!invalidPurInIds.isEmpty() || !invalidInvIds.isEmpty()) {
            return this.buildHasInvalidBillOpResult(invalidPurInIds, invalidInvIds);
        }
        Map<String, HashSet<Long>> statusPurInMap = this.groupByBillStatus(purInBillList);
        Map<String, HashSet<Long>> statusInvMap = this.groupByBillStatus(invBillsList);
        HashSet<Long> saveInvBillIDs = statusInvMap.get("A") == null ? new HashSet(10) : statusInvMap.get("A");
        HashSet<Long> savePurInBillIDs = statusPurInMap.get("A") == null ? new HashSet(10) : statusPurInMap.get("A");
        this.doVirtualSubmit(saveInvBillIDs, invBillsList, savePurInBillIDs, purInBillList);
        HashSet<Object> submitInvBillIDs = statusInvMap.get("B") == null ? new HashSet(10) : statusInvMap.get("B");
        HashSet<Object> submitPurInBillIDs = statusPurInMap.get("B") == null ? new HashSet(10) : statusPurInMap.get("B");
        this.allSubmitInvBillIDs.addAll(submitInvBillIDs);
        this.allSubmitPurInBillIDs.addAll(submitPurInBillIDs);
        HashSet<Object> auditPurInBillIDs = statusPurInMap.get("C") == null ? new HashSet(10) : statusPurInMap.get("C");
        param = null;
        statusInvMap = null;
        statusPurInMap = null;
        List targetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_transferbill", (String)"billentry", (Long[])this.billIds.toArray(new Long[0]), (Long[])this.billEntryIds.toArray(new Long[0]), (OperateOption)OperateHelper.getBFTrackerOperateOption());
        HashSet<Object> needAuditPurInBillIds = this.getNeedDoOperateBillIds(targetRowIds, this.billIds, this.allSubmitInvBillIDs, this.allSubmitPurInBillIDs);
        if (!needAuditPurInBillIds.isEmpty()) {
            List<Object> purInAuditSuccessIds = this.getSuccessID4Audit(this.billIds, needAuditPurInBillIds.toArray(), this.purInEntity, purInBillList);
            Collections.addAll(auditPurInBillIDs, purInAuditSuccessIds.toArray(new Long[0]));
        }
        if (auditPurInBillIDs.isEmpty()) {
            this.updateAndSaveRecord();
            return this.buildOpResult(this.oneSettleLogRecords);
        }
        HashSet<Object> needAuditInvBillIds = this.getNeedDoOperateBillIds(targetRowIds, this.billIds, auditPurInBillIDs, this.allSubmitInvBillIDs);
        List<Object> invAuditSuccessIds = new ArrayList<Object>(10);
        if (!CommonUtils.isNull(needAuditInvBillIds)) {
            invAuditSuccessIds = this.getSuccessID4Audit(this.billIds, needAuditInvBillIds.toArray(), this.invInEntity, invBillsList);
        }
        this.updateAndSaveRecord();
        this.updateTransferBill(invAuditSuccessIds, this.oneSettleLogRecords);
        return this.buildOpResult(this.oneSettleLogRecords);
    }

    private void updateTransferBill(List<Object> invAuditSuccessIds, Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        HashMap<Long, Map<String, BigDecimal>> qtyMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (VMISettleRecordInfo record : oneSettleLogRecords.values()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = record.getEntryInfos();
            entryInfos.entrySet().forEach(entry -> {
                VMISettleRecordEntryInfo entryValue = (VMISettleRecordEntryInfo)entry.getValue();
                String invBillStatus = entryValue.getInvBillStatus();
                Long invBillId = entryValue.getInvBillId();
                Long srcBillEntryId = entryValue.getSrcBillEntryId();
                if ("C".equals(invBillStatus) && invAuditSuccessIds.contains(invBillId)) {
                    HashMap<String, BigDecimal> rowQtyMap = new HashMap<String, BigDecimal>(5);
                    rowQtyMap.put("excutedqty", entryValue.getQty());
                    rowQtyMap.put("excutedbaseqty", entryValue.getBaseQty());
                    rowQtyMap.put("excutedauxqty", entryValue.getAuxQty());
                    qtyMap.put(srcBillEntryId, rowQtyMap);
                }
            });
        }
        TransferBillHelper.changeTransferBillExcutedStatusAndQty(qtyMap.keySet(), VMISettleExcutedStatusEnum.EXCUTEDSUCCESS, qtyMap);
    }

    private boolean checkVirBillIsCouple() {
        VMISettleRecordInfo recordInfo;
        boolean isCouple = true;
        if (CommonUtils.isNull(this.oneSettleLogRecords)) {
            return false;
        }
        block0: for (Map.Entry<Long, VMISettleRecordInfo> entry : this.oneSettleLogRecords.entrySet()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos;
            recordInfo = entry.getValue();
            if (recordInfo == null || CommonUtils.isNull(entryInfos = recordInfo.getEntryInfos())) continue;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> rowEntry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo row = rowEntry.getValue();
                if (CommonUtils.isNull((Object)row)) continue;
                Long purInBillId = row.getPurInBillId();
                Long invBillId = row.getInvBillId();
                String purInBillEntity = row.getPurInBillEntity();
                String invBillEntity = row.getInvBillEntity();
                if (purInBillId != null && purInBillId != 0L && !StringUtils.isEmpty((CharSequence)purInBillEntity) && invBillId != null && invBillId != 0L && !StringUtils.isEmpty((CharSequence)invBillEntity)) continue;
                isCouple = false;
                continue block0;
            }
        }
        if (!isCouple) {
            for (Map.Entry<Long, VMISettleRecordInfo> entry : this.oneSettleLogRecords.entrySet()) {
                recordInfo = entry.getValue();
                recordInfo.setSelttleResult(VMISettleResultEnum.SETTLEFAIL);
                recordInfo.addSettledetails(ResManager.loadKDString((String)"\u7f3a\u5931\u7ed3\u7b97\u865a\u5355\u4fe1\u606f\uff0c\u65e0\u6cd5\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMISettleRetryService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
        }
        return isCouple;
    }

    private void updateAndSaveRecord() {
        this.oneSettleLogRecords = VMISettleRecordHelper.updateRecordVirBillStatus(this.oneSettleLogRecords);
        this.oneSettleLogRecords = this.updateRecordResult(this.oneSettleLogRecords);
        VMISettleRecordHelper.updateVMIRecord(this.oneSettleLogRecords);
    }

    private Map<Long, VMISettleRecordInfo> updateRecordResult(Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        if (CommonUtils.isNull(oneSettleLogRecords)) {
            return oneSettleLogRecords;
        }
        for (Map.Entry<Long, VMISettleRecordInfo> recordInfoEntry : oneSettleLogRecords.entrySet()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos;
            VMISettleRecordInfo record = recordInfoEntry.getValue();
            if (CommonUtils.isNull((Object)record) || CommonUtils.isNull(entryInfos = record.getEntryInfos())) continue;
            boolean success = true;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo recordEntryInfo = entry.getValue();
                Long purInBillId = recordEntryInfo.getPurInBillId();
                Long invBillId = recordEntryInfo.getInvBillId();
                if (purInBillId == null || purInBillId.compareTo(0L) == 0 || invBillId == null || invBillId.compareTo(0L) == 0) {
                    success = false;
                    break;
                }
                String purInBillStatus = recordEntryInfo.getPurInBillStatus();
                String invBillStatus = recordEntryInfo.getInvBillStatus();
                if ("C".equals(purInBillStatus) && "C".equals(invBillStatus)) continue;
                success = false;
            }
            if (!success) continue;
            record.setSettledetails(null);
            record.setSelttleResult(VMISettleResultEnum.SETTLESCUESS);
        }
        return oneSettleLogRecords;
    }

    private void doVirtualSubmit(HashSet<Long> saveInvBillIDs, List<DynamicObject> invBillsList, HashSet<Long> savePurInBillIDs, List<DynamicObject> purInBillList) {
        if (!savePurInBillIDs.isEmpty()) {
            List<Object> submitSuccessPurInBillId = this.invokeAndGetSuccessIds("submit", this.purInEntity, new ArrayList<Object>(savePurInBillIDs), this.billIds, purInBillList);
            Collections.addAll(this.allSubmitPurInBillIDs, submitSuccessPurInBillId.toArray(new Long[0]));
        }
        if (!saveInvBillIDs.isEmpty()) {
            List<Object> submitSuccessInvBillId = this.invokeAndGetSuccessIds("submit", this.invInEntity, new ArrayList<Object>(saveInvBillIDs), this.billIds, invBillsList);
            Collections.addAll(this.allSubmitInvBillIDs, submitSuccessInvBillId.toArray(new Long[0]));
        }
    }

    private List<Object> invokeAndGetSuccessIds(String opKey, String entity, List<Object> billids, Collection<Long> transferBillIds, List<DynamicObject> tarBillList) {
        ArrayList<Object> successIds = new ArrayList(10);
        try {
            OperationResult operationResult = OperateHelper.invokeBillOp(opKey, entity, billids.toArray());
            if (!operationResult.isSuccess()) {
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo(opKey, operationResult, tarBillList);
                String msg = Arrays.toString(opFialMsg.values().toArray());
                for (Long transferBillId : transferBillIds) {
                    VMISettleRecordInfo recordInfo = this.oneSettleLogRecords.get(transferBillId);
                    recordInfo.addSettledetails(recordInfo.getSettledetails() + msg);
                    recordInfo.setSelttleResult(VMISettleResultEnum.SETTLEFAIL);
                }
            }
            successIds = operationResult.getSuccessPkIds();
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            VMISettleRecordHelper.addExceptionMsg(this.oneSettleLogRecords, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
        }
        return successIds;
    }

    private OperationResult buildHasInvalidBillOpResult(List<Long> invalidPurInIds, List<Long> invalidInvIds) {
        String billDisplayName;
        MainEntityType entityType;
        String msg = ResManager.loadKDString((String)"%1$s\u7684\u4e3b\u952e\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"VMISettleRetryService_1", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (CommonUtils.isNull(invalidInvIds)) {
            entityType = MetadataServiceHelper.getDataEntityType((String)this.invInEntity);
            billDisplayName = entityType.getDisplayName().toString();
            invalidInvIds.forEach(invalidInvId -> errorMsg.put((Long)invalidInvId, String.format(msg, billDisplayName, invalidInvId)));
            VMISettleRecordHelper.addTargetBillOpFailMsg(this.oneSettleLogRecords, errorMsg, VMISettleResultEnum.SETTLEFAIL);
        }
        if (CommonUtils.isNull(invalidPurInIds)) {
            entityType = MetadataServiceHelper.getDataEntityType((String)this.purInEntity);
            billDisplayName = entityType.getDisplayName().toString();
            invalidPurInIds.forEach(invalidPurinId -> errorMsg.put((Long)invalidPurinId, String.format(msg, billDisplayName, invalidPurinId)));
        }
        VMISettleRecordHelper.addTargetBillOpFailMsg(this.oneSettleLogRecords, errorMsg, VMISettleResultEnum.SETTLEFAIL);
        this.updateAndSaveRecord();
        return this.buildOpResult(this.oneSettleLogRecords);
    }

    private List<Long> checkIdValid(HashSet<Long> virtualBIllIds, List<DynamicObject> virtualBillsList) {
        if (CommonUtils.isNull(virtualBIllIds) && CommonUtils.isNull(virtualBillsList)) {
            return new ArrayList<Long>(5);
        }
        ArrayList virtualBillIdsDB = new ArrayList(10);
        ArrayList<Long> ids = new ArrayList<Long>(virtualBIllIds);
        virtualBillsList.forEach(bill -> virtualBillIdsDB.add((Long)bill.getPkValue()));
        ids.removeAll(virtualBillIdsDB);
        return ids;
    }

    private OperationResult buildOpResult(Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        OperationResult result = new OperationResult();
        int recordSize = oneSettleLogRecords.size();
        result.setBillCount(recordSize);
        String lotNo = null;
        ArrayList<Long> successPkIds = new ArrayList<Long>(10);
        for (VMISettleRecordInfo info : oneSettleLogRecords.values()) {
            boolean success;
            if (lotNo == null) {
                lotNo = info.getSettleLotNo();
            }
            if (!(success = info.isSettleSuccess())) continue;
            successPkIds.add(info.getId());
        }
        result.getSuccessPkIds().addAll(successPkIds);
        if (successPkIds.size() == recordSize) {
            result.setSuccess(true);
        } else {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setTitle(ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleRetryService_5", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u67e5\u770b\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"VMISettleRetryService_10", (String)"scmc-pm-vmi", (Object[])new Object[0]), lotNo);
            errorInfo.setMessage(msg);
            errorInfo.setLevel(ErrorLevel.Error);
            result.setSuccess(false);
            result.addErrorInfo(errorInfo);
        }
        return result;
    }

    private void init(List<VMISettleRecordInfo> recordInfoList) {
        String srcBillForm = recordInfoList.get(0).getEntryInfos().entrySet().iterator().next().getValue().getSrcBillForm();
        VMISettleModelInfo vmiSettleModelInfo = VMISettleModelHelper.getVMISettleModelInfo(srcBillForm);
        this.invInEntity = vmiSettleModelInfo.getVMISettleSrcBillEntity();
        this.purInEntity = vmiSettleModelInfo.getPurInBillEntity();
        this.billIds = this.oneSettleLogRecords.keySet();
        this.billEntryIds = new HashSet<Long>(10);
        for (VMISettleRecordInfo info : recordInfoList) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = info.getEntryInfos();
            if (CommonUtils.isNull(entryInfos)) continue;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo row = entry.getValue();
                Long srcBillEntryId = row.getSrcBillEntryId();
                this.billEntryIds.add(srcBillEntryId);
            }
        }
    }

    private HashSet<Object> getNeedDoOperateBillIds(List<BFRow> targetRowIds, Collection<Long> transferBillIds, HashSet<Long> otherBillIds, HashSet<Long> currentBillIds) {
        Long tBillId;
        BFRowId id;
        BFRowId sId;
        if (CommonUtils.isNull(currentBillIds)) {
            return new HashSet<Object>(10);
        }
        HashSet<Object> needDoOpBillIds = new HashSet<Object>(10);
        ArrayList<Long> otherSuccessTranserEntryId = new ArrayList<Long>(10);
        for (BFRow bfRow : targetRowIds) {
            sId = bfRow.getSId();
            id = bfRow.getId();
            Long sBillId = sId.getBillId();
            tBillId = id.getBillId();
            if (!transferBillIds.contains(sBillId) || !otherBillIds.contains(tBillId)) continue;
            otherSuccessTranserEntryId.add(sId.getEntryId());
        }
        for (BFRow bfRow : targetRowIds) {
            sId = bfRow.getSId();
            id = bfRow.getId();
            Long sEntryId = sId.getEntryId();
            tBillId = id.getBillId();
            if (!otherSuccessTranserEntryId.contains(sEntryId) || !currentBillIds.contains(tBillId)) continue;
            needDoOpBillIds.add(tBillId);
        }
        return needDoOpBillIds;
    }

    private List<Object> getSuccessID4Audit(Collection<Long> transferBillIds, Object[] tarBillIds, String tarEntity, List<DynamicObject> tarBillList) {
        ArrayList<Object> successIds = new ArrayList(10);
        try {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)tarEntity, (Object[])tarBillIds, (OperateOption)OperateHelper.getOperateOption());
            if (!auditResult.isSuccess()) {
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo("audit", auditResult, tarBillList);
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.oneSettleLogRecords, opFialMsg, VMISettleResultEnum.SETTLEFAIL);
            }
            successIds = auditResult.getSuccessPkIds();
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            VMISettleRecordHelper.addExceptionMsg(this.oneSettleLogRecords, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
            return successIds;
        }
        return successIds;
    }

    private Map<String, HashSet<Long>> groupByBillStatus(List<DynamicObject> billList) {
        if (CommonUtils.isNull(billList)) {
            return new HashMap<String, HashSet<Long>>(5);
        }
        HashMap<String, HashSet<Long>> result = new HashMap<String, HashSet<Long>>(10);
        for (DynamicObject bill : billList) {
            String billstatus = bill.getString("billstatus");
            HashSet<Long> billIds = (HashSet<Long>)result.get(billstatus);
            if (billIds == null) {
                billIds = new HashSet<Long>(10);
            }
            billIds.add((Long)bill.getPkValue());
            result.put(billstatus, billIds);
        }
        return result;
    }
}

