/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.TransferBillHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.common.enums.VMISettleExcutedStatusEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

class SettleReverseHandler {
    private Map<Long, VMISettleRecordInfo> oneSettleLogRecords;
    private Set<Long> billIds;
    private String purInEntity;
    private String invEntity;
    private static final Log log = LogFactory.getLog(SettleReverseHandler.class);

    public SettleReverseHandler(Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        this.oneSettleLogRecords = oneSettleLogRecords;
    }

    public OperationResult settleReverse() {
        OperationResult purInDeleteOp;
        OperationResult invDeleteOp;
        OperationResult purInUnSubmitOp;
        OperationResult invUnSubmitOp;
        OperationResult purInUnAuditOp;
        log.info("\u5f53\u524d\u53cd\u7ed3\u7b97\u7684\u7ed3\u7b97\u8bb0\u5f55ID\u4e3a\uff1a" + this.oneSettleLogRecords.keySet());
        ArrayList<VMISettleRecordInfo> recordInfoList = new ArrayList<VMISettleRecordInfo>(this.oneSettleLogRecords.values());
        this.init(recordInfoList);
        Map<String, HashSet<Long>> param = VMISettleRecordHelper.buildEntityAndVBillIds(recordInfoList);
        HashSet<Long> purInBillIds = param.get(this.purInEntity) == null ? new HashSet(10) : param.get(this.purInEntity);
        HashSet<Long> invBIllIds = param.get(this.invEntity) == null ? new HashSet(10) : param.get(this.invEntity);
        ArrayList<DynamicObject> purInBillList = new ArrayList<DynamicObject>(10);
        if (!CommonUtils.isNull(purInBillIds)) {
            DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)this.purInEntity, (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", purInBillIds)});
            purInBillList = new ArrayList<DynamicObject>(Arrays.asList(purInBills));
        }
        ArrayList<DynamicObject> invBillsList = new ArrayList<DynamicObject>(10);
        if (!CommonUtils.isNull(invBIllIds)) {
            DynamicObject[] invBills = BusinessDataServiceHelper.load((String)this.invEntity, (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invBIllIds)});
            invBillsList = new ArrayList<DynamicObject>(Arrays.asList(invBills));
        }
        List<Long> invalidPurInIds = this.checkIdValid(purInBillIds, purInBillList);
        List<Long> invalidInvIds = this.checkIdValid(invBIllIds, invBillsList);
        if (!invalidPurInIds.isEmpty() || !invalidInvIds.isEmpty()) {
            return this.buildHasInvalidBillOpResult(invalidPurInIds, invalidInvIds);
        }
        Map<String, HashSet<Object>> statusPurInMap = this.groupByBillStatus(purInBillList);
        Map<String, HashSet<Object>> statusInvMap = this.groupByBillStatus(invBillsList);
        HashSet<Object> saveInvBillIDs = statusInvMap.get("A") == null ? new HashSet(10) : statusInvMap.get("A");
        HashSet<Object> savePurInBillIDs = statusPurInMap.get("A") == null ? new HashSet(10) : statusPurInMap.get("A");
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c\u524d\u4e3a\u4fdd\u5b58\u72b6\u6001\u5730\u5e93\u5b58\u865a\u5355\u4e3a\uff1a" + saveInvBillIDs);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c\u524d\u4e3a\u4fdd\u5b58\u72b6\u6001\u5730\u5165\u5e93\u865a\u5355\u4e3a\uff1a" + savePurInBillIDs);
        HashSet<Object> auditInvBillIDs = statusInvMap.get("C") == null ? new HashSet(10) : statusInvMap.get("C");
        log.info("\u5f53\u524d\u4e3a\u5ba1\u6838\u72b6\u6001\u5730\u5e93\u5b58\u865a\u5355\u4e3a\uff1a" + auditInvBillIDs);
        if (!CommonUtils.isNull(auditInvBillIDs)) {
            OperationResult invUnAuditOp = this.doVirtualOp(auditInvBillIDs, "unaudit", this.invEntity, invBillsList, saveInvBillIDs);
            if (!invUnAuditOp.isSuccess()) {
                this.oneSettleLogRecords = VMISettleRecordHelper.updateRecordVirBillStatus(this.oneSettleLogRecords);
                OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
                this.updateTransferBillExcutedStatusAndQty(this.oneSettleLogRecords, VMISettleExcutedStatusEnum.EXCUTION, invUnAuditOp.getSuccessPkIds());
                return operationResult;
            }
            this.oneSettleLogRecords = VMISettleRecordHelper.updateRecordVirBillStatus(this.oneSettleLogRecords);
            this.updateTransferBillExcutedStatusAndQty(this.oneSettleLogRecords, VMISettleExcutedStatusEnum.EXCUTION, invUnAuditOp.getSuccessPkIds());
        }
        HashSet<Object> auditPurInBillIDs = statusPurInMap.get("C") == null ? new HashSet(10) : statusPurInMap.get("C");
        log.info("\u5f53\u524d\u4e3a\u5ba1\u6838\u72b6\u6001\u5730\u5165\u5e93\u865a\u5355\u4e3a\uff1a" + auditPurInBillIDs);
        if (!CommonUtils.isNull(auditPurInBillIDs) && !(purInUnAuditOp = this.doVirtualOp(auditPurInBillIDs, "unaudit", this.purInEntity, purInBillList, savePurInBillIDs)).isSuccess()) {
            OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
            return operationResult;
        }
        HashSet<Object> submitInvBillIDs = statusInvMap.get("B") == null ? new HashSet(10) : statusInvMap.get("B");
        log.info("\u5f53\u524d\u4e3a\u63d0\u4ea4\u72b6\u6001\u5730\u5e93\u5b58\u865a\u5355\u4e3a\uff1a" + submitInvBillIDs);
        if (!CommonUtils.isNull(submitInvBillIDs) && !(invUnSubmitOp = this.doVirtualOp(submitInvBillIDs, "unsubmit", this.invEntity, invBillsList, saveInvBillIDs)).isSuccess()) {
            OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
            return operationResult;
        }
        HashSet<Object> submitPurInBillIDs = statusPurInMap.get("B") == null ? new HashSet(10) : statusPurInMap.get("B");
        log.info("\u5f53\u524d\u4e3a\u63d0\u4ea4\u72b6\u6001\u5730\u5165\u5e93\u865a\u5355\u4e3a\uff1a" + submitPurInBillIDs);
        if (!CommonUtils.isNull(submitPurInBillIDs) && !(purInUnSubmitOp = this.doVirtualOp(submitPurInBillIDs, "unsubmit", this.purInEntity, purInBillList, savePurInBillIDs)).isSuccess()) {
            OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
            return operationResult;
        }
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c\u540e\u2014\u2014\u2014\u2014\u4e3a\u4fdd\u5b58\u72b6\u6001\u5730\u5e93\u5b58\u865a\u5355\u4e3a\uff1a" + saveInvBillIDs);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c\u540e\u2014\u2014\u2014\u2014\u4e3a\u4fdd\u5b58\u72b6\u6001\u5730\u5165\u5e93\u865a\u5355\u4e3a\uff1a" + savePurInBillIDs);
        if (!CommonUtils.isNull(saveInvBillIDs) && !(invDeleteOp = this.doVirtualOp(saveInvBillIDs, "delete", this.invEntity, invBillsList, null)).isSuccess()) {
            OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
            return operationResult;
        }
        if (!CommonUtils.isNull(savePurInBillIDs) && !(purInDeleteOp = this.doVirtualOp(savePurInBillIDs, "delete", this.purInEntity, purInBillList, null)).isSuccess()) {
            OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
            this.updateTransferBillExcutedStatusAndQty(this.oneSettleLogRecords, VMISettleExcutedStatusEnum.UNEXCUTED, purInDeleteOp.getSuccessPkIds());
            return operationResult;
        }
        OperationResult operationResult = this.buildAndsaveOpResult(this.oneSettleLogRecords);
        this.updateTransferBillExcutedStatusAndQty(this.oneSettleLogRecords, VMISettleExcutedStatusEnum.UNEXCUTED, null);
        return operationResult;
    }

    private void updateTransferBillExcutedStatusAndQty(Map<Long, VMISettleRecordInfo> oneSettleLogRecords, VMISettleExcutedStatusEnum statusEnum, List<Object> successBillIds) {
        HashMap<Long, Map<String, BigDecimal>> qtyMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        HashSet<Long> unExcutedEntryIds = new HashSet<Long>(16);
        for (VMISettleRecordInfo record : oneSettleLogRecords.values()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = record.getEntryInfos();
            entryInfos.entrySet().forEach(entry -> {
                VMISettleRecordEntryInfo entryValue = (VMISettleRecordEntryInfo)entry.getValue();
                String invBillStatus = entryValue.getInvBillStatus();
                Long invBillId = entryValue.getInvBillId();
                if ("A".equals(invBillStatus) && VMISettleExcutedStatusEnum.EXCUTION == statusEnum && successBillIds != null && successBillIds.contains(invBillId)) {
                    HashMap<String, BigDecimal> rowQtyMap = new HashMap<String, BigDecimal>(5);
                    rowQtyMap.put("excutedqty", entryValue.getQty() == null ? BigDecimal.ZERO : entryValue.getQty().negate());
                    rowQtyMap.put("excutedbaseqty", entryValue.getBaseQty() == null ? BigDecimal.ZERO : entryValue.getBaseQty().negate());
                    rowQtyMap.put("excutedauxqty", entryValue.getAuxQty() == null ? BigDecimal.ZERO : entryValue.getAuxQty().negate());
                    qtyMap.put(entryValue.getSrcBillEntryId(), rowQtyMap);
                } else if (VMISettleExcutedStatusEnum.UNEXCUTED == statusEnum) {
                    Long purInBillId = entryValue.getPurInBillId();
                    String purInBillStatus = entryValue.getPurInBillStatus();
                    if (invBillId == null && purInBillId == null && invBillStatus == null && purInBillStatus == null) {
                        unExcutedEntryIds.add(entryValue.getSrcBillEntryId());
                    }
                }
            });
        }
        if (VMISettleExcutedStatusEnum.EXCUTION == statusEnum) {
            TransferBillHelper.changeTransferBillExcutedStatusAndQty(qtyMap.keySet(), statusEnum, qtyMap);
        } else if (VMISettleExcutedStatusEnum.UNEXCUTED == statusEnum) {
            TransferBillHelper.changeTransferBillExcutedStatusAndQty(unExcutedEntryIds, statusEnum, null);
        }
    }

    private void deleteRecordByResult(OperationResult result) {
        List successPkIds = result.getSuccessPkIds();
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getClass().getName(), (String)"pm_vmisettlerecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)}, null);
        ArrayList deleteIds = new ArrayList(successPkIds.size());
        query.forEach(dym -> deleteIds.add(dym.get("id")));
        if (!CommonUtils.isNull(deleteIds)) {
            OperateHelper.invokeBillOp("delete", "pm_vmisettlerecord", deleteIds.toArray());
        }
    }

    private OperationResult doVirtualOp(HashSet<Object> virtualBillIDs, String opKey, String entity, List<DynamicObject> virtualBillDymList, HashSet<Object> successAddTarget) {
        OperationResult OpResult = new OperationResult();
        if (!CommonUtils.isNull(virtualBillIDs)) {
            try {
                OpResult = OperateHelper.invokeBillOp(opKey, entity, virtualBillIDs.toArray(new Long[0]));
                if (successAddTarget != null) {
                    successAddTarget.addAll(OpResult.getSuccessPkIds());
                }
                if (OpResult.isSuccess()) {
                    return OpResult;
                }
                this.updateRecordByOp(OpResult, this.billIds, virtualBillDymList, opKey);
                OpResult.setSuccess(false);
                return OpResult;
            }
            catch (Exception e) {
                String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
                VMISettleRecordHelper.addExceptionMsg(this.oneSettleLogRecords, this.billIds, exceptionMsg, VMISettleResultEnum.REVERSEFAIL);
                OpResult.setSuccess(false);
                return OpResult;
            }
        }
        return OpResult;
    }

    private OperationResult buildHasInvalidBillOpResult(List<Long> invalidPurInIds, List<Long> invalidInvIds) {
        String billDisplayName;
        MainEntityType entityType;
        String msg = ResManager.loadKDString((String)"\u201c%1$s\u201dID\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"VMISettleReverseService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (!CommonUtils.isNull(invalidInvIds)) {
            entityType = MetadataServiceHelper.getDataEntityType((String)this.invEntity);
            billDisplayName = entityType.getDisplayName().toString();
            invalidInvIds.forEach(invalidInvId -> errorMsg.put((Long)invalidInvId, String.format(msg, billDisplayName, invalidInvId)));
        }
        if (!CommonUtils.isNull(invalidPurInIds)) {
            entityType = MetadataServiceHelper.getDataEntityType((String)this.purInEntity);
            billDisplayName = entityType.getDisplayName().toString();
            invalidPurInIds.forEach(invalidPurinId -> errorMsg.put((Long)invalidPurinId, String.format(msg, billDisplayName, invalidPurinId)));
        }
        VMISettleRecordHelper.addTargetBillOpFailMsg(this.oneSettleLogRecords, errorMsg, VMISettleResultEnum.REVERSEFAIL);
        return this.buildAndsaveOpResult(this.oneSettleLogRecords);
    }

    private List<Long> checkIdValid(HashSet<Long> virtualBIllIds, List<DynamicObject> virtualBillsList) {
        if (CommonUtils.isNull(virtualBIllIds) && CommonUtils.isNull(virtualBillsList)) {
            return new ArrayList<Long>(5);
        }
        ArrayList virtualBillIdsDB = new ArrayList(10);
        ArrayList<Long> ids = new ArrayList<Long>(virtualBIllIds);
        virtualBillsList.forEach(bill -> virtualBillIdsDB.add((Long)bill.getPkValue()));
        ids.removeAll(virtualBillIdsDB);
        return ids;
    }

    private OperationResult buildAndsaveOpResult(Map<Long, VMISettleRecordInfo> oneSettleLogRecords) {
        int recordSize = oneSettleLogRecords.size();
        oneSettleLogRecords = VMISettleRecordHelper.updateRecordVirBillStatus(oneSettleLogRecords);
        oneSettleLogRecords = this.updateRecordStatus(oneSettleLogRecords);
        VMISettleRecordHelper.updateVMIRecord(oneSettleLogRecords);
        ArrayList<Long> successPkIds = new ArrayList<Long>(10);
        String settleLotNo = null;
        for (VMISettleRecordInfo info : oneSettleLogRecords.values()) {
            if (settleLotNo == null) {
                settleLotNo = info.getSettleLotNo();
            }
            if (!VMISettleResultEnum.REVERSESUCCESS.getValue().equals(info.getSelttleResult())) continue;
            successPkIds.add(info.getId());
        }
        OperationResult result = new OperationResult();
        result.setBillCount(recordSize);
        result.setSuccessPkIds(successPkIds);
        if (successPkIds.size() == recordSize) {
            result.setSuccess(true);
        } else {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setTitle(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleReverseService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u67e5\u770b\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"VMISettleReverseService_15", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo);
            errorInfo.setMessage(msg);
            errorInfo.setLevel(ErrorLevel.Error);
            result.setSuccess(false);
            result.addErrorInfo(errorInfo);
        }
        this.deleteRecordByResult(result);
        return result;
    }

    private Map<Long, VMISettleRecordInfo> updateRecordStatus(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        if (CommonUtils.isNull(settleRecordInfoMap)) {
            return settleRecordInfoMap;
        }
        for (Map.Entry<Long, VMISettleRecordInfo> recordInfoEntry : settleRecordInfoMap.entrySet()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos;
            VMISettleRecordInfo record = recordInfoEntry.getValue();
            if (CommonUtils.isNull((Object)record) || CommonUtils.isNull(entryInfos = record.getEntryInfos())) continue;
            boolean reverseSuccess = true;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo recordEntryInfo = entry.getValue();
                Long purInBillId = recordEntryInfo.getPurInBillId();
                Long invBillId = recordEntryInfo.getInvBillId();
                if ((purInBillId == null || purInBillId.compareTo(0L) == 0) && (invBillId == null || invBillId.compareTo(0L) == 0)) continue;
                reverseSuccess = false;
                break;
            }
            if (!reverseSuccess) continue;
            record.setSelttleResult(VMISettleResultEnum.REVERSESUCCESS);
        }
        return settleRecordInfoMap;
    }

    private void init(List<VMISettleRecordInfo> recordInfoList) {
        String srcBillForm = recordInfoList.get(0).getEntryInfos().entrySet().iterator().next().getValue().getSrcBillForm();
        VMISettleModelInfo vmiSettleModelInfo = VMISettleModelHelper.getVMISettleModelInfo(srcBillForm);
        this.invEntity = vmiSettleModelInfo.getVMISettleSrcBillEntity();
        this.purInEntity = vmiSettleModelInfo.getPurInBillEntity();
        this.billIds = this.oneSettleLogRecords.keySet();
    }

    private Map<String, HashSet<Object>> groupByBillStatus(List<DynamicObject> billList) {
        if (CommonUtils.isNull(billList)) {
            return new HashMap<String, HashSet<Object>>(5);
        }
        HashMap<String, HashSet<Object>> result = new HashMap<String, HashSet<Object>>(10);
        for (DynamicObject bill : billList) {
            String billstatus = bill.getString("billstatus");
            HashSet<Object> billIds = (HashSet<Object>)result.get(billstatus);
            if (billIds == null) {
                billIds = new HashSet<Object>(10);
            }
            billIds.add(bill.getPkValue());
            result.put(billstatus, billIds);
        }
        return result;
    }

    private List<Object> updateRecordByOp(OperationResult operationResult, Collection<Long> transferBillIds, List<DynamicObject> tarBillList, String opKey) {
        ArrayList<Object> successIds = new ArrayList(10);
        try {
            if (!operationResult.isSuccess()) {
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo(opKey, operationResult, tarBillList);
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.oneSettleLogRecords, opFialMsg, VMISettleResultEnum.REVERSEFAIL);
            }
            successIds = operationResult.getSuccessPkIds();
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            VMISettleRecordHelper.addExceptionMsg(this.oneSettleLogRecords, transferBillIds, exceptionMsg, VMISettleResultEnum.REVERSEFAIL);
        }
        return successIds;
    }
}

