/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMIMutexHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.RetrySettleHandler;
import kd.scmc.pm.vmi.business.service.settle.VMIInnerDealService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleLogInfo;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.utils.CommonUtil;

public class VMISettleRetryService {
    private VMISettleLogInfo settleLogInfo;
    private static final Log log = LogFactory.getLog(VMISettleRetryService.class);
    public static int ERRORINFOCOUNT = 100;
    private static String queryRecordField = "id,settletype,settlelotno,settleresult,billentry,billentry.qty,billentry.baseqty,billentry.auxqty,billentry.purinbillentity,billentry.purinbillid,billentry.purinbillstatus,billentry.purinbillnumber,billentry.purinbillentryseq,billentry.purinbillentryid,billentry.invbillentity,billentry.invbillid,billentry.invbillstatus,billentry.invbillnumber,billentry.invbillentryid,billentry.invbillentryseq,billentry.srcbillentryid,billentry.srcbillnumber,billentry.srcbillid,billentry.srcbillform";

    public static OperationResult retrySettle(String ... settleLotNos) {
        VMISettleRetryService service = new VMISettleRetryService();
        return service.retry(settleLotNos);
    }

    private OperationResult retry(String ... allSettleLotNos) {
        List<List<String>> partition = CommonUtil.partition(Arrays.asList(allSettleLotNos), 100);
        OperationResult result = new OperationResult();
        for (int i = 0; i < partition.size(); ++i) {
            List<String> settleLotNos = partition.get(i);
            QFilter settleResultFilter = new QFilter("settleresult", "in", (Object)new String[]{VMISettleResultEnum.SETTLEFAIL.getValue(), VMISettleResultEnum.REVERSEFAIL.getValue()});
            DataSet query = VMISettleRecordHelper.queryTransferBillAndRecord(settleLotNos.toArray(new String[0]), settleResultFilter);
            HashMap<String, List<Long>> innerDealRecordIds = new HashMap<String, List<Long>>(10);
            HashMap<String, List<Long>> isNotInnerDealRecordIds = new HashMap<String, List<Long>>(10);
            for (Row row : query) {
                String settlelotno = row.getString("settlelotno");
                Boolean isintertransaction = row.getBoolean("isintertransaction");
                Long recordid = row.getLong("recordid");
                if (isintertransaction == null || Boolean.FALSE.equals(isintertransaction)) {
                    ArrayList<Long> notRecordIds = (ArrayList<Long>)isNotInnerDealRecordIds.get(settlelotno);
                    if (notRecordIds == null) {
                        notRecordIds = new ArrayList<Long>(5);
                    }
                    notRecordIds.add(recordid);
                    isNotInnerDealRecordIds.put(settlelotno, notRecordIds);
                    continue;
                }
                ArrayList<Long> innerRecordIds = (ArrayList<Long>)innerDealRecordIds.get(settlelotno);
                if (innerRecordIds == null) {
                    innerRecordIds = new ArrayList<Long>(5);
                }
                innerRecordIds.add(recordid);
                innerDealRecordIds.put(settlelotno, innerRecordIds);
            }
            query.close();
            OperationResult innnerSettleNoRetryOpR = new OperationResult();
            OperationResult notInnerSettleNoRetryOpR = new OperationResult();
            if (!CommonUtils.isNull(innerDealRecordIds)) {
                innnerSettleNoRetryOpR = VMIInnerDealService.innerDealSettleRetry(innerDealRecordIds);
            }
            if (!CommonUtils.isNull(isNotInnerDealRecordIds)) {
                notInnerSettleNoRetryOpR = this.simpleSettleRetry(isNotInnerDealRecordIds);
            }
            result = VMISettleRetryService.mergeResult(result, innnerSettleNoRetryOpR, notInnerSettleNoRetryOpR);
        }
        return result;
    }

    private OperationResult simpleSettleRetry(Map<String, List<Long>> oneBatch) {
        OperationResult result = new OperationResult();
        HashSet oneBatchRecordIds = new HashSet(10);
        oneBatch.forEach((k, v) -> oneBatchRecordIds.addAll(v));
        QFilter settleNofilter = new QFilter("id", "in", oneBatchRecordIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)"id,settlelotno,billentry,settletype,billentry.srcbillnumber,billentry.srcbillid", (QFilter[])new QFilter[]{settleNofilter});
        if (CommonUtils.isNull((Object)records)) {
            return result;
        }
        this.buildSettleLog(oneBatch.keySet().toArray(new String[0]), records);
        Map<String, ArrayList<Long>> settleNoAndRecordDym = VMISettleRecordHelper.groupBySettle(records);
        for (Map.Entry<String, ArrayList<Long>> oneSetlleNoEntry : settleNoAndRecordDym.entrySet()) {
            ArrayList<Long> recordIdList = oneSetlleNoEntry.getValue();
            DynamicObject[] oneLotRecord = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)queryRecordField, (QFilter[])new QFilter[]{new QFilter("id", "in", recordIdList)});
            if (oneLotRecord == null || oneLotRecord.length == 0) continue;
            List<DynamicObject> recordList = Arrays.asList(oneLotRecord);
            String settleLotNo = oneSetlleNoEntry.getKey();
            Map<Long, VMISettleRecordInfo> settleRecordInfoMap = VMISettleRecordHelper.convertDynamic2Info(recordList, VMISettleResultEnum.SETTLESCUESS);
            Set<Long> addDoVMIOPMutex = null;
            try {
                Map<Long, String> transferBillIdAndNo = this.getTransferBillIdAndNo(settleRecordInfoMap);
                addDoVMIOPMutex = VMIMutexHelper.addDoVMIOPMutex(transferBillIdAndNo);
                if (addDoVMIOPMutex == null || addDoVMIOPMutex.isEmpty() || addDoVMIOPMutex.size() != transferBillIdAndNo.size()) {
                    OperationResult oneSettleLotOpR = new OperationResult();
                    oneSettleLotOpR.setBillCount(settleRecordInfoMap.size());
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleRetryService_5", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u4e3a %1$s \u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\uff0c\u5f53\u524d\u6279\u6b21\u6b63\u5728\u6267\u884cVMI\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettleRetryService_13", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo);
                    errorInfo.setMessage(msg);
                    errorInfo.setLevel(ErrorLevel.Error);
                    oneSettleLotOpR.setSuccess(false);
                    oneSettleLotOpR.addErrorInfo(errorInfo);
                    OperateHelper.merageOpR(result, oneSettleLotOpR);
                    result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettleRetryService_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleRetryService_5", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    continue;
                }
                OperationResult retryOp = new RetrySettleHandler(settleRecordInfoMap).retry();
                result = this.merageRetryOp(result, retryOp);
                this.buildSettleLogByResult(result);
            }
            catch (Exception e) {
                String msg = e.getMessage() + Arrays.toString(e.getStackTrace());
                log.error("\u91cd\u8bd5\u7ed3\u7b97\u51fa\u9519\uff0c", (Throwable)e);
                this.settleLogInfo.addSettleLogTag(msg);
                this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                throw e;
            }
            finally {
                if (addDoVMIOPMutex != null && !addDoVMIOPMutex.isEmpty()) {
                    VMIMutexHelper.releaseVMIOPMutex(addDoVMIOPMutex);
                }
                VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
            }
        }
        return result;
    }

    private Map<Long, String> getTransferBillIdAndNo(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        HashMap<Long, String> billIdAndNo = new HashMap<Long, String>(10);
        if (settleRecordInfoMap == null || settleRecordInfoMap.isEmpty()) {
            return billIdAndNo;
        }
        settleRecordInfoMap.values().forEach(rec -> {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = rec.getEntryInfos();
            if (entryInfos != null && !entryInfos.isEmpty()) {
                entryInfos.values().forEach(row -> billIdAndNo.put(row.getSrcBillId(), row.getSrcBillNumber()));
            }
        });
        return billIdAndNo;
    }

    private static OperationResult mergeResult(OperationResult result, OperationResult innnerSettleNoReverseOpR, OperationResult notInnerSettleNoReverseOpR) {
        if (innnerSettleNoReverseOpR != null) {
            OperateHelper.merageOpR(result, innnerSettleNoReverseOpR);
        }
        if (notInnerSettleNoReverseOpR != null) {
            OperateHelper.merageOpR(result, notInnerSettleNoReverseOpR);
        }
        result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettleRetryService_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleRetryService_5", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return result;
    }

    private OperationResult merageRetryOp(OperationResult result, OperationResult opResult) {
        result.setBillCount(result.getBillCount() + opResult.getBillCount());
        result.setMessage(opResult.getMessage());
        result.setShowMessage(opResult.isShowMessage());
        result.getSuccessPkIds().addAll(opResult.getSuccessPkIds());
        result.getBillNos().putAll(opResult.getBillNos());
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
            if (!(errorInfo instanceof OperateErrorInfo)) continue;
            if (result.getAllErrorOrValidateInfo().size() >= ERRORINFOCOUNT) break;
            OperateErrorInfo error = (OperateErrorInfo)errorInfo;
            result.addErrorInfo(error);
        }
        result.setCancelWriteLog(opResult.isCancelWriteLog());
        result.setFinishedTime(opResult.getFinishedTime());
        result.setNeedSign(opResult.isNeedSign());
        return result;
    }

    private void buildSettleLogByResult(OperationResult result) {
        boolean success = result.isSuccess();
        if (!success) {
            this.settleLogInfo.addSettleLogTag(SerializationUtils.toJsonString((Object)result));
            this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
        } else {
            this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLESCUESS.getValue());
        }
    }

    private void buildSettleLog(String[] settleLotNos, DynamicObject[] records) {
        HashMap<String, Long> transferBillNoAndIdMap = new HashMap<String, Long>(10);
        String settleType = null;
        if (!CommonUtils.isNull((Object)records)) {
            for (DynamicObject bill : records) {
                DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
                settleType = bill.getString("settletype");
                for (int i = 0; i < billEntrys.size(); ++i) {
                    DynamicObject row = (DynamicObject)billEntrys.get(i);
                    String billNo = row.getString("srcbillnumber");
                    long billId = row.getLong("srcbillid");
                    transferBillNoAndIdMap.put(billNo, billId);
                }
            }
        }
        String paramString = SerializationUtils.toJsonString((Object)settleLotNos);
        this.settleLogInfo = new VMISettleLogInfo(new Date(), settleType, VMISettleOpEnum.RETRY.getValue(), paramString);
        this.settleLogInfo.setTransferBillNoAndBillIdMap(transferBillNoAndIdMap);
    }

    public static void setSelectField(String fields) {
        queryRecordField = fields;
    }
}

