/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMIMutexHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.VMIInnerDealService;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.action.AddVirtualBillInfoAction;
import kd.scmc.pm.vmi.business.service.settle.action.DoVirtualBillAuditOperationAction;
import kd.scmc.pm.vmi.business.service.settle.action.DoVirtualBillSubmitOperationAction;
import kd.scmc.pm.vmi.business.service.settle.action.FilterSourceBillAction;
import kd.scmc.pm.vmi.business.service.settle.action.GenereateSettleBillAction;
import kd.scmc.pm.vmi.business.service.settle.action.GetCurrentSettleQtyAction;
import kd.scmc.pm.vmi.business.service.settle.action.SaveSettleRecordAction;
import kd.scmc.pm.vmi.business.service.settle.action.UpdateSettleRecordAction;
import kd.scmc.pm.vmi.business.service.settle.action.WriteBackExcutedQtyAndStatusAction;
import kd.scmc.pm.vmi.business.service.settle.action.WriteBackExcutedStatusAction;
import kd.scmc.pm.vmi.business.service.settle.factory.VMISettleFactory;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleLogInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.sdk.scmc.pm.extpoint.IVMISettleCasePlugin;

public abstract class VMISettleService {
    private static final Log log = LogFactory.getLog(VMISettleService.class);
    private VMISettleLogInfo settleLogInfo;
    private VMISettleResult result = new VMISettleResult();

    public static VMISettleResult vmiSettle(VMISettleParam settleParam) {
        log.info("vmiSettle\u65b9\u6cd5 \u7ed3\u7b97\u53c2\u6570\u4e3a\uff1a" + settleParam);
        VMISettleService vmiSettleService = VMISettleFactory.getInstance(settleParam.getSettleType());
        if (vmiSettleService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u7c7b\u578b\u3002", (String)"VMISettleService_15", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
        return vmiSettleService.excuteSettle(settleParam);
    }

    private VMISettleResult excuteSettle(VMISettleParam settleParam) {
        DynamicObject[] notInnerDealsettleBills;
        Map<Long, Long> transferEntryIdAndBillIdMap = settleParam.getTransferEntryIdAndBillIdMap();
        DynamicObject[] settleBills = BusinessDataServiceHelper.load((String)"pm_transferbill", (String)this.getSelectField(), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", transferEntryIdAndBillIdMap.keySet())}, (String)"srcbillform");
        DynamicObject[] innerDealBills = this.getIsInnerDealBill(settleBills = this.filterNeedSettleTransferBills(settleBills, transferEntryIdAndBillIdMap), true);
        if (!CommonUtils.isNull((Object)innerDealBills)) {
            VMISettleParam innerSettleParam = this.rebuildSettleParam(innerDealBills, settleParam);
            this.result = this.doInnerDealSettle(innerSettleParam, innerDealBills);
        }
        if (!CommonUtils.isNull((Object)(notInnerDealsettleBills = this.getIsInnerDealBill(settleBills, false)))) {
            Set<Object> addMutexSuccessIds = new HashSet(10);
            try {
                addMutexSuccessIds = this.addMutex(notInnerDealsettleBills);
                this.afterMutexControl(addMutexSuccessIds);
                if (addMutexSuccessIds.isEmpty()) {
                    VMISettleResult vMISettleResult = this.result;
                    return vMISettleResult;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(Arrays.asList(notInnerDealsettleBills));
                for (int i = list.size() - 1; i >= 0; --i) {
                    DynamicObject bill = (DynamicObject)list.get(i);
                    Long pkValue = (Long)bill.getPkValue();
                    if (addMutexSuccessIds.contains(pkValue)) continue;
                    list.remove(i);
                }
                notInnerDealsettleBills = list.toArray(new DynamicObject[0]);
                VMISettleParam isNotInnerSettleParam = this.rebuildSettleParam(notInnerDealsettleBills, settleParam);
                this.result.merge(this.doSimpleSettle(isNotInnerSettleParam, notInnerDealsettleBills));
            }
            catch (Exception e) {
                log.error("VMI\u7ed3\u7b97\u975e\u5185\u90e8\u4ea4\u6613\u7ed3\u7b97\u51fa\u9519\uff0c", (Throwable)e);
                throw e;
            }
            finally {
                if (addMutexSuccessIds != null && !addMutexSuccessIds.isEmpty()) {
                    VMIMutexHelper.releaseVMIOPMutex(addMutexSuccessIds);
                }
            }
        }
        return this.result;
    }

    private Set<Long> addMutex(DynamicObject[] settleBills) {
        HashMap<Long, String> billIdAndNo = new HashMap<Long, String>(10);
        Set<Long> addMutexSuccessIds = new HashSet<Long>(10);
        if (settleBills == null || settleBills.length == 0) {
            return addMutexSuccessIds;
        }
        for (int i = 0; i < settleBills.length; ++i) {
            DynamicObject bill = settleBills[i];
            Long pkValue = (Long)bill.getPkValue();
            String billno = bill.getString("billno");
            billIdAndNo.put(pkValue, billno);
        }
        addMutexSuccessIds = VMIMutexHelper.addDoVMIOPMutex(billIdAndNo);
        return addMutexSuccessIds;
    }

    protected void afterMutexControl(Set<Long> addMutexSuccessIds) {
    }

    private VMISettleParam rebuildSettleParam(DynamicObject[] settleBills, VMISettleParam settleParam) {
        if (CommonUtils.isNull((Object)settleBills)) {
            return settleParam;
        }
        HashMap<Long, Long> sourceMap = new HashMap<Long, Long>(10);
        for (int i = 0; i < settleBills.length; ++i) {
            DynamicObject settleBill = settleBills[i];
            Long billId = (Long)settleBill.getPkValue();
            DynamicObjectCollection billEntry = settleBill.getDynamicObjectCollection("billentry");
            if (CommonUtils.isNull((Object)billEntry)) continue;
            for (DynamicObject entry : billEntry) {
                Long entryId = (Long)entry.getPkValue();
                sourceMap.put(entryId, billId);
            }
        }
        VMISettleParam param = new VMISettleParam(settleParam.getSettleType());
        param.setParam(settleParam.getParam());
        param.setTransferEntryIdAndBillIdMap(sourceMap);
        return param;
    }

    private DynamicObject[] getIsInnerDealBill(DynamicObject[] settleBills, boolean isInner) {
        if (settleBills == null || settleBills.length == 0) {
            return new DynamicObject[0];
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < settleBills.length; ++i) {
            DynamicObject settleBill = settleBills[i];
            boolean isInnerFromDB = settleBill.getBoolean("isintertransaction");
            if (isInner != isInnerFromDB) continue;
            bills.add(settleBill);
        }
        return bills.toArray(new DynamicObject[0]);
    }

    private VMISettleResult doSimpleSettle(VMISettleParam settleParam, DynamicObject[] settleBills) {
        this.settleLogInfo = VMISettleLogHelper.buildLogInfoBySettleParam(settleParam, VMISettleOpEnum.SETTLE);
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5f00\u59cb", (String)"VMISettleService_16", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
        String checkParamErrorStr = this.checkSettleParam(settleParam);
        if (!StringUtils.isBlank((CharSequence)checkParamErrorStr)) {
            this.settleLogInfo.addSettleLogTag(checkParamErrorStr);
            this.result.setSuccess(false);
            this.result.setMessage(checkParamErrorStr);
            VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
            return this.result;
        }
        settleBills = this.beforeDoSettleAction(settleBills, settleParam);
        VMISettleLogHelper.addTransferBillInfo(this.settleLogInfo, settleBills);
        Map<Long, Long> transferEntryIdAndBillIdMap = this.getSettleTransferEntryIdAndBillIdMap(settleBills);
        log.info("vmiSettle\u65b9\u6cd5 \u7ed3\u7b97\u65b9\u5f0f\u5dee\u5f02\u5904\u7406\u540e\u7684\u5f85\u7ed3\u7b97\u7684\u884cid\u4e0e\u5355id\u4e3a \uff1a " + transferEntryIdAndBillIdMap);
        Map<String, VMISettleModelInfo> settleModelInfoMap = this.getSettleModelFromSettleBills(settleBills);
        log.info("vmiSettle\u65b9\u6cd5 \u83b7\u53d6\u7684\u7ed3\u7b97\u6a21\u578b\u7684\u4fe1\u606f\u4e3a\uff1a" + settleModelInfoMap);
        Map<String, List<DynamicObject>> groupBySrcBillEntity = this.groupBySrcEntity(settleBills);
        String checkSettleModelErrMsg = this.checkSettleModel(groupBySrcBillEntity, settleModelInfoMap);
        if (!CommonUtils.isNull((Object)checkSettleModelErrMsg)) {
            this.settleLogInfo.addSettleLogTag(checkSettleModelErrMsg);
            VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5b8c\u6210", (String)"VMISettleService_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
            VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
            this.result.setSuccess(false);
            this.result.setMessage(checkSettleModelErrMsg);
            return this.result;
        }
        this.result = this.doSettle(settleModelInfoMap, groupBySrcBillEntity, settleParam);
        this.afterDoSettleAction(this.result);
        return this.result;
    }

    private VMISettleResult doInnerDealSettle(VMISettleParam settleParam, DynamicObject[] settleBills) {
        ArrayList<DynamicObject> innerDealBills = new ArrayList<DynamicObject>(10);
        Collections.addAll(innerDealBills, settleBills);
        return VMIInnerDealService.innerDealSettle(innerDealBills, settleParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private VMISettleResult doSettle(Map<String, VMISettleModelInfo> schemes, Map<String, List<DynamicObject>> groupBySrcBillEntity, VMISettleParam settleParam) {
        Throwable throwable = null;
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"doSettle");){
            Map<Long, VMISettleRecordInfo> settleRecordInfoMap = null;
            Boolean recordSaved = null;
            for (Map.Entry<String, List<DynamicObject>> entityAndSettleBills : groupBySrcBillEntity.entrySet()) {
                recordSaved = false;
                String entityKey = entityAndSettleBills.getKey();
                VMISettleModelInfo vmiSettleModelInfo = schemes.get(entityKey);
                List<DynamicObject> transferBills = entityAndSettleBills.getValue();
                Map<Long, Long> transferEntryIdAndBillIdMap = this.getSettleTransferEntryIdAndBillIdMap(transferBills.toArray(new DynamicObject[0]));
                settleRecordInfoMap = VMISettleRecordHelper.buildTransferBillInfo4Record(transferBills, settleParam);
                this.result.merge(this.settleOneSrcEntity(transferBills, transferEntryIdAndBillIdMap, vmiSettleModelInfo, settleParam, settleRecordInfoMap));
                VMISettleRecordHelper.saveVMIRecord(settleRecordInfoMap, false);
                recordSaved = true;
            }
            VMISettleResult vMISettleResult = this.result;
            try {
                boolean success;
                if (recordSaved != null && !recordSaved.booleanValue()) {
                    VMISettleRecordHelper.saveVMIRecord(settleRecordInfoMap, false);
                }
                if (success = this.result.isSuccess()) {
                    this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLESCUESS.getValue());
                } else {
                    this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                }
                this.settleLogInfo.addSettleLogTag(this.result.getSettleFailBillNoAndMsgs().toString());
                VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5b8c\u6210", (String)"VMISettleService_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
            }
            catch (Exception e) {
                log.error("VMI\u7ed3\u7b97\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\u65f6\u51fa\u9519\u3002", (Throwable)e);
                String stackTrace = e.getMessage() + Arrays.toString(e.getStackTrace());
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff1a%1$s\u3002", (String)"VMISettleService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), stackTrace);
                this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                this.settleLogInfo.addSettleLogTag(errorMsg);
            }
            finally {
                VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
            }
            return vMISettleResult;
            catch (Exception e) {
                VMISettleResult vMISettleResult2;
                block47: {
                    block48: {
                        String stackTrace = e.getMessage() + Arrays.toString(e.getStackTrace());
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff1a%1$s\u3002", (String)"VMISettleService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), stackTrace);
                        log.error(errorMsg);
                        VMISettleRecordHelper.addExceptionMsg(settleRecordInfoMap, settleParam.getTransferEntryIdAndBillIdMap().values(), errorMsg, VMISettleResultEnum.SETTLEFAIL);
                        this.settleLogInfo.addSettleLogTag(errorMsg);
                        this.result.setSuccess(false);
                        this.result.setMessage(errorMsg);
                        vMISettleResult2 = this.result;
                        try {
                            boolean success;
                            if (recordSaved != null && !recordSaved.booleanValue()) {
                                VMISettleRecordHelper.saveVMIRecord(settleRecordInfoMap, false);
                            }
                            if (success = this.result.isSuccess()) {
                                this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLESCUESS.getValue());
                            } else {
                                this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                            }
                            this.settleLogInfo.addSettleLogTag(this.result.getSettleFailBillNoAndMsgs().toString());
                            VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5b8c\u6210", (String)"VMISettleService_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
                        }
                        catch (Exception e2) {
                            log.error("VMI\u7ed3\u7b97\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\u65f6\u51fa\u9519\u3002", (Throwable)e2);
                            String stackTrace2 = e2.getMessage() + Arrays.toString(e2.getStackTrace());
                            String errorMsg2 = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff1a%1$s\u3002", (String)"VMISettleService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), stackTrace2);
                            this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                            this.settleLogInfo.addSettleLogTag(errorMsg2);
                        }
                        finally {
                            VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
                        }
                        if (span == null) break block47;
                        if (throwable == null) break block48;
                        try {
                            span.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block47;
                    }
                    span.close();
                }
                return vMISettleResult2;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                boolean success;
                                if (recordSaved != null && !recordSaved.booleanValue()) {
                                    VMISettleRecordHelper.saveVMIRecord(settleRecordInfoMap, false);
                                }
                                if (success = this.result.isSuccess()) {
                                    this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLESCUESS.getValue());
                                } else {
                                    this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                                }
                                this.settleLogInfo.addSettleLogTag(this.result.getSettleFailBillNoAndMsgs().toString());
                                VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5b8c\u6210", (String)"VMISettleService_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
                            }
                            catch (Exception e3) {
                                log.error("VMI\u7ed3\u7b97\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\u65f6\u51fa\u9519\u3002", (Throwable)e3);
                                String stackTrace = e3.getMessage() + Arrays.toString(e3.getStackTrace());
                                String errorMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff1a%1$s\u3002", (String)"VMISettleService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), stackTrace);
                                this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
                                this.settleLogInfo.addSettleLogTag(errorMsg);
                            }
                            finally {
                                VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                }
            }
        }
    }

    protected DynamicObject[] filterNeedSettleTransferBills(DynamicObject[] settleBills, Map<Long, Long> transferEntryIdAndBillIdMap) {
        for (DynamicObject bill : settleBills) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (int i = billEntrys.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)billEntrys.get(i);
                Long entryPkValue = (Long)entry.getPkValue();
                if (transferEntryIdAndBillIdMap.containsKey(entryPkValue)) continue;
                billEntrys.remove(i);
            }
        }
        return settleBills;
    }

    private VMISettleResult settleOneSrcEntity(List<DynamicObject> transferBills, Map<Long, Long> transferEntryIdAndBillIdMap, VMISettleModelInfo vmiSettleModelInfo, VMISettleParam settleParam, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) throws Exception {
        VMISettleContext context = this.buildVMISettleContext(transferBills, transferEntryIdAndBillIdMap, settleParam, vmiSettleModelInfo);
        List<AbstractVMISettleAction> settleActions = this.getSettleActions(context, settleRecordInfoMap, this.settleLogInfo);
        for (AbstractVMISettleAction action : settleActions) {
            action.setSettleContext(context);
            action.setSettleRecordInfoMap(settleRecordInfoMap);
            action.setSettleLogInfo(this.settleLogInfo);
            action.doAction();
        }
        context = null;
        return this.buildSettleResult(settleRecordInfoMap);
    }

    private VMISettleResult buildSettleResult(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        VMISettleResult result = new VMISettleResult();
        ArrayList<Long> settleFailId = new ArrayList<Long>(10);
        ArrayList<Long> successId = new ArrayList<Long>(10);
        ArrayList<Object> recordIds = new ArrayList<Object>(10);
        HashMap<Long, String> failIdAndErrorMsg = new HashMap<Long, String>(10);
        HashMap<String, String> failBillNoAndErrorMsg = new HashMap<String, String>(10);
        boolean success = true;
        for (Map.Entry<Long, VMISettleRecordInfo> entry : settleRecordInfoMap.entrySet()) {
            Long billId = entry.getKey();
            VMISettleRecordInfo recordInfo = entry.getValue();
            if (!recordInfo.isSettleSuccess()) {
                VMISettleRecordEntryInfo row;
                Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
                if (!CommonUtils.isNull(entryInfos) && (row = entryInfos.entrySet().iterator().next().getValue()) != null) {
                    failBillNoAndErrorMsg.put(row.getSrcBillNumber(), recordInfo.getSettledetails());
                }
                success = false;
                settleFailId.add(billId);
                failIdAndErrorMsg.put(billId, recordInfo.getSettledetails());
                continue;
            }
            recordIds.add(recordInfo.getId());
            successId.add(billId);
        }
        result.setSuccess(success);
        result.setFailIds(settleFailId);
        result.setSuccessIds(successId);
        result.setSettleSuccessRecordIds(recordIds);
        result.setSettleFailMsgs(failIdAndErrorMsg);
        result.setSettleFailBillNoAndMsgs(failBillNoAndErrorMsg);
        return result;
    }

    protected Map<String, VMISettleModelInfo> getSettleModelFromSettleBills(DynamicObject[] settleBills) {
        Map<String, VMISettleModelInfo> vmiSettleModelInfos = new HashMap<String, VMISettleModelInfo>(10);
        HashSet<String> srcEntitys = new HashSet<String>();
        for (DynamicObject bill : settleBills) {
            DynamicObject srcEntityDymObj = bill.getDynamicObject("srcbillform");
            String srcEntityDymObjPkValue = (String)srcEntityDymObj.getPkValue();
            srcEntitys.add(srcEntityDymObjPkValue);
        }
        ArrayList<String> list = new ArrayList<String>(srcEntitys);
        Map<Object, DynamicObject> settleModelDym = VMISettleModelHelper.querySettleModel(list);
        if (settleModelDym == null || settleModelDym.isEmpty()) {
            return vmiSettleModelInfos;
        }
        List<DynamicObject> settleModelList = new ArrayList<DynamicObject>(settleModelDym.values());
        settleModelList = this.getExtPluginSettleModel(settleBills, settleModelList);
        if (settleModelDym == null || settleModelDym.isEmpty()) {
            return vmiSettleModelInfos;
        }
        vmiSettleModelInfos = VMISettleModelHelper.convertModelInfo(settleModelList);
        return vmiSettleModelInfos;
    }

    private List<DynamicObject> getExtPluginSettleModel(final DynamicObject[] settleBills, List<DynamicObject> settleModelList) {
        try {
            List models;
            PluginProxy pluginProxy = PluginProxy.create(null, IVMISettleCasePlugin.class, (String)"SCMC_PM_VMISETTLE_ADJUSTSETTLEMODEL", null);
            final List finalSettleModelList = settleModelList;
            List modelList = pluginProxy.callReplace((PluginCall)new PluginCall<IVMISettleCasePlugin, List<DynamicObject>>(){

                public List<DynamicObject> call(IVMISettleCasePlugin ivmiSettleCasePlugin) {
                    return ivmiSettleCasePlugin.adjustSettleModel(settleBills, finalSettleModelList);
                }
            });
            if (modelList != null && !modelList.isEmpty() && (models = (List)modelList.get(0)) != null && !models.isEmpty()) {
                settleModelList = models;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6269\u5c55\u70b9\u51fa\u9519\u3002", (Throwable)e);
        }
        return settleModelList;
    }

    private Map<String, List<DynamicObject>> groupBySrcEntity(DynamicObject[] settleBills) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(10);
        for (DynamicObject bill : settleBills) {
            DynamicObject srcBillEntityDym = (DynamicObject)bill.get("srcbillform");
            String srcBillEntity = srcBillEntityDym == null ? null : (String)srcBillEntityDym.getPkValue();
            ArrayList<DynamicObject> oneSrcEntitySettleBills = (ArrayList<DynamicObject>)map.get(srcBillEntity);
            if (oneSrcEntitySettleBills == null) {
                oneSrcEntitySettleBills = new ArrayList<DynamicObject>(10);
            }
            oneSrcEntitySettleBills.add(bill);
            map.put(srcBillEntity, oneSrcEntitySettleBills);
        }
        return map;
    }

    protected Map<Long, Long> getSettleTransferEntryIdAndBillIdMap(DynamicObject[] settleBills) {
        HashMap<Long, Long> transferEntryIdAndBillIdMap = new HashMap<Long, Long>();
        for (DynamicObject bill : settleBills) {
            Long billId = (Long)bill.getPkValue();
            DynamicObjectCollection billentry = (DynamicObjectCollection)bill.get("billentry");
            if (billentry == null || billentry.size() <= 0) continue;
            for (int i = 0; i < billentry.size(); ++i) {
                Long billEntryId = (Long)((DynamicObject)billentry.get(i)).getPkValue();
                transferEntryIdAndBillIdMap.put(billEntryId, billId);
            }
        }
        return transferEntryIdAndBillIdMap;
    }

    private String checkSettleParam(VMISettleParam settleParam) {
        if (settleParam == null) {
            log.error("\u7ed3\u7b97\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u7b97");
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u7b97", (String)"VMISettleService_1", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        Map<Long, Long> transferEntryIdAndBillIdMap = settleParam.getTransferEntryIdAndBillIdMap();
        if (CommonUtils.isNull(transferEntryIdAndBillIdMap)) {
            log.error("\u5f85\u7ed3\u7b97\u6570\u636e\u4e3a\u7a7a\u3002");
            return ResManager.loadKDString((String)"\u5f85\u7ed3\u7b97\u6570\u636e\u4e3a\u7a7a\u3002", (String)"VMISettleService_2", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        return null;
    }

    protected String getSelectField() {
        return "org,purorg,billno,biztime,isintertransaction,srcbillform,billentry.material,billentry.unit,billentry.qty,billentry.baseunit,billentry.baseqty,billentry.supplier,billentry.auxunit,billentry.auxqty,billentry.entrysettleorg,billentry.entryreqorg,billentry.joinqty,billentry.joinbaseqty,billentry.joinauxqty,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid,billentry.price,billentry.seq,billentry.istax,billentry.taxrateid,billentry.taxrate,billentry.amountandtax,billentry.priceandtax,billentry.srcbillnumber,billentry.srcbillid";
    }

    protected List<AbstractVMISettleAction> getSettleActions(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap, VMISettleLogInfo logInfo) {
        ArrayList<AbstractVMISettleAction> actions = new ArrayList<AbstractVMISettleAction>();
        actions.add(new FilterSourceBillAction(context, settleRecordInfoMap));
        actions.add(new GetCurrentSettleQtyAction(context, settleRecordInfoMap));
        actions.add(new GenereateSettleBillAction(context, settleRecordInfoMap));
        actions.add(new AddVirtualBillInfoAction(context, settleRecordInfoMap));
        actions.add(new SaveSettleRecordAction(context, settleRecordInfoMap));
        actions.add(new WriteBackExcutedStatusAction(context, settleRecordInfoMap));
        actions.add(new DoVirtualBillSubmitOperationAction(context, settleRecordInfoMap));
        actions.add(new DoVirtualBillAuditOperationAction(context, settleRecordInfoMap));
        actions.add(new UpdateSettleRecordAction(context, settleRecordInfoMap));
        actions.add(new WriteBackExcutedQtyAndStatusAction(context, settleRecordInfoMap));
        return actions;
    }

    protected abstract DynamicObject[] beforeDoSettleAction(DynamicObject[] var1, VMISettleParam var2);

    protected abstract void afterDoSettleAction(VMISettleResult var1);

    private String checkSettleModel(Map<String, List<DynamicObject>> groupBySrcBillEntity, Map<String, VMISettleModelInfo> schemes) {
        if (schemes == null || schemes.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eVMI\u7ed3\u7b97\u6a21\u578b\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMISettleService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        ArrayList<String> modelEntityList = new ArrayList<String>(schemes.keySet());
        ArrayList<String> srcEntityList = new ArrayList<String>(groupBySrcBillEntity.keySet());
        if (srcEntityList.contains(null)) {
            return ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u6e90\u5355\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"VMISettleService_10", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        srcEntityList.removeAll(modelEntityList);
        if (srcEntityList.size() > 0) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u672a\u627e\u5230\u5339\u914d\u7684\u7ed3\u7b97\u6a21\u578b\u3002", (String)"VMISettleService_11", (String)"scmc-pm-vmi", (Object[])new Object[0]), srcEntityList);
        }
        return null;
    }

    protected VMISettleContext buildVMISettleContext(List<DynamicObject> bills, Map<Long, Long> transferEntryIdAndBillIdMap, VMISettleParam param, VMISettleModelInfo vmiSettleModelInfo) {
        VMISettleContext context = new VMISettleContext();
        context.setTransferBill(bills);
        context.setSettleType(param.getSettleType());
        context.setTransferEntryIdAndBillIdMap(transferEntryIdAndBillIdMap);
        context.setSettleModelInfo(vmiSettleModelInfo);
        context.setParamMap(param.getParam());
        context.setInvInEntity(vmiSettleModelInfo.getVMISettleSrcBillEntity());
        context.setPurInEntity(vmiSettleModelInfo.getPurInBillEntity());
        return context;
    }

    protected void deleteFailBill(VMISettleParam settleParam) {
        Map<Long, Long> transferEntryIdAndBillIdMap = settleParam.getTransferEntryIdAndBillIdMap();
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, ResManager.loadKDString((String)"\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355\uff08\u865a\u5355\u4e3a\u6682\u5b58\u4e14\u672a\u5728\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u8bb0\u5f55\uff09", (String)"VMISettleService_18", (String)"scmc-pm-vmi", (Object[])new Object[0]), TimeServiceHelper.now());
        log.info("\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355 \u5f00\u59cb");
        try {
            log.info("\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355 \u67e5\u8be2BOTP\u4e0b\u6e38\u865a\u5355\u3002");
            Map<String, Set<Long>> botpBill = this.queryTargetBillByBotp(transferEntryIdAndBillIdMap);
            if (CommonUtils.isNull(botpBill)) {
                log.info("\u4e0b\u6e38\u865a\u5355\u5185\u5bb9\u4e3a\u7a7a\u3002");
                return;
            }
            log.info("\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355 \u67e5\u8be2BOTP\u4e0b\u6e38\u865a\u5355\u7ed3\u679c " + SerializationUtils.toJsonString(botpBill));
            Map<String, Set<Long>> recordVirBillIds = this.queryVMIRecord(transferEntryIdAndBillIdMap);
            Map<String, Set<Long>> hasNoRecordTarBill = this.getHasNoRecordTarBill(botpBill, recordVirBillIds);
            botpBill = null;
            recordVirBillIds = null;
            log.info("\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355 \u5f00\u59cb\u5220\u9664\u5e9f\u5355\u3002" + SerializationUtils.toJsonString(hasNoRecordTarBill));
            this.excuteDelete(hasNoRecordTarBill);
            VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        }
        catch (Exception e) {
            log.error("VMI\u7ed3\u7b97\u5220\u9664\u5e9f\u5f03\u865a\u5355\u65f6\u51fa\u9519\u3002", (Throwable)e);
        }
        log.info("\u7ed3\u7b97\u524d\u5220\u9664\u5e9f\u5355 \u7ed3\u675f");
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
    }

    private void excuteDelete(Map<String, Set<Long>> hasNoRecordTarBill) {
        for (Map.Entry<String, Set<Long>> entry : hasNoRecordTarBill.entrySet()) {
            String key = entry.getKey();
            Set<Long> billIds = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)key) || billIds == null || billIds.isEmpty()) continue;
            QFilter idFilter = new QFilter("id", "in", billIds);
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"A");
            DynamicObjectCollection idCol = QueryServiceHelper.query((String)key, (String)"id", (QFilter[])new QFilter[]{idFilter, billStatusFilter}, null);
            ArrayList saveBillIds = new ArrayList(10);
            idCol.forEach(id -> saveBillIds.add(id.getLong("id")));
            if (saveBillIds.isEmpty()) continue;
            OperateHelper.invokeBillOp("delete", key, billIds.toArray());
        }
    }

    private Map<String, Set<Long>> getHasNoRecordTarBill(Map<String, Set<Long>> botpBill, Map<String, Set<Long>> recordVirBillIds) {
        HashMap<String, Set<Long>> hasNoRecordTarBill = new HashMap<String, Set<Long>>(10);
        if (recordVirBillIds == null || recordVirBillIds.isEmpty()) {
            return botpBill;
        }
        for (Map.Entry<String, Set<Long>> entry : botpBill.entrySet()) {
            String entityNo = entry.getKey();
            Set<Long> botpTarBills = entry.getValue();
            Set<Long> recordBills = recordVirBillIds.get(entityNo);
            if (recordBills == null || recordBills.isEmpty()) {
                hasNoRecordTarBill.put(entityNo, botpTarBills);
                continue;
            }
            botpTarBills.removeAll(recordBills);
            if (botpTarBills.isEmpty()) {
                botpBill.remove(entityNo);
                continue;
            }
            hasNoRecordTarBill.put(entityNo, botpTarBills);
        }
        return hasNoRecordTarBill;
    }

    private Map<String, Set<Long>> queryTargetBillByBotp(Map<Long, Long> transferEntryIdAndBillIdMap) {
        HashMap<String, Set<Long>> botp = new HashMap<String, Set<Long>>(10);
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_transferbill", (String)"billentry", (Long[])transferEntryIdAndBillIdMap.values().toArray(new Long[0]), (Long[])transferEntryIdAndBillIdMap.keySet().toArray(new Long[0]), (OperateOption)OperateHelper.getBFTrackerOperateOption());
        if (bfRows == null || bfRows.isEmpty()) {
            return botp;
        }
        HashMap<Long, String> tableIdAndEntityNoMap = new HashMap<Long, String>(10);
        for (BFRow row : bfRows) {
            BFRowId id = row.getId();
            Long tbillId = id.getBillId();
            Long tTableId = id.getMainTableId();
            String targetEntityNo = (String)tableIdAndEntityNoMap.get(tTableId);
            if (targetEntityNo == null) {
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tTableId);
                targetEntityNo = tableDefine.getEntityKey();
                tableIdAndEntityNoMap.put(tTableId, targetEntityNo);
            }
            Set<Long> tBillIds = botp.get(targetEntityNo) == null ? new HashSet(10) : (Set)botp.get(targetEntityNo);
            tBillIds.add(tbillId);
            botp.put(targetEntityNo, tBillIds);
        }
        return botp;
    }

    private Map<String, Set<Long>> queryVMIRecord(Map<Long, Long> transferEntryIdAndBillIdMap) {
        QFilter srcEntryIdFilter = new QFilter("billentry.srcbillentryid", "in", transferEntryIdAndBillIdMap.keySet());
        QFilter purInIdFilter = new QFilter("billentry.purinbillid", "!=", (Object)0L);
        QFilter invIdFilter = new QFilter("billentry.invbillid", "!=", (Object)0L);
        HashMap<String, Set<Long>> entityNoAndTargetBillIds = new HashMap<String, Set<Long>>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_vmisettlerecord", (String)"billentry.purinbillentity as purinbillentity,billentry.purinbillid as purinbillid,billentry.invbillentity as invbillentity ,billentry.invbillid as invbillid,billentry.srcbillentryid as srcbillentryid", (QFilter[])new QFilter[]{srcEntryIdFilter, purInIdFilter, invIdFilter}, null);){
            for (Row row : dataSet) {
                String purinbillentity = row.getString("purinbillentity");
                String invbillentity = row.getString("invbillentity");
                Long purinbillid = row.getLong("purinbillid");
                Long invbillid = row.getLong("invbillid");
                Set<Long> invBills = entityNoAndTargetBillIds.get(invbillentity) == null ? new HashSet(10) : (Set)entityNoAndTargetBillIds.get(invbillentity);
                Set<Long> purInBills = entityNoAndTargetBillIds.get(purinbillentity) == null ? new HashSet(10) : (Set)entityNoAndTargetBillIds.get(purinbillentity);
                invBills.add(invbillid);
                purInBills.add(purinbillid);
                entityNoAndTargetBillIds.put(purinbillentity, purInBills);
                entityNoAndTargetBillIds.put(invbillentity, invBills);
            }
        }
        return entityNoAndTargetBillIds;
    }

    public VMISettleResult getResult() {
        return this.result;
    }
}

