/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMIRecordInvInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMIRecordPurInInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;

public class AddVirtualBillInfoAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(AddVirtualBillInfoAction.class);

    public AddVirtualBillInfoAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u8ffd\u52a0\u865a\u5355\u4fe1\u606f \u5f00\u59cb\uff1a" + this.settleContext);
        log.info("\u8ffd\u52a0\u865a\u5355\u4fe1\u606f \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        Map<Long, Long> transferEntryIdAndBillIdMap = this.settleContext.getTransferEntryIdAndBillIdMap();
        if (CommonUtils.isNull(transferEntryIdAndBillIdMap)) {
            return;
        }
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u7ed3\u7b97\u8bb0\u5f55\u8ffd\u52a0\u865a\u5355\u4fe1\u606f", (String)"AddVirtualBillInfoAction_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        List<Object> allPurInIds = this.settleContext.getAllPurInIds();
        List<Object> invIds = this.settleContext.getInvIds();
        if (CommonUtils.isNull(allPurInIds) && CommonUtils.isNull(invIds)) {
            return;
        }
        Long[] transferBillEntryIDs = transferEntryIdAndBillIdMap.keySet().toArray(new Long[transferEntryIdAndBillIdMap.size()]);
        Long[] billIds = transferEntryIdAndBillIdMap.values().toArray(new Long[0]);
        log.info("\u67e5\u8be2\u865a\u5355\u94fe\u8def\u4fe1\u606f \u5f00\u59cb\uff1a" + System.currentTimeMillis());
        List targetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_transferbill", (String)"billentry", (Long[])billIds, (Long[])transferBillEntryIDs, (OperateOption)OperateHelper.getBFTrackerOperateOption());
        log.info("\u67e5\u8be2\u865a\u5355\u94fe\u8def\u4fe1\u606f \u7ed3\u675f\uff1a" + System.currentTimeMillis());
        this.settleContext.setTargetRowIds(targetRowIds);
        Map<Long, Long> TFRowIDAndPInRowID = this.getTFRowIdANdTargetRowId(targetRowIds, this.settleContext.getPurInBillTableId(), allPurInIds);
        Map<Long, Long> TFRowIDAndInvRowID = this.getTFRowIdANdTargetRowId(targetRowIds, this.settleContext.getInvBillTableId(), invIds);
        log.info("\u589e\u52a0\u5165\u5e93\u4fe1\u606f \u5f00\u59cb\uff1a" + System.currentTimeMillis());
        this.settleRecordInfoMap = this.addPurInBillInfo(transferEntryIdAndBillIdMap, TFRowIDAndPInRowID);
        log.info("\u589e\u52a0\u5165\u5e93\u4fe1\u606f \u7ed3\u675f\uff1a" + System.currentTimeMillis());
        log.info("\u589e\u52a0\u5e93\u5b58\u4fe1\u606f \u5f00\u59cb\uff1a" + System.currentTimeMillis());
        this.settleRecordInfoMap = this.addReqOutBillInfo(transferEntryIdAndBillIdMap, TFRowIDAndInvRowID);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
        log.info("\u589e\u52a0\u5e93\u5b58\u4fe1\u606f \u7ed3\u675f\uff1a" + System.currentTimeMillis());
        log.info("\u8ffd\u52a0\u865a\u5355\u4fe1\u606f \u7ed3\u675f\uff1a" + this.settleContext);
        log.info("\u8ffd\u52a0\u865a\u5355\u4fe1\u606f \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private Map<Long, Long> getTFRowIdANdTargetRowId(List<BFRow> targetRowIds, Long targetTableID, List<Object> targetBillIDs) {
        HashMap<Long, Long> tFRowIDAndTargetRowID = new HashMap<Long, Long>(targetRowIds.size());
        for (BFRow bfRow : targetRowIds) {
            BFRowId sId = bfRow.getSId();
            BFRowId id = bfRow.getId();
            Long tableId = id.getTableId();
            Long sEntryId = sId.getEntryId();
            Long tEntryId = id.getEntryId();
            Long tbillId = id.getBillId();
            if (!targetTableID.equals(tableId) || !targetBillIDs.contains(tbillId)) continue;
            tFRowIDAndTargetRowID.put(sEntryId, tEntryId);
        }
        return tFRowIDAndTargetRowID;
    }

    private Map<Long, VMISettleRecordInfo> addPurInBillInfo(Map<Long, Long> transferEntryIdAndBillIdMap, Map<Long, Long> TFRowIDAndPInRowID) {
        QFilter purInQfilter = new QFilter("billentry.id", "in", (Object)TFRowIDAndPInRowID.values().toArray(new Long[TFRowIDAndPInRowID.size()]));
        DynamicObjectCollection purInCollection = QueryServiceHelper.query((String)this.settleContext.getPurInEntity(), (String)String.join((CharSequence)",", AddVirtualBillInfoAction.getPurInBillField()), (QFilter[])new QFilter[]{purInQfilter});
        HashMap<Long, VMIRecordPurInInfo> purInEntryIdAndPurInInfoMap = new HashMap<Long, VMIRecordPurInInfo>();
        for (DynamicObject dynamicObject : purInCollection) {
            Long purInBillId = (Long)dynamicObject.get("id");
            String purInBillno = (String)dynamicObject.get("billno");
            Long purInBillEntryId = (Long)dynamicObject.get("billentry.id");
            Integer purInBillEntrySeq = (Integer)dynamicObject.get("billentry.seq");
            String purInBillStatus = dynamicObject.getString("billstatus");
            VMIRecordPurInInfo purInInfo = new VMIRecordPurInInfo(this.settleContext.getPurInEntity(), purInBillId, purInBillno, purInBillEntryId, purInBillEntrySeq, purInBillStatus);
            purInEntryIdAndPurInInfoMap.put(purInBillEntryId, purInInfo);
        }
        purInCollection.clear();
        for (Map.Entry<Long, Long> entry : TFRowIDAndPInRowID.entrySet()) {
            Long tFRowId = entry.getKey();
            Long tFId = transferEntryIdAndBillIdMap.get(tFRowId);
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(tFId);
            Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
            for (Map.Entry<Long, VMISettleRecordEntryInfo> recordOneEntry : entryInfos.entrySet()) {
                Long tfRowId = recordOneEntry.getKey();
                Long purInRowId = TFRowIDAndPInRowID.get(tfRowId);
                VMIRecordPurInInfo vmiRecordPurInInfo = (VMIRecordPurInInfo)purInEntryIdAndPurInInfoMap.get(purInRowId);
                VMISettleRecordEntryInfo entryInfo = recordOneEntry.getValue();
                entryInfo.setPurInBillId(vmiRecordPurInInfo.getPurInBillId());
                entryInfo.setPurInBillEntryId(vmiRecordPurInInfo.getPurInBillEntryId());
                entryInfo.setPurInBillEntity(vmiRecordPurInInfo.getPurInBillEntity());
                entryInfo.setPurInBillNumber(vmiRecordPurInInfo.getPurInBillNumber());
                entryInfo.setPurInBillEntrySeq(vmiRecordPurInInfo.getPurInBillEntrySeq());
                entryInfo.setPurInBillStatus(vmiRecordPurInInfo.getPurInBillStatus());
            }
        }
        return this.settleRecordInfoMap;
    }

    protected static List<String> getPurInBillField() {
        ArrayList<String> list = new ArrayList<String>(16);
        Collections.addAll(list, "billno", "id", "billstatus", "billentry.seq", "billentry.id", "billentry.srcbillentryid,billentry.material.masterid");
        return list;
    }

    private Map<Long, VMISettleRecordInfo> addReqOutBillInfo(Map<Long, Long> transferEntryIdAndBillIdMap, Map<Long, Long> TFRowIDAndInvRowID) {
        QFilter reqOutQfilter = new QFilter("billentry.id", "in", (Object)TFRowIDAndInvRowID.values().toArray(new Long[TFRowIDAndInvRowID.size()]));
        DynamicObjectCollection reqOutCollection = QueryServiceHelper.query((String)this.settleContext.getInvInEntity(), (String)String.join((CharSequence)",", this.getReqOutBillField()), (QFilter[])new QFilter[]{reqOutQfilter});
        HashMap<Long, VMIRecordInvInfo> invEntryIdAndInvInfoMap = new HashMap<Long, VMIRecordInvInfo>();
        for (DynamicObject dynamicObject : reqOutCollection) {
            Long invBillId = (Long)dynamicObject.get("id");
            String invBillno = (String)dynamicObject.get("billno");
            Long invBillEntryId = (Long)dynamicObject.get("billentry.id");
            Integer invBillEntrySeq = (Integer)dynamicObject.get("billentry.seq");
            String invBillStatus = dynamicObject.getString("billstatus");
            VMIRecordInvInfo invInfo = new VMIRecordInvInfo(this.settleContext.getInvInEntity(), invBillId, invBillno, invBillEntryId, invBillEntrySeq, invBillStatus);
            invEntryIdAndInvInfoMap.put(invBillEntryId, invInfo);
        }
        reqOutCollection = null;
        for (Map.Entry<Long, Long> entry : TFRowIDAndInvRowID.entrySet()) {
            Long tFRowId = entry.getKey();
            Long tFId = transferEntryIdAndBillIdMap.get(tFRowId);
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(tFId);
            Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
            for (Map.Entry<Long, VMISettleRecordEntryInfo> recordOneEntry : entryInfos.entrySet()) {
                Long tfRowId = recordOneEntry.getKey();
                Long invRowId = TFRowIDAndInvRowID.get(tfRowId);
                VMIRecordInvInfo vmiRecordinvInfo = (VMIRecordInvInfo)invEntryIdAndInvInfoMap.get(invRowId);
                VMISettleRecordEntryInfo entryInfo = recordOneEntry.getValue();
                entryInfo.setInvBillId(vmiRecordinvInfo.getinvBillId());
                entryInfo.setInvBillEntryId(vmiRecordinvInfo.getinvBillEntryId());
                entryInfo.setInvBillEntity(vmiRecordinvInfo.getinvBillEntity());
                entryInfo.setInvBillNumber(vmiRecordinvInfo.getinvBillNumber());
                entryInfo.setInvBillEntrySeq(vmiRecordinvInfo.getinvBillEntrySeq());
                entryInfo.setInvBillStatus(vmiRecordinvInfo.getinvBillStatus());
            }
        }
        invEntryIdAndInvInfoMap = null;
        return this.settleRecordInfoMap;
    }

    private List<String> getReqOutBillField() {
        ArrayList<String> list = new ArrayList<String>(16);
        Collections.addAll(list, "billno", "id", "billstatus", "billentry.id", "billentry.seq", "billentry.srcbillentryid");
        return list;
    }
}

