/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

public class DoVirtualBillSubmitOperationAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(DoVirtualBillSubmitOperationAction.class);
    private List<DynamicObject> purInBillList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> invBillsList = new ArrayList<DynamicObject>(10);

    public DoVirtualBillSubmitOperationAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u5f00\u59cb\uff1a" + this.settleContext);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        List<Object> isNotInnerDealPurInIds = this.settleContext.getIsNotInnerDealPurInIds();
        List<Object> invIds = this.settleContext.getInvIds();
        log.info("\u5e93\u5b58\u5355 id\uff1a" + invIds);
        if (CommonUtils.isNull(invIds) || CommonUtils.isNull(isNotInnerDealPurInIds)) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"DoVirtualBillSubmitOperationAction");){
            this.queryAllTargetBill();
            this.submitIsNotInnerDealBillTarOperate();
        }
        this.settleContext.setPurInBillList(this.purInBillList);
        this.settleContext.setInvBillsList(this.invBillsList);
        ArrayList<Object> allPurInIds = new ArrayList<Object>(10);
        allPurInIds.addAll(this.settleContext.getIsNotInnerDealPurInIds());
        this.settleContext.setAllPurInIds(allPurInIds);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u7ed3\u675f\uff1a" + this.settleContext);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private void queryAllTargetBill() {
        DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)this.settleContext.getPurInEntity(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", this.settleContext.getAllPurInIds())});
        this.purInBillList = new ArrayList<DynamicObject>(Arrays.asList(purInBills));
        if (!CommonUtils.isNull(this.settleContext.getInvIds())) {
            DynamicObject[] invBills = BusinessDataServiceHelper.load((String)this.settleContext.getInvInEntity(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", this.settleContext.getInvIds())});
            this.invBillsList = new ArrayList<DynamicObject>(Arrays.asList(invBills));
        }
    }

    private void submitIsNotInnerDealBillTarOperate() {
        List<Object> isNotInnerDealPurInBillIdList = this.settleContext.getIsNotInnerDealPurInIds();
        List<Object> isNotInnerDealInvBillIdList = this.settleContext.getInvIds();
        if (CommonUtils.isNull(isNotInnerDealPurInBillIdList) || CommonUtils.isNull(isNotInnerDealInvBillIdList)) {
            return;
        }
        Collection<Long> transferBillIds = this.settleContext.getIsNotInnerDealEntryIdAndBillIdMap().values();
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u5165\u5e93\u865a\u5355\u6267\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"DoVirtualBillSubmitOperationAction_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        List<Object> submitSuccessPurInBillId = this.invokeAndGetSuccessIds("submit", this.settleContext.getPurInEntity(), this.settleContext.getIsNotInnerDealPurInIds(), transferBillIds, this.purInBillList);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u63d0\u4ea4\u6210\u529f\u7684id \uff1a" + submitSuccessPurInBillId);
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u5e93\u5b58\u865a\u5355\u6267\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"DoVirtualBillSubmitOperationAction_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        List<Object> submitSuccessInvBillId = this.invokeAndGetSuccessIds("submit", this.settleContext.getInvInEntity(), this.settleContext.getInvIds(), transferBillIds, this.invBillsList);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u5e93\u5b58\u63d0\u4ea4\u6210\u529f\u7684id \uff1a" + submitSuccessInvBillId);
        if (isNotInnerDealPurInBillIdList.size() == submitSuccessPurInBillId.size() && isNotInnerDealInvBillIdList.size() == submitSuccessInvBillId.size()) {
            log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u865a\u5355\u63d0\u4ea4\u5168\u90e8\u6210\u529f\u3002");
            this.settleContext.setInvIds(submitSuccessInvBillId);
            this.settleContext.setIsNotInnerDealPurInIds(submitSuccessPurInBillId);
            return;
        }
        if (CommonUtils.isNull(submitSuccessInvBillId) || CommonUtils.isNull(submitSuccessPurInBillId)) {
            this.settleContext.getInvIds().clear();
            this.settleContext.getIsNotInnerDealPurInIds().clear();
            return;
        }
        HashSet<Object> submitPurInFailIds = this.getSubmitFailBill4Current(submitSuccessPurInBillId, this.settleContext.getIsNotInnerDealPurInIds());
        HashSet<Object> submitInvFailIds = this.getSubmitFailBill4Current(submitSuccessInvBillId, this.settleContext.getInvIds());
        this.getNeedAuditBill4Relation(submitPurInFailIds, submitInvFailIds);
    }

    private void getNeedAuditBill4Relation(HashSet<Object> submitPurInFailIds, HashSet<Object> submitInvFailIds) {
        Long invBillId;
        Long purInBillId;
        VMISettleRecordEntryInfo entryInfo;
        Map<Long, VMISettleRecordEntryInfo> entryInfos;
        VMISettleRecordInfo record;
        for (Map.Entry recordInfoEntry : this.settleRecordInfoMap.entrySet()) {
            record = (VMISettleRecordInfo)recordInfoEntry.getValue();
            entryInfos = record.getEntryInfos();
            if (CommonUtils.isNull(entryInfos)) continue;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entryInfoEntry : entryInfos.entrySet()) {
                entryInfo = entryInfoEntry.getValue();
                purInBillId = entryInfo.getPurInBillId();
                invBillId = entryInfo.getInvBillId();
                if (submitPurInFailIds.contains(purInBillId)) {
                    submitInvFailIds.add(invBillId);
                }
                if (!submitInvFailIds.contains(invBillId)) continue;
                submitPurInFailIds.add(purInBillId);
            }
        }
        for (Map.Entry recordInfoEntry : this.settleRecordInfoMap.entrySet()) {
            record = (VMISettleRecordInfo)recordInfoEntry.getValue();
            entryInfos = record.getEntryInfos();
            if (CommonUtils.isNull(entryInfos)) continue;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entryInfoEntry : entryInfos.entrySet()) {
                entryInfo = entryInfoEntry.getValue();
                purInBillId = entryInfo.getPurInBillId();
                invBillId = entryInfo.getInvBillId();
                if (submitPurInFailIds.contains(purInBillId)) {
                    submitInvFailIds.add(invBillId);
                }
                if (!submitInvFailIds.contains(invBillId)) continue;
                submitPurInFailIds.add(purInBillId);
            }
        }
        this.settleContext.getInvIds().removeAll(submitInvFailIds);
        this.settleContext.getIsNotInnerDealPurInIds().removeAll(submitPurInFailIds);
    }

    private HashSet<Object> getSubmitFailBill4Current(List<Object> submitSuccessBillId, List<Object> purInIds) {
        ArrayList<Object> result = new ArrayList<Object>(purInIds);
        result.removeAll(submitSuccessBillId);
        return new HashSet<Object>(result);
    }

    private List<Object> invokeAndGetSuccessIds(String opKey, String entity, List<Object> billids, Collection<Long> transferBillIds, List<DynamicObject> tarBillList) {
        ArrayList<Object> successIds = new ArrayList(10);
        try {
            OperationResult operationResult = OperateHelper.invokeBillOp(opKey, entity, billids.toArray());
            if (!operationResult.isSuccess()) {
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo(opKey, operationResult, tarBillList);
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.settleRecordInfoMap, opFialMsg, VMISettleResultEnum.SETTLEFAIL);
            }
            successIds = operationResult.getSuccessPkIds();
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            log.info(opKey + " \u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff1a" + exceptionMsg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
        }
        return successIds;
    }
}

