/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class FilterSourceBillAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(FilterSourceBillAction.class);
    private final BigDecimal ZERO = BigDecimal.ZERO;
    List<DynamicObject> transferBills;
    Map<Long, Long> transferEntryIdAndBillIdMap;

    public FilterSourceBillAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u8fc7\u6ee4\u6e90\u5355\u4fe1\u606f\u5f00\u59cb \u5f00\u59cb" + this.settleContext);
        log.info("\u8fc7\u6ee4\u6e90\u5355\u4fe1\u606f\u5f00\u59cb \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        this.transferBills = this.settleContext.getTransferBill();
        this.transferEntryIdAndBillIdMap = this.settleContext.getTransferEntryIdAndBillIdMap();
        if (CommonUtils.isNull(this.transferBills) || CommonUtils.isNull(this.transferEntryIdAndBillIdMap)) {
            return;
        }
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u7ed3\u7b97\u5355\u636e\u8fdb\u884c\u8fc7\u6ee4\uff0c\u6392\u9664\u6389\u4e0d\u53ef\u4ee5\u7ed3\u7b97\u7684\u5355\u636e", (String)"FilterSourceBillAction_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), new Date());
        try (TraceSpan span = Tracer.create((String)"FilterSourceBillAction.doAction", (String)"doAction");){
            this.addBOTPTbaleId(this.settleContext);
            this.filterHasSettleFailBill();
            this.filterHasQtyAndAmountInfo();
        }
        this.settleContext.setTransferBill(this.transferBills);
        this.settleContext.setTransferEntryIdAndBillIdMap(this.transferEntryIdAndBillIdMap);
        log.info("\u8fc7\u6ee4\u6e90\u5355\u4fe1\u606f\u5f00\u59cb \u7ed3\u675f" + this.settleContext);
        log.info("\u8fc7\u6ee4\u6e90\u5355\u4fe1\u606f\u5f00\u59cb \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
    }

    private void filterHasSettleFailBill() {
        VMISettleTypeEnum settleType = this.settleContext.getSettleType();
        if (VMISettleTypeEnum.REALTIME == settleType) {
            return;
        }
        ArrayList<Long> settleFailBillIdList = new ArrayList<Long>(10);
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_transferbill", (String)"billentry", (Long[])this.transferEntryIdAndBillIdMap.values().toArray(new Long[0]), (Long[])this.transferEntryIdAndBillIdMap.keySet().toArray(new Long[0]), (OperateOption)OperateHelper.getBFTrackerOperateOption());
        if (CommonUtils.isNull((Object)bfRows)) {
            log.info("\u4e0b\u6e38\u865a\u5355\u5185\u5bb9\u4e3a\u7a7a\u3002");
            return;
        }
        settleFailBillIdList.addAll(this.checkIsNotInnerDealSettle(bfRows));
        log.info("\u5168\u90e8 \u67e5\u8be2\u7ed3\u7b97\u5931\u8d25\u7684\u7269\u6743\u8f6c\u79fb\u5355ID \uff1a" + settleFailBillIdList);
        if (settleFailBillIdList == null || settleFailBillIdList.isEmpty()) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u7684\u7ed3\u7b97\u5355\u636e\uff0c\u8bf7\u91cd\u8bd5\u4fee\u590d\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"FilterSourceBillAction_1", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        for (Long hasFailTarTFBillId : settleFailBillIdList) {
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(hasFailTarTFBillId);
            recordInfo.setSelttleResult(VMISettleResultEnum.WARNNING);
            recordInfo.setSettledetails(msg);
        }
        List<DynamicObject> transferBills = this.settleContext.getTransferBill();
        Iterator<DynamicObject> iterator = transferBills.iterator();
        while (iterator.hasNext()) {
            Long transferBillId = (Long)iterator.next().getPkValue();
            if (!settleFailBillIdList.contains(transferBillId)) continue;
            iterator.remove();
        }
        this.transferEntryIdAndBillIdMap.values().removeAll(settleFailBillIdList);
    }

    private HashSet<Long> checkIsNotInnerDealSettle(List<BFRow> dirtTargetBills) {
        List<Long> isNotinnerDealBillEntryIds = this.getBillEntryIds(this.transferBills, false);
        List<BFRow> currentEntryBFRow = this.filterByTransferEntryID(dirtTargetBills, isNotinnerDealBillEntryIds);
        HashSet<Long> failBillID = this.getOneEntitySettleFailTransferBillID(currentEntryBFRow, this.settleContext.getPurInEntity(), this.settleContext.getPurInBillTableId(), isNotinnerDealBillEntryIds);
        failBillID.addAll(this.getOneEntitySettleFailTransferBillID(currentEntryBFRow, this.settleContext.getInvInEntity(), this.settleContext.getInvBillTableId(), isNotinnerDealBillEntryIds));
        return failBillID;
    }

    private List<BFRow> filterByTransferEntryID(List<BFRow> dirtTargetBills, List<Long> transferBillEntryIdList) {
        ArrayList<BFRow> result = new ArrayList<BFRow>(10);
        for (BFRow bfRow : dirtTargetBills) {
            BFRowId sId = bfRow.getSId();
            Long entryId = sId.getEntryId();
            if (!transferBillEntryIdList.contains(entryId)) continue;
            result.add(bfRow);
        }
        return result;
    }

    private HashSet<Long> getOneEntitySettleFailTransferBillID(List<BFRow> purInBFRow, String entity, Long tableId, List<Long> entryIds) {
        HashSet<Long> failIdList = new HashSet<Long>(10);
        if (purInBFRow == null || purInBFRow.isEmpty()) {
            return new HashSet<Long>(10);
        }
        HashSet<Long> tarBillIDSet = new HashSet<Long>(10);
        for (BFRow bfRow : purInBFRow) {
            Long entryId = bfRow.getSId().getEntryId();
            BFRowId tid = bfRow.getId();
            Long tTableId = tid.getTableId();
            if (!entryIds.contains(entryId) || !tTableId.equals(tableId)) continue;
            tarBillIDSet.add(bfRow.getId().getBillId());
        }
        DynamicObjectCollection targetBillCol = QueryServiceHelper.query((String)entity, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", tarBillIDSet)});
        if (targetBillCol == null || targetBillCol.isEmpty()) {
            return new HashSet<Long>(10);
        }
        for (DynamicObject bill : targetBillCol) {
            String billstatus = bill.getString("billstatus");
            if (!"C".equals(billstatus)) continue;
            tarBillIDSet.remove(bill.getLong("id"));
        }
        if (tarBillIDSet.isEmpty()) {
            return new HashSet<Long>(10);
        }
        for (BFRow bfRow : purInBFRow) {
            BFRowId id = bfRow.getId();
            BFRowId sId = bfRow.getSId();
            Long billId = id.getBillId();
            Long sIdBillId = sId.getBillId();
            if (!tarBillIDSet.contains(billId)) continue;
            failIdList.add(sIdBillId);
        }
        return failIdList;
    }

    private void filterHasQtyAndAmountInfo() {
        Iterator<DynamicObject> iterator = this.transferBills.iterator();
        ArrayList<Long> hasNoAmountInfoBillIdList = new ArrayList<Long>();
        block0: while (iterator.hasNext()) {
            DynamicObject bill = iterator.next();
            Long billId = (Long)bill.getPkValue();
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < billEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntrys.get(i);
                BigDecimal price = entry.getBigDecimal("price");
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                if (price != null && priceAndTax != null && price.compareTo(this.ZERO) != 0 && priceAndTax.compareTo(this.ZERO) != 0) continue;
                hasNoAmountInfoBillIdList.add(billId);
                iterator.remove();
                continue block0;
            }
        }
        if (hasNoAmountInfoBillIdList.isEmpty()) {
            return;
        }
        this.transferEntryIdAndBillIdMap.values().removeAll(hasNoAmountInfoBillIdList);
        for (Long hasNoAmountInfoBillId : hasNoAmountInfoBillIdList) {
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(hasNoAmountInfoBillId);
            recordInfo.setSelttleResult(VMISettleResultEnum.WARNNING);
            recordInfo.setSettledetails(ResManager.loadKDString((String)"\u4ef7\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"FilterSourceBillAction_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
    }

    private List<Long> getBillEntryIds(List<DynamicObject> transferBill, boolean innerDeal) {
        ArrayList<Long> billEntryIds = new ArrayList<Long>(10);
        for (DynamicObject bill : transferBill) {
            boolean isInnerDealFlag = bill.getBoolean("isintertransaction");
            if (isInnerDealFlag != innerDeal) continue;
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                billEntryIds.add((Long)row.getPkValue());
            }
        }
        return billEntryIds;
    }

    private void addBOTPTbaleId(VMISettleContext settleContext) {
        TableDefine purInTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)settleContext.getPurInEntity(), (String)"billentry");
        TableDefine invTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)settleContext.getInvInEntity(), (String)"billentry");
        settleContext.setPurInBillTableId(purInTableDefine.getTableId());
        settleContext.setInvBillTableId(invTableDefine.getTableId());
        log.info("\u91c7\u8d2d\u5165\u5e93\u5355TableId\u4e3a\uff1a" + purInTableDefine.getTableId() + " ,\u6e90\u5355TableId \u4e3a\uff1a" + invTableDefine.getTableId());
    }
}

