/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.BotpHelper;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.GenerateTargetResult;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

public class GenereateSettleBillAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(GenereateSettleBillAction.class);
    private List<Object> allPurInIds = new ArrayList<Object>(10);

    public GenereateSettleBillAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() throws Exception {
        log.info("\u751f\u6210\u865a\u5355\u5e76\u4fdd\u5b58 \u5f00\u59cb" + this.settleContext);
        log.info("\u751f\u6210\u865a\u5355\u5e76\u4fdd\u5b58 \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        List<DynamicObject> transferBill = this.settleContext.getTransferBill();
        if (CommonUtils.isNull(this.settleContext.getTransferBill()) || CommonUtils.isNull(this.settleContext.getTransferEntryIdAndBillIdMap())) {
            return;
        }
        Map<String, String> paramMap = this.settleContext.getParamMap();
        this.generateSettleIsNotInnerDealBill(transferBill, paramMap);
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u4e0b\u63a8\u5165\u5e93\u865a\u5355\u7ed3\u679c\u4e3a\uff1a" + this.settleContext.getIsNotInnerDealPurInIds());
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u4e0b\u63a8\u5e93\u5b58\u865a\u5355\u7ed3\u679c\u4e3a\uff1a" + this.settleContext.getInvIds());
        this.settleContext.setAllPurInIds(this.allPurInIds);
        log.info("\u751f\u6210\u865a\u5355\u5e76\u4fdd\u5b58 \u7ed3\u675f" + this.settleContext);
        log.info("\u751f\u6210\u865a\u5355\u5e76\u4fdd\u5b58 \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private void handleFailGenResult(GenerateTargetResult genAndSaveOpResult, Collection<Long> transferBillIds) {
        transferBillIds = new HashSet<Long>(transferBillIds);
        if (!CommonUtils.isNull((Object)genAndSaveOpResult.getExceptionMsg())) {
            this.addExceptionMsg(genAndSaveOpResult, transferBillIds);
        } else if (!genAndSaveOpResult.isPushSrcSuccess()) {
            this.buildPushErrorInfo2Record(genAndSaveOpResult);
        } else {
            this.buildSaveErrorInfo2Record(transferBillIds, genAndSaveOpResult);
        }
    }

    private void generateSettleIsNotInnerDealBill(List<DynamicObject> transferBill, Map<String, String> paramMap) throws Exception {
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"generateSettleIsNotInnerDealBill");){
            Map<Long, Long> isNotInnerDealEntryIdAndBillIdMap = this.getEntryIdANdBillIdMap(transferBill, false);
            this.settleContext.setIsNotInnerDealEntryIdAndBillIdMap(isNotInnerDealEntryIdAndBillIdMap);
            log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u5f85\u7ed3\u7b97\u884cid\u548c\u5355idMap\u4e3a\uff1a" + isNotInnerDealEntryIdAndBillIdMap);
            log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u7ed3\u7b97\u7684\u53c2\u6570\u4e3a\uff1a" + paramMap);
            if (isNotInnerDealEntryIdAndBillIdMap.isEmpty()) {
                return;
            }
            Collection<Long> tranferBillIds = isNotInnerDealEntryIdAndBillIdMap.values();
            VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u751f\u6210\u5165\u5e93\u865a\u5355\u5e76\u4fdd\u5b58", (String)"GenereateSettleBillAction_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), new Date());
            GenerateTargetResult genPurInAndSaveOpResult = BotpHelper.pushAndSaveTargetBill("pm_transferbill", this.settleContext.getPurInEntity(), "billentry", this.settleContext.getSettleModelInfo().getToPurInBillRuleID(), isNotInnerDealEntryIdAndBillIdMap, paramMap);
            log.info("\u5165\u5e93\u5355\u4e0b\u63a8\u5e76\u4fdd\u5b58\u7ed3\u679c\uff1a" + genPurInAndSaveOpResult);
            if (!genPurInAndSaveOpResult.isSuccess()) {
                this.handleFailGenResult(genPurInAndSaveOpResult, tranferBillIds);
                if (!CommonUtils.isNull(genPurInAndSaveOpResult.getSaveFailTarIds())) {
                    ArrayList<DynamicObject> purInBills = new ArrayList<DynamicObject>(10);
                    List<Object> savePurInBillFailTarIds = genPurInAndSaveOpResult.getSaveFailTarIds();
                    log.info("\u5165\u5e93\u5931\u8d25\uff0c\u8fd4\u56de\u5f85\u5220\u9664\u7684\u5165\u5e93\u5355\u636e\uff1a" + savePurInBillFailTarIds);
                    Collections.addAll(purInBills, BusinessDataServiceHelper.load((String)this.settleContext.getPurInEntity(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", savePurInBillFailTarIds)}));
                    ArrayList<Object> purInBillIds = new ArrayList<Object>(10);
                    purInBills.forEach(bill -> purInBillIds.add(bill.getPkValue()));
                    if (purInBills.size() > 0) {
                        List<Object> purInDeleteSuccessIds = this.invokeAndGetSuccessIds("delete", this.settleContext.getPurInEntity(), purInBillIds, isNotInnerDealEntryIdAndBillIdMap.values(), purInBills);
                        log.info("\u5165\u5e93\u5931\u8d25\uff0c\u5220\u9664\u6210\u529f\u5730\u5165\u5e93\u865a\u5355id\u4e3a\uff1a" + purInDeleteSuccessIds);
                    }
                }
                VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
                return;
            }
            VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
            VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u751f\u6210\u5e93\u5b58\u865a\u5355\u5e76\u4fdd\u5b58", (String)"GenereateSettleBillAction_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
            GenerateTargetResult genSrcBillAndSaveOpResult = BotpHelper.pushAndSaveTargetBill("pm_transferbill", this.settleContext.getInvInEntity(), "billentry", this.settleContext.getSettleModelInfo().getToVMISettleSrcBillRuleID(), isNotInnerDealEntryIdAndBillIdMap, paramMap);
            log.info("\u5e93\u5b58\u5355\u4e0b\u63a8\u5e76\u4fdd\u5b58\u7ed3\u679c\uff1a" + genSrcBillAndSaveOpResult);
            if (!genSrcBillAndSaveOpResult.isSuccess()) {
                this.handleFailGenResult(genSrcBillAndSaveOpResult, tranferBillIds);
                ArrayList<DynamicObject> purInBills = new ArrayList<DynamicObject>(10);
                List<Object> savePurInBillSuccessTarIds = genPurInAndSaveOpResult.getSaveSuccessTarIds();
                log.info("\u5e93\u5b58\u865a\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u5f85\u5220\u9664\u7684\u5165\u5e93\u5355\u636e\uff1a" + savePurInBillSuccessTarIds);
                Collections.addAll(purInBills, BusinessDataServiceHelper.load((String)this.settleContext.getPurInEntity(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", savePurInBillSuccessTarIds)}));
                ArrayList<Object> purInBillIds = new ArrayList<Object>(10);
                purInBills.forEach(bill -> purInBillIds.add(bill.getPkValue()));
                if (purInBills.size() > 0) {
                    List<Object> purInDeleteSuccessIds = this.invokeAndGetSuccessIds("delete", this.settleContext.getPurInEntity(), purInBillIds, isNotInnerDealEntryIdAndBillIdMap.values(), purInBills);
                    log.info("\u5e93\u5b58\u865a\u5355\u5931\u8d25\uff0c\u5220\u9664\u6210\u529f\u5730\u5165\u5e93\u865a\u5355id\u4e3a\uff1a" + purInDeleteSuccessIds);
                }
                if (!CommonUtils.isNull(genSrcBillAndSaveOpResult.getSaveFailTarIds())) {
                    ArrayList<DynamicObject> invBills = new ArrayList<DynamicObject>(10);
                    List<Object> saveSrcBillFailTarIds = genSrcBillAndSaveOpResult.getSaveFailTarIds();
                    log.info("\u5e93\u5b58\u865a\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u5f85\u5220\u9664\u7684inv\u5355\u636e\uff1a" + saveSrcBillFailTarIds);
                    Collections.addAll(invBills, BusinessDataServiceHelper.load((String)this.settleContext.getInvInEntity(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", saveSrcBillFailTarIds)}));
                    ArrayList<Object> invBillIds = new ArrayList<Object>(10);
                    invBills.forEach(bill -> invBillIds.add(bill.getPkValue()));
                    if (invBills.size() > 0) {
                        List<Object> invDeleteSuccessIds = this.invokeAndGetSuccessIds("delete", this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity(), invBillIds, isNotInnerDealEntryIdAndBillIdMap.values(), invBills);
                        log.info("\u5e93\u5b58\u865a\u5355\u5931\u8d25\uff0c\u5220\u9664\u6210\u529f\u5730\u5e93\u5b58\u865a\u5355id\u4e3a\uff1a" + invDeleteSuccessIds);
                    }
                }
                VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
            }
            VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
            if (genPurInAndSaveOpResult.isSuccess() && genSrcBillAndSaveOpResult.isSuccess()) {
                this.settleContext.setInvIds(genSrcBillAndSaveOpResult.getSaveSuccessTarIds());
                List<Object> isNotInnerDealPurInSaveSuccessIds = genPurInAndSaveOpResult.getSaveSuccessTarIds();
                this.allPurInIds.addAll(isNotInnerDealPurInSaveSuccessIds);
                this.settleContext.setIsNotInnerDealPurInIds(isNotInnerDealPurInSaveSuccessIds);
                return;
            }
        }
    }

    private List<Object> invokeAndGetSuccessIds(String opKey, String entity, List<Object> billids, Collection<Long> transferBillIds, List<DynamicObject> tarBillList) {
        ArrayList<Object> successIds = new ArrayList(10);
        try {
            OperationResult operationResult = OperateHelper.invokeBillOp(opKey, entity, billids.toArray());
            successIds = operationResult.getSuccessPkIds();
            if (!operationResult.isSuccess()) {
                ArrayList<Long> deleteFailTarBillIds = new ArrayList<Long>();
                billids.forEach(id -> deleteFailTarBillIds.add((Long)id));
                deleteFailTarBillIds.removeAll(successIds);
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo(opKey, operationResult, tarBillList);
                if (opFialMsg.isEmpty() || deleteFailTarBillIds.isEmpty()) {
                    return successIds;
                }
                this.addDeleteFailMsgToRecord(entity, deleteFailTarBillIds, opFialMsg);
            }
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            log.info(opKey + " \u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff1a" + exceptionMsg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, transferBillIds, exceptionMsg, VMISettleResultEnum.WARNNING);
        }
        return successIds;
    }

    private void addDeleteFailMsgToRecord(String entity, List<Long> deleteFailTarBillIds, Map<Long, String> opFialMsg) {
        List linkUpRow = BFTrackerServiceHelper.loadBillLinkUp((String)entity, (Long[])deleteFailTarBillIds.toArray(new Long[0]), (boolean)true);
        for (BFRow linkRow : linkUpRow) {
            BFRowId sId;
            Long srcBillId;
            VMISettleRecordInfo recordInfo;
            BFRowId id = linkRow.getId();
            Long billId = id.getBillId();
            String targetBillFailMsg = opFialMsg.get(billId);
            if (!StringUtils.isNotBlank((CharSequence)targetBillFailMsg) || (recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(srcBillId = (sId = linkRow.getSId()).getBillId())) == null) continue;
            recordInfo.addSettledetails(targetBillFailMsg);
        }
    }

    private void addExceptionMsg(GenerateTargetResult genAndSaveOpResult, Collection<Long> tranferBillIds) {
        String exceptionMsg = genAndSaveOpResult.getExceptionMsg() == null ? "" : genAndSaveOpResult.getExceptionMsg();
        for (Long transferBillId : tranferBillIds) {
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(transferBillId);
            recordInfo.addSettledetails(recordInfo.getSettledetails() + exceptionMsg);
            recordInfo.setSelttleResult(VMISettleResultEnum.WARNNING);
        }
    }

    private void buildSaveErrorInfo2Record(Collection<Long> tranferBillIds, GenerateTargetResult genOpResult) {
        Map<Long, String> saveFailMsgMap = genOpResult.getSaveFailMsgMap();
        String msg = Arrays.toString(saveFailMsgMap.values().toArray());
        for (Long transferBillId : tranferBillIds) {
            VMISettleRecordInfo recordInfo = (VMISettleRecordInfo)this.settleRecordInfoMap.get(transferBillId);
            recordInfo.addSettledetails(recordInfo.getSettledetails() + msg);
            recordInfo.setSelttleResult(VMISettleResultEnum.SETTLEFAIL);
        }
    }

    private void buildPushErrorInfo2Record(GenerateTargetResult genOpResult) {
        Map settleRecordInfoMap = this.settleRecordInfoMap;
        Map<Long, String> pushFailMsgMap = genOpResult.getPushFailMsgMap();
        for (Map.Entry<Long, String> entry : pushFailMsgMap.entrySet()) {
            VMISettleRecordInfo vmiSettleRecordInfo = (VMISettleRecordInfo)settleRecordInfoMap.get(entry.getKey());
            String msg = vmiSettleRecordInfo.getSettledetails() + entry.getValue();
            vmiSettleRecordInfo.addSettledetails(msg);
            vmiSettleRecordInfo.setSelttleResult(VMISettleResultEnum.SETTLEFAIL);
        }
    }

    private Map<Long, Long> getEntryIdANdBillIdMap(List<DynamicObject> transferBill, boolean innerDeal) {
        HashMap<Long, Long> entryIdAndBillIdMap = new HashMap<Long, Long>(10);
        for (DynamicObject bill : transferBill) {
            Long billId = (Long)bill.getPkValue();
            boolean isInnerDealFlag = bill.getBoolean("isintertransaction");
            if (isInnerDealFlag != innerDeal) continue;
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            billEntrys.forEach(billEntry -> entryIdAndBillIdMap.put((Long)billEntry.getPkValue(), billId));
        }
        return entryIdAndBillIdMap;
    }
}

