/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;

public class GetCurrentSettleQtyAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(GetCurrentSettleQtyAction.class);
    private static List<String> qtyFiledNo = new ArrayList<String>(Arrays.asList("qty", "baseqty", "auxqty"));

    public GetCurrentSettleQtyAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u83b7\u53d6\u7ed3\u7b97\u6570\u91cf \u5f00\u59cb" + this.settleContext);
        log.info("\u83b7\u53d6\u7ed3\u7b97\u6570\u91cf \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        List<DynamicObject> transferBills = this.settleContext.getTransferBill();
        if (CommonUtils.isNull(this.settleContext.getTransferBill()) || CommonUtils.isNull(this.settleContext.getTransferEntryIdAndBillIdMap())) {
            return;
        }
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u83b7\u53d6\u7ed3\u7b97\u6570\u91cf", (String)"GetCurrentSettleQtyAction_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        Map<Long, Map<String, BigDecimal>> settleQtyMap = GetCurrentSettleQtyAction.buildSettleQtyMap(transferBills);
        log.info("\u8bb0\u5f55\u6b64\u6b21\u7ed3\u7b97\u6570\u91cf\u7ed3\u679c\uff1a" + settleQtyMap);
        this.settleContext.setSettleQtyMap(settleQtyMap);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u83b7\u53d6\u7ed3\u7b97\u6570\u91cf \u5f00\u59cb" + this.settleContext);
        log.info("\u83b7\u53d6\u7ed3\u7b97\u6570\u91cf \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
    }

    public static Map<Long, Map<String, BigDecimal>> buildSettleQtyMap(List<DynamicObject> bills) {
        HashMap<Long, Map<String, BigDecimal>> qtyMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billentry = (DynamicObjectCollection)bill.get("billentry");
            for (DynamicObject entry : billentry) {
                Long entryPkValue = (Long)entry.getPkValue();
                HashMap<String, BigDecimal> oneEntryQtyMap = new HashMap<String, BigDecimal>(5);
                for (String field : qtyFiledNo) {
                    oneEntryQtyMap.put(field, (BigDecimal)entry.get(field));
                }
                qtyMap.put(entryPkValue, oneEntryQtyMap);
            }
        }
        return qtyMap;
    }
}

