/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;

public class UpdateSettleRecordAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(UpdateSettleRecordAction.class);

    public UpdateSettleRecordAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5f00\u59cb" + this.settleContext);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        Map<Long, Long> transferEntryIdAndBillIdMap = this.settleContext.getTransferEntryIdAndBillIdMap();
        if (transferEntryIdAndBillIdMap == null || transferEntryIdAndBillIdMap.size() < 1) {
            return;
        }
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55", (String)"UpdateSettleRecordAction_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        List<Object> purInIds = this.settleContext.getAllPurInIds();
        List<Object> invIds = this.settleContext.getInvIds();
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 settleContext\u5165\u5e93\u5355id\uff1a" + purInIds);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 settleContext\u5e93\u5b58\u5355id\uff1a" + invIds);
        Map<String, HashSet<Long>> entityAndBillIds = VMISettleRecordHelper.buildEntityAndVBillIds(new ArrayList<VMISettleRecordInfo>(this.settleRecordInfoMap.values()));
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u7ed3\u7b97\u865a\u5355\u4fe1\u606f\uff1a" + entityAndBillIds);
        HashSet<Long> purInBillIds = entityAndBillIds.get(this.settleContext.getPurInEntity());
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5165\u5e93\u865a\u5355ID\u4fe1\u606f\uff1a" + purInBillIds);
        Map<Long, String> purInBillIdAndStatusMap = this.queryBillStatus(this.settleContext.getPurInEntity(), purInBillIds);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5165\u5e93\u5355\u5355\u636e\u72b6\u6001\uff1a" + purInBillIdAndStatusMap);
        HashSet<Long> invBillIds = entityAndBillIds.get(this.settleContext.getInvInEntity());
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5e93\u5b58\u865a\u5355ID\u4fe1\u606f\uff1a" + invBillIds);
        Map<Long, String> invBillIdAndStatusMap = this.queryBillStatus(this.settleContext.getInvInEntity(), invBillIds);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5e93\u5b58\u5355\u5355\u636e\u72b6\u6001\uff1a" + invBillIdAndStatusMap);
        this.settleRecordInfoMap = VMISettleRecordHelper.updateRecordStatusBySettle(purInBillIdAndStatusMap, invBillIdAndStatusMap, this.settleRecordInfoMap);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u7ed3\u675f" + this.settleContext);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private Map<Long, String> queryBillStatus(String tarBillEntity, Collection<Long> billIDs) {
        HashMap<Long, String> billStatusMap = new HashMap<Long, String>(10);
        if (CommonUtils.isNull(billIDs)) {
            return billStatusMap;
        }
        DynamicObjectCollection billStatusDB = QueryServiceHelper.query((String)tarBillEntity, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIDs)});
        for (DynamicObject bill : billStatusDB) {
            billStatusMap.put((Long)bill.get("id"), bill.getString("billstatus"));
        }
        return billStatusMap;
    }
}

