/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.pm.vmi.business.helper.TransferBillHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.common.enums.VMISettleExcutedStatusEnum;

public class WriteBackExcutedQtyAndStatusAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(WriteBackExcutedQtyAndStatusAction.class);

    public WriteBackExcutedQtyAndStatusAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u7ed3\u7b97\u8bb0\u5f55\u4e34\u65f6\u4fdd\u5b58 \u5f00\u59cb\uff1a" + this.settleContext);
        log.info("\u7ed3\u7b97\u8bb0\u5f55\u4e34\u65f6\u4fdd\u5b58 \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u53cd\u5199\u7269\u6743\u8f6c\u79fb\u5355\u5df2\u6267\u884c\u6570\u91cf", (String)"WriteBackExcutedQtyAndStatusAction_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        HashMap<Long, Map<String, BigDecimal>> qtyMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (VMISettleRecordInfo record : this.settleRecordInfoMap.values()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = record.getEntryInfos();
            entryInfos.entrySet().forEach(entry -> {
                VMISettleRecordEntryInfo entryValue = (VMISettleRecordEntryInfo)entry.getValue();
                String invBillStatus = entryValue.getInvBillStatus();
                if ("C".equals(invBillStatus)) {
                    HashMap<String, BigDecimal> rowQtyMap = new HashMap<String, BigDecimal>(5);
                    rowQtyMap.put("excutedqty", entryValue.getQty());
                    rowQtyMap.put("excutedbaseqty", entryValue.getBaseQty());
                    rowQtyMap.put("excutedauxqty", entryValue.getAuxQty());
                    qtyMap.put((Long)entry.getKey(), (Map<String, BigDecimal>)rowQtyMap);
                }
            });
        }
        TransferBillHelper.changeTransferBillExcutedStatusAndQty(qtyMap.keySet(), VMISettleExcutedStatusEnum.EXCUTEDSUCCESS, qtyMap);
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, new Date());
        log.info("\u7ed3\u7b97\u8bb0\u5f55\u4e34\u65f6\u4fdd\u5b58 \u7ed3\u675f\uff1a" + this.settleContext);
        log.info("\u7ed3\u7b97\u8bb0\u5f55\u4e34\u65f6\u4fdd\u5b58 \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }
}

