/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.async;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.async.VMIAsyncSettleFactory;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public abstract class VMIAsyncSettle {
    private static final Log log = LogFactory.getLog(VMIAsyncSettle.class);

    public static void asyncSettle(List<Long> transferBillId, String asyncType) {
        if (transferBillId == null || transferBillId.isEmpty()) {
            return;
        }
        VMIAsyncSettle instance = VMIAsyncSettleFactory.getInstance(asyncType);
        if (instance != null) {
            instance.doAsyncSettle(transferBillId);
        }
    }

    public abstract void doAsyncSettle(List<Long> var1);

    protected Set<Long> getRealTimeSettlePurOrgId(DynamicObject[] bills) {
        HashSet<Long> realTimeSettlePurOrgIds = new HashSet<Long>();
        if (CommonUtils.isNull((Object)bills)) {
            return realTimeSettlePurOrgIds;
        }
        HashSet<Long> purOrgIds = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            DynamicObject purOrg = (DynamicObject)bill.get("purorg");
            if (purOrg == null) continue;
            Long purOrgId = (Long)purOrg.getPkValue();
            purOrgIds.add(purOrgId);
        }
        if (CommonUtils.isNull(purOrgIds)) {
            return realTimeSettlePurOrgIds;
        }
        Map settleTypeParam = SysParamHelper.batchGetSysParam((String)"/JJVO8XV9MVB", (String)"02", new ArrayList(purOrgIds), (String)"fvmisettletype");
        log.info("\u83b7\u53d6\u662f\u5426\u5b9e\u65f6\u7ed3\u7b97\u7684\u53c2\u6570\u7ed3\u679c\u4e3a\uff1a " + settleTypeParam);
        return this.getRealTimeSettlePurOrgId(settleTypeParam);
    }

    protected Set<Long> getRealTimeSettlePurOrgId(Map<String, Object> settleTypeParam) {
        HashSet<Long> realTimeSettlePurOrgIds = new HashSet<Long>(10);
        if (CommonUtils.isNull(settleTypeParam)) {
            return realTimeSettlePurOrgIds;
        }
        for (Map.Entry<String, Object> onePurOrgPara : settleTypeParam.entrySet()) {
            Long purOrgId = Long.parseLong(onePurOrgPara.getKey());
            String settleType = (String)onePurOrgPara.getValue();
            if (!VMISettleTypeEnum.REALTIME.getValue().equals(settleType)) continue;
            realTimeSettlePurOrgIds.add(purOrgId);
        }
        return realTimeSettlePurOrgIds;
    }

    protected void sendMsgToUser(String msg) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> userIDS = new ArrayList<Long>(5);
        userIDS.add(currentUserId);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setUserIds(userIDS);
        MainEntityType transferBill = MetadataServiceHelper.getDataEntityType((String)"pm_transferbill");
        LocaleString disPlayName = transferBill.getDisplayName();
        msgInfo.setEntityNumber(transferBill.getName());
        msgInfo.setTitle(disPlayName.toString());
        msgInfo.setContent(msg);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }
}

