/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.async;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.async.VMIAsyncSettle;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMIAsyncSettleByThread
extends VMIAsyncSettle {
    private static final Log log = LogFactory.getLog(VMIAsyncSettleByThread.class);

    @Override
    public void doAsyncSettle(final List<Long> transferBillId) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                VMIAsyncSettleByThread.this.VMISettle(transferBillId);
            }
        };
        ThreadPools.executeOnce((String)"VMIService.AsyncExecuteVMISettle", (Runnable)run);
    }

    private void VMISettle(List<Long> ids) {
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_transferbill", (String)"id,billno,billentry.id,purorg", (QFilter[])qFilter);
        if (bills == null || bills.length < 1) {
            return;
        }
        Set<Long> realTimeSettlePurOrgId = this.getRealTimeSettlePurOrgId(bills);
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> sourceIdAndBillNoMap = new HashMap<Long, String>(16);
        VMISettleParam settleParam = new VMISettleParam(VMISettleTypeEnum.REALTIME);
        for (int i = 0; i < bills.length; ++i) {
            Long purorgPkValue;
            DynamicObject bill = bills[i];
            DynamicObject purorg = (DynamicObject)bill.get("purorg");
            if (purorg == null || !realTimeSettlePurOrgId.contains(purorgPkValue = (Long)purorg.getPkValue())) continue;
            Long billId = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            sourceIdAndBillNoMap.put(billId, billNo);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                sourceIdMap.put((Long)entry.getPkValue(), billId);
            }
        }
        if (CommonUtils.isNull(sourceIdMap)) {
            return;
        }
        settleParam.setTransferEntryIdAndBillIdMap(sourceIdMap);
        log.info("\u5b9e\u65f6\u7ed3\u7b97\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        VMISettleResult vmiSettleResult = VMISettleService.vmiSettle(settleParam);
        log.info("\u5b9e\u65f6\u7ed3\u7b97\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        if (vmiSettleResult != null && !vmiSettleResult.isSuccess()) {
            List<Long> failIds = vmiSettleResult.getFailIds();
            StringBuilder failBillNo = new StringBuilder();
            failIds.forEach(id -> failBillNo.append((String)sourceIdAndBillNoMap.get(id)).append('\uff0c'));
            this.sendMsgToUser(String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u201c%s\u201d\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIAsyncSettleByThread_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), failBillNo.substring(0, failBillNo.lastIndexOf("\uff0c"))));
        }
    }
}

