/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.factory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMISettleFactory {
    private static final Log log = LogFactory.getLog(VMISettleFactory.class);
    private static Map<VMISettleTypeEnum, String> serviceMap = new HashMap<VMISettleTypeEnum, String>(5);

    public static VMISettleService getInstance(VMISettleTypeEnum settleType) {
        if (settleType == null || !serviceMap.containsKey((Object)settleType)) {
            log.info("\u6ca1\u6709\u5339\u914d\u7684\u7ed3\u7b97\u7c7b\u578b");
            return null;
        }
        VMISettleService settleService = null;
        String className = serviceMap.get((Object)settleType);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                settleService = (VMISettleService)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u51fa\u73b0\u9519\u8bef\uff0c\u672a\u627e\u5230\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002" + e.getMessage() + Arrays.toString(e.getStackTrace()));
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u51fa\u73b0\u9519\u8bef\uff0c\u672a\u627e\u5230\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VMISettleFactory_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
            if (!(settleService instanceof VMISettleService)) {
                log.error("\u751f\u6210\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u51fa\u73b0\u9519\u8bef\uff0c\u7c7b\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002");
                return null;
            }
        }
        return settleService;
    }

    public static Map<VMISettleTypeEnum, String> getServiceMap() {
        return serviceMap;
    }

    public static void setServiceMap(Map<VMISettleTypeEnum, String> serviceMap) {
        VMISettleFactory.serviceMap = serviceMap;
    }

    static {
        serviceMap.put(VMISettleTypeEnum.CYCLE, "kd.scmc.pm.vmi.business.service.settle.impl.CycleSettleServiceImpl");
        serviceMap.put(VMISettleTypeEnum.MANUAL, "kd.scmc.pm.vmi.business.service.settle.impl.ManualSettleServiceImpl");
        serviceMap.put(VMISettleTypeEnum.REALTIME, "kd.scmc.pm.vmi.business.service.settle.impl.RealTimeSettleServiceImpl");
    }
}

