/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonUtil {
    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }

    public static <K, V> List<Map<K, V>> partition(Map<K, V> map, int batchSize) {
        ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>(16);
        if (map == null) {
            return result;
        }
        HashMap<K, V> temp = new HashMap<K, V>(10);
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            temp.put(entry.getKey(), entry.getValue());
            if (++i < batchSize) continue;
            result.add(temp);
            temp = new HashMap(10);
        }
        if (!temp.isEmpty()) {
            result.add(temp);
        }
        return result;
    }
}

