/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;
import kd.sdk.scmc.pm.extpoint.IVMISettleCasePlugin;

public class VMISettlePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_QUERY = "query";
    private static final String OP_SETTLEMENT = "settlement";
    private static final String OP_GAINPRICE = "gainprice";
    private static final String LINE_BREAK = "\r\n";
    private static final Log log = LogFactory.getLog(VMISettlePlugin.class);
    private final String CUR_AMTPRECISION = "amtprecision";
    private final String SETTLEPARAM_BOTPID = "botp";
    private final BigDecimal ZERO = BigDecimal.ZERO;

    public void registerListener(EventObject e) {
        BasedataEdit srcEntityNo;
        BasedataEdit supplier;
        BasedataEdit taxrateId;
        BasedataEdit recorg;
        super.registerListener(e);
        BasedataEdit purOrg = (BasedataEdit)this.getControl("purorg");
        if (purOrg != null) {
            purOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((recorg = (BasedataEdit)this.getControl("recorg")) != null) {
            recorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateId = (BasedataEdit)this.getControl("taxrateid")) != null) {
            taxrateId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((srcEntityNo = (BasedataEdit)this.getControl("srcentityno")) != null) {
            srcEntityNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        String formId = this.getView().getEntityId();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "purorg": {
                QFilter hasPerPurOrgF7Qfilter = this.getHasPerOrgF7Qfilter(formId, "02");
                showParameter.getListFilterParameter().getQFilters().add(hasPerPurOrgF7Qfilter);
                break;
            }
            case "taxrateid": {
                Date settleDate = (Date)this.getModel().getValue("settledate");
                QFilter q1 = new QFilter("activedate", "<=", (Object)settleDate);
                QFilter q2 = new QFilter("expdate", ">", (Object)settleDate);
                q2 = QFilter.isNull((String)"expdate").or(q2);
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                break;
            }
            case "supplier": {
                DynamicObject invOrg = (DynamicObject)this.getModel().getValue("recorg");
                if (invOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VMISettlePlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)"1");
                QFilter enableVmi = new QFilter("enablevmi", "=", (Object)"1");
                showParameter.getListFilterParameter().getQFilters().add(status.and(enable).and(enableVmi));
                break;
            }
            case "srcentityno": {
                QFilter q4 = new QFilter("enable", "=", (Object)"1");
                QFilter q3 = new QFilter("status", "=", (Object)"C");
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_vmisettlemodel", (String)"vmisettlesrcbill", (QFilter[])new QFilter[]{q4, q3});
                if (loadFromCache == null || loadFromCache.isEmpty()) {
                    return;
                }
                ArrayList list = new ArrayList(loadFromCache.size());
                loadFromCache.values().forEach(settleModel -> list.add(((DynamicObject)settleModel.get("vmisettlesrcbill")).getPkValue()));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", list));
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        model.setValue("start_bizdate", (Object)new Date());
        model.setValue("end_bizdate", (Object)new Date());
        String formId = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        long currentOrgId = RequestContext.get().getOrgId();
        Long queryRecOrg = null;
        Long queryPurOrg = null;
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)currentUserId, (String)"05", (String)appId, (String)formId, (String)"47150e89000000ac");
        if (!allPermOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            if (hasPermOrgs != null && !hasPermOrgs.isEmpty() && hasPermOrgs.contains(currentOrgId)) {
                queryRecOrg = currentOrgId;
            }
        } else {
            Boolean isInvOrg = OrgViewServiceHelper.isBizUnit((String)"05", (Long)currentOrgId);
            if (isInvOrg != null && isInvOrg.booleanValue()) {
                queryRecOrg = currentOrgId;
            }
        }
        List hasPermissionPurOrg = OrgHelper.getHasPermissionOrg((String)formId, (String)"02");
        if (queryRecOrg != null && !queryRecOrg.equals(0L)) {
            List purOrgs = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)queryRecOrg, (String)"02", (boolean)false);
            for (Long purOrgFrom : hasPermissionPurOrg) {
                if (!purOrgs.contains(purOrgFrom)) continue;
                queryPurOrg = purOrgFrom;
                break;
            }
        }
        model.setValue("recorg", (Object)queryRecOrg);
        model.setValue("purorg", queryPurOrg);
    }

    /*
     * Unable to fully structure code
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        var3_3 = key = ((AbstractOperate)e.getSource()).getOperateKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 107944136: {
                if (!var3_3.equals("query")) break;
                var4_4 = 0;
                break;
            }
            case 73828649: {
                if (!var3_3.equals("settlement")) break;
                var4_4 = 1;
                break;
            }
            case 2019409194: {
                if (!var3_3.equals("gainprice")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                billInfo = this.queryTransferBillInfo();
                var6_7 = null;
                if (billInfo != null) ** GOTO lbl34
                e.setCancel(true);
                if (billInfo == null) ** GOTO lbl32
                if (var6_7 == null) ** GOTO lbl31
                try {
                    billInfo.close();
                }
                catch (Throwable var7_9) {
                    var6_7.addSuppressed(var7_9);
                }
                ** GOTO lbl32
lbl31:
                // 1 sources

                billInfo.close();
lbl32:
                // 4 sources

                return;
lbl34:
                // 2 sources

                dbEntryCount = billInfo.copy().count("billentryid", false);
                queryCountFromSysParam = this.getQueryCountFromSysParam();
                if (dbEntryCount <= queryCountFromSysParam) ** GOTO lbl50
                e.setCancel(true);
                confirmCallBacks = new ConfirmCallBackListener("queryTransferBillInfo", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u6570\u636e\u91cf\u8d85\u8fc7%1$s\u6761\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u8be2\uff1f", (String)"VMISettlePlugin_26", (String)"scmc-pm-vmi", (Object[])new Object[0]), new Object[]{queryCountFromSysParam}), MessageBoxOptions.OKCancel, confirmCallBacks);
                if (billInfo == null) ** GOTO lbl49
                if (var6_7 == null) ** GOTO lbl48
                try {
                    billInfo.close();
                }
                catch (Throwable var10_20) {
                    var6_7.addSuppressed(var10_20);
                }
                ** GOTO lbl49
lbl48:
                // 1 sources

                billInfo.close();
lbl49:
                // 4 sources

                return;
lbl50:
                // 1 sources

                if (billInfo == null) break;
                if (var6_7 != null) {
                    try {
                        billInfo.close();
                    }
                    catch (Throwable dbEntryCount) {
                        var6_7.addSuppressed(dbEntryCount);
                    }
                    break;
                }
                billInfo.close();
                break;
                catch (Throwable dbEntryCount) {
                    try {
                        var6_7 = dbEntryCount;
                        throw dbEntryCount;
                    }
                    catch (Throwable var11_23) {
                        if (billInfo != null) {
                            if (var6_7 != null) {
                                try {
                                    billInfo.close();
                                }
                                catch (Throwable var12_25) {
                                    var6_7.addSuppressed(var12_25);
                                }
                            } else {
                                billInfo.close();
                            }
                        }
                        throw var11_23;
                    }
                }
            }
            case 1: {
                rows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
                if (rows == null || rows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"VMISettlePlugin_30", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                errorInfo = this.checkMustInput();
                allMessage = new StringBuilder();
                if (errorInfo != null && errorInfo.size() > 0) {
                    for (String s : errorInfo) {
                        allMessage.append('\r').append('\n').append(s);
                    }
                    e.setCancel(true);
                    this.getView().showMessage(String.valueOf(allMessage), "", MessageTypes.Commit);
                    return;
                }
                settleDateHead = (Date)this.getModel().getValue("settledate");
                if (settleDateHead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u7b97\u65e5\u671f\u3002", (String)"VMISettlePlugin_22", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                maxBookDate = (Date)this.getModel().getValue("bookdate", rows[0]);
                for (i = 0; i < rows.length; ++i) {
                    rowIndex = rows[i];
                    bookdate = (Date)this.getModel().getValue("bookdate", rowIndex);
                    if (maxBookDate == null || !maxBookDate.before(bookdate)) continue;
                    maxBookDate = bookdate;
                }
                if (settleDateHead != null && maxBookDate != null && settleDateHead.before(maxBookDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u201c\u7ed3\u7b97\u65e5\u671f\u201d\u5c0f\u4e8e\u5f85\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u8bb0\u8d26\u65e5\u671f\u7684\u6700\u5927\u503c\uff0c\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u7ed3\u7b97\u65e5\u671f\u3002", (String)"VMISettlePlugin_23", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                model = this.getModel();
                hasDirtyData = false;
                excessCheck = false;
                modleJoinBaseQtyMap = new HashMap<Long, BigDecimal>(16);
                modelQtyMap = new HashMap<Long, BigDecimal>(16);
                modelRowIndexMap = new HashMap<Object, Integer>(16);
                for (i = 0; i < rows.length; ++i) {
                    rowIndex = rows[i];
                    joinBaseQty = (BigDecimal)model.getValue("joinbaseqty", rowIndex);
                    qty = (BigDecimal)model.getValue("qty", rowIndex);
                    entryID = (Long)model.getValue("billentryid", rowIndex);
                    modleJoinBaseQtyMap.put(entryID, joinBaseQty);
                    modelQtyMap.put(entryID, (BigDecimal)qty);
                    modelRowIndexMap.put(entryID, rowIndex + 1);
                }
                rowIndxs = new ArrayList<V>();
                filter = new QFilter("billentry.id", "in", modleJoinBaseQtyMap.keySet());
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_transferbill", (String)"billentry.id,billentry.joinbaseqty,billentry.joinqty,billentry.qty", (QFilter[])new QFilter[]{filter}, null);
                qty = null;
                try {
                    for (Row row : dataSet) {
                        entryID = row.getLong("billentry.id");
                        dbJoinBaseQty = row.getBigDecimal("billentry.joinbaseqty");
                        dbJoinQty = row.getBigDecimal("billentry.joinqty") == null ? BigDecimal.ZERO : row.getBigDecimal("billentry.joinqty");
                        dbQty = row.getBigDecimal("billentry.qty") == null ? BigDecimal.ZERO : row.getBigDecimal("billentry.qty");
                        modelBaseQty = (BigDecimal)modleJoinBaseQtyMap.get(entryID);
                        if (modelBaseQty == null || dbJoinBaseQty == null || modelBaseQty.compareTo(dbJoinBaseQty) == 0) ** GOTO lbl139
                        hasDirtyData = true;
                        break;
lbl139:
                        // 1 sources

                        remainQty = dbQty.subtract(dbJoinQty);
                        modelQty = (BigDecimal)modelQtyMap.get(entryID);
                        if ((dbQty.compareTo(BigDecimal.ZERO) < 0 || remainQty.compareTo(modelQty) >= 0 && modelQty.compareTo(BigDecimal.ZERO) >= 0) && (dbQty.compareTo(BigDecimal.ZERO) >= 0 || remainQty.compareTo(modelQty) <= 0 && modelQty.compareTo(BigDecimal.ZERO) <= 0)) continue;
                        rowIndxs.add(modelRowIndexMap.get(entryID));
                        excessCheck = true;
                    }
                }
                catch (Throwable entryID) {
                    qty = entryID;
                    throw entryID;
                }
                finally {
                    if (dataSet != null) {
                        if (qty != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable entryID) {
                                qty.addSuppressed(entryID);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                if (hasDirtyData) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u7ed3\u7b97\u7684\u6570\u636e\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u540e\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMISettlePlugin_3", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (!excessCheck) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f85\u7ed3\u7b97\u8bb0\u5f55\u7b2c%1$s\u884c\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u51fa\uff08\u5e94\u7ed3\u7b97\u6570\u91cf-\u5df2\u7ed3\u7b97\u5165\u5e93\u6570\u91cf\uff09\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMISettlePlugin_4", (String)"scmc-pm-vmi", (Object[])new Object[0]), new Object[]{rowIndxs}));
                e.setCancel(true);
                return;
            }
            case 2: {
                selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
                if (selectRows == null || selectRows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u4ef7\u7684\u5206\u5f55\u884c\u3002", (String)"VMISettlePlugin_5", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                entryPurOrg = (DynamicObject)this.getModel().getValue("entrypurorg", selectRows[0]);
                if (entryPurOrg == null || entryPurOrg.getPkValue() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u7b97\u4fe1\u606f\u4e2d\u7684\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VMISettlePlugin_6", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                settleDate = (Date)this.getModel().getValue("settledate");
                if (settleDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u7b97\u4fe1\u606f\u4e2d\u7684\u7ed3\u7b97\u65e5\u671f\u3002", (String)"VMISettlePlugin_7", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                result = this.gainPrice(selectRows, entryPurOrg);
                if (result == null || result.isEmpty()) break;
                this.setPriceToEntry(result);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        QFilter[] filter;
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("queryTransferBillInfo".equals(callBackId) && e.getResult() == MessageBoxResult.Yes && (filter = this.getQFilter()) != null) {
            Map<String, String> fieldMap = this.getFieldMap();
            String mapperFileds = this.mapperFileds(fieldMap);
            try (DataSet billInfo = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_transferbill", (String)mapperFileds, (QFilter[])this.getQFilter(), (String)"biztime", (int)this.getQueryCountFromSysParam());){
                this.fillEntry(billInfo, fieldMap);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        operateKey = e.getOperateKey();
        operationResult = e.getOperationResult();
        var4_4 = operateKey;
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case 107944136: {
                if (!var4_4.equals("query")) break;
                var5_5 = 0;
                break;
            }
            case 73828649: {
                if (!var4_4.equals("settlement")) break;
                var5_5 = 1;
            }
        }
        switch (var5_5) {
            case 0: {
                if (!operationResult.isSuccess()) {
                    return;
                }
                billInfo = this.queryTransferBillInfo();
                var7_8 = null;
                if (billInfo != null) {
                    this.fillEntry(billInfo, this.getFieldMap());
                }
                if (billInfo == null) break;
                if (var7_8 == null) ** GOTO lbl31
                try {
                    billInfo.close();
                }
                catch (Throwable var8_10) {
                    var7_8.addSuppressed(var8_10);
                }
                break;
lbl31:
                // 1 sources

                billInfo.close();
                break;
                catch (Throwable var8_11) {
                    try {
                        var7_8 = var8_11;
                        throw var8_11;
                    }
                    catch (Throwable var9_12) {
                        if (billInfo != null) {
                            if (var7_8 != null) {
                                try {
                                    billInfo.close();
                                }
                                catch (Throwable var10_13) {
                                    var7_8.addSuppressed(var10_13);
                                }
                            } else {
                                billInfo.close();
                            }
                        }
                        throw var9_12;
                    }
                }
            }
            case 1: {
                if (!operationResult.isSuccess()) {
                    return;
                }
                entry = (EntryGrid)this.getControl("billentry");
                selectRows = entry.getSelectRows();
                this.settle(selectRows);
                this.getModel().deleteEntryData("billentry");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block18: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "istax": {
                    this.calAmount(rowIndex);
                    continue block18;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block18;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block18;
                }
                case "price": 
                case "priceandtax": 
                case "taxrate": {
                    this.getModel().beginInit();
                    this.calAmount(rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("priceandtax", rowIndex);
                    this.getView().updateView("price", rowIndex);
                    this.getView().updateView("amountandtax", rowIndex);
                    continue block18;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    continue block18;
                }
                case "recorg": {
                    if (newValue != null && newValue == oldValue) continue block18;
                    this.getModel().setValue("supplier", null);
                }
            }
        }
    }

    private DataSet queryTransferBillInfo() {
        DataSet billInfo = null;
        QFilter[] filter = this.getQFilter();
        if (filter != null) {
            Map<String, String> fieldMap = this.getFieldMap();
            billInfo = this.doQuery(filter, fieldMap);
        }
        return billInfo;
    }

    private void setPriceToEntry(Map<Integer, Map<String, Object>> result) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (Map.Entry<Integer, Map<String, Object>> rowPriceInfo : result.entrySet()) {
            Integer rowIndex = rowPriceInfo.getKey();
            Map<String, Object> priceMap = rowPriceInfo.getValue();
            for (Map.Entry<String, Object> priceEntry : priceMap.entrySet()) {
                String field = priceEntry.getKey();
                Object value = priceEntry.getValue();
                model.setValue(field, value, rowIndex.intValue());
            }
            this.calAmount(rowIndex);
        }
        model.endInit();
        this.getView().updateView("billentry");
    }

    private int getQueryCountFromSysParam() {
        DynamicObject purOrg = (DynamicObject)this.getModel().getValue("purorg");
        Long purOrgId = (Long)purOrg.getPkValue();
        String queryCoutString = String.valueOf(SysParamHelper.getSysParam4pm((Long)purOrgId, (String)"vmisettlequerycount"));
        log.error("\u83b7\u53d6\u53c2\u6570" + queryCoutString);
        int count = 1000;
        try {
            count = Integer.parseInt(queryCoutString);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return count;
    }

    private Map<Integer, Map<String, Object>> gainPrice(int[] selectRows, DynamicObject entryPurOrg) {
        Long orgID = (Long)entryPurOrg.getPkValue();
        String formId = this.getView().getEntityId();
        Map result = null;
        Map fieldMap = null;
        try {
            fieldMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"plat", (String)"QuoteService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{new Long[]{orgID}, formId});
            log.info("VMI\u53d6\u4ef7\u63a5\u53e3\u53d6\u5f97\u5fc5\u8981\u7ef4\u5ea6\u952e\u503c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a " + SerializationUtils.toJsonString((Object)fieldMap, (boolean)true));
        }
        catch (Exception e) {
            log.error("VMI\u53d6\u4ef7\u670d\u52a1\u5f02\u5e38\u3002" + e.fillInStackTrace());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettlePlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        if (fieldMap == null || fieldMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettlePlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        Map map = (Map)fieldMap.get(orgID);
        if (map != null && map.get("success") != null) {
            boolean success;
            Object successObj = map.get("success");
            boolean bl = success = !StringUtils.isBlank(successObj) ? Boolean.parseBoolean(successObj.toString()) : false;
            if (!success) {
                Object msg = map.get("msg");
                this.getView().showTipNotification(StringUtils.isBlank(msg) ? ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettlePlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : msg.toString());
                return null;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettlePlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        Map<Long, List<Map<String, Object>>> quoteInfoMap = this.buildQuoteInfoMap(orgID, fieldMap, selectRows);
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"plat", (String)"QuoteService", (String)"quoteByMap", (Object[])new Object[]{quoteInfoMap, formId});
            log.info("VMI\u53d6\u4ef7\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a " + SerializationUtils.toJsonString((Object)result, (boolean)true));
        }
        catch (Exception e) {
            log.error("VMI\u53d6\u4ef7\u670d\u52a1\u5f02\u5e38\u3002" + e.fillInStackTrace());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettlePlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        if (result == null || result.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002", (String)"VMISettlePlugin_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        Map priceInfo = (Map)result.get(orgID);
        Boolean stausFlag = (Boolean)priceInfo.get("success");
        if (stausFlag == null || !stausFlag.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002", (String)"VMISettlePlugin_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            log.error("\u53d6\u4ef7\u5931\u8d25\u3002" + priceInfo.get("msg"));
            return null;
        }
        Map<Integer, Map<String, Object>> successResult = this.dealResultToMap(selectRows, priceInfo);
        return successResult;
    }

    private Map<Long, List<Map<String, Object>>> buildQuoteInfoMap(Long orgID, Map<Long, Map<String, ?>> fieldMap, int[] selectRows) {
        IDataModel model = this.getModel();
        HashMap<Long, List<Map<String, Object>>> params = new HashMap<Long, List<Map<String, Object>>>();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection billentry = (DynamicObjectCollection)dataEntity.get("billentry");
        Map<String, ?> orgFieldmap = fieldMap.get(orgID);
        if (orgFieldmap == null) {
            return null;
        }
        List headFields = (List)orgFieldmap.get("header");
        HashMap<String, Object> headMap = new HashMap<String, Object>(headFields.size());
        for (String headField : headFields) {
            headMap.put(headField, this.getValue(headField.split("\\."), 0, dataEntity));
        }
        List entryKeys = (List)orgFieldmap.get("entry");
        ArrayList list = new ArrayList(selectRows.length);
        for (int j = 0; j < selectRows.length; ++j) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject entry = (DynamicObject)billentry.get(selectRows[j]);
            entryKeys.forEach(l -> map.put((String)l, this.getValue(l.split("\\."), 1, entry)));
            map.putAll(headMap);
            list.add(map);
        }
        params.put(orgID, list);
        return params;
    }

    private Object getValue(String[] dividePropertys, int startIndex, DynamicObject source) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return source.get(dividePropertys[startIndex]);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return this.getValue(dividePropertys, ++startIndex, source);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return null;
            }
        }
        return null;
    }

    private Map<Integer, Map<String, Object>> dealResultToMap(int[] selectRows, Map<String, Object> priceMap) {
        HashMap<Integer, Map<String, Object>> seqAndPriceMap = new HashMap<Integer, Map<String, Object>>(16);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
        priceMap.remove("success");
        if (priceMap.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7269\u6599\u6ca1\u6709\u7ef4\u62a4\u4ef7\u683c\u3002", (String)"VMISettlePlugin_15", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        IDataEntityType dataEntityType = ((DynamicObject)billEntry.get(0)).getDataEntityType();
        Set<String> priceMapKey = this.getKeys(dataEntityType, priceMap);
        if (priceMapKey == null || priceMapKey.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002", (String)"VMISettlePlugin_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return seqAndPriceMap;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            DynamicObject rowInfo = (DynamicObject)billEntry.get(rowIndex);
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            for (String priceKey : priceMapKey) {
                map.put(priceKey, priceMap.get(this.getPriceKey(rowInfo, priceKey)));
            }
            seqAndPriceMap.put(rowIndex, map);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7269\u6599\u53d6\u4ef7\u6210\u529f\u3002", (String)"VMISettlePlugin_16", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return seqAndPriceMap;
    }

    private Set<String> getKeys(IDataEntityType dataEntityType, Map<String, Object> priceMap) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        HashSet<String> preiceResultkeys = new HashSet<String>(10);
        if (priceMap != null && !priceMap.isEmpty()) {
            Set<String> priceKeys = priceMap.keySet();
            for (String key : priceKeys) {
                String fieldKey;
                int tagIndex;
                if (key == null || (tagIndex = key.lastIndexOf("$$")) == -1 || "iscover".equals(fieldKey = key.substring(tagIndex + 2))) continue;
                preiceResultkeys.add(fieldKey);
            }
        }
        if (preiceResultkeys.isEmpty()) {
            return preiceResultkeys;
        }
        HashSet<String> result = new HashSet<String>(10);
        if (properties != null && !properties.isEmpty()) {
            block1: for (String key : preiceResultkeys) {
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    if (name == null || !name.equals(key)) continue;
                    result.add(key);
                    continue block1;
                }
            }
        }
        return result;
    }

    private String getPriceKey(DynamicObject rowInfo, String fieldkey) {
        Integer seq = (Integer)rowInfo.get("seq");
        StringBuilder sb = new StringBuilder();
        sb.append(0).append("$$").append(0).append("$$").append(seq).append("$$").append(fieldkey);
        return sb.toString();
    }

    private Long getSettleOrgId(Long orgId) {
        Map companyByOrg = OrgHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Long settleOrgId = null;
        if (companyByOrg != null) {
            settleOrgId = (Long)companyByOrg.get("id");
        }
        return settleOrgId;
    }

    private void settle(int[] selectRows) {
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
        Map<Long, Map<String, Object>> map = this.buildPushSettleBillParam(selectRows, sourceIdMap);
        log.info("VMI\u7ed3\u7b97\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e3a\uff1a" + Arrays.toString(selectRows));
        log.info("\u7269\u6743\u8f6c\u79fb\u5355botp\u751f\u6210\u91c7\u8d2d\u5165\u5e93\u548c\u5e93\u5b58\u5355\u636e\u7684\u4f20\u9012\u53c2\u6570" + map);
        log.info("\u7269\u6743\u8f6c\u79fb\u5355botp\u751f\u6210\u91c7\u8d2d\u5165\u5e93\u7684\u884cID\u548c\u5355\u636eID\u7684map\u4e3a:" + sourceIdMap);
        VMISettleParam settleParam = new VMISettleParam(VMISettleTypeEnum.MANUAL);
        settleParam.setTransferEntryIdAndBillIdMap(sourceIdMap);
        IDataModel model = this.getModel();
        HashMap<String, String> param = new HashMap<String, String>(16);
        Date settleDate = (Date)model.getValue("settledate");
        DynamicObject org = (DynamicObject)model.getValue("purorg");
        if (settleDate != null) {
            param.put("settledate", String.valueOf(settleDate.getTime()));
        }
        param.put("entryinfo", SerializationUtils.toJsonString(map));
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IVMISettleCasePlugin.class, (String)"SCMC_PM_VMIMANMALSETTLE_ADDCUSTOMPARAM", null);
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
            ArrayList<Object> selectedRowInfos = new ArrayList<Object>(10);
            for (int i = 0; i < selectRows.length; ++i) {
                selectedRowInfos.add(entrys.get(selectRows[i]));
            }
            List customParams = pluginProxy.callReplace(p -> p.getManualSettleCustomParam(selectedRowInfos));
            HashMap customParam = new HashMap(16);
            if (customParams != null && !customParams.isEmpty()) {
                for (Map onePluginCustParam : customParams) {
                    if (onePluginCustParam == null) continue;
                    customParam.putAll(onePluginCustParam);
                }
                param.put("customparam", SerializationUtils.toJsonString(customParam));
            }
        }
        catch (Exception e) {
            log.error("VMI\u91c7\u8d2d\u7ed3\u7b97\u6269\u5c55\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"VMI\u91c7\u8d2d\u7ed3\u7b97\u6269\u5c55\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\u3002", (String)"VMISettlePlugin_32", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
        settleParam.setParam(param);
        VMISettleResult vmiSettleResult = VMISettleService.vmiSettle(settleParam);
        if (vmiSettleResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettlePlugin_24", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        vmiSettleResult.getSettleFailBillNoAndMsgs().entrySet().forEach(entry -> sb.append((String)entry.getKey()).append('\uff1a').append((String)entry.getValue()).append(LINE_BREAK));
        sb.append(vmiSettleResult.getMessage());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettlePlugin_29", (String)"scmc-pm-vmi", (Object[])new Object[0]), sb.toString(), MessageBoxOptions.None, ConfirmTypes.Fail, null);
    }

    private Map<Long, Map<String, Object>> buildPushSettleBillParam(int[] selectRows, Map<Long, Long> sourceIdMap) {
        IDataModel model = this.getModel();
        HashMap<Long, Map<String, Object>> param = new HashMap<Long, Map<String, Object>>(16);
        for (int rowIndex : selectRows) {
            Long billEntryID = (Long)model.getValue("billentryid", rowIndex);
            Long billID = (Long)model.getValue("billid", rowIndex);
            sourceIdMap.put(billEntryID, billID);
            HashMap<String, Object> para = new HashMap<String, Object>(16);
            Long entryId = (Long)model.getValue("billentryid", rowIndex);
            for (String field : this.getFieldList4Param()) {
                Object value = model.getValue(field, rowIndex);
                if (value == null) {
                    value = 0L;
                } else if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                para.put(field, value);
            }
            param.put(entryId, para);
        }
        return param;
    }

    private List<String> getFieldList4Param() {
        ArrayList<String> list = new ArrayList<String>(16);
        Collections.addAll(list, "qty", "baseqty", "auxqty", "istax", "price", "taxrateid", "taxrate", "priceandtax", "amountandtax");
        return list;
    }

    private List<String> getCheckMustInPutFieldList() {
        ArrayList<String> list = new ArrayList<String>(16);
        Collections.addAll(list, "qty", "baseqty", "istax", "price", "priceandtax");
        return list;
    }

    private List<String> checkMustInput() {
        IDataModel model = this.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        int[] selectRows = entry.getSelectRows();
        ArrayList<String> errorMessage = new ArrayList<String>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            ArrayList<String> list = new ArrayList<String>(5);
            for (String field : this.getCheckMustInPutFieldList()) {
                Object value = model.getValue(field, rowIndex);
                if (value != null && (!(value instanceof BigDecimal) || ((BigDecimal)value).compareTo(this.ZERO) != 0)) continue;
                IDataEntityProperty property = dataEntityType.findProperty(field);
                String displayName = property.getDisplayName().toString();
                list.add(displayName);
            }
            if (list.size() <= 0) continue;
            ++rowIndex;
            StringBuilder errorInfoString = new StringBuilder();
            for (int j = 0; j < list.size(); ++j) {
                if (j < list.size() - 1) {
                    errorInfoString.append((String)list.get(j)).append('\uff0c');
                    continue;
                }
                errorInfoString.append((String)list.get(j));
            }
            errorMessage.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f85\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u7684\u7b2c%1$s\u884c\u7684%2$s\u3002", (String)"VMISettlePlugin_31", (String)"scmc-pm-vmi", (Object[])new Object[0]), rowIndex, errorInfoString));
        }
        return errorMessage;
    }

    private void fillEntry(DataSet billInfo, Map<String, String> fieldMap) {
        IDataModel model = this.getModel();
        model.deleteEntryData("billentry");
        int count = billInfo.copy().count("billentryid", false);
        if (count == 0) {
            return;
        }
        model.batchCreateNewEntryRow("billentry", count);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        Set<String> values = fieldMap.keySet();
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            model.beginInit();
            int i = 0;
            for (Row row : billInfo) {
                for (IDataEntityProperty prop : properties) {
                    String name = prop.getName();
                    if (!values.contains(name)) continue;
                    Object val = row.get(name);
                    model.setValue(name, val, i);
                }
                if (row.get("shouldqty") != null && row.get("joinqty") != null) {
                    model.setValue("qty", (Object)row.getBigDecimal("shouldqty").subtract(row.getBigDecimal("joinqty")), i);
                }
                if (row.get("shouldbaseqty") != null && row.get("joinbaseqty") != null) {
                    model.setValue("baseqty", (Object)row.getBigDecimal("shouldbaseqty").subtract(row.getBigDecimal("joinbaseqty")), i);
                }
                if (row.get("shouldauxqty") != null && row.get("joinauxqty") != null) {
                    model.setValue("auxqty", (Object)row.getBigDecimal("shouldauxqty").subtract(row.getBigDecimal("joinauxqty")), i);
                }
                ++i;
            }
            model.endInit();
            this.getView().updateView("billentry");
        }
    }

    private DataSet doQuery(QFilter[] filters, Map<String, String> mapper) {
        String mapperFileds = this.mapperFileds(mapper);
        DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_transferbill", (String)mapperFileds, (QFilter[])filters, (String)"biztime");
        return rows;
    }

    private Map<String, String> getFieldMap() {
        HashMap<String, String> map = new HashMap<String, String>(50);
        map.put("billid", "id");
        map.put("entryrecorg", "org");
        map.put("biztime", "biztime");
        map.put("bookdate", "bookdate");
        map.put("srcbillform", "srcbillform");
        map.put("isintertransaction", "isintertransaction");
        map.put("billno", "billno");
        map.put("settlecurrency", "settlecurrency");
        map.put("billentryid", "billentry.id");
        map.put("entrypurorg", "purorg");
        map.put("entryseq", "billentry.seq");
        map.put("material", "billentry.material");
        map.put("auxpty", "billentry.auxpty");
        map.put("entrysupplier", "billentry.supplier");
        map.put("shouldqty", "billentry.qty");
        map.put("joinqty", "billentry.joinqty");
        map.put("unit", "billentry.unit");
        map.put("warehouse", "billentry.warehouse");
        map.put("location", "billentry.location");
        map.put("project", "billentry.project");
        map.put("istax", "billentry.istax");
        map.put("price", "billentry.price");
        map.put("taxrateid", "billentry.taxrateid");
        map.put("taxrate", "billentry.taxrate");
        map.put("priceandtax", "billentry.priceandtax");
        map.put("amountandtax", "billentry.amountandtax");
        map.put("entrysettleorg", "billentry.entrysettleorg");
        map.put("lotnumber", "billentry.lotnumber");
        map.put("shouldbaseqty", "billentry.baseqty");
        map.put("joinbaseqty", "billentry.joinbaseqty");
        map.put("baseunit", "billentry.baseunit");
        map.put("shouldauxqty", "billentry.auxqty");
        map.put("joinauxqty", "billentry.joinauxqty");
        map.put("auxunit", "billentry.auxunit");
        map.put("srcbillid", "billentry.srcbillid");
        map.put("excutedbaseqty", "billentry.excutedbaseqty");
        return map;
    }

    private QFilter[] getQFilter() {
        List<Object> srcEntityNos;
        DynamicObject supplier;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        IDataModel model = this.getModel();
        DynamicObject recorg = (DynamicObject)model.getValue("recorg");
        if (recorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VMISettlePlugin_19", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        DynamicObject purOrg = (DynamicObject)model.getValue("purorg");
        if (purOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u67e5\u8be2\u91c7\u8d2d\u7ec4\u7ec7\u201d\u3002", (String)"VMISettlePlugin_20", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        Long recorgID = (Long)recorg.getPkValue();
        filters.add(new QFilter("org", "=", (Object)recorgID));
        if (purOrg != null) {
            Long purOrgID = (Long)purOrg.getPkValue();
            filters.add(new QFilter("purorg", "=", (Object)purOrgID));
        }
        if ((supplier = (DynamicObject)model.getValue("supplier")) != null) {
            Long supplierID = (Long)supplier.getPkValue();
            filters.add(new QFilter("billentry.supplier", "=", (Object)supplierID));
        }
        filters.add(new QFilter("billentry.settlestatus", "!=", (Object)"C"));
        filters.add(new QFilter("billentry.excutedstatus", "!=", (Object)"B"));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        Date startDate = (Date)model.getValue("start_bizdate");
        Date endDate = (Date)model.getValue("end_bizdate");
        if (startDate == null || endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u4e1a\u52a1\u65e5\u671f\u201d\u3002", (String)"VMISettlePlugin_21", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return null;
        }
        startDate = DateUtil.getDate((Date)startDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.add(5, 1);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        endDate = cal.getTime();
        if (startDate != null && endDate != null) {
            filters.add(new QFilter("biztime", ">=", (Object)startDate));
            filters.add(new QFilter("biztime", "<", (Object)endDate));
        }
        if ((srcEntityNos = this.getMulBaseDataIdList(this.getModel(), "srcentityno")) != null && !srcEntityNos.isEmpty()) {
            filters.add(new QFilter("srcbillform", "in", srcEntityNos));
        }
        return filters.toArray(new QFilter[filters.size()]);
    }

    private List<Object> getMulBaseDataIdList(IDataModel model, String fieldKey) {
        DynamicObjectCollection baseDataCol = (DynamicObjectCollection)model.getValue(fieldKey);
        ArrayList<Object> idList = new ArrayList<Object>(16);
        for (DynamicObject row : baseDataCol) {
            DynamicObject baseData = row.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            idList.add(baseData.getPkValue());
        }
        return idList;
    }

    private String mapperFileds(Map<String, String> mapper) {
        ArrayList<String> list = new ArrayList<String>(mapper.size());
        for (Map.Entry<String, String> mapEntry : mapper.entrySet()) {
            String mapValue = mapEntry.getValue();
            String mapKey = mapEntry.getKey();
            if (mapValue == null) continue;
            mapValue = mapValue.concat(" as ").concat(mapKey);
            list.add(mapValue);
        }
        String arrayS = Arrays.toString(list.toArray(new String[list.size()]));
        return arrayS.substring(1, arrayS.length() - 1);
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && unit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    this.calAmount(rowIndex);
                    model.endInit();
                    this.getView().updateView("baseqty", rowIndex);
                    this.getView().updateView("qty", rowIndex);
                    this.getView().updateView("price", rowIndex);
                    this.getView().updateView("priceandtax", rowIndex);
                    this.getView().updateView("amountandtax", rowIndex);
                }
            }
        }
    }

    private void calAmount(int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax", rowIndex);
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency", rowIndex);
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        Object taxRateId = model.getValue("taxrateid");
        if (taxRateId != null && taxRate != null && taxRate.compareTo(BigDecimal.ZERO) == 0) {
            if (taxRateId instanceof DynamicObject) {
                taxRate = ((DynamicObject)taxRateId).getBigDecimal("taxrate");
            } else {
                DynamicObject taxRateDym = BusinessDataServiceHelper.loadSingleFromCache((Object)taxRateId, (String)"bd_taxrate", (String)"id,taxrate");
                if (taxRateDym != null) {
                    taxRate = taxRateDym.getBigDecimal("taxrate");
                }
            }
            this.getModel().beginInit();
            model.setValue("taxrate", (Object)taxRate, rowIndex);
            this.getModel().endInit();
        }
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
        if (isTax) {
            model.setValue("price", (Object)amountInfo.getPrice(), rowIndex);
        } else {
            model.setValue("priceandtax", (Object)amountInfo.getPriceAndTax(), rowIndex);
        }
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            model.beginInit();
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null) {
                    String unitConvertDir = master.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            this.calAmount(rowIndex);
            model.endInit();
            this.getView().updateView("baseqty", rowIndex);
            this.getView().updateView("qty", rowIndex);
            this.getView().updateView("price", rowIndex);
            this.getView().updateView("priceandtax", rowIndex);
            this.getView().updateView("amountandtax", rowIndex);
            this.getView().updateView("auxqty", rowIndex);
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", (Object)taxRateID.getBigDecimal("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)this.ZERO, rowIndex);
        }
    }

    private QFilter getHasPerOrgF7Qfilter(String formId, String orgType) {
        List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)formId, (String)orgType);
        QFilter filterOrg = null;
        filterOrg = hasPermissionOrg != null && !hasPermissionOrg.isEmpty() ? new QFilter("id", "in", (Object)hasPermissionOrg) : new QFilter("id", "in", (Object)0L);
        return filterOrg;
    }
}

