/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class Transfer2VMIRecordConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(Transfer2VMIRecordConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObject bill;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> targetBills = new ArrayList<DynamicObject>(16);
        Map variables = this.getOption().getVariables();
        log.info("\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55BOTP\u53c2\u6570\u4e3a\uff1a" + variables);
        if (variables == null || variables.isEmpty()) {
            return;
        }
        String settleDateTimes = (String)variables.get("settledate");
        String settlementman = (String)variables.get("settlementman");
        DynamicObject settlementmanObj = null;
        if (StringUtils.isNotBlank((CharSequence)settlementman)) {
            settlementmanObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(settlementman), (String)"bos_user");
        }
        String purorgV = (String)variables.get("purorg");
        Date settleDate = settleDateTimes == null ? new Date() : new Date(Long.parseLong(settleDateTimes));
        Long purOrgId = StringUtils.isBlank((CharSequence)purorgV) ? null : Long.valueOf(purorgV);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject org;
            bill = entity.getDataEntity();
            if (purOrgId != null) {
                bill.set("org_id", (Object)purOrgId);
            }
            if ((org = bill.getDynamicObject("org")) == null) {
                return;
            }
            if (settleDate != null) {
                bill.set("settledate", (Object)settleDate);
            }
            if (StringUtils.isNotBlank((CharSequence)settlementman) && settlementmanObj != null) {
                bill.set("settlementman", (Object)settlementmanObj);
            }
            targetBills.add(bill);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                String entryId;
                String rowValue;
                Object pkValue = entry.get("srcbillentryid");
                if (pkValue == null || !StringUtils.isNotBlank((CharSequence)(rowValue = (String)variables.get(entryId = String.valueOf(pkValue))))) continue;
                Map rowParam = (Map)SerializationUtils.fromJsonString((String)rowValue, Map.class);
                for (String field : this.getFieldList()) {
                    Object fieldValue = rowParam.get(field);
                    if (fieldValue == null) continue;
                    if ("material".equals(field)) {
                        field = field + "_id";
                    }
                    entry.set(field, fieldValue);
                }
            }
        }
        List billNos = CodeRuleServiceHelper.getNumbers((String)this.getTgtMainType().getName(), targetBills);
        String settleRecordLotNumber = null;
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity;
            entity = entitys[i];
            bill = entity.getDataEntity();
            String billNo = (String)billNos.get(i);
            if (i == 0) {
                int index = billNo.indexOf(45);
                settleRecordLotNumber = index != -1 ? billNo.substring(index + 1) : billNo;
            }
            bill.set("billno", (Object)billNo);
            bill.set("settlelotno", settleRecordLotNumber);
        }
    }

    private List<String> getFieldList() {
        ArrayList<String> list = new ArrayList<String>(16);
        list.add("material");
        list.add("qty");
        list.add("baseqty");
        list.add("auxqty");
        list.add("purinbillentity");
        list.add("purinbillid");
        list.add("purinbillnumber");
        list.add("purinbillentryid");
        list.add("purinbillentryseq");
        list.add("invbillentity");
        list.add("invbillid");
        list.add("invbillnumber");
        list.add("invbillentryid");
        list.add("invbillentryseq");
        return list;
    }
}

