/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin.botp;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.JSONUtils;

public class Transfer2VMISettleSrcBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(Transfer2VMISettleSrcBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("qty");
        e.addSrcField("baseqty");
        e.addSrcField("auxqty");
        e.addSrcField("joinqty");
        e.addSrcField("joinbaseqty");
        e.addSrcField("joinauxqty");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        log.info("\u7269\u6743\u8f6c\u79fb\u5355\u4e0b\u63a8\u9886\u6599\u51fa\u5e93\uff08\u865a\uff09\u53c2\u6570\u4e3a \uff1a" + variables);
        if (variables == null || !variables.containsKey("settledate") || !variables.containsKey("entryinfo")) {
            return;
        }
        String entryinfo = (String)variables.get("entryinfo");
        String settledateString = (String)variables.get("settledate");
        Date settledate = null;
        if (StringUtils.isNotBlank((CharSequence)settledateString)) {
            settledate = new Date(Long.parseLong(settledateString));
        }
        String bookDateN = null;
        DynamicProperty bookDateProp = (DynamicProperty)fldProperties.get("bookdate");
        if (bookDateProp != null) {
            bookDateN = bookDateProp.getName();
        }
        if (StringUtils.isBlank((CharSequence)entryinfo)) {
            return;
        }
        Map entryInfoMap = (Map)SerializationUtils.fromJsonString((String)entryinfo, HashMap.class);
        HashSet<String> fields = new HashSet<String>(16);
        Map<Long, Map<String, Object>> dataMap = this.parseCustomerVariables(entryInfoMap, fields);
        for (DynamicObject bill : sourceRows) {
            if (settledate != null) {
                bill.set(bookDateN, (Object)settledate);
            }
            this.updateEntryInfoFromVar(bill, dataMap, fldProperties);
            this.updateEntryQtyInfo(bill, fldProperties);
        }
    }

    private void updateEntryQtyInfo(DynamicObject bill, Map<String, DynamicProperty> fldProperties) {
        DynamicProperty qtyProperty = fldProperties.get("qty");
        DynamicProperty baseqtyProperty = fldProperties.get("baseqty");
        DynamicProperty auxqtyProperty = fldProperties.get("auxqty");
        DynamicProperty joinqtyProperty = fldProperties.get("joinqty");
        DynamicProperty joinbaseqtyProperty = fldProperties.get("joinbaseqty");
        DynamicProperty joinauxqtyProperty = fldProperties.get("joinauxqty");
        BigDecimal qty = bill.getBigDecimal((IDataEntityProperty)qtyProperty).add(bill.getBigDecimal((IDataEntityProperty)joinqtyProperty));
        BigDecimal baseQty = bill.getBigDecimal((IDataEntityProperty)baseqtyProperty).add(bill.getBigDecimal((IDataEntityProperty)joinbaseqtyProperty));
        BigDecimal auxQty = bill.getBigDecimal((IDataEntityProperty)auxqtyProperty).add(bill.getBigDecimal((IDataEntityProperty)joinauxqtyProperty));
        bill.set((IDataEntityProperty)qtyProperty, (Object)qty);
        bill.set((IDataEntityProperty)baseqtyProperty, (Object)baseQty);
        bill.set((IDataEntityProperty)auxqtyProperty, (Object)auxQty);
    }

    private void updateEntryInfoFromVar(DynamicObject bill, Map<Long, Map<String, Object>> dataMap, Map<String, DynamicProperty> fldProperties) {
        Long billentryID = (Long)bill.get((IDataEntityProperty)fldProperties.get("billentry.id"));
        Map<String, Object> map = dataMap.get(billentryID);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                DynamicProperty dynamicProperty = fldProperties.get(key);
                if (dynamicProperty == null) continue;
                String name = dynamicProperty.getName();
                bill.set(name, value);
            }
        }
    }

    private Map<Long, Map<String, Object>> parseCustomerVariables(Map<Long, Object> variables, Set<String> fields) {
        HashMap<Long, Map<String, Object>> allDataMap = new HashMap<Long, Map<String, Object>>(16);
        try {
            Map entryDataDetailMap = (Map)variables.entrySet().iterator().next().getValue();
            fields.addAll(entryDataDetailMap.keySet());
            Map<String, Class<?>> propMap = this.getFieldsProp(fields);
            for (Map.Entry<Long, Object> entry : variables.entrySet()) {
                HashMap dataMap = (HashMap)entry.getValue();
                Long billEntryID = Long.parseLong(String.valueOf(entry.getKey()));
                if (dataMap == null) continue;
                for (Map.Entry entry2 : dataMap.entrySet()) {
                    String key = (String)entry2.getKey();
                    Object jsonValue = entry2.getValue();
                    Object value = JSONUtils.cast((String)jsonValue.toString(), propMap.get(key));
                    entry2.setValue(value);
                }
                allDataMap.put(billEntryID, dataMap);
            }
        }
        catch (IOException e) {
            log.error(e.fillInStackTrace());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u51fa\u9519\u3002", (String)"Transfer2VMISettleSrcBillConvertPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
        return allDataMap;
    }

    private Map<String, Class<?>> getFieldsProp(Set<String> fields) {
        BillEntityType srcMainType = this.getSrcMainType();
        HashMap map = new HashMap(16);
        for (String field : fields) {
            IDataEntityProperty property = srcMainType.findProperty(field);
            if (property == null) continue;
            if (property instanceof BasedataProp) {
                map.put(field, Long.class);
                continue;
            }
            if (property instanceof DecimalProp) {
                map.put(field, BigDecimal.class);
                continue;
            }
            if (!(property instanceof BooleanProp)) continue;
            map.put(field, Boolean.class);
        }
        return map;
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> tarBills = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < entitys.length; ++i) {
            tarBills.add(entitys[i].getDataEntity());
        }
        List billNos = CodeRuleServiceHelper.getNumbers((String)this.getTgtMainType().getName(), tarBills);
        int billNoSeq = 0;
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            if (billNos == null || billNos.size() <= billNoSeq) continue;
            bill.set("billno", (Object)("*" + (String)billNos.get(billNoSeq)));
            ++billNoSeq;
        }
    }
}

