/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.OperateExecuteHelper;
import kd.scmc.pm.business.pojo.ReturnResultInfo;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMIMutexHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;
import kd.scmc.pm.vmi.mservice.api.VMIService;

public class VMIServiceImpl
implements VMIService {
    private static final Log log = LogFactory.getLog(VMIServiceImpl.class);
    private static final TrackLogService trackLog = new TrackLogService(VMIServiceImpl.class, "vmi");
    private static final String VMITransferBillEntity = "pm_transferbill";

    @Override
    public Map<String, Object> checkGenerateTransferBill(String VMISettleSrcBillEntity, List<Long> ids) {
        trackLog.startInfo(VMISettleSrcBillEntity + this.serialization(ids));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ids == null || StringUtils.isBlank((CharSequence)VMISettleSrcBillEntity) || ids.isEmpty()) {
            log.info("\u5fae\u670d\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            map.put("success", Boolean.FALSE);
            map.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5fae\u670d\u52a1\u53c2\u6570\u201d\u3002", (String)"VMIServiceImpl_7", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            trackLog.endInfo(this.serialization(map));
            return map;
        }
        VMISettleModelInfo vmiSettleModelInfo = VMISettleModelHelper.getVMISettleModelInfo(VMISettleSrcBillEntity);
        if (vmiSettleModelInfo == null) {
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"VMI\u7ed3\u7b97\u6e90\u5355", (String)"VMIServiceImpl_12", (String)"scmc-pm-vmi", (Object[])new Object[0])).append('[').append(VMISettleSrcBillEntity).append(']').append(ResManager.loadKDString((String)"\u672a\u914d\u7f6eVMI\u7ed3\u7b97\u6a21\u578b\u3002", (String)"VMIServiceImpl_13", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            String msg = message.toString();
            log.info(msg);
            map.put("success", Boolean.FALSE);
            map.put("message", msg);
            trackLog.endInfo(this.serialization(map));
            return map;
        }
        String ruleID = vmiSettleModelInfo.getToTransferBillRuleID();
        HashMap<String, String> checkParam = new HashMap<String, String>(4);
        checkParam.put("ruleid", ruleID);
        map.put("success", Boolean.TRUE);
        map.put("checkparam", checkParam);
        trackLog.endInfo(this.serialization(map));
        return map;
    }

    @Override
    public Map<String, Object> generateTransferBill(String VMISettleSrcBillEntity, List<Long> ids, Map<String, Object> checkParam) {
        trackLog.startInfo(VMISettleSrcBillEntity + this.serialization(ids) + this.serialization(checkParam));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ids == null || StringUtils.isBlank((CharSequence)VMISettleSrcBillEntity) || ids.isEmpty()) {
            log.info("\u5fae\u670d\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            map.put("success", Boolean.FALSE);
            map.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5fae\u670d\u52a1\u53c2\u6570\u201d\u3002", (String)"VMIServiceImpl_7", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            trackLog.endInfo(this.serialization(map));
            return map;
        }
        if (checkParam == null || checkParam.isEmpty()) {
            Map<String, Object> checkGenerateTransferBill = this.checkGenerateTransferBill(VMISettleSrcBillEntity, ids);
            if (checkGenerateTransferBill != null && !checkGenerateTransferBill.isEmpty() && checkGenerateTransferBill.get("success") instanceof Boolean && ((Boolean)checkGenerateTransferBill.get("success")).booleanValue() && checkGenerateTransferBill.get("checkparam") instanceof Map) {
                checkParam = (Map)checkGenerateTransferBill.get("checkparam");
            } else {
                return checkGenerateTransferBill;
            }
        }
        if (checkParam == null || checkParam.get("ruleid") == null) {
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"VMI\u7ed3\u7b97\u6e90\u5355", (String)"VMIServiceImpl_12", (String)"scmc-pm-vmi", (Object[])new Object[0])).append('[').append(VMISettleSrcBillEntity).append(']').append(ResManager.loadKDString((String)"\u672a\u914d\u7f6eVMI\u7ed3\u7b97\u6a21\u578b\u3002", (String)"VMIServiceImpl_13", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            map.put("success", Boolean.FALSE);
            map.put("message", message.toString());
            trackLog.endInfo(this.serialization(map));
            return map;
        }
        String ruleId = (String)checkParam.get("ruleid");
        PushArgs pushArgs = this.getPushArgs(VMISettleSrcBillEntity, ruleId);
        int size = ids.size();
        ArrayList targetBills = new ArrayList(size);
        ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(size);
        for (Long id : ids) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)id);
            sourceEntryRows.add(row);
        }
        pushArgs.setSelectedRows(sourceEntryRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess()) {
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)VMITransferBillEntity);
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            if (targetData != null && targetData.size() > 0) {
                targetBills.addAll(targetData);
            }
            log.info("\u6e90\u5355\u5355\u636e(" + VMISettleSrcBillEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + VMITransferBillEntity + ")\u6210\u529f");
        } else {
            String message = String.format(ResManager.loadKDString((String)"\u6e90\u5355\u636e\u201c%1$s\u201d\u4e0b\u63a8\u76ee\u6807\u5355\u636e\u201c%2$s\u201d\u5931\u8d25\uff1a%3$s\u3002", (String)"VMIServiceImpl_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), VMISettleSrcBillEntity, VMITransferBillEntity, result.getMessage());
            map.put("success", Boolean.FALSE);
            map.put("message", message);
        }
        if (targetBills != null && targetBills.size() > 0) {
            log.info("\u76ee\u6807\u5355\u636e(pm_transferbill)\u4e0b\u63a8\u6210\u529f\uff1a");
            ReturnResultInfo executeSave = OperateExecuteHelper.executeSave4Rollback((String)VMITransferBillEntity, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), null, (Boolean)Boolean.TRUE);
            if (executeSave != null && executeSave.isSuccess() && executeSave.getSuccessList() != null) {
                List saveSuccessPkIds = executeSave.getSuccessList();
                log.info("\u76ee\u6807\u5355\u636e(pm_transferbill)\u4fdd\u5b58\u6210\u529f\uff1a");
                ReturnResultInfo executeSubmit = OperateExecuteHelper.executeSubmit4Rollback((String)VMITransferBillEntity, (Object[])saveSuccessPkIds.toArray(), null, (Boolean)Boolean.TRUE);
                if (executeSubmit != null && executeSubmit.isSuccess() && executeSubmit.getSuccessList() != null) {
                    List submitSuccessPkIds = executeSubmit.getSuccessList();
                    log.info("\u76ee\u6807\u5355\u636e(pm_transferbill)\u63d0\u4ea4\u6210\u529f\uff1a");
                    ReturnResultInfo executeAudit = OperateExecuteHelper.executeAudit4Rollback((String)VMITransferBillEntity, (Object[])submitSuccessPkIds.toArray(), null, (Boolean)Boolean.TRUE);
                    if (executeAudit != null && executeAudit.isSuccess() && executeAudit.getSuccessList() != null) {
                        List auditSuccessPkIds = executeAudit.getSuccessList();
                        log.info("\u76ee\u6807\u5355\u636e(pm_transferbill)\u5ba1\u6838\u6210\u529f\uff1a");
                        map.put("success", Boolean.TRUE);
                        map.put("successlist", auditSuccessPkIds);
                    } else if (executeAudit != null) {
                        String message = String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e0b\u6e38\u7269\u6743\u8f6c\u79fb\u5355\u5f02\u5e38\uff1a%1$s\u3002", (String)"VMIServiceImpl_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), executeAudit.getMessage());
                        log.error("\u76ee\u6807\u5355\u636e(pm_transferbill)\u5ba1\u6838\u5f02\u5e38\uff1a");
                        trackLog.info("audit failer:" + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u201c%1$s\u201d\u5ba1\u6838\u5f02\u5e38\uff1a%2$s\u3002", (String)"VMIServiceImpl_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), VMITransferBillEntity, message));
                        map.put("success", Boolean.FALSE);
                        map.put("message", message);
                    }
                } else if (executeSubmit != null) {
                    String message = String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e0b\u6e38\u7269\u6743\u8f6c\u79fb\u5355\u5f02\u5e38\uff1a%1$s\u3002", (String)"VMIServiceImpl_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), executeSubmit.getMessage());
                    log.error("\u76ee\u6807\u5355\u636e(pm_transferbill)\u63d0\u4ea4\u5f02\u5e38\uff1a");
                    trackLog.info("submit failer:" + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u201c%1$s\u201d\u63d0\u4ea4\u5f02\u5e38\uff1a%2$s\u3002", (String)"VMIServiceImpl_5", (String)"scmc-pm-vmi", (Object[])new Object[0]), VMITransferBillEntity, message));
                    map.put("success", Boolean.FALSE);
                    map.put("message", message);
                }
            } else if (executeSave != null) {
                String message = String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e0b\u6e38\u7269\u6743\u8f6c\u79fb\u5355\u5f02\u5e38\uff1a%1$s\u3002", (String)"VMIServiceImpl_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), executeSave.getMessage());
                log.error("\u76ee\u6807\u5355\u636e(pm_transferbill)\u4fdd\u5b58\u5f02\u5e38\uff1a");
                trackLog.info("save failer:" + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u201c%1$s\u201d\u4fdd\u5b58\u5931\u8d25\uff1a%2$s\u3002", (String)"VMIServiceImpl_18", (String)"scmc-pm-vmi", (Object[])new Object[0]), VMITransferBillEntity, message));
                map.put("success", Boolean.FALSE);
                map.put("message", message);
            }
        }
        trackLog.endInfo(this.serialization(map));
        return map;
    }

    @Override
    public Map<String, Object> checkDeleteTransferBill(String VMISettleSrcBillEntity, List<Long> ids) {
        trackLog.startInfo(VMISettleSrcBillEntity + this.serialization(ids));
        log.info("\u5fae\u670d\u52a1\u53c2\u6570\u4e3a: " + VMISettleSrcBillEntity + this.serialization(ids));
        Map<String, Object> result = new HashMap<String, Object>(4);
        if (ids == null || StringUtils.isBlank((CharSequence)VMISettleSrcBillEntity) || ids.isEmpty()) {
            log.info("\u5fae\u670d\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5fae\u670d\u52a1\u53c2\u6570\u201d\u3002", (String)"VMIServiceImpl_7", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            trackLog.endInfo(this.serialization(result));
            return result;
        }
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)VMISettleSrcBillEntity, (Long[])ids.toArray(new Long[0]));
        log.info("\u5b9e\u5355\u67e5\u8be2\u4e0b\u6e38\u7269\u6743\u8f6c\u79fb\u5355\u7684\u4fe1\u606f\u4e3a\uff1a" + SerializationUtils.toJsonString((Object)dirtTargetBills));
        if (dirtTargetBills == null || dirtTargetBills.isEmpty()) {
            result.put("success", Boolean.TRUE);
            result.put("message", "");
            result.put("successids", ids);
            log.info("\u5f53\u524d\u5355\u636e\u65e0\u4e0b\u6e38\u5355\u636e\uff1a" + this.serialization(result));
            return result;
        }
        ArrayList<Long> successIds = new ArrayList<Long>(10);
        Map<Long, Set<Long>> srcBillAndTransferBillIdMap = this.getSrcBillAndTransferBillMap(dirtTargetBills);
        ids.forEach(id -> {
            if (!srcBillAndTransferBillIdMap.containsKey(id)) {
                successIds.add((Long)id);
            }
        });
        ArrayList<Long> transferBillIds = new ArrayList<Long>(10);
        srcBillAndTransferBillIdMap.values().forEach(billids -> {
            if (billids != null && !billids.isEmpty()) {
                transferBillIds.addAll((Collection<Long>)billids);
            }
        });
        if (transferBillIds.isEmpty()) {
            result.put("success", Boolean.TRUE);
            result.put("message", "");
            result.put("successids", ids);
            log.info("\u5f53\u524d\u5355\u636e\u65e0\u4e0b\u6e38\u5355\u636e\uff1a" + this.serialization(result));
            return result;
        }
        QFilter filter = new QFilter("id", "in", transferBillIds);
        HashMap<Long, String> settledTransferBillIdAndMsg = new HashMap<Long, String>(10);
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)VMITransferBillEntity, (String)"id,billno,billentry.settlestatus,billentry.srcbillid,billentry.srcbillnumber", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : dataSet) {
                String settleStatus = row.getString("billentry.settlestatus");
                long id2 = row.getLong("id");
                String billno = row.getString("billno");
                idAndBillNoMap.put(id2, billno);
                if ("A".equals(settleStatus)) continue;
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u4e0b\u6e38\u5355\u636e\u7269\u6743\u8f6c\u79fb\u5355%2$s\u5df2\u7ecf\u53d1\u751fVMI\u7ed3\u7b97\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"VMIServiceImpl_8", (String)"scmc-pm-vmi", (Object[])new Object[0]), row.getString("billentry.srcbillnumber"), billno);
                settledTransferBillIdAndMsg.put(id2, message);
            }
            log.info("\u67e5\u8be2\u7269\u6743\u8f6c\u79fb\u5355\u7ed3\u7b97\u72b6\u6001\u7684\u63d0\u793a\u8bed\u4e3a\uff1a" + settledTransferBillIdAndMsg.size());
        }
        transferBillIds.removeAll(new HashSet(settledTransferBillIdAndMsg.keySet()));
        Map<Long, String> hasVirBillTransferBillIds = this.getHasVirBillTranBillIds(transferBillIds);
        log.info("\u67e5\u8be2\u7269\u6743\u8f6c\u79fb\u5355\u4e0b\u6e38\u865a\u5355\u7684\u63d0\u793a\u8bed\u4e3a\uff1a" + hasVirBillTransferBillIds.size());
        transferBillIds.removeAll(new HashSet<Long>(hasVirBillTransferBillIds.keySet()));
        Map<Long, String> addMutexFailMsg = this.addMutex(transferBillIds, idAndBillNoMap);
        log.info("\u67e5\u8be2\u7269\u6743\u8f6c\u79fb\u5355\u4e0b\u6e38\u865a\u5355\u7684\u63d0\u793a\u8bed\u4e3a\uff1a" + addMutexFailMsg.size());
        transferBillIds.removeAll(addMutexFailMsg.keySet());
        result = this.buildResult(successIds, srcBillAndTransferBillIdMap, settledTransferBillIdAndMsg, hasVirBillTransferBillIds, addMutexFailMsg, transferBillIds);
        trackLog.endInfo(this.serialization(result));
        return result;
    }

    private Map<Long, String> addMutex(List<Long> transferBillIds, Map<Long, String> query) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        if (transferBillIds == null || transferBillIds.isEmpty()) {
            return result;
        }
        HashMap<Long, String> billIdAndBillNoMap = new HashMap<Long, String>(10);
        query.entrySet().forEach(row -> {
            long id = (Long)row.getKey();
            if (transferBillIds.contains(id)) {
                billIdAndBillNoMap.put(id, (String)row.getValue());
            }
        });
        Set<Long> addDoVMIOPMutex = VMIMutexHelper.addDoVMIOPMutex(billIdAndBillNoMap);
        for (Long id : transferBillIds) {
            if (addDoVMIOPMutex.contains(id)) continue;
            result.put(id, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a %1$s \u7684\u7269\u6743\u8f6c\u79fb\u5355\u6b63\u5728\u6267\u884cVMI\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMIServiceImpl_19", (String)"scmc-pm-vmi", (Object[])new Object[0]), billIdAndBillNoMap.get(id)));
        }
        return result;
    }

    private Map<String, Object> buildResult(List<Long> successIds, Map<Long, Set<Long>> srcBillAndTransferBillIdMap, Map<Long, String> settledTransferBillIdAndMsg, Map<Long, String> hasVirBillTransferBillIds, Map<Long, String> addMutexFailMsg, List<Long> transferBillIds) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Map<Long, String> errorMsg = new HashMap<Long, String>(10);
        errorMsg = this.addSettledErrorMsg(errorMsg, srcBillAndTransferBillIdMap, settledTransferBillIdAndMsg);
        errorMsg = this.addSettledErrorMsg(errorMsg, srcBillAndTransferBillIdMap, hasVirBillTransferBillIds);
        errorMsg = this.addSettledErrorMsg(errorMsg, srcBillAndTransferBillIdMap, addMutexFailMsg);
        srcBillAndTransferBillIdMap.keySet().removeAll(errorMsg.keySet());
        successIds.addAll(srcBillAndTransferBillIdMap.keySet());
        result.put("success", Boolean.TRUE);
        result.put("errormsg", errorMsg);
        result.put("billmapping", srcBillAndTransferBillIdMap);
        result.put("mutexedids", transferBillIds);
        return result;
    }

    private Map<Long, String> addSettledErrorMsg(Map<Long, String> errorMsg, Map<Long, Set<Long>> srcBillAndTransferBillIdMap, Map<Long, String> checkTransferResult) {
        if (checkTransferResult == null || checkTransferResult.isEmpty()) {
            return errorMsg;
        }
        block0: for (Map.Entry<Long, Set<Long>> entry : srcBillAndTransferBillIdMap.entrySet()) {
            Long srcBillId = entry.getKey();
            Set<Long> transferBillIds = entry.getValue();
            if (srcBillId == null || transferBillIds == null || transferBillIds.isEmpty()) continue;
            for (Long transferBIllId : transferBillIds) {
                String msg = checkTransferResult.get(transferBIllId);
                if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
                errorMsg.put(srcBillId, msg);
                continue block0;
            }
        }
        return errorMsg;
    }

    private Map<Long, String> getHasVirBillTranBillIds(List<Long> transferBillIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        if (transferBillIds == null || transferBillIds.isEmpty()) {
            return result;
        }
        Map virBillBFMap = BFTrackerServiceHelper.findDirtTargetBills((String)VMITransferBillEntity, (Long[])transferBillIds.toArray(new Long[0]));
        log.info("\u7269\u67e5\u8be2\u7269\u6743\u8f6c\u79fb\u5355\u4e0b\u6e38\u865a\u5355\u7684\u94fe\u8def\u5173\u7cfb\u4e3a\uff1a" + SerializationUtils.toJsonString((Object)virBillBFMap));
        if (virBillBFMap == null || virBillBFMap.isEmpty()) {
            return new HashMap<Long, String>(10);
        }
        for (Map.Entry entry : virBillBFMap.entrySet()) {
            List value = (List)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            result.put((Long)entry.getKey(), ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0b\u6e38\u7684\u7269\u6743\u8f6c\u79fb\u5355\u5df2\u7ecf\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"VMIServiceImpl_20", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
        return result;
    }

    private Map<Long, Set<Long>> getSrcBillAndTransferBillMap(Map<Long, List<BFRow>> dirtTargetBills) {
        HashMap<Long, Set<Long>> srcBillAndTransferBillIdMap = new HashMap<Long, Set<Long>>(10);
        TableDefine transferBillTableDef = ConvertMetaServiceHelper.loadMainTableDefine((String)VMITransferBillEntity);
        Long transferBillTableId = transferBillTableDef.getTableId();
        for (Map.Entry<Long, List<BFRow>> entry : dirtTargetBills.entrySet()) {
            Long srcBillId = entry.getKey();
            List<BFRow> bfRows = entry.getValue();
            if (bfRows == null || bfRows.isEmpty()) continue;
            HashSet<Long> billIds = null;
            for (BFRow row : bfRows) {
                BFRowId id = row.getId();
                Long mainTableId = id.getMainTableId();
                if (transferBillTableId == null || mainTableId == null || !transferBillTableId.equals(mainTableId)) continue;
                if (billIds == null) {
                    billIds = new HashSet<Long>(2);
                }
                billIds.add(id.getBillId());
            }
            if (billIds == null) continue;
            srcBillAndTransferBillIdMap.put(srcBillId, billIds);
        }
        return srcBillAndTransferBillIdMap;
    }

    @Override
    public Map<String, Object> deleteTransferBill(String VMISettleSrcBillEntity, List<Long> ids, List<Long> needDeleteBillIds) {
        trackLog.startInfo(VMISettleSrcBillEntity + this.serialization(ids) + this.serialization(needDeleteBillIds));
        log.info(VMISettleSrcBillEntity + this.serialization(ids) + this.serialization(needDeleteBillIds));
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (ids == null || StringUtils.isBlank((CharSequence)VMISettleSrcBillEntity) || ids.isEmpty() || needDeleteBillIds == null || needDeleteBillIds.isEmpty()) {
            log.info("\u5fae\u670d\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5fae\u670d\u52a1\u53c2\u6570\u201d\u3002", (String)"VMIServiceImpl_7", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            trackLog.endInfo(this.serialization(result));
            return result;
        }
        DynamicObject[] query = BusinessDataServiceHelper.load((String)VMITransferBillEntity, (String)"id,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", needDeleteBillIds)});
        ArrayList<Object> auditBillIds = new ArrayList<Object>(10);
        ArrayList<Object> submitBillIds = new ArrayList<Object>(10);
        ArrayList<Object> saveBillIds = new ArrayList<Object>(10);
        for (DynamicObject bill : query) {
            String billstatus = bill.getString("billstatus");
            long id = bill.getLong("id");
            if ("A".equals(billstatus)) {
                saveBillIds.add(id);
            }
            if ("B".equals(billstatus)) {
                submitBillIds.add(id);
            }
            if (!"C".equals(billstatus)) continue;
            auditBillIds.add(id);
        }
        StringBuilder errorMsg = new StringBuilder();
        saveBillIds.addAll(this.excuteOp("unaudit", auditBillIds, errorMsg, query));
        saveBillIds.addAll(this.excuteOp("unsubmit", submitBillIds, errorMsg, query));
        this.excuteOp("delete", saveBillIds, errorMsg, query);
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            result.put("success", Boolean.FALSE);
            result.put("message", errorMsg.toString());
            trackLog.endInfo(this.serialization(result));
            return result;
        }
        result.put("success", Boolean.TRUE);
        return result;
    }

    private List<Object> excuteOp(String op, List<Object> billids, StringBuilder errorMsg, DynamicObject[] query) {
        if (!billids.isEmpty()) {
            Map<Long, String> errorMsgMapping;
            OperationResult deleteResult = OperateHelper.invokeBillOp(op, VMITransferBillEntity, billids.toArray());
            if (!deleteResult.isSuccess() && (errorMsgMapping = OperateHelper.handleFailInfo("unaudit", deleteResult, new ArrayList<DynamicObject>(Arrays.asList(query)))) != null && !errorMsgMapping.isEmpty()) {
                errorMsgMapping.values().forEach(msg -> this.addErrMsg(errorMsg, (String)msg));
            }
            return deleteResult.getSuccessPkIds();
        }
        return new ArrayList<Object>(10);
    }

    private StringBuilder addErrMsg(StringBuilder sb, String msg) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (sb.length() < 2000) {
            sb.append(msg);
        }
        return sb;
    }

    @Override
    @Deprecated
    public void AsyncExecuteVMISettle(List<Long> ids) {
        trackLog.startInfo(this.serialization(ids));
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.VMISettle(ids);
    }

    private void VMISettle(List<Long> ids) {
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)VMITransferBillEntity, (String)"id,billno,billentry,purorg", (QFilter[])qFilter);
        if (bills == null || bills.length < 1) {
            return;
        }
        Set<Long> realTimeSettlePurOrgId = this.getRealTimeSettlePurOrgId(bills);
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> sourceIdAndBillNoMap = new HashMap<Long, String>(16);
        VMISettleParam settleParam = new VMISettleParam(VMISettleTypeEnum.REALTIME);
        for (int i = 0; i < bills.length; ++i) {
            Long purorgPkValue;
            DynamicObject bill = bills[i];
            DynamicObject purorg = (DynamicObject)bill.get("purorg");
            if (purorg == null || !realTimeSettlePurOrgId.contains(purorgPkValue = (Long)purorg.getPkValue())) continue;
            Long billId = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            sourceIdAndBillNoMap.put(billId, billNo);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                sourceIdMap.put((Long)entry.getPkValue(), billId);
            }
        }
        if (CommonUtils.isNull(sourceIdMap)) {
            return;
        }
        settleParam.setTransferEntryIdAndBillIdMap(sourceIdMap);
        VMISettleResult vmiSettleResult = VMISettleService.vmiSettle(settleParam);
        if (vmiSettleResult != null && !vmiSettleResult.isSuccess()) {
            List<Long> failIds = vmiSettleResult.getFailIds();
            StringBuilder failBillNo = new StringBuilder();
            failIds.forEach(id -> failBillNo.append((String)sourceIdAndBillNoMap.get(id)).append('\uff0c'));
            this.sendMsgToUser(String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u201c%s\u201d\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIServiceImpl_16", (String)"scmc-pm-vmi", (Object[])new Object[0]), failBillNo.substring(0, failBillNo.lastIndexOf("\uff0c"))));
        }
    }

    private Set<Long> getRealTimeSettlePurOrgId(DynamicObject[] bills) {
        HashSet<Long> realTimeSettlePurOrgIds = new HashSet<Long>();
        if (CommonUtils.isNull((Object)bills)) {
            return realTimeSettlePurOrgIds;
        }
        HashSet<Long> purOrgIds = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            DynamicObject purOrg = (DynamicObject)bill.get("purorg");
            if (purOrg == null) continue;
            Long purOrgId = (Long)purOrg.getPkValue();
            purOrgIds.add(purOrgId);
        }
        if (CommonUtils.isNull(purOrgIds)) {
            return realTimeSettlePurOrgIds;
        }
        Map settleTypeParam = SysParamHelper.batchGetSysParam((String)"/JJVO8XV9MVB", (String)"02", new ArrayList(purOrgIds), (String)"fvmisettletype");
        return this.getRealTimeSettlePurOrgId(settleTypeParam);
    }

    private Set<Long> getRealTimeSettlePurOrgId(Map<String, Object> settleTypeParam) {
        HashSet<Long> realTimeSettlePurOrgIds = new HashSet<Long>(10);
        if (CommonUtils.isNull(settleTypeParam)) {
            return realTimeSettlePurOrgIds;
        }
        for (Map.Entry<String, Object> onePurOrgPara : settleTypeParam.entrySet()) {
            Long purOrgId = Long.parseLong(onePurOrgPara.getKey());
            String settleType = (String)onePurOrgPara.getValue();
            if (!VMISettleTypeEnum.REALTIME.getValue().equals(settleType)) continue;
            realTimeSettlePurOrgIds.add(purOrgId);
        }
        return realTimeSettlePurOrgIds;
    }

    private void sendMsgToUser(String msg) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> userIDS = new ArrayList<Long>(5);
        userIDS.add(currentUserId);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setUserIds(userIDS);
        MainEntityType transferBill = MetadataServiceHelper.getDataEntityType((String)VMITransferBillEntity);
        LocaleString disPlayName = transferBill.getDisplayName();
        msgInfo.setEntityNumber(transferBill.getName());
        msgInfo.setTitle(disPlayName.toString());
        msgInfo.setContent(msg);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }

    private PushArgs getPushArgs(String srcBillEntity, String ruleId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcBillEntity);
        pushArgs.setTargetEntityNumber(VMITransferBillEntity);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(false);
        return pushArgs;
    }

    private String serialization(Object o) {
        String jsonString = "";
        if (o == null) {
            jsonString = "param is null";
        } else if (o instanceof Map || o instanceof List) {
            jsonString = SerializationUtils.toJsonString((Object)o);
        }
        return jsonString;
    }
}

