/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.validation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

public class VMISRSingleValidator
extends AbstractValidator {
    private static final String ENTITY_PURINBILL = "im_purinbill";
    private static final String ENTITY_BUSBILL = "ap_busbill";
    private static final String ENTITY_FINAPBILL = "ap_finapbill";

    public void validate() {
        Serializable purInBillId;
        String operateKey = this.getOperateKey();
        if (!"singlesettlereverse".equals(operateKey)) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        if (dataEntities == null || dataEntities.length != 1) {
            return;
        }
        ExtendedDataEntity extendedDataEntity = dataEntities[0];
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String settleLotNo = dataEntity.getString("settlelotno");
        String currentResult = dataEntity.getString("settleresult");
        if (!VMISettleResultEnum.SETTLESCUESS.getValue().equals(currentResult) && !VMISettleResultEnum.REVERSEFAIL.getValue().equals(currentResult)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ed3\u679c\u4e3a\u201c\u7ed3\u7b97\u6210\u529f\u201d\u6216\u201c\u53cd\u7ed3\u7b97\u5931\u8d25\u201d\u7684\u6570\u636e\u53cd\u7ed3\u7b97\u3002", (String)"VMISRSingleValidator_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
        if (billEntrys == null || billEntrys.isEmpty()) {
            return;
        }
        HashSet<Long> purInBillIds = new HashSet<Long>(10);
        HashSet<Long> invBillIds = new HashSet<Long>(10);
        for (int i = 0; i < billEntrys.size(); ++i) {
            Object invBillId;
            DynamicObject entry = (DynamicObject)billEntrys.get(i);
            purInBillId = (Long)entry.get("purinbillid");
            if ((Long)purInBillId != 0L) {
                purInBillIds.add((Long)purInBillId);
            }
            if ((Long)(invBillId = (Long)entry.get("invbillid")) == 0L) continue;
            invBillIds.add((Long)invBillId);
        }
        Long pkValue = (Long)dataEntity.getPkValue();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)"id,billentry.purinbillid as purinbillid,billentry.invbillid as invbillid", (QFilter[])new QFilter[]{new QFilter("settlelotno", "=", (Object)settleLotNo)}, null);
        purInBillId = null;
        try {
            for (Row row : dataSet) {
                Long id = (Long)row.get("id");
                if (pkValue.compareTo(id) == 0) continue;
                Long purinbillid = row.getLong("purinbillid");
                Long invbillid = row.getLong("invbillid");
                if (!purInBillIds.contains(purinbillid) && !invBillIds.contains(invbillid)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7684\u7269\u6743\u8f6c\u79fb\u5355\u4e0e\u5165\u5e93\u865a\u5355\u548c\u5e93\u5b58\u865a\u5355\u975e\u4e00\u5bf9\u4e00\u5173\u7cfb\uff0c\u65e0\u6cd5\u5355\u6761\u53cd\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u53cd\u7ed3\u7b97\u3002", (String)"VMISRSingleValidator_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                return;
            }
        }
        catch (Throwable invBillId) {
            purInBillId = invBillId;
            throw invBillId;
        }
        finally {
            if (dataSet != null) {
                if (purInBillId != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)purInBillId).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (purInBillIds.isEmpty()) {
            return;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)ENTITY_PURINBILL, (Long[])purInBillIds.toArray(new Long[0]));
        HashSet busbillIds = (HashSet)targetBills.get(ENTITY_BUSBILL);
        HashSet finapBillIds = (HashSet)targetBills.get(ENTITY_FINAPBILL);
        if (busbillIds != null && busbillIds.size() > 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u6682\u4f30\u5e94\u4ed8\u5355\uff0c\u65e0\u6cd5\u5355\u6761\u53cd\u7ed3\u7b97\u3002", (String)"VMISRSingleValidator_2", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return;
        }
        if (finapBillIds != null && finapBillIds.size() > 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u65e0\u6cd5\u5355\u6761\u53cd\u7ed3\u7b97\u3002", (String)"VMISRSingleValidator_3", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return;
        }
    }
}

