/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.OrgHelper;

public class VmiConDetailsRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    private static final String HAS_PERMISSION_INV_ORG = "HasPermissionAndStartedInvOrg";

    public void registerListener(EventObject e) {
        BasedataEdit warehouse;
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit supplier;
        BasedataEdit purorg;
        super.registerListener(e);
        BasedataEdit orghead = (BasedataEdit)this.getView().getControl("invorg");
        if (orghead != null) {
            orghead.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((purorg = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getView().getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgid = RequestContext.get().getOrgId();
        List invorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (invorgList != null && !invorgList.isEmpty()) {
            if (invorgList.contains(orgid)) {
                model.setValue("invorg", (Object)orgid);
            } else {
                model.setValue("invorg", invorgList.get(0));
            }
            this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString((Object)invorgList));
        }
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgid)) {
                model.setValue("purorg", (Object)orgid);
            } else {
                model.setValue("purorg", purorgList.get(0));
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
        }
        Object startdate = model.getValue("startdate");
        Object enddate = model.getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject orghead = (DynamicObject)this.getModel().getValue("invorg");
        switch (fieldKey) {
            case "invorg": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_INV_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    List<Long> orgList = VmiConDetailsRptPlugin.getHasPermissionOrg("pm_vmi_condetailrpt", OrgViewTypeEnum.IS_INVENTORY.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgList = VmiConDetailsRptPlugin.getHasPermissionOrg("pm_vmi_condetailrpt", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "supplier": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)orghead.getPkValue()));
                showParameter.getListFilterParameter().getQFilters().add(filter);
                showParameter.setCustomParam("useOrg", (Object)orghead.getPkValue().toString());
                showParameter.setShowApproved(false);
                break;
            }
            case "material": 
            case "project": 
            case "warehouse": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "invorg": {
                this.getModel().setValue("supplier", null);
                this.getModel().setValue("material", null);
                this.getModel().setValue("project", null);
                this.getModel().setValue("warehouse", null);
                break;
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        if (this.getView().getFormShowParameter().getCustomParam("hyperlinkFromSumPpt") != null) {
            this.getHyperLinkClickCustomParams(queryParam);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("invorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        DynamicObject purorg = filter.getDynamicObject("purorg");
        if (purorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiConDetailsRptPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"VmiConDetailsRptPlugin_2", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return false;
    }

    private void getHyperLinkClickCustomParams(ReportQueryParam queryParam) {
        Object invorg = this.getView().getFormShowParameter().getCustomParam("invorg");
        Object purorg = this.getView().getFormShowParameter().getCustomParam("purorg");
        Object material = this.getView().getFormShowParameter().getCustomParam("material");
        Object supplier = this.getView().getFormShowParameter().getCustomParam("supplier");
        Object project = this.getView().getFormShowParameter().getCustomParam("project");
        if (invorg != null) {
            queryParam.getFilter().addFilterItem("invorg", invorg);
        }
        if (purorg != null) {
            queryParam.getFilter().addFilterItem("purorg", purorg);
        }
        if (material != null) {
            queryParam.getFilter().addFilterItem("material", material);
        }
        if (supplier != null) {
            queryParam.getFilter().addFilterItem("supplier", supplier);
        }
        if (project != null) {
            queryParam.getFilter().addFilterItem("project", project);
        }
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

