/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.OrgHelper;

public class VmiConSumRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(VmiConSumRptPlugin.class);
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    private static final String HAS_PERMISSION_INV_ORG = "HasPermissionAndStartedInvOrg";

    public void registerListener(EventObject e) {
        BasedataEdit warehouse;
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit supplier;
        BasedataEdit purorg;
        super.registerListener(e);
        BasedataEdit orghead = (BasedataEdit)this.getView().getControl("invorg");
        if (orghead != null) {
            orghead.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((purorg = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getView().getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgid = RequestContext.get().getOrgId();
        List invorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (invorgList != null && !invorgList.isEmpty()) {
            if (invorgList.contains(orgid)) {
                model.setValue("invorg", (Object)orgid);
                this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString((Object)invorgList));
            } else {
                model.setValue("invorg", invorgList.get(0));
            }
        }
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgid)) {
                model.setValue("purorg", (Object)orgid);
                this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
            } else {
                model.setValue("purorg", purorgList.get(0));
            }
        }
        Object startdate = model.getValue("startdate");
        Object enddate = model.getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject orghead = (DynamicObject)this.getModel().getValue("invorg");
        switch (fieldKey) {
            case "invorg": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_INV_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    List<Long> orgList = VmiConSumRptPlugin.getHasPermissionOrg("pm_vmi_consumrpt", OrgViewTypeEnum.IS_INVENTORY.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgList = VmiConSumRptPlugin.getHasPermissionOrg("pm_vmi_consumrpt", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "supplier": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)orghead.getPkValue()));
                showParameter.getListFilterParameter().getQFilters().add(filter);
                showParameter.setCustomParam("useOrg", (Object)orghead.getPkValue().toString());
                showParameter.setShowApproved(false);
                break;
            }
            case "material": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "project": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "warehouse": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)Long.valueOf(orghead.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(qFilter);
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "invorg": {
                this.getModel().setValue("supplier", null);
                this.getModel().setValue("material", null);
                this.getModel().setValue("project", null);
                this.getModel().setValue("warehouse", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("invorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        DynamicObject purorg = filter.getDynamicObject("purorg");
        if (purorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiConSumRptPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"VmiConSumRptPlugin_2", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return false;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("entry_material".equals(evt.getFieldName())) {
            this.showBills(rowData);
        }
    }

    protected void showBills(DynamicObject rowData) {
        ReportShowParameter rsp = new ReportShowParameter();
        this.setInvBillReportFilterValue(rowData);
        rsp.setQueryParam(this.getQueryParam());
        Map customParams = rsp.getCustomParams();
        this.handleHyperLinkClickCustomParams(rowData, customParams);
        rsp.setFormId("pm_vmi_condetailrpt");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)rsp);
    }

    private void setInvBillReportFilterValue(DynamicObject rowData) {
        DynamicObject material;
        DynamicObject supplier;
        DynamicObject purorg;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject invorg = rowData.getDynamicObject("entry_invorg");
        if (invorg != null) {
            filterInfo.addFilterItem("invorg", invorg.getPkValue());
        }
        if ((purorg = rowData.getDynamicObject("entry_purorg")) != null) {
            filterInfo.addFilterItem("purorg", purorg.getPkValue());
        }
        if ((supplier = rowData.getDynamicObject("entry_supplier")) != null) {
            filterInfo.addFilterItem("supplier", supplier.getPkValue());
        }
        if ((material = rowData.getDynamicObject("entry_material")) != null) {
            filterInfo.addFilterItem("material", material.getPkValue());
        }
        DynamicObject project = rowData.getDynamicObject("entry_project");
        if (material != null) {
            filterInfo.addFilterItem("project", (Object)project);
        }
    }

    private void handleHyperLinkClickCustomParams(DynamicObject rowData, Map<String, Object> customParams) {
        DynamicObject projectLink;
        DynamicObject supplierHyperLink;
        DynamicObject materialHyperLink;
        DynamicObject purorgHyperLink;
        customParams.put("hyperlinkFromSumPpt", "hyperlinkFromSumPpt");
        DynamicObject invorg = rowData.getDynamicObject("entry_invorg");
        if (invorg != null) {
            customParams.put("invorg", invorg.getPkValue());
        }
        if ((purorgHyperLink = rowData.getDynamicObject("entry_purorg")) != null) {
            customParams.put("purorg", purorgHyperLink.getPkValue());
        }
        if ((materialHyperLink = rowData.getDynamicObject("entry_material")) != null) {
            customParams.put("material", materialHyperLink.getPkValue());
        }
        if ((supplierHyperLink = rowData.getDynamicObject("entry_supplier")) != null) {
            customParams.put("supplier", supplierHyperLink.getPkValue());
        }
        if ((projectLink = rowData.getDynamicObject("entry_project")) != null) {
            customParams.put("project", projectLink);
        }
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

