/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.utils.DateUtil;

public class VmiSettlementSumRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> filters = VmiSettlementSumRptQuery.getFilters(filterInfo);
        String selectField = VmiSettlementSumRptQuery.getSelectField();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)selectField, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet gpdataSet = dataSet.groupBy(new String[]{"entry_purorg", "entry_supplier", "entry_material", "unit"}).sum("settlementqty").finish();
        return gpdataSet.select(this.getShowField());
    }

    private String getShowField() {
        return "entry_purorg,entry_supplier,entry_material,unit,settlementqty";
    }

    private static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("settledate", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("settledate", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObject purOrg = filterInfo.getDynamicObject("purorg");
        if (purOrg != null) {
            filters.add(new QFilter("org", "=", purOrg.getPkValue()));
        }
        if ((supplers = filterInfo.getDynamicObjectCollection("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = VmiSettlementSumRptQuery.getBaseDataPkIds(supplers);
            filters.add(new QFilter("billentry.supplier", "in", (Object)supplerids));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiSettlementSumRptQuery.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        filters.add(new QFilter("settleresult", "=", (Object)"A"));
        return filters;
    }

    private static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("org as entry_purorg");
        selectorSet.add("billentry.supplier as entry_supplier");
        selectorSet.add("billentry.material.id as entry_material");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.qty as settlementqty");
        return String.join((CharSequence)",", selectorSet);
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

