/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.utils.DateUtil;

public class VmiConsumRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("org as entry_invorg");
        selectorSet.add("purorg as entry_purorg");
        selectorSet.add("billentry.supplier as entry_supplier");
        selectorSet.add("billentry.material.masterid.id as entry_material");
        selectorSet.add("billentry.project as entry_project");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.joinqty as joinqty");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject warehouse;
        DynamicObject project;
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        DynamicObject purOrg;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObject org = filterInfo.getDynamicObject("invorg");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((purOrg = filterInfo.getDynamicObject("purorg")) != null) {
            filters.add(new QFilter("purorg", "=", purOrg.getPkValue()));
        }
        if ((supplers = filterInfo.getDynamicObjectCollection("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = VmiConsumRptHelper.getBaseDataPkIds(supplers);
            filters.add(new QFilter("billentry.supplier", "in", (Object)supplerids));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiConsumRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((project = filterInfo.getDynamicObject("project")) != null) {
            filters.add(new QFilter("billentry.project", "in", project.getPkValue()));
        }
        if ((warehouse = filterInfo.getDynamicObject("warehouse")) != null) {
            filters.add(new QFilter("billentry.warehouse", "in", warehouse.getPkValue()));
        }
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

