/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmicondetail;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;

public class VmiConDetailsReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    private static final String HAS_PERMISSION_INV_ORG = "HasPermissionAndStartedInvOrg";

    public void registerListener(EventObject e) {
        BasedataEdit transferbillno;
        BasedataEdit srcEntityNo;
        BasedataEdit warehouse;
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit supplier;
        BasedataEdit purorg;
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orghead = (BasedataEdit)this.getView().getControl("invorg");
        if (orghead != null) {
            orghead.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((purorg = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getView().getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((srcEntityNo = (BasedataEdit)this.getControl("srcentityno")) != null) {
            srcEntityNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((transferbillno = (BasedataEdit)this.getControl("transferbillno")) != null) {
            transferbillno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("hyperlinkFromSumPpt")) {
            this.initParamByParam();
            this.getPageCache().put("linkOpened", "true");
        } else {
            this.initDefaultParam();
        }
    }

    private void initParamByParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("invorg", (Object)new Object[]{customParams.get("invorg")});
        this.getModel().setValue("purorg", (Object)new Object[]{customParams.get("purorg")});
        this.getModel().setValue("material", (Object)new Object[]{customParams.get("material")});
        this.getModel().setValue("supplier", (Object)new Object[]{customParams.get("supplier")});
        this.getModel().setValue("project", customParams.get("project"));
        Object startdate = customParams.get("startdate");
        Object enddate = customParams.get("enddate");
        this.getModel().setValue("startdate", startdate);
        this.getModel().setValue("enddate", enddate);
    }

    private void initDefaultParam() {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgid = RequestContext.get().getOrgId();
        List invorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (invorgList != null && !invorgList.isEmpty()) {
            if (invorgList.contains(orgid)) {
                model.setValue("invorg", (Object)new Object[]{orgid});
            } else {
                model.setValue("invorg", (Object)new Object[]{invorgList.get(0)});
            }
            this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString((Object)invorgList));
        }
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgid)) {
                model.setValue("purorg", (Object)new Object[]{orgid});
            } else {
                model.setValue("purorg", (Object)new Object[]{purorgList.get(0)});
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
        }
        Object startdate = model.getValue("startdate");
        Object enddate = model.getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String linkOpened = this.getPageCache().get("linkOpened");
        if (linkOpened != null && customParams != null && customParams.containsKey("hyperlinkFromSumPpt")) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orghead = (DynamicObjectCollection)this.getModel().getValue("invorg");
        List<Long> listOrgId = null;
        switch (fieldKey) {
            case "invorg": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_INV_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    String formId = this.getView().getFormShowParameter().getFormId();
                    List<Long> orgList = VmiConDetailsReportPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_INVENTORY.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_INV_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    String formId = this.getView().getFormShowParameter().getFormId();
                    List<Long> orgList = VmiConDetailsReportPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "supplier": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "invorg");
                QFilter bd_supplier = MultiOrgHelper.getBaseDataFilter("bd_supplier", listOrgId);
                if (bd_supplier != null) {
                    showParameter.getListFilterParameter().setFilter(bd_supplier);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "material": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "invorg");
                QFilter bd_material = MultiOrgHelper.getBaseDataFilter("bd_material", listOrgId);
                if (bd_material != null) {
                    showParameter.getListFilterParameter().setFilter(bd_material);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "project": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "invorg");
                QFilter bd_project = MultiOrgHelper.getBaseDataFilter("bd_project", listOrgId);
                if (bd_project != null) {
                    showParameter.getListFilterParameter().setFilter(bd_project);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "warehouse": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "invorg");
                QFilter bd_warehouse = MultiOrgHelper.getBaseDataFilter("bd_warehouse", listOrgId);
                if (bd_warehouse != null) {
                    showParameter.getListFilterParameter().setFilter(bd_warehouse);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "srcentityno": {
                QFilter q4 = new QFilter("enable", "=", (Object)"1");
                QFilter q3 = new QFilter("status", "=", (Object)"C");
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_vmisettlemodel", (String)"vmisettlesrcbill", (QFilter[])new QFilter[]{q4, q3});
                if (loadFromCache == null || loadFromCache.isEmpty()) {
                    return;
                }
                ArrayList list = new ArrayList(loadFromCache.size());
                loadFromCache.values().forEach(settleModel -> list.add(((DynamicObject)settleModel.get("vmisettlesrcbill")).getPkValue()));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", list));
                break;
            }
            case "transferbillno": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection purOrgHead = (DynamicObjectCollection)this.getModel().getValue("purorg");
                if (purOrgHead == null || purOrgHead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                if (startDate == null || endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"VmiConDetailsReportPlugin_2", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<QFilter> filters = this.getQueryTransferBillFilter();
                showParameter.getListFilterParameter().getQFilters().addAll(filters);
                break;
            }
        }
    }

    private List<QFilter> getQueryTransferBillFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        DynamicObjectCollection orghead = (DynamicObjectCollection)this.getModel().getValue("invorg");
        filters.add(new QFilter("org", "in", this.getBaseDataPkIds(orghead)));
        DynamicObjectCollection purOrgHead = (DynamicObjectCollection)this.getModel().getValue("purorg");
        filters.add(new QFilter("purorg", "in", this.getBaseDataPkIds(purOrgHead)));
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        DynamicObjectCollection srcBillForms = (DynamicObjectCollection)this.getModel().getValue("srcentityno");
        if (srcBillForms != null && !srcBillForms.isEmpty()) {
            filters.add(new QFilter("srcbillform", "in", this.getBaseDataPkIds(srcBillForms)));
        }
        return filters;
    }

    private List<Object> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Object> pkIds = new ArrayList<Object>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "invorg": {
                this.getModel().setValue("supplier", null);
                this.getModel().setValue("material", null);
                this.getModel().setValue("project", null);
                this.getModel().setValue("warehouse", null);
                this.getModel().setValue("transferbillno", null);
                break;
            }
            case "purorg": {
                this.getModel().setValue("transferbillno", null);
                break;
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("invorg", filterInfo.getDynamicObjectCollection("invorg"));
        queryParam.getCustomParam().put("purorg", filterInfo.getDynamicObjectCollection("purorg"));
        queryParam.getCustomParam().put("supplier", filterInfo.getDynamicObjectCollection("supplier"));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("material", filterInfo.getDynamicObjectCollection("material"));
        queryParam.getCustomParam().put("project", filterInfo.getDynamicObject("project"));
        queryParam.getCustomParam().put("warehouse", filterInfo.getDynamicObject("warehouse"));
        queryParam.getCustomParam().put("transferbillno", filterInfo.getDynamicObjectCollection("transferbillno"));
        queryParam.getCustomParam().put("srcentityno", filterInfo.getDynamicObjectCollection("srcentityno"));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("invorg");
        if (org == null || org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection purorg = filter.getDynamicObjectCollection("purorg");
        if (purorg == null || purorg.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiConDetailsReportPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"VmiConDetailsReportPlugin_2", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return false;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("billno".equals(evt.getFieldName())) {
            String billno = (String)rowData.get("billno");
            if (StringUtils.isBlank((CharSequence)billno)) {
                return;
            }
            DynamicObject transferBill = QueryServiceHelper.queryOne((String)"pm_transferbill", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            if (transferBill == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"VmiConDetailsReportPlugin_3", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            } else {
                Long billid = transferBill.getLong("id");
                this.showOneBillInfo("pm_transferbill", billid);
            }
        }
    }

    private void showOneBillInfo(String entityid, Long billID) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(entityid);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId((Object)billID);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }
}

