/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmiconsumrpt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;
import kd.scmc.pm.vmi.report.vmiconsumrpt.GroupTransform;

public class VmiConSumReportHandler
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> generalFs = this.getGeneralFilter(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
                srcBlockConf.setDataFs(dataFs);
            }
            if (!"pm_transferbill".equals(srcEntity)) continue;
            for (QFilter ctxFixedFs : generalFs) {
                dataFs.and(ctxFixedFs);
            }
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new GroupTransform());
    }

    private List<QFilter> getGeneralFilter(Map<String, Object> filterInfo) {
        DynamicObject warehouse;
        DynamicObject project;
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        DynamicObjectCollection purOrg;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.get("invorg");
        if (org != null && org.size() > 0) {
            Object[] orgPkIds = VmiConSumReportHandler.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)orgPkIds));
        }
        if ((purOrg = (DynamicObjectCollection)filterInfo.get("purorg")) != null && purOrg.size() > 0) {
            Object[] purOrgPkIds = VmiConSumReportHandler.getBaseDataPkIds(purOrg);
            filters.add(new QFilter("purorg", "in", (Object)purOrgPkIds));
        }
        if ((supplers = (DynamicObjectCollection)filterInfo.get("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = MultiOrgHelper.getMasterIds(supplers);
            filters.add(new QFilter("billentry.supplier.masterid", "in", (Object)supplerids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiConSumReportHandler.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((project = (DynamicObject)filterInfo.get("project")) != null) {
            filters.add(new QFilter("billentry.project", "in", project.getPkValue()));
        }
        if ((warehouse = (DynamicObject)filterInfo.get("warehouse")) != null) {
            filters.add(new QFilter("billentry.warehouse", "in", warehouse.getPkValue()));
        }
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

