/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.pm.forecast.business.helper.ExecuteSql;
import kd.scmc.pm.forecast.business.pojo.QuotaSupplierInfo;
import kd.scmc.pm.forecast.business.pojo.SplitQtyBySupplierInfo;
import kd.scmc.pm.forecast.business.pojo.SplitResultInfo;
import kd.scmc.pm.forecast.business.pojo.SupplierQtyInfo;
import kd.scmc.pm.forecast.common.consts.enums.SupplierOrigin;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class SplitResultHelper {
    private static final String CONSTRAINTTYPE_FORECASTSPLIT = "A";
    private static final String STATUS_AUDIT = "C";
    private static final Date today = Date.from(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant());
    private static final String DAY = "mrp_day";
    private static final String WEEK = "mrp_week";
    private static final String MRP_MASTERID = "mrp_masterid";
    private static final Log log = LogFactory.getLog(SplitResultHelper.class);

    public static List<Long> forecastSplitResult(long fid, List<DynamicObject> billEntry) {
        ArrayList<SplitResultInfo> splitResult = new ArrayList<SplitResultInfo>(5000);
        ArrayList<Long> successSplitMrp = new ArrayList<Long>(5000);
        log.info("\u91c7\u8d2d\u9884\u6d4b\u62c6\u5206\u903b\u8f91\u5f00\u59cb...");
        Map<String, Collection<DynamicObject>> billEntryByOrgAndMode = SplitResultHelper.divideBillEntryByOrgAndMode(billEntry);
        for (Map.Entry<String, Collection<DynamicObject>> entries : billEntryByOrgAndMode.entrySet()) {
            Map<String, Object> resultMap = SplitResultHelper.queryBaseDataAndPreSplitAlgo(entries, fid);
            if (resultMap == null || resultMap.isEmpty()) continue;
            List splitResultInfos = (List)resultMap.get("splitresult");
            List splitMrpEntryIds = (List)resultMap.get("mrp_entryid");
            splitResult.addAll(splitResultInfos);
            successSplitMrp.addAll(splitMrpEntryIds);
        }
        if (splitResult.isEmpty()) {
            log.info("\u672a\u751f\u6210\u62c6\u5206\u7ed3\u679c\u3002");
            return null;
        }
        SplitResultHelper.batchExecute(fid, splitResult);
        log.info("\u91c7\u8d2d\u9884\u6d4b\u62c6\u5206\u5b8c\u6210...");
        return successSplitMrp;
    }

    private static Map<String, Collection<DynamicObject>> divideBillEntryByOrgAndMode(List<DynamicObject> billEntry) {
        ArrayListValuedHashMap rowGroup = new ArrayListValuedHashMap();
        for (DynamicObject entryRow : billEntry) {
            DynamicObject mrpPurOrg = entryRow.getDynamicObject("mrp_purorg");
            if (mrpPurOrg == null) continue;
            String purMode = "todo_delete";
            rowGroup.put((Object)(mrpPurOrg.getPkValue() + "," + purMode), (Object)entryRow);
        }
        return rowGroup.asMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> queryBaseDataAndPreSplitAlgo(Map.Entry<String, Collection<DynamicObject>> entries, long fid) {
        List<SupplierQtyInfo> effectPO;
        List<SupplierQtyInfo> onOrderQtyColl;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Long> splitMrp = new ArrayList<Long>();
        ArrayList<SplitResultInfo> arrayToList = new ArrayList<SplitResultInfo>();
        String key = entries.getKey();
        String[] strings = key.split(",");
        Long purOrgId = Long.valueOf(strings[0]);
        Collection<DynamicObject> value = entries.getValue();
        Map<Long, Long> materialMap = SplitResultHelper.getMaterial(value, purOrgId);
        if (materialMap == null || materialMap.isEmpty()) {
            log.info("\u5f53\u524d\u63a8\u9001\u7684MRP\u6570\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3002");
            return null;
        }
        FilterBuilder splitConstraint = SplitResultHelper.getNormalSplitConstraint(purOrgId);
        DynamicObject[] quotaAssign = SplitResultHelper.queryQuotaColl(purOrgId, materialMap, splitConstraint);
        Map<String, Date> effectDateUnion = SplitResultHelper.getEffectDateUnion(quotaAssign);
        Set<Long> supplierColl = SplitResultHelper.getAllSupplierColl(quotaAssign);
        DynamicObject[] sourceListColl = SplitResultHelper.querySourceListColl(purOrgId, materialMap, supplierColl);
        if (sourceListColl == null || sourceListColl.length < 1) {
            log.info("\u672a\u67e5\u8be2\u5230\u8d27\u6e90\u6e05\u5355\u3002");
        }
        if ((onOrderQtyColl = SplitResultHelper.queryOnOrderPO(splitConstraint, purOrgId)) == null || onOrderQtyColl.isEmpty()) {
            log.info("\u5728\u9014\u91c7\u8d2d\u8ba2\u5355\u4e3a\u7a7a\u3002");
        }
        if ((effectPO = SplitResultHelper.queryEffectPO(splitConstraint, purOrgId, supplierColl, effectDateUnion)).isEmpty()) {
            log.info("\u6709\u6548\u91c7\u8d2d\u8ba2\u5355\u4e3a\u7a7a\u3002");
        }
        Iterator<DynamicObject> iterator = value.iterator();
        while (true) {
            Long material;
            if (!iterator.hasNext()) {
                resultMap.put("mrp_entryid", splitMrp);
                resultMap.put("splitresult", arrayToList);
                return resultMap;
            }
            DynamicObject entryRow = iterator.next();
            if (entryRow == null || (material = materialMap.get(entryRow.getLong(MRP_MASTERID))) == null) continue;
            entryRow.set("mrp_material", (Object)material);
            try {
                List<SplitResultInfo> splitResultInfos;
                SplitQtyBySupplierInfo splitQtyBySupplierInfo;
                BigDecimal onOrderSumQty;
                BigDecimal forecastSumQty;
                Map<String, BigDecimal> forecastSumQtyAndOnOrderSumQty;
                ArrayList<SupplierQtyInfo> onOrderQtyCollByMaterial;
                if (onOrderQtyColl != null && !onOrderQtyColl.isEmpty() && quotaAssign.length == 0) {
                    onOrderQtyCollByMaterial = new ArrayList();
                    for (SupplierQtyInfo supplierQtyInfo : onOrderQtyColl) {
                        if (!material.equals(supplierQtyInfo.getMaterial())) continue;
                        onOrderQtyCollByMaterial.add(supplierQtyInfo);
                    }
                    forecastSumQtyAndOnOrderSumQty = SplitResultHelper.getForecastSumQtyAndOnOrderSumQty(entryRow, onOrderQtyCollByMaterial);
                    forecastSumQty = forecastSumQtyAndOnOrderSumQty.get("forecastSumQty");
                    onOrderSumQty = forecastSumQtyAndOnOrderSumQty.get("onOrderSumQty");
                    if (onOrderSumQty.compareTo(forecastSumQty) < 0) {
                        log.info("\u5f53\u524d\u7269\u6599\u7684\u5728\u9014\u8ba2\u5355\u4e0d\u6ee1\u8db3\u62c6\u5206\u6570\u91cf\u4e14\u65e0\u914d\u989d\u4e0d\u8fdb\u884c\u62c6\u5206\u3002");
                        return null;
                    }
                    splitQtyBySupplierInfo = SplitResultHelper.assignOnOrderQtyAndFinish(entryRow, quotaAssign, onOrderQtyCollByMaterial, material);
                    splitResultInfos = SplitResultInfo.splitResultIncludeSupplier(entryRow, splitQtyBySupplierInfo);
                    if (splitResultInfos == null) {
                        log.info("\u5f53\u524d\u7269\u6599\u672a\u627e\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u62c6\u5206\u3002");
                        return null;
                    }
                    arrayToList.addAll(splitResultInfos);
                } else {
                    if (quotaAssign.length == 0) {
                        log.info("\u5728\u9014\u8ba2\u5355\u548c\u914d\u989d\u90fd\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u62c6\u5206\u3002");
                        return null;
                    }
                    onOrderQtyCollByMaterial = new ArrayList<SupplierQtyInfo>();
                    if (onOrderQtyColl != null && !onOrderQtyColl.isEmpty()) {
                        for (SupplierQtyInfo supplierQtyInfo : onOrderQtyColl) {
                            if (!material.equals(supplierQtyInfo.getMaterial())) continue;
                            onOrderQtyCollByMaterial.add(supplierQtyInfo);
                        }
                    }
                    forecastSumQtyAndOnOrderSumQty = SplitResultHelper.getForecastSumQtyAndOnOrderSumQty(entryRow, onOrderQtyCollByMaterial);
                    forecastSumQty = forecastSumQtyAndOnOrderSumQty.get("forecastSumQty");
                    onOrderSumQty = forecastSumQtyAndOnOrderSumQty.get("onOrderSumQty");
                    if (onOrderSumQty.compareTo(forecastSumQty) >= 0) {
                        splitQtyBySupplierInfo = SplitResultHelper.assignOnOrderQtyAndFinish(entryRow, quotaAssign, onOrderQtyCollByMaterial, material);
                        splitResultInfos = SplitResultInfo.splitResultIncludeSupplier(entryRow, splitQtyBySupplierInfo);
                        if (splitResultInfos == null) {
                            log.info("\u5f53\u524d\u7269\u6599\u672a\u627e\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u62c6\u5206\u3002");
                            return null;
                        }
                        arrayToList.addAll(splitResultInfos);
                    } else {
                        Map<String, Date> quotaEffectDate = SplitResultHelper.getQuotaEffectDate(material, quotaAssign);
                        if (quotaEffectDate.isEmpty()) continue;
                        ArrayList<SupplierQtyInfo> effectPOQtyCollByMaterial = new ArrayList<SupplierQtyInfo>();
                        if (!effectPO.isEmpty()) {
                            for (SupplierQtyInfo supplierQtyInfo : effectPO) {
                                if (supplierQtyInfo == null || !material.equals(supplierQtyInfo.getMaterial()) || supplierQtyInfo.getCreateDate().after(quotaEffectDate.get("expirydate")) || supplierQtyInfo.getCreateDate().before(quotaEffectDate.get("effectdate"))) continue;
                                effectPOQtyCollByMaterial.add(supplierQtyInfo);
                            }
                        }
                        BigDecimal remainForeCastQty = forecastSumQty.subtract(onOrderSumQty);
                        SplitQtyBySupplierInfo splitQtyBySupplierInfo2 = SplitResultHelper.assignOnOrderQtyAndFinish(entryRow, quotaAssign, onOrderQtyCollByMaterial, material);
                        SplitResultHelper.assignRectifyQty(entryRow, splitQtyBySupplierInfo2, remainForeCastQty, sourceListColl, effectPOQtyCollByMaterial, material);
                        List<SplitResultInfo> splitResultInfos2 = SplitResultInfo.splitResultIncludeSupplier(entryRow, splitQtyBySupplierInfo2);
                        if (splitResultInfos2 != null) {
                            arrayToList.addAll(splitResultInfos2);
                        }
                    }
                }
                splitMrp.add(entryRow.getLong("mrp_entryid"));
            }
            catch (Exception e) {
                log.info("\u62c6\u5206\u5f02\u5e38\uff0c\u7269\u6599id=" + material, (Object)e);
                SplitResultHelper.logErrorResult(fid, material);
                return resultMap;
            }
        }
    }

    private static Map<Long, Long> getMaterial(Collection<DynamicObject> value, Long orgId) {
        String materialEntityName = "bd_materialpurchaseinfo";
        HashSet<Long> masterIdSet = new HashSet<Long>(16);
        for (DynamicObject entryRow : value) {
            long masterId = entryRow.getLong(MRP_MASTERID);
            if (masterId == 0L) continue;
            masterIdSet.add(masterId);
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)materialEntityName, (Long)orgId);
        if (qFilter == null) {
            return null;
        }
        qFilter.and("masterid", "in", masterIdSet);
        qFilter.and("status", "=", (Object)STATUS_AUDIT);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)materialEntityName, (String)"id,masterid,status,enable", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null) {
            return null;
        }
        return dynamicObjects.stream().collect(Collectors.toMap(obj -> obj.getLong("masterid"), obj -> obj.getLong("id"), (k1, k2) -> k1));
    }

    private static void logErrorResult(Object fid, Object materialId) {
        String errorInfo = String.format(ResManager.loadKDString((String)"\u62c6\u5206\u7269\u6599(\u7269\u6599ID=%s)\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8be5\u7269\u6599\u7684\u7269\u6599\u6e05\u5355\u3001\u914d\u989d\u5206\u914d\u3001\u914d\u989d\u65b9\u6848", (String)"SplitResultHelper_0", (String)"scmc-pm-forecast", (Object[])new Object[0]), materialId);
        String sql = "update t_pm_splitresult set fresulttext='" + errorInfo + "' where fid = '" + fid + "'";
        DB.update((DBRoute)DBRoute.of((String)"scm"), (String)sql);
    }

    private static Map<String, BigDecimal> getForecastSumQtyAndOnOrderSumQty(DynamicObject entryRow, List<SupplierQtyInfo> onOrderQtyCollByMaterial) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(2);
        BigDecimal forecastSumQty = BigDecimal.ZERO;
        BigDecimal onOrderSumQty = BigDecimal.ZERO;
        for (int i = 0; i < 103; ++i) {
            String number = SplitResultHelper.translateNumber(i);
            BigDecimal forecastQty = entryRow.getBigDecimal(number);
            forecastSumQty = forecastSumQty.add(forecastQty);
        }
        for (SupplierQtyInfo supplierQtyInfo : onOrderQtyCollByMaterial) {
            BigDecimal remainQty = supplierQtyInfo.getRemainQty();
            onOrderSumQty = onOrderSumQty.add(remainQty);
        }
        map.put("forecastSumQty", forecastSumQty);
        map.put("onOrderSumQty", onOrderSumQty);
        return map;
    }

    private static void batchExecute(long fid, List<SplitResultInfo> splitResult) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pm_splitresult");
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String sql = "select max(fseq) from t_pm_resultentry where fid=" + fid + ";";
        try (DataSet rows = DB.queryDataSet((String)SplitResultHelper.class.getName(), (DBRoute)dbRoute, (String)sql);){
            Object[] entity;
            int i;
            int seq = rows.next().getInteger(0);
            int size = splitResult.size();
            ArrayList<Object[]> values = new ArrayList<Object[]>(size);
            String invokeExeSql = ExecuteSql.invokeInsertEntrySql();
            ArrayList<Object[]> values_d = new ArrayList<Object[]>(size);
            String invokeExeSql_d = ExecuteSql.invokeInsertDaySql();
            ArrayList<Object[]> values_w = new ArrayList<Object[]>(size);
            String invokeExeSql_w = ExecuteSql.invokeInsertWeekSql();
            long[] resultEntryId = DB.genLongIds((String)"t_pm_resultentry", (int)size);
            for (i = 0; i < size; ++i) {
                entity = new Object[13];
                Object[] entity_d = new Object[30];
                SplitResultInfo splitEntryRow = splitResult.get(i);
                entity[0] = fid;
                entity_d[0] = fid;
                entity[1] = resultEntryId[i];
                entity_d[1] = resultEntryId[i];
                entity[2] = seq + i;
                entity[3] = splitEntryRow.getMrpid();
                entity[4] = splitEntryRow.getMaterial();
                entity[5] = splitEntryRow.getUnit();
                entity[6] = splitEntryRow.getSupplier();
                entity[7] = splitEntryRow.getMinPackage() == null ? BigDecimal.ONE : splitEntryRow.getMinPackage();
                entity[8] = splitEntryRow.getMinOrder() == null ? BigDecimal.ONE : splitEntryRow.getMinOrder();
                entity[9] = splitEntryRow.getType();
                entity[10] = splitEntryRow.getSubType();
                entity[11] = "B";
                entity[12] = "B";
                values.add(entity);
                BigDecimal[] array = splitEntryRow.getArray();
                for (int j = 0; j < 28; ++j) {
                    int temp = j + 2;
                    entity_d[temp] = array[j] == null ? BigDecimal.ZERO : array[j];
                }
                values_d.add(entity_d);
            }
            for (i = 0; i < size; ++i) {
                entity = new Object[77];
                SplitResultInfo splitEntryRow = splitResult.get(i);
                entity[0] = fid;
                entity[1] = resultEntryId[i];
                BigDecimal[] array = splitEntryRow.getArray();
                for (int j = 28; j < 103; ++j) {
                    entity[j - 26] = array[j] == null ? BigDecimal.ZERO : array[j];
                }
                values_w.add(entity);
            }
            DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql, values);
            DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql_d, values_d);
            DB.executeBatch((DBRoute)dbRoute, (String)invokeExeSql_w, values_w);
        }
    }

    private static DynamicObject[] queryQuotaColl(Long orgId, Map<Long, Long> materialMap, FilterBuilder splitConstraint) {
        String selectProperties = "org,material,quota";
        QFilter qFilter1 = new QFilter("org", "=", (Object)orgId);
        QFilter qFilter2 = new QFilter("material", "in", materialMap.values());
        ArrayList<QFilter> supplierFilterList = new ArrayList<QFilter>();
        supplierFilterList.add(qFilter1);
        supplierFilterList.add(qFilter2);
        ArrayList<QFilter> tempFilterList = new ArrayList<QFilter>();
        if (splitConstraint != null) {
            splitConstraint.getQFilters().forEach(filter -> {
                if ("supplier.name".equals(filter.getProperty())) {
                    if ("!=".equals(filter.getCP()) || "<>".equals(filter.getCP()) || "not in".equals(filter.getCP()) || "not like".equals(filter.getCP())) {
                        QFilter qFilter = new QFilter("quota.entryentity.subentryentity.supplier.name", "in", filter.getValue());
                        log.info("\u914d\u989d\u65b9\u6848\u6392\u9664 \u4f9b\u5e94\u5546ID\uff1a" + filter.getValue());
                        tempFilterList.add(qFilter);
                    }
                } else if ("supplier.number".equals(filter.getProperty()) && ("!=".equals(filter.getCP()) || "<>".equals(filter.getCP()) || "not in".equals(filter.getCP()) || "not like".equals(filter.getCP()))) {
                    QFilter qFilter = new QFilter("quota.entryentity.subentryentity.supplier.number", "in", filter.getValue());
                    log.info("\u914d\u989d\u65b9\u6848\u6392\u9664 \u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + filter.getValue());
                    tempFilterList.add(qFilter);
                }
            });
        }
        if (!tempFilterList.isEmpty()) {
            tempFilterList.addAll(supplierFilterList);
            DynamicObject[] exceptQuotaAssign = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)selectProperties, (QFilter[])tempFilterList.toArray(new QFilter[0]));
            ArrayList<Long> quotaAssignIdList = new ArrayList<Long>();
            if (exceptQuotaAssign != null) {
                for (DynamicObject quotaAssign : exceptQuotaAssign) {
                    long quotaAssignId;
                    if (quotaAssign == null || (quotaAssignId = quotaAssign.getLong("id")) == 0L) continue;
                    quotaAssignIdList.add(quotaAssignId);
                }
            }
            if (!quotaAssignIdList.isEmpty()) {
                QFilter filter2 = new QFilter("id", "not in", quotaAssignIdList);
                supplierFilterList.add(filter2);
            }
        }
        DynamicObject[] quotaAssign = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)selectProperties, (QFilter[])supplierFilterList.toArray(new QFilter[0]));
        ArrayList<DynamicObject> quotaAssignList = new ArrayList<DynamicObject>();
        if (quotaAssign != null && quotaAssign.length > 0) {
            for (DynamicObject dynamicObject : quotaAssign) {
                DynamicObject quota;
                if (dynamicObject == null || (quota = dynamicObject.getDynamicObject("quota")) == null) continue;
                String status = quota.getString("status");
                String enable = quota.getString("enable");
                if (!STATUS_AUDIT.equals(status) || !"1".equals(enable)) continue;
                quotaAssignList.add(dynamicObject);
            }
        }
        return quotaAssignList.toArray(new DynamicObject[0]);
    }

    private static Map<String, Date> getEffectDateUnion(DynamicObject[] quotaAssign) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (quotaAssign == null || quotaAssign.length == 0) {
            return map;
        }
        ArrayList<Date> effectList = new ArrayList<Date>();
        ArrayList<Date> expiryList = new ArrayList<Date>();
        for (DynamicObject baseData : quotaAssign) {
            DynamicObject quota;
            if (baseData == null || (quota = baseData.getDynamicObject("quota")) == null) continue;
            DynamicObjectCollection entryEntity = quota.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                if (entry == null) continue;
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (effectDate != null) {
                    effectList.add(effectDate);
                }
                if (expiryDate == null) continue;
                expiryList.add(expiryDate);
            }
        }
        Date min = (Date)Collections.min(effectList);
        Date max = (Date)Collections.max(expiryList);
        map.put("minDate", min);
        map.put("maxDate", max);
        return map;
    }

    private static Set<Long> getAllSupplierColl(DynamicObject[] quotaAssign) {
        HashSet<Long> supplierColl = new HashSet<Long>();
        if (quotaAssign == null || quotaAssign.length == 0) {
            return supplierColl;
        }
        for (DynamicObject baseData : quotaAssign) {
            DynamicObject quota;
            if (baseData == null || (quota = baseData.getDynamicObject("quota")) == null) continue;
            DynamicObjectCollection entryEntity = quota.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                if (entry == null) continue;
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (today.before(effectDate) || today.after(expiryDate)) continue;
                DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntryEntity) {
                    DynamicObject supplier;
                    if (subEntry == null || (supplier = subEntry.getDynamicObject("supplier")) == null) continue;
                    supplierColl.add((Long)supplier.getPkValue());
                }
            }
        }
        return supplierColl;
    }

    private static DynamicObject[] querySourceListColl(Long orgId, Map<Long, Long> materialMap, Set<Long> supplierColl) {
        String selectProperties = "org, number, supplier, entryentity.type, entryentity.material, entryentity.minbillbaseqty, entryentity.packagebatchqty";
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qFilter1 = new QFilter("entryentity.material", "in", materialMap.values());
        QFilter qFilter2 = new QFilter("supplier", "in", supplierColl);
        QFilter qFilter3 = new QFilter("entryentity.effectdate", "<=", (Object)today);
        QFilter qFilter4 = new QFilter("entryentity.expirydate", ">=", (Object)today);
        QFilter qFilter5 = new QFilter("status", "=", (Object)STATUS_AUDIT);
        QFilter qFilter6 = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter5, qFilter6});
    }

    private static FilterBuilder getNormalSplitConstraint(Long purOrg) {
        String selectProperties = "org,number,name,constrainttype,sourcebill,srcbillcontion,srcbillcontion_tag";
        QFilter qFilter1 = new QFilter("org", "in", (Object)purOrg);
        QFilter qFilter2 = new QFilter("constrainttype", "=", (Object)CONSTRAINTTYPE_FORECASTSPLIT);
        QFilter qFilter4 = new QFilter("status", "=", (Object)STATUS_AUDIT);
        DynamicObject splitConstraint = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_splitconstraint", (String)selectProperties, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter4});
        if (splitConstraint != null) {
            return SplitResultHelper.convertStringToQFilter(splitConstraint);
        }
        return null;
    }

    private static FilterBuilder convertStringToQFilter(DynamicObject splitConstraint) {
        String srcBillCondition = splitConstraint.getString("srcbillcontion_tag");
        if (srcBillCondition != null) {
            String srcType = splitConstraint.getDynamicObject("sourcebill").getString("number");
            if (StringUtils.isNotEmpty((String)srcBillCondition)) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)srcBillCondition, FilterCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
                fb.buildFilter();
                return fb;
            }
        }
        return null;
    }

    private static List<SupplierQtyInfo> queryOnOrderPO(FilterBuilder splitConstraint, Long purOrgId) {
        if (splitConstraint == null) {
            return null;
        }
        ArrayList<SupplierQtyInfo> onOrderQtyColl = new ArrayList<SupplierQtyInfo>();
        QFilter qFilter = splitConstraint.getQFilter();
        QFilter qFilter1 = new QFilter("org", "=", (Object)purOrgId);
        QFilter qFilter3 = new QFilter("closestatus", "=", (Object)CONSTRAINTTYPE_FORECASTSPLIT);
        QFilter qFilter5 = new QFilter("billentry.baseqty", ">", (Object)"billentry.receivebaseqty", true);
        QFilter qFilter6 = new QFilter("billentry.rowclosestatus", "=", (Object)CONSTRAINTTYPE_FORECASTSPLIT);
        QFilter qFilter7 = new QFilter("billentry.rowterminatestatus", "=", (Object)CONSTRAINTTYPE_FORECASTSPLIT);
        String selectFields = "id,billno,biztime,billstatus,org,supplier,createtime,billentry.material,billentry.promisedate,billentry.baseqty,billentry.receivebaseqty";
        String orderBys = "billentry.promisedate,createtime,supplier";
        DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter == null ? qFilter1 : qFilter, qFilter1, qFilter3, qFilter5, qFilter6, qFilter7}, (String)orderBys);
        if (purOrderBills != null) {
            for (DynamicObject purOrderBill : purOrderBills) {
                if (purOrderBill == null) continue;
                Long supplierId = purOrderBill.getLong("supplier");
                Long materialId = purOrderBill.getLong("billentry.material");
                Date createTime = purOrderBill.getDate("createtime");
                BigDecimal qty = purOrderBill.getBigDecimal("billentry.baseqty");
                BigDecimal receiveQty = purOrderBill.getBigDecimal("billentry.receivebaseqty");
                SupplierQtyInfo supplierQtyInfo = SupplierQtyInfo.acceptSupplierQtyInfo(supplierId, materialId, qty, receiveQty, createTime);
                onOrderQtyColl.add(supplierQtyInfo);
            }
        }
        return onOrderQtyColl;
    }

    private static List<SupplierQtyInfo> queryEffectPO(FilterBuilder splitConstraint, Long purOrgId, Set<Long> supplierColl, Map<String, Date> effectDateUnion) {
        List filterList;
        ArrayList<SupplierQtyInfo> effectPOQtyColl = new ArrayList<SupplierQtyInfo>();
        ArrayList<Object> spplierFilterList = new ArrayList<Object>();
        QFilter qFilter1 = new QFilter("org", "=", (Object)purOrgId);
        QFilter qFilter2 = new QFilter("supplier", "in", supplierColl);
        QFilter qFilter4 = new QFilter("createtime", ">=", (Object)effectDateUnion.get("minDate"));
        QFilter qFilter5 = new QFilter("createtime", "<=", (Object)effectDateUnion.get("maxDate"));
        spplierFilterList.add(qFilter1);
        spplierFilterList.add(qFilter2);
        spplierFilterList.add(qFilter4);
        spplierFilterList.add(qFilter5);
        if (splitConstraint != null && !(filterList = splitConstraint.getQFilters().stream().filter(f -> !"closestatus".equals(f.getProperty()) && !"billentry.rowclosestatus".equals(f.getProperty())).collect(Collectors.toList())).isEmpty()) {
            spplierFilterList.addAll(filterList);
        }
        String selectFields = "id,billno,biztime,billstatus,closestatus,createtime,org,supplier,billentry.material,billentry.promisedate,billentry.baseqty,billentry.receivebaseqty,billentry.rowclosestatus,billentry.rowterminatestatus";
        DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)selectFields, (QFilter[])spplierFilterList.toArray(new QFilter[0]));
        for (DynamicObject purOrderBill : purOrderBills) {
            BigDecimal receiveQty;
            BigDecimal qty;
            if (purOrderBill == null) continue;
            String closeStatus = purOrderBill.getString("closestatus");
            Long supplierId = purOrderBill.getLong("supplier");
            Long materialId = purOrderBill.getLong("billentry.material");
            Date createTime = purOrderBill.getDate("createtime");
            String rowCloseStatus = purOrderBill.getString("billentry.rowclosestatus");
            String rowTerminateStatus = purOrderBill.getString("billentry.rowterminatestatus");
            if (CONSTRAINTTYPE_FORECASTSPLIT.equals(closeStatus) && CONSTRAINTTYPE_FORECASTSPLIT.equals(rowCloseStatus) && CONSTRAINTTYPE_FORECASTSPLIT.equals(rowTerminateStatus)) {
                qty = purOrderBill.getBigDecimal("billentry.baseqty");
                receiveQty = purOrderBill.getBigDecimal("billentry.receivebaseqty");
            } else {
                qty = purOrderBill.getBigDecimal("billentry.receivebaseqty");
                receiveQty = BigDecimal.ZERO;
            }
            SupplierQtyInfo supplierQtyInfo = SupplierQtyInfo.acceptSupplierQtyInfo(supplierId, materialId, qty, receiveQty, createTime);
            effectPOQtyColl.add(supplierQtyInfo);
        }
        return effectPOQtyColl;
    }

    private static Map<String, Date> getQuotaEffectDate(Long materialId, DynamicObject[] quotaAssign) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (quotaAssign == null || quotaAssign.length == 0) {
            return map;
        }
        for (DynamicObject baseData : quotaAssign) {
            DynamicObject material;
            if (baseData == null || (material = baseData.getDynamicObject("material")) == null || materialId.compareTo((Long)material.getPkValue()) != 0) continue;
            DynamicObject quota = baseData.getDynamicObject("quota");
            DynamicObjectCollection entryEntity = quota.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                if (entry == null) continue;
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (today.before(effectDate) || today.after(expiryDate)) continue;
                map.put("effectdate", effectDate);
                map.put("expirydate", expiryDate);
            }
        }
        return map;
    }

    private static String translateNumber(int index) {
        StringBuilder number = new StringBuilder();
        if (index < 28) {
            int day = index + 1;
            return number.append(DAY).append(day).toString();
        }
        int week = index - 27;
        week = Math.min(week, 75);
        return number.append(WEEK).append(week).toString();
    }

    private static SplitQtyBySupplierInfo assignOnOrderQtyAndFinish(DynamicObject entryRow, DynamicObject[] quotaAssign, List<SupplierQtyInfo> onOrderQtyColl, Long material) {
        List<QuotaSupplierInfo> supplierByMaterial = SplitResultHelper.getSupplierByMaterial(quotaAssign, material);
        if (onOrderQtyColl.isEmpty()) {
            BigDecimal[][] arrayTemp = new BigDecimal[supplierByMaterial.size()][103];
            return SplitQtyBySupplierInfo.acceptSplitQtyBySupplierInfo(arrayTemp, supplierByMaterial, 0, BigDecimal.ZERO);
        }
        List<QuotaSupplierInfo> supplierByOnOrderPO = SplitResultHelper.getSupplierByOnOrderPO(onOrderQtyColl);
        SplitResultHelper.setSupplierOrigin(supplierByOnOrderPO, supplierByMaterial);
        List<QuotaSupplierInfo> onOrderSplitSupplierColl = SplitResultHelper.getOnOrderSplitSupplierColl(supplierByOnOrderPO, supplierByMaterial);
        BigDecimal[][] array = new BigDecimal[onOrderSplitSupplierColl.size()][103];
        int lineIndex = 0;
        int orderIndex = 0;
        BigDecimal leftOfLastDay = BigDecimal.ZERO;
        block0: while (lineIndex < 103 && orderIndex < onOrderQtyColl.size()) {
            BigDecimal sumQty = BigDecimal.ZERO;
            String number = SplitResultHelper.translateNumber(lineIndex);
            BigDecimal forecastQty = entryRow.getBigDecimal(number).subtract(leftOfLastDay);
            if (entryRow.getBigDecimal(number).compareTo(leftOfLastDay) < 0) {
                forecastQty = entryRow.getBigDecimal(number);
            }
            leftOfLastDay = BigDecimal.ZERO;
            BigDecimal lineSumQty = BigDecimal.ZERO;
            for (int i = 0; i < onOrderSplitSupplierColl.size(); ++i) {
                if (array[i][lineIndex] == null) continue;
                lineSumQty = lineSumQty.add(array[i][lineIndex]);
            }
            if (entryRow.getBigDecimal(number).compareTo(BigDecimal.ZERO) == 0 || lineSumQty.compareTo(entryRow.getBigDecimal(number)) == 0) {
                ++lineIndex;
                continue;
            }
            block2: for (int j = orderIndex; j < onOrderQtyColl.size(); ++j) {
                Integer row;
                SupplierQtyInfo supplierQtyInfo = onOrderQtyColl.get(j);
                Long supplierId = supplierQtyInfo.getSupplier();
                BigDecimal remainQty = supplierQtyInfo.getRemainQty();
                if ((sumQty = sumQty.add(remainQty)).compareTo(forecastQty) < 0) {
                    for (QuotaSupplierInfo quotaSupplierInfo : onOrderSplitSupplierColl) {
                        if (quotaSupplierInfo == null || quotaSupplierInfo.getSupplierId().compareTo(supplierId) != 0) continue;
                        row = quotaSupplierInfo.getRow();
                        array[row.intValue()][lineIndex] = array[row][lineIndex] == null || array[row][lineIndex].compareTo(BigDecimal.ZERO) == 0 ? remainQty : array[row][lineIndex].add(remainQty);
                        ++orderIndex;
                        continue block2;
                    }
                    continue;
                }
                if (sumQty.compareTo(forecastQty) == 0) {
                    for (QuotaSupplierInfo quotaSupplierInfo : onOrderSplitSupplierColl) {
                        if (quotaSupplierInfo == null || quotaSupplierInfo.getSupplierId().compareTo(supplierId) != 0) continue;
                        row = quotaSupplierInfo.getRow();
                        array[row.intValue()][lineIndex] = array[row][lineIndex] == null || array[row][lineIndex].compareTo(BigDecimal.ZERO) == 0 ? remainQty : array[row][lineIndex].add(remainQty);
                        ++orderIndex;
                        ++lineIndex;
                        sumQty = BigDecimal.ZERO;
                        continue block0;
                    }
                    continue block0;
                }
                if (sumQty.compareTo(forecastQty) <= 0) continue;
                BigDecimal surplusQty = sumQty.subtract(forecastQty);
                BigDecimal actualQty = remainQty.subtract(surplusQty);
                int row2 = 0;
                for (QuotaSupplierInfo quotaSupplierInfo : onOrderSplitSupplierColl) {
                    if (quotaSupplierInfo == null || quotaSupplierInfo.getSupplierId().compareTo(supplierId) != 0) continue;
                    row2 = quotaSupplierInfo.getRow();
                    if (array[row2][lineIndex] == null || array[row2][lineIndex].compareTo(BigDecimal.ZERO) == 0) {
                        array[row2][lineIndex] = actualQty;
                        continue;
                    }
                    array[row2][lineIndex] = actualQty.add(array[row2][lineIndex]);
                }
                forecastQty = entryRow.getBigDecimal(SplitResultHelper.translateNumber(++lineIndex));
                int temp_lindex = lineIndex;
                while (lineIndex <= 102 && surplusQty.compareTo(forecastQty) > 0) {
                    BigDecimal nextActualQty;
                    BigDecimal nextSurplusQty = surplusQty.subtract(forecastQty);
                    array[row2][lineIndex] = nextActualQty = surplusQty.subtract(nextSurplusQty);
                    surplusQty = nextSurplusQty;
                    if (++lineIndex > 102) continue;
                    forecastQty = entryRow.getBigDecimal(SplitResultHelper.translateNumber(++temp_lindex));
                }
                if (lineIndex > 102) continue block0;
                if (surplusQty.compareTo(forecastQty) < 0) {
                    leftOfLastDay = surplusQty;
                    array[row2][lineIndex] = surplusQty.add(array[row2][lineIndex] == null ? BigDecimal.ZERO : array[row2][lineIndex]);
                    ++orderIndex;
                    continue block0;
                }
                if (surplusQty.compareTo(forecastQty) != 0) continue;
                array[row2][lineIndex] = surplusQty;
                ++lineIndex;
                ++orderIndex;
                continue block0;
            }
        }
        BigDecimal lastValue = BigDecimal.ZERO;
        if (lineIndex < 103) {
            for (int i = 0; i < onOrderSplitSupplierColl.size(); ++i) {
                if (array[i][lineIndex] == null) continue;
                lastValue = lastValue.add(array[i][lineIndex]);
            }
        }
        return SplitQtyBySupplierInfo.acceptSplitQtyBySupplierInfo(array, onOrderSplitSupplierColl, lineIndex, lastValue);
    }

    private static void assignRectifyQty(DynamicObject entryRow, SplitQtyBySupplierInfo splitQtyBySupplierInfo, BigDecimal remainForeCastQty, DynamicObject[] sourceListColl, List<SupplierQtyInfo> effectPO, Long material) {
        BigDecimal[][] array = splitQtyBySupplierInfo.getSplitQty();
        List<QuotaSupplierInfo> onOrderSupplierColl = splitQtyBySupplierInfo.getSupplierColl();
        ArrayList<QuotaSupplierInfo> supplierColl = new ArrayList<QuotaSupplierInfo>();
        for (QuotaSupplierInfo quotaSupplierInfo : onOrderSupplierColl) {
            String supplierOrigin;
            if (quotaSupplierInfo == null || (supplierOrigin = quotaSupplierInfo.getSupplierOrigin().getValue()) == null || !supplierOrigin.equals(SupplierOrigin.ONORDER_QUOTA.getValue()) && !supplierOrigin.equals(SupplierOrigin.QUOTA.getValue())) continue;
            supplierColl.add(quotaSupplierInfo);
        }
        Map<String, BigDecimal> minAndMax_minBillQty = SplitResultHelper.getMinBillQtyBySourceList(sourceListColl, supplierColl, material);
        BigDecimal max_minBillQty = minAndMax_minBillQty.get("max");
        BigDecimal min_minBillQty = minAndMax_minBillQty.get("min");
        if (remainForeCastQty.compareTo(max_minBillQty) < 0) {
            List<QuotaSupplierInfo> minBillQtyColl = supplierColl.stream().filter(q -> min_minBillQty.compareTo(q.getMinBillQty() == null ? BigDecimal.ONE : q.getMinBillQty()) == 0).collect(Collectors.toList());
            if (minBillQtyColl.size() == 1) {
                array = SplitResultHelper.qtyLessMinBillQtyToArray(entryRow, splitQtyBySupplierInfo, (QuotaSupplierInfo)minBillQtyColl.get(0));
            } else if (!minBillQtyColl.isEmpty()) {
                BigDecimal maxDeviationQty = SplitResultHelper.calculateHistoryDeviation(effectPO, minBillQtyColl);
                List maxDeviationQtyColl = minBillQtyColl.stream().filter(m -> maxDeviationQty.compareTo(m.getDeviationQty() == null ? BigDecimal.ZERO : m.getDeviationQty()) == 0).collect(Collectors.toList());
                if (!maxDeviationQtyColl.isEmpty()) {
                    array = SplitResultHelper.qtyLessMinBillQtyToArray(entryRow, splitQtyBySupplierInfo, (QuotaSupplierInfo)maxDeviationQtyColl.get(0));
                    array = SplitResultHelper.roundingArray(array);
                }
            }
        } else {
            SplitResultHelper.calculateHistoryDeviation(effectPO, supplierColl);
            SplitResultHelper.assignQtyByDeviationQty(entryRow, splitQtyBySupplierInfo, supplierColl);
            SplitResultHelper.roundingArray(array);
        }
    }

    private static List<QuotaSupplierInfo> getSupplierByMaterial(DynamicObject[] quotaAssign, Long materialId) {
        ArrayList<QuotaSupplierInfo> list = new ArrayList<QuotaSupplierInfo>();
        if (quotaAssign == null || quotaAssign.length == 0) {
            return list;
        }
        for (DynamicObject baseData : quotaAssign) {
            DynamicObjectCollection entryEntity;
            DynamicObject quota;
            DynamicObject material;
            if (baseData == null || (material = baseData.getDynamicObject("material")) == null || materialId.compareTo((Long)material.getPkValue()) != 0 || (quota = baseData.getDynamicObject("quota")) == null || (entryEntity = quota.getDynamicObjectCollection("entryentity")) == null) continue;
            for (DynamicObject entry : entryEntity) {
                DynamicObjectCollection subEntryEntity;
                if (entry == null) continue;
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (today.before(effectDate) || today.after(expiryDate) || (subEntryEntity = entry.getDynamicObjectCollection("subentryentity")) == null) continue;
                for (int i = 0; i < subEntryEntity.size(); ++i) {
                    DynamicObject subEntry = (DynamicObject)subEntryEntity.get(i);
                    if (subEntry == null) continue;
                    DynamicObject supplier = subEntry.getDynamicObject("supplier");
                    BigDecimal quotaRate = subEntry.getBigDecimal("quotarate");
                    QuotaSupplierInfo quotaSupplierInfo = QuotaSupplierInfo.acceptSupplierByQuota((Long)supplier.getPkValue(), quotaRate, i);
                    SupplierOrigin quotaSupplierOrigin = SupplierOrigin.QUOTA;
                    quotaSupplierInfo.setSupplierOrigin(quotaSupplierOrigin);
                    list.add(quotaSupplierInfo);
                }
            }
        }
        return list;
    }

    private static List<QuotaSupplierInfo> getSupplierByOnOrderPO(List<SupplierQtyInfo> onOrderQtyColl) {
        LinkedHashSet<Long> supplierIdColl = new LinkedHashSet<Long>();
        ArrayList<QuotaSupplierInfo> list = new ArrayList<QuotaSupplierInfo>();
        for (SupplierQtyInfo onOrder : onOrderQtyColl) {
            if (onOrder == null) continue;
            Long supplierId = onOrder.getSupplier();
            supplierIdColl.add(supplierId);
        }
        if (!supplierIdColl.isEmpty()) {
            for (Long supplierId : supplierIdColl) {
                QuotaSupplierInfo quotaSupplierInfo = new QuotaSupplierInfo();
                quotaSupplierInfo.setSupplierId(supplierId);
                SupplierOrigin onOrderSupplierOrigin = SupplierOrigin.ONORDER;
                quotaSupplierInfo.setSupplierOrigin(onOrderSupplierOrigin);
                quotaSupplierInfo.setMinBillQty(BigDecimal.ONE);
                quotaSupplierInfo.setPackageBatchQty(BigDecimal.ONE);
                list.add(quotaSupplierInfo);
            }
            return list;
        }
        return null;
    }

    private static void setSupplierOrigin(List<QuotaSupplierInfo> supplierByOnOrderPO, List<QuotaSupplierInfo> supplierByMaterial) {
        if (supplierByMaterial.isEmpty()) {
            return;
        }
        for (QuotaSupplierInfo orderSupplierInfo : supplierByOnOrderPO) {
            if (orderSupplierInfo == null) continue;
            Long orderSupplierId = orderSupplierInfo.getSupplierId();
            for (QuotaSupplierInfo quotaSupplierInfo : supplierByMaterial) {
                if (quotaSupplierInfo == null || quotaSupplierInfo.getSupplierId().compareTo(orderSupplierId) != 0) continue;
                SupplierOrigin onOrderAndQuota = SupplierOrigin.ONORDER_QUOTA;
                quotaSupplierInfo.setSupplierOrigin(onOrderAndQuota);
            }
        }
    }

    private static List<QuotaSupplierInfo> getOnOrderSplitSupplierColl(List<QuotaSupplierInfo> supplierByOnOrderPO, List<QuotaSupplierInfo> supplierByMaterial) {
        if (supplierByMaterial.isEmpty()) {
            for (int i = 0; i < supplierByOnOrderPO.size(); ++i) {
                QuotaSupplierInfo quotaSupplierInfo = supplierByOnOrderPO.get(i);
                quotaSupplierInfo.setRow(i);
            }
            return supplierByOnOrderPO;
        }
        Integer lastRow = supplierByMaterial.get(supplierByMaterial.size() - 1).getRow();
        ArrayList<QuotaSupplierInfo> supplierInfoColl = new ArrayList<QuotaSupplierInfo>(supplierByMaterial);
        for (QuotaSupplierInfo orderSupplierInfo : supplierByOnOrderPO) {
            if (orderSupplierInfo == null) continue;
            Long orderSupplierId = orderSupplierInfo.getSupplierId();
            for (int i = 0; i < supplierByMaterial.size() && supplierByMaterial.get(i).getSupplierId().compareTo(orderSupplierId) != 0; ++i) {
                if (i != supplierByMaterial.size() - 1 || supplierByMaterial.get(i).getSupplierId().compareTo(orderSupplierId) == 0) continue;
                lastRow = lastRow + 1;
                orderSupplierInfo.setRow(lastRow);
                supplierInfoColl.add(orderSupplierInfo);
            }
        }
        return supplierInfoColl;
    }

    private static Map<String, BigDecimal> getMinBillQtyBySourceList(DynamicObject[] sourceListColl, List<QuotaSupplierInfo> supplierColl, Long material) {
        BigDecimal maxQty = BigDecimal.ONE;
        BigDecimal minQty = BigDecimal.ONE;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int i = 0; i < supplierColl.size(); ++i) {
            QuotaSupplierInfo quotaSupplierInfo = supplierColl.get(i);
            if (quotaSupplierInfo == null) continue;
            Long supplierId = quotaSupplierInfo.getSupplierId();
            for (DynamicObject sourceList : sourceListColl) {
                DynamicObjectCollection entryEntity;
                if (sourceList == null || supplierId == null || supplierId.compareTo((Long)sourceList.getDynamicObject("supplier").getPkValue()) != 0 || (entryEntity = sourceList.getDynamicObjectCollection("entryentity")) == null) continue;
                for (DynamicObject entryRow : entryEntity) {
                    DynamicObject entryMaterial;
                    String type;
                    if (entryRow == null || !CONSTRAINTTYPE_FORECASTSPLIT.equals(type = entryRow.getString("type")) || (entryMaterial = entryRow.getDynamicObject("material")) == null || ((Long)entryMaterial.getPkValue()).compareTo(material) != 0) continue;
                    BigDecimal minBillQty = entryRow.getBigDecimal("minbillbaseqty");
                    if (minBillQty == null) {
                        minBillQty = BigDecimal.ONE;
                    }
                    BigDecimal packageBatchQty = entryRow.getBigDecimal("packagebatchqty");
                    quotaSupplierInfo.setMinBillQty(minBillQty);
                    quotaSupplierInfo.setPackageBatchQty(packageBatchQty);
                    if (i == 0) {
                        maxQty = quotaSupplierInfo.getMinBillQty();
                        minQty = quotaSupplierInfo.getMinBillQty();
                        continue;
                    }
                    BigDecimal temp = quotaSupplierInfo.getMinBillQty();
                    if (maxQty.compareTo(temp) < 0) {
                        maxQty = temp;
                    }
                    if (minQty.compareTo(temp) <= 0) continue;
                    minQty = temp;
                }
            }
        }
        map.put("max", maxQty);
        map.put("min", minQty);
        return map;
    }

    private static BigDecimal[][] qtyLessMinBillQtyToArray(DynamicObject entryRow, SplitQtyBySupplierInfo splitQtyBySupplierInfo, QuotaSupplierInfo minBillQtySupplier) {
        int index = splitQtyBySupplierInfo.getIndex();
        BigDecimal[][] array = splitQtyBySupplierInfo.getSplitQty();
        BigDecimal lastValue = splitQtyBySupplierInfo.getLastValue();
        Integer rowIndex = minBillQtySupplier.getRow();
        String number = SplitResultHelper.translateNumber(index);
        BigDecimal forecastQty = entryRow.getBigDecimal(number);
        BigDecimal remainQty = forecastQty.subtract(lastValue);
        array[rowIndex.intValue()][index] = array[rowIndex][index] == null ? remainQty : array[rowIndex][index].add(remainQty);
        for (int i = index + 1; i < 103; ++i) {
            BigDecimal dayForecastQty;
            String translateNum = SplitResultHelper.translateNumber(i);
            array[rowIndex.intValue()][i] = dayForecastQty = entryRow.getBigDecimal(translateNum);
        }
        return array;
    }

    private static BigDecimal calculateHistoryDeviation(List<SupplierQtyInfo> effectPO, List<QuotaSupplierInfo> minBillQtyColl) {
        for (QuotaSupplierInfo quotaSupplierInfo : minBillQtyColl) {
            if (quotaSupplierInfo == null) continue;
            Long supplierId = quotaSupplierInfo.getSupplierId();
            ArrayList<SupplierQtyInfo> list = new ArrayList<SupplierQtyInfo>();
            for (SupplierQtyInfo supplierQtyInfo : effectPO) {
                Long supplier;
                if (supplierQtyInfo == null || (supplier = supplierQtyInfo.getSupplier()).compareTo(supplierId) != 0) continue;
                list.add(supplierQtyInfo);
            }
            BigDecimal sumQty = list.stream().map(SupplierQtyInfo::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            quotaSupplierInfo.setEffectPOQty(sumQty);
            if (quotaSupplierInfo.getQuotaRate() == null) continue;
            if (BigDecimal.ZERO.compareTo(quotaSupplierInfo.getQuotaRate()) == 0) {
                quotaSupplierInfo.setPositiveDeviationQty(BigDecimal.ZERO);
                continue;
            }
            BigDecimal positiveDeviationQty = sumQty.movePointRight(2).divide(quotaSupplierInfo.getQuotaRate(), 2, RoundingMode.HALF_UP);
            quotaSupplierInfo.setPositiveDeviationQty(positiveDeviationQty);
        }
        QuotaSupplierInfo maxPositiveDeviation = minBillQtyColl.stream().max(Comparator.comparing(QuotaSupplierInfo::getPositiveDeviationQty)).get();
        BigDecimal positiveDeviationQty = maxPositiveDeviation.getPositiveDeviationQty();
        BigDecimal maxDeviationQty = BigDecimal.ZERO;
        for (QuotaSupplierInfo quotaSupplierInfo : minBillQtyColl) {
            if (quotaSupplierInfo == null) continue;
            BigDecimal theoryAssignQty = positiveDeviationQty.multiply(quotaSupplierInfo.getQuotaRate().movePointLeft(2));
            BigDecimal effectPOQty = quotaSupplierInfo.getEffectPOQty();
            BigDecimal deviationQty = theoryAssignQty.subtract(effectPOQty);
            quotaSupplierInfo.setTheoryAssignQty(theoryAssignQty);
            quotaSupplierInfo.setDeviationQty(deviationQty);
            if (quotaSupplierInfo == minBillQtyColl.get(0)) {
                maxDeviationQty = deviationQty;
                continue;
            }
            if (maxDeviationQty.compareTo(deviationQty) >= 0) continue;
            maxDeviationQty = deviationQty;
        }
        return maxDeviationQty;
    }

    private static BigDecimal[][] roundingArray(BigDecimal[][] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        int supplierNum = data.length;
        int dataSize = data[0].length;
        if (dataSize == 0) {
            return data;
        }
        int scale = 0;
        block0: for (int i = 0; i < supplierNum; ++i) {
            int j;
            BigDecimal offset = BigDecimal.ZERO;
            for (j = 0; j < dataSize; ++j) {
                BigDecimal origin = data[i][j];
                if (origin == null) {
                    data[i][j] = BigDecimal.ZERO;
                    continue;
                }
                BigDecimal target = origin.setScale(scale, RoundingMode.UP);
                offset = offset.add(target.subtract(origin));
                data[i][j] = target;
            }
            if (BigDecimal.ZERO.compareTo(offset) == 0) continue;
            for (j = dataSize - 1; j >= 0; --j) {
                BigDecimal target = data[i][j].setScale(scale, RoundingMode.UP);
                if (offset.compareTo(target) <= 0) {
                    data[i][j] = target.subtract(offset).setScale(scale, RoundingMode.UP);
                    continue block0;
                }
                offset = offset.subtract(target);
                data[i][j] = BigDecimal.ZERO;
            }
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private static void assignQtyByDeviationQty(DynamicObject entryRow, SplitQtyBySupplierInfo splitQtyBySupplierInfo, List<QuotaSupplierInfo> quotaSupplierColl) {
        block36: {
            BigDecimal remainQty;
            BigDecimal sumDeviationQty;
            BigDecimal[][] array;
            int index;
            block35: {
                void var15_38;
                BigDecimal assignQtyByDeviationRate;
                index = splitQtyBySupplierInfo.getIndex();
                array = splitQtyBySupplierInfo.getSplitQty();
                BigDecimal lastValue = splitQtyBySupplierInfo.getLastValue();
                if (lastValue == null) {
                    lastValue = BigDecimal.ZERO;
                }
                if ((sumDeviationQty = quotaSupplierColl.stream().map(QuotaSupplierInfo::getDeviationQty).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) == 0) {
                    for (int i = index; i < 103; ++i) {
                        String translateNum = SplitResultHelper.translateNumber(i);
                        BigDecimal dayForecastQty = entryRow.getBigDecimal(translateNum);
                        if (lastValue.compareTo(BigDecimal.ZERO) > 0) {
                            dayForecastQty = dayForecastQty.subtract(lastValue);
                            lastValue = BigDecimal.ZERO;
                        }
                        for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                            if (quotaSupplierInfo == null) continue;
                            BigDecimal assignQtyByQuotaRate = dayForecastQty.multiply(quotaSupplierInfo.getQuotaRate().multiply(BigDecimal.valueOf(0.01)));
                            array[quotaSupplierInfo.getRow().intValue()][i] = assignQtyByQuotaRate.add(array[quotaSupplierInfo.getRow()][i] == null ? BigDecimal.ZERO : array[quotaSupplierInfo.getRow()][i]);
                        }
                    }
                    return;
                }
                BigDecimal sumDeviationQtyRate = BigDecimal.ZERO;
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    BigDecimal deviationQtyRate;
                    if (quotaSupplierInfo == quotaSupplierColl.get(quotaSupplierColl.size() - 1)) {
                        deviationQtyRate = BigDecimal.ONE.subtract(sumDeviationQtyRate);
                        quotaSupplierInfo.setDeviationQtyRate(deviationQtyRate);
                        continue;
                    }
                    deviationQtyRate = quotaSupplierInfo.getDeviationQty().divide(sumDeviationQty, 4, RoundingMode.HALF_UP);
                    quotaSupplierInfo.setDeviationQtyRate(deviationQtyRate);
                    sumDeviationQtyRate = sumDeviationQtyRate.add(deviationQtyRate);
                }
                String number = SplitResultHelper.translateNumber(index);
                BigDecimal forecastQty = entryRow.getBigDecimal(number);
                if (forecastQty == null) {
                    forecastQty = BigDecimal.ZERO;
                }
                if ((remainQty = forecastQty.subtract(lastValue)).compareTo(sumDeviationQty) >= 0) break block35;
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    if (quotaSupplierInfo == null) continue;
                    BigDecimal assignQtyByDeviationRate2 = remainQty.multiply(quotaSupplierInfo.getDeviationQtyRate());
                    if (array[quotaSupplierInfo.getRow()][index] == null || array[quotaSupplierInfo.getRow()][index].compareTo(BigDecimal.ZERO) == 0) {
                        array[quotaSupplierInfo.getRow().intValue()][index] = assignQtyByDeviationRate2;
                        continue;
                    }
                    array[quotaSupplierInfo.getRow().intValue()][index] = array[quotaSupplierInfo.getRow()][index].add(assignQtyByDeviationRate2);
                }
                BigDecimal lastDeviationQty = sumDeviationQty.subtract(remainQty);
                String nextNumber = SplitResultHelper.translateNumber(++index);
                BigDecimal nextForecastQty = entryRow.getBigDecimal(nextNumber);
                while (index < 103 && lastDeviationQty.compareTo(nextForecastQty) >= 0) {
                    int tmp_index;
                    for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                        if (quotaSupplierInfo == null) continue;
                        assignQtyByDeviationRate = nextForecastQty.multiply(quotaSupplierInfo.getDeviationQtyRate());
                        if (array[quotaSupplierInfo.getRow()][index] == null || array[quotaSupplierInfo.getRow()][index].compareTo(BigDecimal.ZERO) == 0) {
                            array[quotaSupplierInfo.getRow().intValue()][index] = assignQtyByDeviationRate;
                            continue;
                        }
                        array[quotaSupplierInfo.getRow().intValue()][index] = array[quotaSupplierInfo.getRow()][index].add(assignQtyByDeviationRate);
                    }
                    lastDeviationQty = lastDeviationQty.subtract(nextForecastQty);
                    if ((tmp_index = ++index) >= 103) continue;
                    nextForecastQty = entryRow.getBigDecimal(SplitResultHelper.translateNumber(tmp_index));
                }
                if (index >= 103) break block36;
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    if (quotaSupplierInfo == null) continue;
                    assignQtyByDeviationRate = lastDeviationQty.multiply(quotaSupplierInfo.getDeviationQtyRate());
                    if (array[quotaSupplierInfo.getRow()][index] == null || array[quotaSupplierInfo.getRow()][index].compareTo(BigDecimal.ZERO) == 0) {
                        array[quotaSupplierInfo.getRow().intValue()][index] = assignQtyByDeviationRate;
                        continue;
                    }
                    array[quotaSupplierInfo.getRow().intValue()][index] = array[quotaSupplierInfo.getRow()][index].add(assignQtyByDeviationRate);
                }
                BigDecimal lastRemainQty = BigDecimal.ZERO;
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    if (quotaSupplierInfo == null || array[quotaSupplierInfo.getRow()][index] == null) continue;
                    lastRemainQty = lastRemainQty.add(array[quotaSupplierInfo.getRow()][index]);
                }
                int n = index;
                while (var15_38 < 103) {
                    BigDecimal dayForecastQty;
                    if (var15_38 == index) {
                        dayForecastQty = nextForecastQty.compareTo(BigDecimal.ZERO) > 0 && lastRemainQty.compareTo(BigDecimal.ZERO) > 0 ? nextForecastQty.subtract(lastRemainQty) : lastRemainQty;
                    } else {
                        String translateNum = SplitResultHelper.translateNumber((int)var15_38);
                        dayForecastQty = entryRow.getBigDecimal(translateNum);
                    }
                    for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                        if (quotaSupplierInfo == null) continue;
                        BigDecimal assignQtyByQuotaRate = dayForecastQty.multiply(quotaSupplierInfo.getQuotaRate().multiply(BigDecimal.valueOf(0.01)));
                        if (var15_38 > index) {
                            array[quotaSupplierInfo.getRow().intValue()][var15_38] = assignQtyByQuotaRate;
                            continue;
                        }
                        array[quotaSupplierInfo.getRow().intValue()][var15_38] = array[quotaSupplierInfo.getRow()][var15_38].add(assignQtyByQuotaRate);
                    }
                    ++var15_38;
                }
                break block36;
            }
            if (remainQty.compareTo(sumDeviationQty) == 0) {
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    if (quotaSupplierInfo == null) continue;
                    BigDecimal assignQtyByDeviationRate = remainQty.multiply(quotaSupplierInfo.getDeviationQtyRate());
                    if (array[quotaSupplierInfo.getRow()][index] == null || array[quotaSupplierInfo.getRow()][index].compareTo(BigDecimal.ZERO) == 0) {
                        array[quotaSupplierInfo.getRow().intValue()][index] = assignQtyByDeviationRate;
                        continue;
                    }
                    array[quotaSupplierInfo.getRow().intValue()][index] = array[quotaSupplierInfo.getRow()][index].add(assignQtyByDeviationRate);
                }
                for (int i = index + 1; i < 103; ++i) {
                    String translateNum = SplitResultHelper.translateNumber(i);
                    BigDecimal dayForecastQty = entryRow.getBigDecimal(translateNum);
                    for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                        BigDecimal assignQtyByQuotaRate;
                        if (quotaSupplierInfo == null) continue;
                        array[quotaSupplierInfo.getRow().intValue()][i] = assignQtyByQuotaRate = dayForecastQty.multiply(quotaSupplierInfo.getQuotaRate().multiply(BigDecimal.valueOf(0.01)));
                    }
                }
            } else if (remainQty.compareTo(sumDeviationQty) > 0) {
                for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                    if (quotaSupplierInfo == null) continue;
                    BigDecimal assignQtyByDeviationQty = quotaSupplierInfo.getDeviationQty();
                    if (array[quotaSupplierInfo.getRow()][index] == null || array[quotaSupplierInfo.getRow()][index].compareTo(BigDecimal.ZERO) == 0) {
                        array[quotaSupplierInfo.getRow().intValue()][index] = assignQtyByDeviationQty;
                        continue;
                    }
                    array[quotaSupplierInfo.getRow().intValue()][index] = array[quotaSupplierInfo.getRow()][index].add(assignQtyByDeviationQty);
                }
                BigDecimal lastRemainQty = remainQty.subtract(sumDeviationQty);
                for (int i = index; i < 103; ++i) {
                    BigDecimal dayForecastQty;
                    if (i == index) {
                        dayForecastQty = lastRemainQty;
                    } else {
                        String translateNum = SplitResultHelper.translateNumber(i);
                        dayForecastQty = entryRow.getBigDecimal(translateNum);
                    }
                    for (QuotaSupplierInfo quotaSupplierInfo : quotaSupplierColl) {
                        if (quotaSupplierInfo == null) continue;
                        BigDecimal assignQtyByQuotaRate = dayForecastQty.multiply(quotaSupplierInfo.getQuotaRate().multiply(BigDecimal.valueOf(0.01)));
                        if (i > index) {
                            array[quotaSupplierInfo.getRow().intValue()][i] = assignQtyByQuotaRate;
                            continue;
                        }
                        array[quotaSupplierInfo.getRow().intValue()][i] = array[quotaSupplierInfo.getRow()][i].add(assignQtyByQuotaRate);
                    }
                }
            }
        }
    }
}

