/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.business.helper;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.forecast.business.helper.DateHelper;
import kd.scmc.pm.forecast.business.pojo.GAPReportEntity;
import kd.scmc.pm.forecast.business.pojo.SplitResultDateInfo;

public class SupplyDemandHelper {
    private static final Log log = LogFactory.getLog(SupplyDemandHelper.class);

    public static String getStartDate(String planCalcNum) {
        String startDate;
        QFilter filter = new QFilter("plancalcnum", "=", (Object)planCalcNum);
        DynamicObject[] splitResults = BusinessDataServiceHelper.load((String)"pm_splitresult", (String)"startdate", (QFilter[])new QFilter[]{filter});
        if (splitResults != null && splitResults.length > 0 && (startDate = splitResults[0].getString("startdate")) != null) {
            String datePattern = "yyyy-MM-dd";
            return DateHelper.getDateString(DateHelper.getDateByString(startDate, datePattern), datePattern);
        }
        return null;
    }

    public static String invokeExeSql_day() {
        Class<SplitResultDateInfo> updateFields = SplitResultDateInfo.class;
        Field[] dtoFields = updateFields.getDeclaredFields();
        StringJoiner joiner = new StringJoiner(",", "update t_pm_resultentry_d set ", " where fentryid = ?");
        for (int i = 0; i < 28; ++i) {
            Field field = dtoFields[i];
            String fieldName = field.getName();
            joiner.add("f".concat(fieldName).concat("=?"));
        }
        return joiner.toString();
    }

    public static String invokeExeSql_week() {
        Class<SplitResultDateInfo> updateFields = SplitResultDateInfo.class;
        Field[] dtoFields = updateFields.getDeclaredFields();
        StringBuilder str = new StringBuilder("update t_pm_resultentry_w set ");
        for (int i = 28; i < 103; ++i) {
            Field field = dtoFields[i];
            String fieldName = field.getName();
            if (i == dtoFields.length - 1) {
                str.append("f".concat(fieldName).concat("=?"));
                continue;
            }
            str.append("f".concat(fieldName).concat("=?,"));
        }
        str.append(" where fentryid = ?");
        String exeSql = str.toString();
        str.setLength(0);
        return exeSql;
    }

    public static String invokeBuyerStatusSql() {
        return "update t_pm_resultentry set foperatestatus = 'A', foperatedate = now() where fentryid = ? ";
    }

    public static Map<String, BigDecimal> invokeDynamicEntry(DynamicObject dto, List<String> fieldsList) {
        int i;
        LinkedHashMap<String, BigDecimal> dateQtyMap = new LinkedHashMap<String, BigDecimal>(128);
        List<String> dayList = fieldsList.subList(0, 28);
        List<String> weekList = fieldsList.subList(28, 103);
        BigDecimal weekSum = new BigDecimal(0);
        LinkedHashMap<String, BigDecimal> weekSumMap = new LinkedHashMap<String, BigDecimal>();
        for (i = 0; i < dayList.size(); ++i) {
            int index = 1 + i;
            String ival = String.valueOf(index);
            BigDecimal qty = dto.getBigDecimal("day".concat(ival));
            dateQtyMap.put("day".concat(ival), qty);
            if (i > 0 && index % 7 == 0) {
                weekSum = weekSum.add(qty);
                weekSumMap.put("countweek" + index / 7, weekSum);
                weekSum = BigDecimal.ZERO;
                continue;
            }
            weekSum = weekSum.add(qty);
        }
        dateQtyMap.putAll(weekSumMap);
        for (i = 0; i < weekList.size(); ++i) {
            String weekKey = "week" + (i + 1);
            BigDecimal qty = dto.getBigDecimal(weekKey);
            dateQtyMap.put(weekKey, qty);
        }
        return dateQtyMap;
    }

    public static List<String> invokeDynamicDate(String startDate) {
        LocalDate plusDays;
        int i;
        ArrayList<String> dto = new ArrayList<String>(107);
        LocalDate firstDayOfMonth = LocalDate.parse(startDate);
        DateTimeFormatter formatterDay = DateTimeFormatter.ofPattern("MM-dd");
        DateTimeFormatter formatterWeek = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (i = 0; i < 28; ++i) {
            plusDays = firstDayOfMonth.plusDays(i);
            String day = formatterDay.format(plusDays);
            dto.add(day);
        }
        for (i = 1; i <= 4; ++i) {
            plusDays = firstDayOfMonth.plusDays(i * 7 - 7);
            String week = formatterWeek.format(plusDays);
            dto.add(week);
        }
        LocalDate lastDay = firstDayOfMonth.plusDays(28L);
        for (int i2 = 0; i2 < 75; ++i2) {
            LocalDate plusDays2 = lastDay.plusDays(i2 * 7);
            String week = formatterWeek.format(plusDays2);
            dto.add(week);
        }
        return dto;
    }

    public static InputStream obtainInputStream(AttachmentPanel attachmentPanel, IPageCache iPageCache) {
        List attachmentDataList = attachmentPanel.getAttachmentData();
        Map attachmentData = (Map)attachmentDataList.get(0);
        String fileUrl = (String)attachmentData.get("url");
        iPageCache.put("key_excel", fileUrl);
        Map<String, String> parseUrl = SupplyDemandHelper.parseUrl(fileUrl);
        TempFileCacheDownloadable downLoadCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoadCache.get(parseUrl.get("configKey"), parseUrl.get("id"));
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (tempFileCache.exists(fileUrl)) {
            tempFileCache.remove(fileUrl);
        }
        return content.getInputStream();
    }

    private static Map<String, String> parseUrl(String url) {
        String[] pairStr = url.split("\\?");
        String[] pairs = pairStr[1].split("&");
        HashMap<String, String> result = new HashMap<String, String>(32);
        int index0 = 0;
        int index1 = 1;
        for (String pair : pairs) {
            String[] p = pair.split("=");
            result.put(p[index0], p[index1]);
        }
        return result;
    }

    public static Set<String> obtainLockFields() {
        LinkedHashSet<String> dto = new LinkedHashSet<String>();
        Collections.addAll(dto, "prodorg", "plancalcnumber", "purorg", "material", "baseunit");
        Collections.addAll(dto, "supplier", "minpackageqty", "minorderbaseqty", "replydate", "operatedate");
        Collections.addAll(dto, "type", "subtype", "billno", "replystatus", "operatestatus", "splitdate", "issuppcolla");
        Collections.addAll(dto, "countweek1", "countweek2", "countweek3", "countweek4");
        return dto;
    }

    public static <T> void setValue(T dto, Field field, Object value) {
        try {
            field.set(dto, value);
        }
        catch (IllegalAccessException ignored) {
            log.info("\u5f02\u5e38 ", (Object)ignored);
        }
    }

    public static Object getValue(GAPReportEntity dto, String filedName) {
        try {
            Field field = dto.getClass().getDeclaredField(filedName);
            return field.get(dto);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, String> obtainFields(Set<String> dateSet) {
        int i;
        LinkedHashMap<String, String> dto = new LinkedHashMap<String, String>(128);
        ArrayList<String> result = new ArrayList<String>(dateSet);
        List dayList = result.subList(0, 28);
        List weekSumList = result.subList(28, 32);
        List weekList = result.subList(32, 107);
        for (i = 0; i < dayList.size(); ++i) {
            dto.put((String)dayList.get(i), "day" + (i + 1));
        }
        for (i = 1; i <= weekSumList.size(); ++i) {
            dto.put((String)weekSumList.get(i - 1), "countweek" + i);
        }
        for (i = 0; i < weekList.size(); ++i) {
            dto.put((String)weekList.get(i), "week" + (i + 1));
        }
        return dto;
    }
}

