/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.formplugin.supplydemand;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.scmc.pm.forecast.business.helper.ExcelImportMessageHelper;
import kd.scmc.pm.forecast.business.helper.ExecuteSql;
import kd.scmc.pm.forecast.business.helper.SupplyDemandHelper;
import kd.scmc.pm.forecast.business.helper.excel.ExcelUtils;
import kd.scmc.pm.forecast.common.consts.SupplyDemandAdjustConsts;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelImportPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final String btn_ok = "ok";
    private static final String btn_view = "view";
    private static final String attachmentpanel = "attachmentpanel";
    private static final String progressbarap = "progressbar";
    private static final String cachekey_url = "errorFileUrl";
    private static final String cachekey_tip = "tip";
    private static final String cachekey_progress = "progress";
    private static final String cachekey_complete = "complete";
    private static final String cachekey_exception = "exception";
    private static final String cachekey_validate_error = "validate_error";
    private static final int max_colwidth = 18215;
    private static final Log log = LogFactory.getLog(ExcelImportPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_ok, btn_view});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(attachmentpanel);
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl(progressbarap);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{btn_view});
    }

    public void beforeClick(BeforeClickEvent evt) {
        List attachmentDataList;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(attachmentpanel);
        if (StringUtils.equals((CharSequence)btn_ok, (CharSequence)control.getKey()) && (attachmentDataList = attachmentPanel.getAttachmentData()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"ExcelImportPlugin_26", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        if (btn_ok.equals(key)) {
            view.showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0a\u8f7d\u2026", (String)"ExcelImportPlugin_27", (String)"scmc-pm-forecast", (Object[])new Object[0])));
            ProgressBar progressBar = (ProgressBar)this.getControl(progressbarap);
            progressBar.start();
        } else if (btn_view.equals(key)) {
            String tempUrl = pageCache.get(cachekey_url);
            view.download(tempUrl);
            view.setVisible(Boolean.TRUE, new String[]{btn_view});
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getProgress();
        if (progress == 0) {
            this.setProgress(1);
            this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"ExcelImportPlugin_28", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            RequestContext rc = RequestContextCreator.createForThreadPool();
            Object runnable = new RequestContextRunnable(this::batchExecute, rc);
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
            ThreadPools.executeOnce((String)"SCMC-PM-FORECAST", (Runnable)runnable);
        } else {
            IFormView view = this.getView();
            IPageCache pageCache = this.getPageCache();
            String exceptionStack = pageCache.get(cachekey_exception);
            String validateError = pageCache.get(cachekey_validate_error);
            String completed = pageCache.get(cachekey_complete);
            if (exceptionStack != null) {
                ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
                progressBar.stop();
                this.removeCache();
                view.hideLoading();
                view.showErrMessage(exceptionStack, "");
            } else if (validateError != null) {
                List validateErrors = (List)SerializationUtils.fromJsonString((String)validateError, List.class);
                ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
                progressBar.stop();
                this.removeCache();
                view.hideLoading();
                if (validateErrors.size() > 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{btn_ok});
                    ExcelImportMessageHelper.clear();
                    this.exportErrorInfo(validateErrors);
                }
            } else if (completed != null) {
                ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
                progressBar.stop();
                view.returnDataToParent((Object)completed);
                view.close();
            } else {
                String tip = this.getTip();
                view.showProgressLoading(new LocaleString(tip), progress);
            }
        }
    }

    private List<String> validationExcelData(List<List<String>> excelData) {
        ArrayList<String> validateErrors = new ArrayList<String>();
        for (int i = 0; i < excelData.size(); ++i) {
            String suppler;
            String purmodel;
            String purorg;
            String plannum;
            String proorg;
            List<String> row = excelData.get(i);
            String material = row.get(0);
            if (material == null || "".equals(material)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010\u7269\u6599\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_48", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            if ((proorg = row.get(2)) == null || "".equals(proorg)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010\u7269\u6599\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_25", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            if ((plannum = row.get(3)) == null || "".equals(plannum)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010\u5355\u636e\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_49", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            if ((purorg = row.get(4)) == null || "".equals(purorg)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010Plan Id\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_50", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            if ((purmodel = row.get(6)) == null || "".equals(purmodel)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010\u4f9b\u5e94\u5546\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_51", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            if ((suppler = row.get(7)) == null || "".equals(suppler)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\u3010\u4f9b\u5e94\u5546\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_52", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2));
            }
            String subType = row.get(SupplyDemandAdjustConsts.SUB_TYPE_COLUMN);
            if (!ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u8c03\u6574", (String)"ExcelImportPlugin_34", (String)"scmc-pm-forecast", (Object[])new Object[0]).equals(subType)) continue;
            for (int k = SupplyDemandAdjustConsts.ENTRY_DATE_COLUMN.intValue(); k < SupplyDemandAdjustConsts.ENTRY_DATE_COLUMN + 28 + 4 + 75; ++k) {
                String value = row.get(k);
                if (value == null) {
                    validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c %2$s \u5217\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_35", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2, k + 1));
                    continue;
                }
                BigDecimal decimal = new BigDecimal(value);
                if (BigDecimal.ZERO.compareTo(decimal) > 0) {
                    validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c %2$s \u5217\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_36", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2, k + 1));
                }
                if (!value.contains(".")) continue;
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c %1$s\u884c %2$s \u5217\u4e0d\u80fd\u4e3a\u5c0f\u6570\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u5bfc\u5165excel\u6a21\u677f\u3002", (String)"ExcelImportPlugin_53", (String)"scmc-pm-forecast", (Object[])new Object[0]), i + 2, k + 1));
            }
        }
        return validateErrors;
    }

    private void batchExecute() {
        Map<String, List<List>> data;
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(attachmentpanel);
        InputStream inputStream = SupplyDemandHelper.obtainInputStream(attachmentPanel, this.getPageCache());
        DBRoute dbRoute = DBRoute.of((String)"scm");
        ArrayList<Object[]> values_day = new ArrayList<Object[]>();
        ArrayList<Object[]> values_week = new ArrayList<Object[]>();
        ArrayList<Object[]> values_status = new ArrayList<Object[]>();
        String invokeExeSql = SupplyDemandHelper.invokeExeSql_day();
        String invokeExeSql_week = SupplyDemandHelper.invokeExeSql_week();
        String invokeExeSql_status = SupplyDemandHelper.invokeBuyerStatusSql();
        try {
            List<List<String>> excelDataTmp = ExcelUtils.convertEasyExcelToList(inputStream);
            ArrayList<List<String>> excelData = new ArrayList<List<String>>(excelDataTmp);
            ExcelUtils.clearData();
            ExcelImportMessageHelper.add(excelData.size(), 0, null);
            List<String> validateErrors = null;
            try {
                validateErrors = this.validationExcelData(excelData);
            }
            catch (Exception e) {
                log.info("\u91c7\u8d2d\u9884\u6d4b\u91c7\u8d2d\u5458\u8c03\u6574\u5f15\u5165\u5f02\u5e38", (Object)e);
                validateErrors = Collections.singletonList(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"ExcelImportPlugin_47", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                this.getPageCache().put(cachekey_validate_error, SerializationUtils.toJsonString(validateErrors));
                return;
            }
            if (!validateErrors.isEmpty()) {
                this.getPageCache().put(cachekey_validate_error, SerializationUtils.toJsonString(validateErrors));
                return;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            data = excelData.stream().collect(Collectors.groupingBy(this::groupKey));
        }
        catch (Exception e) {
            log.info(e.getLocalizedMessage());
            this.setExceptionStack(e);
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
        try (TXHandle handle = TX.required((String)"import");){
            try {
                int rowNum = 0;
                int progress = 0;
                for (Map.Entry<String, List<List>> entry : data.entrySet()) {
                    List<List> value = entry.getValue();
                    List purpfline = null;
                    List supplyline = null;
                    List adjustline = null;
                    List gapline = null;
                    for (List dto : value) {
                        String subtype = ((String)dto.get(SupplyDemandAdjustConsts.SUB_TYPE_COLUMN)).replaceAll("\\s*", "");
                        if (ResManager.loadKDString((String)"\u672c\u671f\u9700\u6c42", (String)"ExcelImportPlugin_38", (String)"scmc-pm-forecast", (Object[])new Object[0]).equalsIgnoreCase(subtype)) {
                            purpfline = dto;
                        }
                        if (ResManager.loadKDString((String)"\u672c\u671f\u4f9b\u5e94", (String)"ExcelImportPlugin_39", (String)"scmc-pm-forecast", (Object[])new Object[0]).equalsIgnoreCase(subtype)) {
                            supplyline = dto;
                        }
                        if (ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u8c03\u6574", (String)"ExcelImportPlugin_34", (String)"scmc-pm-forecast", (Object[])new Object[0]).equalsIgnoreCase(subtype)) {
                            adjustline = dto;
                        }
                        if (ResManager.loadKDString((String)"\u672c\u671f\u7f3a\u53e3", (String)"ExcelImportPlugin_40", (String)"scmc-pm-forecast", (Object[])new Object[0]).equalsIgnoreCase(subtype)) {
                            gapline = dto;
                        }
                        values_status.add(new Object[]{Long.parseLong((String)dto.get(SupplyDemandAdjustConsts.ENTRY_ID_COLUMN))});
                    }
                    if (adjustline != null) {
                        long entryId = Long.parseLong((String)adjustline.get(SupplyDemandAdjustConsts.ENTRY_ID_COLUMN));
                        Object[] entity_day = new Object[29];
                        Object[] entity_week = new Object[76];
                        int startField = SupplyDemandAdjustConsts.ENTRY_DATE_COLUMN;
                        for (int i = 0; i < 103; ++i) {
                            String purAdjust = (String)adjustline.get((i >= 28 ? startField + 4 : startField) + i);
                            BigDecimal adjustQty = new BigDecimal(purAdjust);
                            if (i < 28) {
                                entity_day[i] = adjustQty;
                                continue;
                            }
                            entity_week[i - 28] = adjustQty;
                        }
                        entity_day[28] = entryId;
                        values_day.add(entity_day);
                        entity_week[75] = entryId;
                        values_week.add(entity_week);
                    }
                    if (gapline != null && adjustline != null && supplyline != null && purpfline != null) {
                        this.calcGap(gapline, adjustline, supplyline, purpfline, values_day, values_week);
                    }
                    if (((rowNum += 4) & 0x3FF) == 0) {
                        if ((progress += 2) >= 100) {
                            progress = 99;
                        }
                        this.setProgress(progress);
                        this.setTip(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406%d\u6761", (String)"ExcelImportPlugin_41", (String)"scmc-pm-forecast", (Object[])new Object[0]), rowNum));
                    }
                    if (values_day.size() > 0 && values_day.size() % SupplyDemandAdjustConsts.BATCH_NUM == 0) {
                        ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql, values_day);
                        values_day.clear();
                    }
                    if (values_week.size() > 0 && values_week.size() % SupplyDemandAdjustConsts.BATCH_NUM == 0) {
                        ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_week, values_week);
                        values_week.clear();
                    }
                    if (values_status.size() <= 0 || values_status.size() % SupplyDemandAdjustConsts.BATCH_NUM != 0) continue;
                    ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_status, values_status);
                    values_status.clear();
                }
                if (values_day.size() != 0) {
                    ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql, values_day);
                    values_day.clear();
                }
                if (values_week.size() != 0) {
                    ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_week, values_week);
                    values_week.clear();
                }
                if (values_status.size() != 0) {
                    ExecuteSql.batchInvokeSql(dbRoute, invokeExeSql_status, values_status);
                    values_status.clear();
                }
                ExcelImportMessageHelper.add(0, data.size() * 4, null);
                this.setCompleted();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.info(e.getLocalizedMessage());
                }
                this.setExceptionStack(e);
                handle.markRollback();
                throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
            }
        }
    }

    private void calcGap(List<String> gapLine, List<String> adjustLine, List<String> supplyLine, List<String> pfLine, List<Object[]> values_day, List<Object[]> values_week) {
        BigDecimal gap = BigDecimal.ZERO;
        String entryIdColumn = gapLine.get(SupplyDemandAdjustConsts.ENTRY_ID_COLUMN);
        long entryId = entryIdColumn == null ? 0L : Long.parseLong(entryIdColumn);
        Object[] entity_day = new Object[29];
        Object[] entity_week = new Object[76];
        int startField = SupplyDemandAdjustConsts.ENTRY_DATE_COLUMN;
        for (int i = 0; i < 103; ++i) {
            BigDecimal adjustQty;
            int dataIndex = (i >= 28 ? startField + 4 : startField) + i;
            String purPf = pfLine.get(dataIndex);
            BigDecimal pfQty = purPf == null ? BigDecimal.ZERO : new BigDecimal(purPf);
            String purAdjust = adjustLine.get(dataIndex);
            BigDecimal bigDecimal = adjustQty = purAdjust == null ? BigDecimal.ZERO : new BigDecimal(purAdjust);
            if (adjustQty.compareTo(BigDecimal.ZERO) >= 0) {
                gap = adjustQty.subtract(pfQty).add(gap);
            } else {
                String supplyAdjust = supplyLine.get(dataIndex);
                BigDecimal supplyQty = supplyAdjust == null ? BigDecimal.ZERO : new BigDecimal(supplyAdjust);
                gap = supplyQty.compareTo(BigDecimal.ZERO) != 0 ? supplyQty.subtract(pfQty).add(gap) : BigDecimal.ZERO.add(gap);
            }
            if (i < 28) {
                entity_day[i] = gap;
                continue;
            }
            entity_week[i - 28] = gap;
        }
        entity_day[28] = entryId;
        values_day.add(entity_day);
        entity_week[75] = entryId;
        values_week.add(entity_week);
    }

    public String groupKey(List<String> detail) {
        return detail.get(SupplyDemandAdjustConsts.MATERIAL_COLUMN) + detail.get(SupplyDemandAdjustConsts.PLAN_ID_COLUMN) + detail.get(SupplyDemandAdjustConsts.SUPPLIER_COLUMN);
    }

    private void exportErrorInfo(List<String> validateErrors) {
        try (SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            SXSSFSheet sheet = sxssfWorkbook.createSheet(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a\u4fe1\u606f", (String)"ExcelImportPlugin_43", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            SXSSFRow headRow = sheet.createRow(0);
            SXSSFCell cell = headRow.createCell(0, CellType.STRING);
            CellStyle cellStyle = sxssfWorkbook.createCellStyle();
            Font font = sxssfWorkbook.createFont();
            font.setColor((short)10);
            cellStyle.setFont(font);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"ExcelImportPlugin_44", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            int errorInfoListSize = validateErrors.size();
            for (int i = 0; i < errorInfoListSize; ++i) {
                String errorInfo = validateErrors.get(i);
                SXSSFRow row = sheet.createRow(i + 1);
                row.createCell(0, CellType.STRING).setCellValue(errorInfo);
            }
            sheet.setColumnWidth(0, 18215);
            sxssfWorkbook.write((OutputStream)outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u9519\u8bef\u65e5\u5fd7\u8be6\u60c5.xlsx", (String)"ExcelImportPlugin_45", (String)"scmc-pm-forecast", (Object[])new Object[0]), (InputStream)inStream, 7200);
            this.getPageCache().put(cachekey_url, tempUrl);
            this.getView().setVisible(Boolean.TRUE, new String[]{btn_view});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef\u65e5\u5fd7", (String)"ExcelImportPlugin_46", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            inStream.close();
        }
        catch (IOException e) {
            log.info("\u5f02\u5e38\uff1a", (Object)e);
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
    }

    protected void setExceptionStack(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        String stack = Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
        this.getPageCache().put(cachekey_exception, exception + ": " + stack);
    }

    private void removeCache() {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(cachekey_progress);
        pageCache.remove(cachekey_exception);
        pageCache.remove(cachekey_validate_error);
    }

    private int getProgress() {
        String str = this.getPageCache().get("progressbarap");
        return StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    private void setProgress(int progress) {
        this.getPageCache().put("progressbarap", String.valueOf(progress));
    }

    private void setTip(String tip) {
        this.getPageCache().put(cachekey_tip, tip);
    }

    private String getTip() {
        return this.getPageCache().get(cachekey_tip);
    }

    protected void setCompleted() {
        this.getPageCache().put(cachekey_complete, String.valueOf(true));
    }
}

