/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.formplugin.supplydemand;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.forecast.business.helper.SupplyDemandHelper;

public class SuppDemAdjustEntryPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener,
RowClickEventListener {
    public static final String ENTRYENTITY = "entryentity";
    private static final Log log = LogFactory.getLog(SuppDemAdjustEntryPlugin.class);
    private final Set<String> keyList = new HashSet<String>(16);

    public void createNewData(BizDataEventArgs evt) {
        IFormView view = this.getView();
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2...", (String)"SuppDemAdjustEntryPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0])));
        DynamicObject[] data = this.getBillAdjustData(view.getFormShowParameter());
        if (data == null) {
            return;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String dateJson = (String)formShowParameter.getCustomParam("detail_no");
        List fieldsList = (List)SerializationUtils.fromJsonString((String)dateJson, ArrayList.class);
        view.showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"SuppDemAdjustEntryPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0])), 0);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        ArrayList<String> gapList = new ArrayList<String>();
        for (DynamicObject object : data) {
            gapList.clear();
            String planCalcNum = object.getString("plancalcnum");
            DynamicObject org = object.getDynamicObject("org");
            DynamicObjectCollection collection = object.getDynamicObjectCollection("resultentry");
            try {
                DynamicObject supplier;
                List issuppcollaList = (List)formShowParameter.getCustomParam("param_filter_issuppcolla");
                String issuppcolla = null;
                if (issuppcollaList != null && issuppcollaList.size() > 0) {
                    issuppcolla = (String)issuppcollaList.get(0);
                }
                List buyerStatusList = (List)formShowParameter.getCustomParam("param_filter_buyerstatus");
                String buyerstatus = null;
                if (buyerStatusList != null && buyerStatusList.size() > 0) {
                    buyerstatus = (String)buyerStatusList.get(0);
                }
                List supplierstatusList = (List)formShowParameter.getCustomParam("param_filter_supplierstatus");
                String supplierstatus = null;
                if (supplierstatusList != null && supplierstatusList.size() > 0) {
                    supplierstatus = (String)supplierstatusList.get(0);
                }
                String materialId = (String)formShowParameter.getCustomParam("param_filter_materialId");
                String materialNumber = (String)formShowParameter.getCustomParam("param_filter_materialNumber");
                boolean existsGap = (Boolean)formShowParameter.getCustomParam("param_filter_existsgap");
                if (existsGap) {
                    for (DynamicObject dynamicObject : collection) {
                        String key;
                        if (dynamicObject == null) continue;
                        String supplierid = "";
                        supplier = dynamicObject.getDynamicObject("supplier");
                        if (supplier != null) {
                            supplierid = supplier.getString("masterid");
                        }
                        String masterid = "";
                        DynamicObject materiel = dynamicObject.getDynamicObject("material");
                        if (materiel != null) {
                            masterid = materiel.getString("masterid.id");
                        }
                        String billno = "";
                        DynamicObject parentDynamicObject = (DynamicObject)dynamicObject.getParent();
                        if (parentDynamicObject != null) {
                            billno = parentDynamicObject.getString("billno");
                        }
                        Map<String, BigDecimal> dateQtyMap = SupplyDemandHelper.invokeDynamicEntry(dynamicObject, fieldsList);
                        String subtype = (String)dynamicObject.get("subtype");
                        if (!"D".equals(subtype)) continue;
                        boolean istrue = false;
                        for (Map.Entry<String, BigDecimal> entry : dateQtyMap.entrySet()) {
                            BigDecimal value = entry.getValue();
                            if (value == null || value.compareTo(BigDecimal.ZERO) >= 0) continue;
                            istrue = true;
                            break;
                        }
                        if (!istrue || gapList.contains(key = supplierid + "-" + masterid + "-" + billno)) continue;
                        gapList.add(key);
                    }
                }
                int collectionSize = collection.size();
                for (int i = 0; i < collectionSize; ++i) {
                    String key;
                    DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                    supplier = dynamicObject.getDynamicObject("supplier");
                    if (supplier != null) {
                        String iscolla = supplier.getString("issuppcolla");
                        if (issuppcolla != null && !issuppcolla.equals(iscolla)) continue;
                    }
                    DynamicObject dto = dynamicObject.getDynamicObject("material");
                    DynamicObject splitResult = (DynamicObject)dynamicObject.getParent();
                    if (dto != null) {
                        String masterid = dto.getString("masterid.id");
                        String masterNumber = dto.getString("masterid.number");
                        if (materialId != null && materialNumber != null && !materialId.equals(masterid) && !materialNumber.equals(masterNumber)) continue;
                    }
                    if (existsGap && supplier != null && dto != null && !gapList.contains(key = supplier.getString("masterid") + "-" + dto.getString("masterid.id") + "-" + splitResult.getString("billno"))) continue;
                    String buyerstatus2 = (String)dynamicObject.get("operatestatus");
                    if (buyerstatus != null && !buyerstatus.equals(buyerstatus2)) continue;
                    String supplierstatus2 = (String)dynamicObject.get("replystatus");
                    if (supplierstatus != null && !supplierstatus.equals(supplierstatus2)) continue;
                    DynamicObject entryRow = entryRows.addNew();
                    if (supplier != null) {
                        entryRow.set("issuppcolla", (Object)supplier.getString("issuppcolla"));
                        entryRow.set("supplierid", (Object)supplier.getString("masterid"));
                    }
                    entryRow.set("entryid", dynamicObject.getPkValue());
                    entryRow.set("material", (Object)dto);
                    if (dto != null) {
                        entryRow.set("materialname", (Object)dto.getString("masterid.name"));
                        entryRow.set("materialmasterid", (Object)dto.getLong("id"));
                    }
                    entryRow.set("splitdate", (Object)splitResult.getDate("splitdate"));
                    entryRow.set("billno", (Object)splitResult.getString("billno"));
                    entryRow.set("plancalcnumber", (Object)planCalcNum);
                    entryRow.set("purorg", (Object)org);
                    entryRow.set("baseunit", dynamicObject.get("baseunit"));
                    entryRow.set("status", dynamicObject.get("status"));
                    entryRow.set("supplier", dynamicObject.get("supplier"));
                    entryRow.set("minpackageqty", dynamicObject.get("minpackageqty"));
                    entryRow.set("minorderbaseqty", dynamicObject.get("minorderbaseqty"));
                    entryRow.set("replydate", dynamicObject.get("replydate"));
                    entryRow.set("operatedate", dynamicObject.get("operatedate"));
                    entryRow.set("type", dynamicObject.get("type"));
                    entryRow.set("subtype", dynamicObject.get("subtype"));
                    entryRow.set("operatestatus", dynamicObject.get("operatestatus"));
                    entryRow.set("replystatus", dynamicObject.get("replystatus"));
                    Map<String, BigDecimal> dateQtyMap = SupplyDemandHelper.invokeDynamicEntry(dynamicObject, fieldsList);
                    if ("D".equals(dynamicObject.get("subtype"))) {
                        dateQtyMap.put("countweek1", dateQtyMap.get("day7"));
                        dateQtyMap.put("countweek2", dateQtyMap.get("day14"));
                        dateQtyMap.put("countweek3", dateQtyMap.get("day21"));
                        dateQtyMap.put("countweek4", dateQtyMap.get("day28"));
                    }
                    dateQtyMap.forEach((arg_0, arg_1) -> ((DynamicObject)entryRow).set(arg_0, arg_1));
                    if (i % 100 != 0) continue;
                    String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d%1$s%2$s\u6761", (String)"SuppDemAdjustEntryPlugin_2", (String)"scmc-pm-forecast", (Object[])new Object[0]), i, collectionSize);
                    int progress = i * 100 / collectionSize;
                    view.showProgressLoading(new LocaleString(tip), progress);
                }
            }
            catch (Exception e) {
                this.getView().hideLoading();
                log.info("\u521d\u59cb\u5316\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage());
                throw new KDException(new ErrorCode("", e.getLocalizedMessage()), e.getLocalizedMessage(), (Throwable)e);
            }
        }
        evt.setDataEntity((Object)dataEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int indexOfKey;
        super.propertyChanged(e);
        String key = e.getProperty().getName().toLowerCase(Locale.ENGLISH);
        if (this.keyList.contains(key)) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List<String> properties = this.getContainerProperties((Container)entryGrid);
        for (int i = indexOfKey = properties.indexOf(key); i < properties.size(); ++i) {
            String keyNext = properties.get(i);
            BigDecimal requestNext = (BigDecimal)this.getModel().getValue(keyNext, rowIndex - 2);
            requestNext = requestNext == null ? BigDecimal.ZERO : requestNext;
            BigDecimal adjustNext = (BigDecimal)this.getModel().getValue(keyNext, rowIndex);
            adjustNext = adjustNext == null ? BigDecimal.ZERO : adjustNext;
            BigDecimal lastNeeded = "day1".equals(keyNext) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(properties.get(i - 1), rowIndex + 1);
            BigDecimal neededNext = adjustNext.subtract(requestNext).add(lastNeeded);
            String subtypeNext = (String)this.getModel().getValue("subtype", rowIndex + 1);
            if (!"D".equals(subtypeNext)) continue;
            this.keyList.add(keyNext);
            if ("countweek1".equals(keyNext)) {
                this.getModel().setValue(keyNext, this.getModel().getValue("day7", rowIndex + 1), rowIndex + 1);
                continue;
            }
            if ("countweek2".equals(keyNext)) {
                this.getModel().setValue(keyNext, this.getModel().getValue("day14", rowIndex + 1), rowIndex + 1);
                continue;
            }
            if ("countweek3".equals(keyNext)) {
                this.getModel().setValue(keyNext, this.getModel().getValue("day21", rowIndex + 1), rowIndex + 1);
                continue;
            }
            if ("countweek4".equals(keyNext)) {
                this.getModel().setValue(keyNext, this.getModel().getValue("day28", rowIndex + 1), rowIndex + 1);
                continue;
            }
            this.getModel().setValue(keyNext, (Object)neededNext, rowIndex + 1);
        }
        this.getView().updateView(ENTRYENTITY);
        this.lockRow();
        entryGrid.selectRows(rowIndex, true);
    }

    private List<String> getContainerProperties(Container container) {
        List items = container.getItems();
        ArrayList<String> properties = new ArrayList<String>(items.size());
        for (Control control : items) {
            properties.add(control.getKey());
        }
        return properties;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.lockRow();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.setColumnProperty("material", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("materialname", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("subtype", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("suppliername", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("supplier", "isFixed", (Object)Boolean.TRUE);
        this.lockRow();
        Set<String> firstFourWeeks = SupplyDemandHelper.obtainLockFields();
        for (String week : firstFourWeeks) {
            entryGrid.setColumnProperty(week, "l", (Object)Boolean.TRUE);
        }
        this.getView().hideLoading();
    }

    private void lockRow() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        AbstractGrid.GridState entryState = entryGrid.getEntryState();
        int startIndex = (entryState.getCurrentPageIndex() - 1) * entryGrid.getPageRow();
        int endIndex = Math.min(startIndex + entryGrid.getPageRow(), entryRowCount);
        ArrayList<Integer> rowIndexsCon = new ArrayList<Integer>();
        ArrayList<Integer> rowIndexsColor = new ArrayList<Integer>();
        for (int i = 0; i < endIndex; ++i) {
            String subtype = ((DynamicObject)entryEntity.get(i)).getString("subtype");
            if (!"C".equals(subtype)) {
                rowIndexsCon.add(i);
                continue;
            }
            rowIndexsColor.add(i);
        }
        int[] rowIndexs = new int[rowIndexsCon.size()];
        for (int i = 0; i < rowIndexsCon.size(); ++i) {
            rowIndexs[i] = (Integer)rowIndexsCon.get(i);
        }
        int[] rowIndexs_color = new int[rowIndexsColor.size()];
        for (int i = 0; i < rowIndexsColor.size(); ++i) {
            rowIndexs_color[i] = (Integer)rowIndexsColor.get(i);
        }
        entryGrid.setRowLock(true, rowIndexs);
        entryGrid.setRowBackcolor("#F8F8FF", rowIndexs_color);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Set<String> dateSet = this.getDateSet(formShowParameter);
        if (dateSet == null) {
            return;
        }
        EntryAp entryAp = this.createDynamicEntryAp(dateSet, formShowParameter.getFormId());
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap.put("id", ENTRYENTITY);
        entryMap.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Set<String> dateSet = this.getDateSet(formShowParameter);
        if (dateSet == null) {
            return;
        }
        Map<String, String> obtainFields = SupplyDemandHelper.obtainFields(dateSet);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("SuppDemAdjustEntryPlugin", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        for (String date : dateSet) {
            QtyProp qtyProp = new QtyProp();
            qtyProp.setName(obtainFields.get(date));
            qtyProp.setDisplayName(new LocaleString(date));
            qtyProp.setDbIgnore(true);
            entryType.registerSimpleProperty((DynamicSimpleProperty)qtyProp);
        }
        e.setNewEntityType(newMainType);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        EntryAp entryAp = this.createDynamicEntryAp(dateSet, formShowParameter.getFormId());
        List newItems = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : newItems) {
            item.setView(view);
        }
        List items = entryGrid.getItems();
        items.clear();
        items.addAll(newItems);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.contains((CharSequence)key, (CharSequence)"day") || StringUtils.contains((CharSequence)key, (CharSequence)"week")) {
            QtyEdit qtyEdit = new QtyEdit();
            qtyEdit.setKey(key);
            qtyEdit.setEntryKey(ENTRYENTITY);
            qtyEdit.setView(this.getView());
            e.setControl((Control)qtyEdit);
        }
    }

    private EntryAp createDynamicEntryAp(Set<String> dateSet, String formId) {
        Map<String, String> obtainFields = SupplyDemandHelper.obtainFields(dateSet);
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(ENTRYENTITY);
        String entityId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        List items = entryAp.getItems();
        for (String date : dateSet) {
            String keyid = obtainFields.get(date);
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(keyid);
            entryFieldAp.setKey(keyid);
            entryFieldAp.setName(new LocaleString(date));
            entryFieldAp.setFireUpdEvt(true);
            QtyField qtyField = new QtyField();
            qtyField.setId(keyid);
            qtyField.setKey(keyid);
            qtyField.setZeroShow(true);
            qtyField.setDataScope("[0,]");
            qtyField.setEntityMetadata(entitymeta);
            qtyField.setScale(0);
            entryFieldAp.setField((Field)qtyField);
            items.add(entryFieldAp);
        }
        return entryAp;
    }

    protected Set<String> getDateSet(FormShowParameter formShowParameter) {
        String dateJson = (String)formShowParameter.getCustomParam("detail_no");
        if (StringUtils.isBlank((CharSequence)dateJson)) {
            return null;
        }
        return (Set)SerializationUtils.fromJsonString((String)dateJson, LinkedHashSet.class);
    }

    private DynamicObject[] getBillAdjustData(FormShowParameter formShowParameter) {
        int i;
        List filterStrList = (List)formShowParameter.getCustomParam("param_filter");
        if (CollectionUtils.isEmpty((Collection)filterStrList)) {
            return null;
        }
        QFilter[] filters = (QFilter[])filterStrList.stream().map(QFilter::fromSerializedString).toArray(QFilter[]::new);
        log.info("\u8fc7\u6ee4\u6761\u4ef6\uff1a" + SerializationUtils.toJsonString((Object)filters));
        String selectPorperties = "billno,org,plancalcnum,splitstatus,startdate,splitdate,publishdate,resulttext,resultentry.material,resultentry.materialmasterid,resultentry.baseunit,resultentry.status,resultentry.supplier,resultentry.minpackageqty,resultentry.minorderbaseqty,resultentry.replystatus,resultentry.replydate,resultentry.operatestatus,resultentry.operatedate,resultentry.type, resultentry.subtype ";
        StringBuilder select = new StringBuilder(selectPorperties);
        for (i = 1; i <= 28; ++i) {
            select.append(",resultentry.day").append(i);
        }
        for (i = 1; i <= 75; ++i) {
            select.append(",resultentry.week").append(i);
        }
        log.info("\u67e5\u8be2SQL ->" + select);
        return BusinessDataServiceHelper.load((String)"pm_splitresult", (String)select.toString(), (QFilter[])filters);
    }
}

