/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.opplugin;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.pm.forecast.business.helper.DateHelper;
import kd.scmc.pm.forecast.business.helper.SplitResultHelper;
import kd.scmc.pm.forecast.business.pojo.SplitAutoScpData;
import kd.scmc.pm.forecast.business.pojo.SplitEntry4AutoScp;
import kd.scmc.pm.forecast.business.pojo.UpdateFieldsDTO;
import kd.scmc.pm.forecast.common.consts.enums.SplitResultStatus;
import kd.scmc.pm.forecast.opplugin.validation.MrpEntryValidator;
import org.apache.commons.collections.CollectionUtils;

public class SplitResultOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SplitResultOp.class);
    private static final String START_DATE = "startdate";
    private static final String PLAN_ID = "plancalcnum";
    private static final String SUPPLIER = "supplier";
    private static final String ENTRY_MATERIAL = "billentry.material";
    private static final String ENTRY_PROMISE = "billentry.promisedate";
    private static final String ENTRY_QTY = "billentry.baseqty";
    private static final String ENTRY_RECEIVE = "billentry.receivebaseqty";
    private static final String F_ENTRY_ID = "fentryid";
    private static final String F_SUPPLIER = "fsupplierid";
    private static final String F_MATERIAL = "fmaterialid";
    private static final String F_START_DATE = "fstartdate";
    private static final String FID = "fid";
    private final String keySplit = "::";
    private Set<String> splitSuccessIds;
    private Set<String> autoScpIds;
    private Date minTime;
    private Date maxTime;
    private final Map<String, String[]> dayCache = new HashMap<String, String[]>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new MrpEntryValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKey = e.getFieldKeys();
        fieldKey.addAll(this.getFieldKey());
        log.info("\u62c6\u5206\u524d\u52a0\u8f7d\u5b57\u6bb5");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.minTime = null;
        this.maxTime = null;
        HashMap<Long, String> wbSplitResult = new HashMap<Long, String>(32);
        this.splitSuccessIds = new HashSet<String>(32);
        ArrayList<Object[]> updateMrpStatusParams = new ArrayList<Object[]>();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> errorIds = new HashSet<Long>(dataEntities.length);
        ArrayList<Object[]> updateHeadTextParams = new ArrayList<Object[]>();
        Date now = new Date();
        int batchNum = 5000;
        for (DynamicObject dataEntity : dataEntities) {
            if (dataEntity == null) continue;
            String billStatus = dataEntity.getString("splitstatus");
            long id = dataEntity.getLong("id");
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                log.info("\u65e0\u91c7\u8d2d\u7ec4\u7ec7:id=" + id);
                errorIds.add(id);
                continue;
            }
            if (!SplitResultStatus.UNSPLIT.getValue().equals(billStatus) && !SplitResultStatus.SPLIT_FAILURE.getValue().equals(billStatus)) continue;
            DynamicObjectCollection mrpEntry = dataEntity.getDynamicObjectCollection("mrpentry");
            if (mrpEntry == null || mrpEntry.size() == 0) {
                log.info("\u65e0MRP\u6570\u636e:id=" + id);
                errorIds.add(id);
                continue;
            }
            Date startDate = dataEntity.getDate(START_DATE);
            if (startDate == null) {
                log.info("\u65e0\u9884\u6d4b\u8d77\u59cb\u65e5\u671f:id=" + id);
                errorIds.add(id);
                continue;
            }
            this.setMinMaxTime(startDate);
            int lastIndex = mrpEntry.size();
            boolean splitSuccess = this.doSplit(lastIndex, batchNum, id, mrpEntry, errorIds, updateMrpStatusParams, org, updateHeadTextParams, now);
            if (!splitSuccess) continue;
            this.putWbMrpSplitStatusMap(wbSplitResult, mrpEntry);
        }
        if (this.splitSuccessIds.size() > 0) {
            this.afterSplit(updateHeadTextParams, wbSplitResult, updateMrpStatusParams);
        } else {
            log.info("\u672c\u6b21\u62c6\u5206\u672a\u4ea7\u751f\u6570\u636e");
        }
        if (errorIds.size() > 0) {
            this.logErrorIds(errorIds);
        }
    }

    private void putWbMrpSplitStatusMap(Map<Long, String> wbSplitResult, DynamicObjectCollection mrpEntry) {
        String splitSuccessStatus = "Y";
        for (DynamicObject dynamicObject : mrpEntry) {
            wbSplitResult.put(dynamicObject.getLong("mrp_entryid"), splitSuccessStatus);
        }
    }

    private boolean doSplit(int lastIndex, int batchNum, long id, DynamicObjectCollection mrpEntry, Set<Long> errorIds, List<Object[]> updateMrpStatusParams, DynamicObject org, List<Object[]> updateHeadTextParams, Date now) {
        HashSet<Long> oneBillMrpEntryIdSet = new HashSet<Long>();
        try {
            List<Long> list;
            while (lastIndex > batchNum) {
                int startIndex = lastIndex - batchNum;
                List<Long> list2 = this.batchSplitEntry(id, mrpEntry, startIndex, lastIndex);
                lastIndex -= batchNum;
                if (list2 == null || list2.size() <= 0) continue;
                oneBillMrpEntryIdSet.addAll(list2);
            }
            if (lastIndex > 0 && (list = this.splitEntry(id, (List<DynamicObject>)mrpEntry)) != null && list.size() > 0) {
                oneBillMrpEntryIdSet.addAll(list);
            }
        }
        catch (Exception e1) {
            log.info("\u62c6\u5206\u5931\u8d25", (Object)e1);
            errorIds.add(id);
            return false;
        }
        if (oneBillMrpEntryIdSet.size() > 0) {
            this.prepareSuccessSqlParam(id, oneBillMrpEntryIdSet, updateMrpStatusParams, org, lastIndex, updateHeadTextParams, now);
            return true;
        }
        log.info("\u65e0\u62c6\u5206\u6210\u529f\u7269\u6599\uff0cfid=" + id);
        errorIds.add(id);
        return false;
    }

    private void prepareSuccessSqlParam(long id, Set<Long> oneBillMrpEntryIdSet, List<Object[]> updateMrpStatusParams, DynamicObject org, int lastIndex, List<Object[]> updateHeadTextParams, Date now) {
        for (Long mid : oneBillMrpEntryIdSet) {
            updateMrpStatusParams.add(new Object[]{id, mid});
        }
        this.splitSuccessIds.add(String.valueOf(id));
        String splitResultInfo = String.format(ResManager.loadKDString((String)"\u5171\u62c6\u5206 %1$s \u6761\u6570\u636e\uff0c\u6210\u529f %2$s \u6761\u3002", (String)"SplitResultOp_0", (String)"scmc-pm-forecast", (Object[])new Object[0]), lastIndex, oneBillMrpEntryIdSet.size());
        Object[] param = new Object[]{org.getPkValue(), now, splitResultInfo, id};
        updateHeadTextParams.add(param);
    }

    private void afterSplit(List<Object[]> updateHeadTextParams, Map<Long, String> wbSplitResult, List<Object[]> updateMrpStatusParams) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)this.getSplitSuccessUpdateSql(), updateHeadTextParams);
        log.info("\u62c6\u5206\u5b8c\u6210\uff0c\u8bb0\u5f55\u62c6\u5206\u72b6\u6001,fid:" + this.splitSuccessIds);
        if (updateMrpStatusParams.size() > 0) {
            this.updateMrpEntry(updateMrpStatusParams);
        }
        this.writeBackMrp(wbSplitResult);
    }

    private void updateMrpEntry(List<Object[]> mrpStatusList) {
        StringBuilder updateMrpStatusSql = new StringBuilder("update ").append("t_pm_mrpentry").append(" set fsplitstatus='B' where fid=? and fmrpentryid=?");
        try {
            int[] batchResult = DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateMrpStatusSql.toString(), mrpStatusList);
            log.info("\u66f4\u65b0MRP\u5df2\u62c6\u5206\u72b6\u6001\u6210\u529f " + Arrays.toString(batchResult) + " params:" + SerializationUtils.toJsonString(mrpStatusList));
        }
        catch (Exception e1) {
            log.info("\u66f4\u65b0MRP\u5df2\u62c6\u5206\u72b6\u6001\u5931\u8d25", (Object)e1);
        }
    }

    private void logErrorIds(Set<Long> errorIds) {
        StringBuilder sql = new StringBuilder("update ").append("t_pm_splitresult").append(" set fsplitstatus='").append(SplitResultStatus.SPLIT_FAILURE.getValue()).append("',fsplitdate=? where fid in ");
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (Long id : errorIds) {
            joiner.add(id.toString());
        }
        sql.append(joiner);
        int result = DB.update((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])new Object[]{new Date()});
        log.info("\u8bb0\u5f55\u62c6\u5206\u5931\u8d25\u5355\u636e\u6570\u636e\uff1a" + result + "\uff0cfid:" + errorIds);
    }

    private void writeBackMrp(Map<Long, String> param) {
        try {
            log.info("\u53cd\u5199\u751f\u4ea7\u5fae\u670d\u52a1\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(param));
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"PurForecastReverseService", (String)"splitStatusReverse", (Object[])new Object[]{param});
        }
        catch (Exception e1) {
            log.info("\u53cd\u5199\u62c6\u5206\u72b6\u6001\u5931\u8d25", (Object)e1);
        }
    }

    private String getSplitSuccessUpdateSql() {
        return "update t_pm_splitresult set forgid= ? ,fsplitstatus= '" + SplitResultStatus.SPLIT_NOT_SCP.getValue() + "',fsplitdate= ? ,fresulttext= ? where fid = ?";
    }

    private void dualAutoScpData() {
        List<Object[]> weekParams;
        List<SplitEntry4AutoScp> splitEntry4AutoScpList;
        if (this.splitSuccessIds == null || this.splitSuccessIds.size() == 0) {
            return;
        }
        Set<String> supplierIdList = this.getSupplierIds();
        if (supplierIdList.size() == 0) {
            log.info("\u81ea\u52a8\u56de\u590d\u67e5\u8be2\u4e0d\u542f\u7528\u534f\u540c\u4f9b\u5e94\u5546\u7ed3\u679c\u4e3a\u7a7a\u3002");
            return;
        }
        log.info("\u5f00\u59cb\u6267\u884c\u4f9b\u5e94\u5546\u81ea\u52a8\u56de\u590d\u3002");
        List<SplitAutoScpData> splitAutoScpDataList = this.getSplitAutoScpData(supplierIdList);
        if (splitAutoScpDataList.size() == 0 || splitAutoScpDataList.get(1) == null || (splitEntry4AutoScpList = splitAutoScpDataList.get(1).getSplitEntry()).size() == 0) {
            log.info("\u65e0\u9700\u81ea\u52a8\u56de\u590d\u62c6\u5206\u884c\u3002");
            return;
        }
        Map<String, Map<String, BigDecimal>> autoScpPurOrderData = this.getSplitAutoScpPurOrderData(supplierIdList, splitAutoScpDataList.get(1));
        if (autoScpPurOrderData.size() == 0) {
            log.info("\u65e0\u5728\u9014\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002");
            return;
        }
        List<List<Object[]>> updateSqlParamList = this.getUpdateSqlParamList(splitEntry4AutoScpList, autoScpPurOrderData);
        List<List<Object[]>> selectForecastQty = this.getSelectForecastQty(splitAutoScpDataList.get(0));
        List<List<Object[]>> updateParamList = this.calculateGapAndGetUpdateParamList(updateSqlParamList, selectForecastQty, splitAutoScpDataList);
        List<Object[]> dayParams = updateParamList.get(0);
        DBRoute dbRoute = DBRoute.of((String)"scm");
        boolean canChange = false;
        if (dayParams.size() > 0) {
            canChange = true;
            DB.executeBatch((DBRoute)dbRoute, (String)this.getUpdateDayDataSql(), dayParams);
        }
        if ((weekParams = updateParamList.get(1)).size() > 0) {
            canChange = true;
            DB.executeBatch((DBRoute)dbRoute, (String)this.getUpdateWeekDataSql(), weekParams);
        }
        if (canChange && this.autoScpIds != null && this.autoScpIds.size() > 0) {
            StringBuilder sql = new StringBuilder("update ").append("t_pm_splitresult").append(" set fautoreply='1',fsplitstatus='").append(SplitResultStatus.ADJUSTABLE.getValue()).append("' where fid in (");
            sql.append(String.join((CharSequence)",", this.autoScpIds)).append(')');
            int updateCount = DB.update((DBRoute)dbRoute, (String)sql.toString());
            log.info("\u81ea\u52a8\u56de\u590d\u5355\u636e\u53ef\u8c03\u6574\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c" + updateCount);
        }
        log.info("\u81ea\u52a8\u56de\u590d\u5904\u7406\u5b8c\u6210\uff0ccanChange:" + canChange + ",autoScpIds:" + this.autoScpIds);
    }

    private void setMinMaxTime(Date startDate) {
        if (startDate == null) {
            startDate = new Date();
        }
        if (this.minTime == null || startDate.before(this.minTime)) {
            this.minTime = DateHelper.getStartOfDay(startDate);
        }
        Date endDay = DateHelper.getEndDay(startDate);
        if (this.maxTime == null || endDay.after(this.maxTime)) {
            this.maxTime = endDay;
        }
    }

    private List<Long> batchSplitEntry(long id, DynamicObjectCollection dynamicObjectCollection, int startIndex, int endIndex) {
        List subList = dynamicObjectCollection.subList(startIndex, endIndex);
        return this.splitEntry(id, subList);
    }

    private List<Long> splitEntry(long id, List<DynamicObject> dynamicObjects) {
        return SplitResultHelper.forecastSplitResult(id, dynamicObjects);
    }

    private String getUpdateWeekDataSql() {
        return this.getUpdateSql("t_pm_resultentry_w");
    }

    private String getUpdateDayDataSql() {
        return this.getUpdateSql("t_pm_resultentry");
    }

    private String getUpdateSql(String tableName) {
        int forTimes;
        String word;
        if ("t_pm_resultentry".equals(tableName)) {
            word = "d";
            forTimes = 28;
        } else if ("t_pm_resultentry_w".equals(tableName)) {
            word = "w";
            forTimes = 75;
        } else {
            return "";
        }
        StringBuilder updateSql = new StringBuilder("update ").append(tableName).append(" set f").append(word).append("1=?");
        for (int i = 2; i <= forTimes; ++i) {
            updateSql.append(",f").append(word).append(i).append("=?");
        }
        updateSql.append(" where fentryid=?");
        return updateSql.toString();
    }

    private List<List<Object[]>> getUpdateSqlParamList(List<SplitEntry4AutoScp> splitEntry4AutoScpList, Map<String, Map<String, BigDecimal>> autoScpPurOrderData) {
        this.autoScpIds = new HashSet<String>(8);
        ArrayList<List<Object[]>> updateSqlParamList = new ArrayList<List<Object[]>>(2);
        ArrayList<Object[]> updateDaySqlParamList = new ArrayList<Object[]>(splitEntry4AutoScpList.size());
        ArrayList<Object[]> updateWeekSqlParamList = new ArrayList<Object[]>(splitEntry4AutoScpList.size());
        for (SplitEntry4AutoScp entry : splitEntry4AutoScpList) {
            BigDecimal qty;
            Map<String, BigDecimal> dateQtyMap = autoScpPurOrderData.get(entry.getSupplier() + "::" + entry.getMaterial() + "::" + DateHelper.getDateString(entry.getStartDate(), "yyyy-MM-dd"));
            if (dateQtyMap == null || dateQtyMap.size() == 0) {
                Object[] dayParams = new Object[29];
                for (int i = 0; i < 28; ++i) {
                    dayParams[i] = BigDecimal.ZERO;
                }
                dayParams[28] = entry.getEntryId();
                updateDaySqlParamList.add(dayParams);
                Object[] weekParams = new Object[76];
                for (int i = 0; i < 75; ++i) {
                    weekParams[i] = BigDecimal.ZERO;
                }
                weekParams[75] = entry.getEntryId();
                updateWeekSqlParamList.add(weekParams);
                this.autoScpIds.add(entry.getFid().toString());
                continue;
            }
            this.autoScpIds.add(entry.getFid().toString());
            String formatDate = DateHelper.getDateString(entry.getStartDate(), "yyyy-MM-dd");
            String[] forecastDays = this.dayCache.get(formatDate);
            if (forecastDays == null) {
                forecastDays = DateHelper.getForecastDays(entry.getStartDate(), "yyyy-MM-dd", "yyyy-MM-dd");
                this.dayCache.put(formatDate, forecastDays);
            }
            Object[] dayParams = new Object[29];
            for (int i = 0; i < 28; ++i) {
                qty = dateQtyMap.get(forecastDays[i]);
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                dayParams[i] = qty;
            }
            dayParams[28] = entry.getEntryId();
            updateDaySqlParamList.add(dayParams);
            Object[] weekParams = new Object[76];
            for (int i = 0; i < 75; ++i) {
                qty = dateQtyMap.get(forecastDays[28 + i]);
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                weekParams[i] = qty;
            }
            weekParams[75] = entry.getEntryId();
            updateWeekSqlParamList.add(weekParams);
        }
        updateSqlParamList.add(updateDaySqlParamList);
        updateSqlParamList.add(updateWeekSqlParamList);
        return updateSqlParamList;
    }

    private List<List<Object[]>> getSelectForecastQty(SplitAutoScpData splitAutoScpData) {
        List<SplitEntry4AutoScp> splitEntry4AutoScpList = splitAutoScpData.getSplitEntry();
        if (splitEntry4AutoScpList.size() == 0) {
            return new ArrayList<List<Object[]>>();
        }
        ArrayList<String> list = new ArrayList<String>(splitEntry4AutoScpList.size());
        for (SplitEntry4AutoScp splitEntry4AutoScp : splitEntry4AutoScpList) {
            Long entryId = splitEntry4AutoScp.getEntryId();
            list.add(String.valueOf(entryId));
        }
        StringBuilder selectDaySql = new StringBuilder("select fentryid,");
        for (int i = 1; i < 29; ++i) {
            if (i == 28) {
                selectDaySql.append("fd".concat(String.valueOf(i)));
                continue;
            }
            selectDaySql.append("fd".concat(String.valueOf(i)).concat(","));
        }
        selectDaySql.append(" from t_pm_resultentry");
        selectDaySql.append(" where fentryid in  (").append(String.join((CharSequence)",", list)).append(") ");
        StringBuilder selectWeekSql = new StringBuilder("select fentryid,");
        for (int i = 1; i < 76; ++i) {
            if (i == 75) {
                selectWeekSql.append("fw".concat(String.valueOf(i)));
                continue;
            }
            selectWeekSql.append("fw".concat(String.valueOf(i)).concat(","));
        }
        selectWeekSql.append(" from t_pm_resultentry_w");
        selectWeekSql.append(" where fentryid in  (").append(String.join((CharSequence)",", list)).append(") ");
        DBRoute dbRoute = DBRoute.of((String)"scm");
        ArrayList<List<Object[]>> dayAndWeekQtyColl = new ArrayList<List<Object[]>>(2);
        dayAndWeekQtyColl.add(this.getDayQtyList(dbRoute, selectDaySql.toString()));
        dayAndWeekQtyColl.add(this.getWeekQtyList(dbRoute, selectWeekSql.toString()));
        return dayAndWeekQtyColl;
    }

    private List<Object[]> getWeekQtyList(DBRoute dbRoute, String sql) {
        ArrayList<Object[]> weekQtyColl = new ArrayList<Object[]>(10);
        try (DataSet WeekForeCastData = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            while (WeekForeCastData.hasNext()) {
                Row row = WeekForeCastData.next();
                Object[] weekQtyRow = new Object[76];
                for (int i = 0; i < 75; ++i) {
                    int temp = i + 1;
                    BigDecimal weekQty = row.getBigDecimal("fw".concat(String.valueOf(temp)));
                    weekQtyRow[i] = weekQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : weekQty;
                }
                weekQtyRow[75] = row.getLong(F_ENTRY_ID);
                weekQtyColl.add(weekQtyRow);
            }
        }
        return weekQtyColl;
    }

    private List<Object[]> getDayQtyList(DBRoute dbRoute, String sql) {
        ArrayList<Object[]> dayQtyColl = new ArrayList<Object[]>(10);
        try (DataSet DayForeCastData = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            while (DayForeCastData.hasNext()) {
                Row row = DayForeCastData.next();
                Object[] dayQtyRow = new Object[29];
                for (int i = 0; i < 28; ++i) {
                    int temp = i + 1;
                    BigDecimal dayQty = row.getBigDecimal("fd".concat(String.valueOf(temp)));
                    dayQtyRow[i] = dayQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : dayQty;
                }
                dayQtyRow[28] = row.getLong(F_ENTRY_ID);
                dayQtyColl.add(dayQtyRow);
            }
        }
        return dayQtyColl;
    }

    private List<List<Object[]>> calculateGapAndGetUpdateParamList(List<List<Object[]>> updateSqlParamList, List<List<Object[]>> selectForecastQty, List<SplitAutoScpData> splitAutoScpDataColl) {
        List<Object[]> dayForecastQtyList = selectForecastQty.get(0);
        List<Object[]> weekForecastQtyList = selectForecastQty.get(1);
        List<Object[]> daySupplierQtyList = updateSqlParamList.get(0);
        List<Object[]> weekSupplierQtyList = updateSqlParamList.get(1);
        SplitAutoScpData splitAutoScpData1 = splitAutoScpDataColl.get(2);
        SplitAutoScpData splitAutoScpData2 = splitAutoScpDataColl.get(3);
        List<SplitEntry4AutoScp> adjustRowEntryIdList = splitAutoScpData1.getSplitEntry();
        List<SplitEntry4AutoScp> gapRowEntryIdList = splitAutoScpData2.getSplitEntry();
        ArrayList<List<Object[]>> updateThreeRowDataSqlParam = new ArrayList<List<Object[]>>(2);
        if (dayForecastQtyList == null) {
            return updateThreeRowDataSqlParam;
        }
        int dayQtySize = dayForecastQtyList.size();
        ArrayList<Object[]> dayQty = new ArrayList<Object[]>(dayQtySize * 3);
        ArrayList<Object[]> weekQty = new ArrayList<Object[]>(dayQtySize * 3);
        for (int i = 0; i < dayQtySize; ++i) {
            BigDecimal setScale;
            BigDecimal supplierQty;
            BigDecimal pfQty;
            Object[] dayForecastQty = dayForecastQtyList.get(i);
            Object[] daySupplierQty = daySupplierQtyList.get(i);
            Object[] weekForecastQty = weekForecastQtyList.get(i);
            Object[] weekSupplierQty = weekSupplierQtyList.get(i);
            Long adjustRowEntryId = adjustRowEntryIdList.get(i).getEntryId();
            Long gapRowEntryId = gapRowEntryIdList.get(i).getEntryId();
            Object[] dayAdjustQty = new Object[29];
            Object[] dayGapQty = new Object[29];
            Object[] weekAdjustQty = new Object[76];
            Object[] weekGapQty = new Object[76];
            BigDecimal gap = BigDecimal.ZERO;
            for (int j = 0; j < 28; ++j) {
                pfQty = (BigDecimal)dayForecastQty[j];
                supplierQty = (BigDecimal)daySupplierQty[j];
                gap = setScale = supplierQty.subtract(pfQty).add(gap);
                dayAdjustQty[j] = supplierQty;
                dayGapQty[j] = gap;
            }
            dayAdjustQty[28] = adjustRowEntryId;
            dayGapQty[28] = gapRowEntryId;
            dayQty.add(daySupplierQty);
            dayQty.add(dayAdjustQty);
            dayQty.add(dayGapQty);
            for (int k = 0; k < 75; ++k) {
                pfQty = (BigDecimal)weekForecastQty[k];
                supplierQty = (BigDecimal)weekSupplierQty[k];
                gap = setScale = supplierQty.subtract(pfQty).add(gap);
                weekAdjustQty[k] = supplierQty;
                weekGapQty[k] = gap;
            }
            weekAdjustQty[75] = adjustRowEntryId;
            weekGapQty[75] = gapRowEntryId;
            weekQty.add(weekSupplierQty);
            weekQty.add(weekAdjustQty);
            weekQty.add(weekGapQty);
        }
        updateThreeRowDataSqlParam.add(dayQty);
        updateThreeRowDataSqlParam.add(weekQty);
        return updateThreeRowDataSqlParam;
    }

    private Map<String, Map<String, BigDecimal>> getSplitAutoScpPurOrderData(Set<String> supplierIdList, SplitAutoScpData splitAutoScpData) {
        DynamicObject normalSplitConstraint;
        FilterBuilder filterBuilder;
        if (this.maxTime == null) {
            log.info("\u81ea\u52a8\u56de\u590d\u5931\u8d25\uff0c\u65e0\u9884\u6d4b\u6700\u5927\u65e5\u671f\u3002");
            return new HashMap<String, Map<String, BigDecimal>>(0);
        }
        Set<String> materialSet = splitAutoScpData.getMaterialSet();
        List<SplitEntry4AutoScp> splitEntry4AutoScpList = splitAutoScpData.getSplitEntry();
        if (materialSet.size() == 0 || splitEntry4AutoScpList.size() == 0) {
            log.info("\u81ea\u52a8\u56de\u590d\u5931\u8d25\uff0c\u67e5\u8be2\u6761\u4ef6\u4e0d\u5b58\u5728\u3002");
            return new HashMap<String, Map<String, BigDecimal>>(0);
        }
        HashMap<String, HashSet<String>> startDateMap = new HashMap<String, HashSet<String>>(16);
        for (SplitEntry4AutoScp splitEntry4AutoScp : splitEntry4AutoScpList) {
            String key = splitEntry4AutoScp.getSupplier() + "::" + splitEntry4AutoScp.getMaterial();
            String startDateString = DateHelper.getDateString(splitEntry4AutoScp.getStartDate(), "yyyy-MM-dd");
            HashSet<String> set = (HashSet<String>)startDateMap.get(key);
            if (set == null) {
                set = new HashSet<String>(8);
            }
            set.add(startDateString);
            startDateMap.put(key, set);
        }
        ArrayList supplierList = new ArrayList();
        ArrayList materialList = new ArrayList();
        CollectionUtils.collect(supplierIdList, input -> Long.valueOf(input.toString()), supplierList);
        if (materialSet.size() < 100) {
            CollectionUtils.collect(materialSet, input -> Long.valueOf(input.toString()), materialList);
        }
        if ((filterBuilder = SplitResultOp.convertStringToQFilter(normalSplitConstraint = this.getNormalSplitConstraint())) == null) {
            log.info("\u7ea6\u675f\u6761\u4ef6\u4e3a\u7a7a\u3002");
            return new HashMap<String, Map<String, BigDecimal>>(0);
        }
        QFilter qFilter = filterBuilder.getQFilter();
        Object orgId = normalSplitConstraint.getDynamicObject("org").getPkValue();
        qFilter.and(new QFilter("org", "=", orgId));
        qFilter.and(new QFilter("closestatus", "=", (Object)"A"));
        qFilter.and(new QFilter(SUPPLIER, "in", supplierList));
        qFilter.and(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        if (materialSet.size() < 100) {
            qFilter.and(new QFilter(ENTRY_MATERIAL, "in", materialList));
        }
        String selectFields = "id,billstatus,supplier,billentry.id,billentry.material,billentry.promisedate,billentry.baseqty,billentry.receivebaseqty";
        HashMap<String, Map<String, BigDecimal>> qtyMap = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)ENTRY_PROMISE);){
            if (dataSet == null) {
                log.info("\u81ea\u52a8\u56de\u590d\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\uff0c\u6570\u636e\u4e3anull\u3002");
                HashMap<String, Map<String, BigDecimal>> hashMap = new HashMap<String, Map<String, BigDecimal>>(0);
                return hashMap;
            }
            Date today = DateHelper.getStartOfDay(LocalDate.now());
            while (dataSet.hasNext()) {
                BigDecimal receiveQty;
                Set set;
                Row row = dataSet.next();
                Long supplierId = row.getLong(SUPPLIER);
                Long materialId = row.getLong(ENTRY_MATERIAL);
                Date promise = row.getDate(ENTRY_PROMISE);
                if (supplierId == null || materialId == null || promise == null || (set = (Set)startDateMap.get(supplierId + "::" + materialId)) == null || set.size() == 0) continue;
                BigDecimal qty = row.getBigDecimal(ENTRY_QTY);
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                if ((receiveQty = row.getBigDecimal(ENTRY_RECEIVE)) == null) {
                    receiveQty = BigDecimal.ZERO;
                }
                BigDecimal onRouteQty = qty.subtract(receiveQty);
                for (String startDateString : set) {
                    String key = supplierId + "::" + materialId + "::" + startDateString;
                    String dateString = this.getScpDateByPromiseDate(promise, today, startDateString);
                    if (dateString == null) continue;
                    HashMap<String, BigDecimal> dateMap = (HashMap<String, BigDecimal>)qtyMap.get(key);
                    if (dateMap == null) {
                        dateMap = new HashMap<String, BigDecimal>();
                        dateMap.put(dateString, onRouteQty);
                    } else {
                        BigDecimal qtySum = (BigDecimal)dateMap.get(dateString);
                        if (qtySum == null) {
                            qtySum = BigDecimal.ZERO;
                        }
                        dateMap.put(dateString, qtySum.add(onRouteQty));
                    }
                    qtyMap.put(key, dateMap);
                }
            }
        }
        return qtyMap;
    }

    private DynamicObject getNormalSplitConstraint() {
        String selectProperties = "org,number,name,constrainttype,sourcebill,srcbillcontion,srcbillcontion_tag";
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pm_splitconstraint", (String)selectProperties, (QFilter[])new QFilter[]{qFilter2});
    }

    private static FilterBuilder convertStringToQFilter(DynamicObject splitConstraint) {
        if (splitConstraint != null) {
            String srcBillCondition = splitConstraint.getString("srcbillcontion_tag");
            String srcType = splitConstraint.getDynamicObject("sourcebill").getString("number");
            if (StringUtils.isNotEmpty((String)srcBillCondition)) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)srcBillCondition, FilterCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
                fb.buildFilter();
                return fb;
            }
        }
        return null;
    }

    private String getScpDateByPromiseDate(Date promiseDate, Date compareDate, String startDateStr) {
        if (promiseDate == null || compareDate == null || startDateStr == null) {
            return null;
        }
        Date startDate = DateHelper.getDateByString(startDateStr, "yyyy-MM-dd");
        LocalDate startOfDay28 = DateHelper.date2LocalDate(startDate).plusDays(27L);
        LocalDate promiseLocalDate = DateHelper.date2LocalDate(promiseDate);
        if (!promiseDate.before(compareDate)) {
            if (promiseLocalDate.isBefore(startOfDay28.plusDays(1L))) {
                return DateHelper.getDateString(promiseDate, "yyyy-MM-dd");
            }
            return DateHelper.getDateString(DateHelper.getScpThisWeekDate(promiseLocalDate), "yyyy-MM-dd");
        }
        if (this.maxTime == null) {
            return null;
        }
        LocalDate compareLocalDate = DateHelper.date2LocalDate(compareDate);
        if (compareDate.before(startDate)) {
            return startDateStr;
        }
        if (compareLocalDate.isBefore(startOfDay28.plusDays(1L))) {
            return DateHelper.getDateString(compareDate, "yyyy-MM-dd");
        }
        if (compareLocalDate.isBefore(DateHelper.getNextNDayOfWeek(startOfDay28, 1))) {
            return null;
        }
        if (compareDate.before(this.maxTime)) {
            return DateHelper.getDateString(DateHelper.getScpThisWeekDate(compareLocalDate), "yyyy-MM-dd");
        }
        return null;
    }

    private List<SplitAutoScpData> getSplitAutoScpData(Set<String> supplierIdList) {
        String selectField = "t1.fid,t1.fsplitstatus,t2.fentryid,t2.fmaterialid,t2.fsupplierid,t1.fstartdate,t2.fsubtype";
        String querySplitEntrySql = "select " + selectField + " from t_pm_splitresult t1 inner join t_pm_resultentry t2 on t1.fid=t2.fid where t1.fid in(" + String.join((CharSequence)",", this.splitSuccessIds) + ") and t2.fsupplierid in (" + String.join((CharSequence)",", supplierIdList) + ")";
        ArrayList<SplitAutoScpData> splitAutoScpData = new ArrayList<SplitAutoScpData>(4);
        try (DataSet dataSet = DB.queryDataSet((String)"pm_splitresult", (DBRoute)DBRoute.of((String)"scm"), (String)querySplitEntrySql);){
            if (dataSet == null) {
                List<SplitAutoScpData> list = Collections.emptyList();
                return list;
            }
            ArrayList<SplitEntry4AutoScp> splitEntryList_forecast = new ArrayList<SplitEntry4AutoScp>();
            ArrayList<SplitEntry4AutoScp> splitEntryList_supplier = new ArrayList<SplitEntry4AutoScp>();
            ArrayList<SplitEntry4AutoScp> splitEntryList_adjust = new ArrayList<SplitEntry4AutoScp>();
            ArrayList<SplitEntry4AutoScp> splitEntryList_gap = new ArrayList<SplitEntry4AutoScp>();
            HashSet<String> materialSet = new HashSet<String>();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String subType = row.getString("fsubtype");
                if ("A".equals(subType)) {
                    splitEntryList_forecast.add(new SplitEntry4AutoScp(row.getLong(F_ENTRY_ID), row.getLong(F_SUPPLIER), row.getLong(F_MATERIAL), row.getDate(F_START_DATE), row.getLong(FID)));
                    continue;
                }
                if ("B".equals(subType)) {
                    splitEntryList_supplier.add(new SplitEntry4AutoScp(row.getLong(F_ENTRY_ID), row.getLong(F_SUPPLIER), row.getLong(F_MATERIAL), row.getDate(F_START_DATE), row.getLong(FID)));
                    materialSet.add(String.valueOf(row.getLong(F_SUPPLIER)));
                    continue;
                }
                if ("C".equals(subType)) {
                    splitEntryList_adjust.add(new SplitEntry4AutoScp(row.getLong(F_ENTRY_ID), row.getLong(F_SUPPLIER), row.getLong(F_MATERIAL), row.getDate(F_START_DATE), row.getLong(FID)));
                    continue;
                }
                if (!"D".equals(subType)) continue;
                splitEntryList_gap.add(new SplitEntry4AutoScp(row.getLong(F_ENTRY_ID), row.getLong(F_SUPPLIER), row.getLong(F_MATERIAL), row.getDate(F_START_DATE), row.getLong(FID)));
            }
            splitAutoScpData.add(new SplitAutoScpData(splitEntryList_forecast, materialSet));
            splitAutoScpData.add(new SplitAutoScpData(splitEntryList_supplier, materialSet));
            splitAutoScpData.add(new SplitAutoScpData(splitEntryList_adjust, materialSet));
            splitAutoScpData.add(new SplitAutoScpData(splitEntryList_gap, materialSet));
        }
        return splitAutoScpData;
    }

    private Set<String> getSupplierIds() {
        QFilter qFilter = new QFilter("issuppcolla", "=", (Object)Boolean.FALSE);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            return new HashSet<String>(0);
        }
        return dynamicObjectMap.values().stream().map(dynamicObject -> String.valueOf(dynamicObject.getLong("id"))).collect(Collectors.toSet());
    }

    private List<String> getFieldKey() {
        String splitChar = ".";
        ArrayList<String> fieldKey = new ArrayList<String>();
        fieldKey.add(PLAN_ID);
        fieldKey.add(START_DATE);
        fieldKey.add("splitstatus");
        fieldKey.add("org");
        fieldKey.add("mrpentry");
        fieldKey.add("mrpentry" + splitChar + "mrp_purorg");
        fieldKey.add("mrpentry" + splitChar + "mrp_material");
        fieldKey.add("mrpentry" + splitChar + "mrp_masterid");
        fieldKey.add("mrpentry" + splitChar + "mrp_baseunit");
        fieldKey.addAll(this.getClassFieldName(UpdateFieldsDTO.class, "mrpentry" + splitChar + "mrp_"));
        return fieldKey;
    }

    private <T> List<String> getClassFieldName(Class<T> cls, String prefix) {
        if (cls == null) {
            return new ArrayList<String>(0);
        }
        Field[] fields = cls.getDeclaredFields();
        ArrayList<String> fieldName = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            fieldName.add(prefix + field.getName());
        }
        return fieldName;
    }
}

