/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.report;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.pm.forecast.business.helper.ReportGAPHelper;

public class MaterialGAPReportOperaPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(MaterialGAPReportOperaPlugin.class);
    private final String algo = ((Object)((Object)this)).getClass().getSimpleName();

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl("plancalculateno");
        textEdit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long defaultPurOrg = ReportGAPHelper.getDefaultOrg(this.getView().getEntityId(), "02");
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        if (defaultPurOrg != null) {
            model.setValue("purorgid", (Object)defaultPurOrg);
        } else {
            QFilter qFilter = new QFilter("purorgid", "=", null);
            filterParameter.setFilter(qFilter);
            billList.setFilterParameter(filterParameter);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u91c7\u8d2d\u7ec4\u7ec7", (String)"MaterialGAPReportOperaPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
        }
        QFilter[] filters = QFilter.isNotNull((String)"createtime").and("splitstatus", "in", (Object)new String[]{"A", "B", "C", "D"}).toArray();
        try (DataSet rows = ORM.create().queryDataSet(this.algo, "pm_splitresult", "plancalcnum, id", filters, "createtime desc", 1);){
            if (rows.hasNext()) {
                Row row = rows.next();
                model.setValue("plancalculateno", (Object)row.getString("plancalcnum"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (!(oldValue instanceof BigDecimal) || !(newValue instanceof BigDecimal) || ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0) continue;
            return;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String plancalculateno = filter.getString("plancalculateno");
        if (plancalculateno == null || "".equals(plancalculateno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6:\u3010\u8ba1\u5212\u8fd0\u7b97\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MaterialGAPReportOperaPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"plancalculateno", (CharSequence)control.getKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pm_splitresult", (boolean)false);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("splitstatus", "in", (Object)new String[]{"A", "B", "C", "D"}));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "plancalculateno");
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)"plancalculateno", (CharSequence)actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            Object primaryKeyValue = listSelectedRows.get(0).getPrimaryKeyValue();
            QFilter[] filters = new QFilter("id", "=", primaryKeyValue).toArray();
            try (DataSet rows = ORM.create().queryDataSet(this.algo, "pm_splitresult", "plancalcnum,id", filters, null, 1);){
                if (rows.hasNext()) {
                    Row row = rows.next();
                    this.getModel().setValue("plancalculateno", (Object)row.getString("plancalcnum"));
                }
            }
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            if (!"material".equals(event.getColumnName()) && !"materialnumber".equals(event.getColumnName()) && !"materialname".equals(event.getColumnName()) && !"type".equals(event.getColumnName()) && !"subtype".equals(event.getColumnName())) continue;
            event.setSort(true);
            event.setFilter(true);
        }
    }
}

