/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecast.report;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.forecast.business.helper.DateHelper;
import kd.scmc.pm.forecast.business.helper.ReportGAPHelper;
import kd.scmc.pm.forecast.business.pojo.MaterialGAPDto;
import kd.scmc.pm.forecast.report.MaterialGAPReportOperaPlugin;

public class MaterialGAPReportQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(MaterialGAPReportOperaPlugin.class);
    private static final String KEY_MATERIAL = "material";
    private static final String planCalcNum = "plancalcnum";
    private static final String[] groupByFields = new String[]{"plancalcnum", "material", "purorg", "type", "subtype", "mrpentryid"};

    public DataSet query(ReportQueryParam queryParam, Object obj) {
        String finalFilterString;
        boolean existsGap;
        List<DataSet> calculateList;
        String sort;
        String srcField;
        int i;
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter[] qFilter = this.getQFilter(filterInfo);
        List<QFilter> filterList = Arrays.stream(qFilter).collect(Collectors.toList());
        String orderBy = "resultentry.material,resultentry.type,resultentry.subtype";
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_splitresult", (String)this.initQueryFields(), (QFilter[])filterList.toArray(new QFilter[0]), (String)orderBy);
        GroupbyDataSet groupBy = queryDataSet.groupBy(groupByFields);
        for (i = 1; i < 29; ++i) {
            srcField = "day" + i;
            groupBy.sum(srcField);
            if (i % 7 != 0) continue;
            String srcSumField = "week" + i + "A";
            groupBy.sum(srcSumField);
        }
        for (i = 1; i < 76; ++i) {
            srcField = "week" + i;
            groupBy.sum(srcField);
        }
        DataSet finish = groupBy.finish();
        LinkedList<String> orderByList = new LinkedList<String>();
        String sortInfo = queryParam.getSortInfo();
        if (sortInfo != null && orderBy.contains(sort = sortInfo.replaceAll(" desc", "").replaceAll(" asc", ""))) {
            orderByList.add(sortInfo);
        }
        if ((calculateList = this.calculate((finish = finish.filter("subtype in ('A','B','C')")).copy())).size() > 0) {
            for (DataSet data : calculateList) {
                finish = finish.union(data);
                if (data == null) continue;
                data.close();
            }
        }
        if (existsGap = filterInfo.getBoolean("exists_gap")) {
            int i2;
            ArrayList<String> existsgap2 = new ArrayList<String>(103);
            for (i2 = 1; i2 <= 28; ++i2) {
                existsgap2.add("day" + i2 + " < 0");
            }
            for (i2 = 1; i2 <= 75; ++i2) {
                existsgap2.add("week" + i2 + " < 0");
            }
            String filter = String.join((CharSequence)" or ", existsgap2);
            finish = finish.filter(filter);
        }
        if (orderByList.size() <= 0) {
            orderByList.add(KEY_MATERIAL);
            orderByList.add("type");
            orderByList.add("subtype");
        }
        List headFilterList = queryParam.getFilter().getHeadFilters();
        StringBuilder filterSb = new StringBuilder();
        if (headFilterList != null && headFilterList.size() > 0) {
            for (QFilter headFilter : headFilterList) {
                QFilter filter = new QFilter("resultentry." + headFilter.getProperty(), headFilter.getCP(), headFilter.getValue());
                if (filterSb.length() > 0) {
                    filterSb.append(" and ").append(filter);
                    continue;
                }
                filterSb.append(filter);
            }
        }
        if ((finalFilterString = filterSb.toString().replaceAll("resultentry.", "")).length() > 0) {
            finish = finish.filter(finalFilterString);
        }
        finish = finish.orderBy(orderByList.toArray(new String[0]));
        queryDataSet.close();
        return finish;
    }

    private List<DataSet> calculate(DataSet dataSet) {
        DataSet finish = dataSet.copy();
        DataSet temp = dataSet.copy();
        Iterator iterator = dataSet.iterator();
        ArrayList<MaterialGAPDto> list = new ArrayList<MaterialGAPDto>();
        while (iterator.hasNext()) {
            MaterialGAPDto gapDto;
            Row row = (Row)iterator.next();
            String material = row.getString(KEY_MATERIAL);
            Object splitMap = null;
            LinkedHashMap<String, Row> adjustMap = null;
            for (Row row_tmp : temp.copy()) {
                String subtype_tmp = row_tmp.getString("subtype");
                String material_tmp = row_tmp.getString(KEY_MATERIAL);
                if ("A".equals(subtype_tmp) && material_tmp.equals(material)) {
                    splitMap = new LinkedHashMap();
                    splitMap.put(material_tmp, row_tmp);
                }
                if (!"C".equals(subtype_tmp) || !material_tmp.equals(material)) continue;
                adjustMap = new LinkedHashMap<String, Row>();
                adjustMap.put(material, row_tmp);
            }
            if (splitMap == null || adjustMap == null || this.isExists(list, gapDto = new MaterialGAPDto((Map<String, Row>)splitMap, (Map<String, Row>)adjustMap, material))) continue;
            list.add(gapDto);
        }
        LinkedList<String> sqlList = new LinkedList<String>();
        LinkedHashMap<String, String> leftMap = new LinkedHashMap<String, String>();
        for (MaterialGAPDto materialGAPDto : list) {
            String value;
            String lastValue;
            Row adjustRow;
            Row splitRow;
            StringBuilder key;
            int i;
            leftMap.clear();
            Map<String, Row> splitMap = materialGAPDto.getSplitMap();
            Map<String, Row> adjustMap = materialGAPDto.getAdjustMap();
            Row row = adjustMap.get(materialGAPDto.getMaterial());
            StringBuilder executeSql = new StringBuilder("select ");
            if (row != null) {
                executeSql.append('\'').append(row.getString(planCalcNum)).append("' as plancalcnum").append(',');
                executeSql.append(row.getString(KEY_MATERIAL)).append(" as material").append(',');
                executeSql.append(row.getString("purorg")).append(" as purorg").append(',');
                executeSql.append('\'').append(row.getString("type")).append("' as type").append(',');
                executeSql.append("'D' as subtype").append(',');
                executeSql.append(row.getLong("mrpentryid")).append(" as mrpentryid");
            }
            for (i = 0; i < 28; ++i) {
                key = new StringBuilder();
                key.append("day").append(i + 1);
                splitRow = splitMap.get(materialGAPDto.getMaterial());
                adjustRow = adjustMap.get(materialGAPDto.getMaterial());
                if (splitRow == null || adjustRow == null) continue;
                if (i > 0) {
                    lastValue = (String)leftMap.get("day" + i);
                    value = adjustRow.getBigDecimal(key.toString()).subtract(splitRow.getBigDecimal(key.toString())).add(new BigDecimal(lastValue == null ? "0" : lastValue)).longValue() + "";
                    leftMap.put(key.toString(), value);
                    executeSql.append(", ").append(value).append(" as ").append((CharSequence)key);
                    if ((i + 1) % 7 != 0) continue;
                    String kw = "week" + (i + 1) + "A";
                    String kd = "day" + (i + 1);
                    leftMap.put(kw, (String)leftMap.get(kd));
                    executeSql.append(", ").append((String)leftMap.get(kd)).append(" as ").append(kw);
                    continue;
                }
                String value2 = adjustRow.getBigDecimal(key.toString()).subtract(splitRow.getBigDecimal(key.toString())).longValue() + "";
                leftMap.put(key.toString(), value2);
                executeSql.append(", ").append(value2).append(" as ").append((CharSequence)key);
            }
            for (i = 0; i < 75; ++i) {
                key = new StringBuilder();
                key.append("week").append(i + 1);
                splitRow = splitMap.get(materialGAPDto.getMaterial());
                adjustRow = adjustMap.get(materialGAPDto.getMaterial());
                if (splitRow == null || adjustRow == null) continue;
                if (i > 0) {
                    lastValue = (String)leftMap.get("week" + i);
                    value = adjustRow.getBigDecimal(key.toString()).subtract(splitRow.getBigDecimal(key.toString())).add(new BigDecimal(lastValue == null ? "0" : lastValue)).longValue() + "";
                    leftMap.put(key.toString(), value);
                    executeSql.append(", ").append(value).append(" as ").append((CharSequence)key);
                    continue;
                }
                String day28 = (String)leftMap.get("day28");
                value = adjustRow.getBigDecimal(key.toString()).subtract(splitRow.getBigDecimal(key.toString())).add(new BigDecimal(day28 == null ? "0" : day28)).longValue() + "";
                leftMap.put(key.toString(), value);
                executeSql.append(", ").append(value).append(" as ").append((CharSequence)key);
            }
            executeSql.append(" from dual ");
            sqlList.add(executeSql.toString());
        }
        finish = finish.groupBy(new String[]{planCalcNum, KEY_MATERIAL}).finish();
        DataSet tempDataSet = finish.copy().top(1);
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>();
        if (sqlList.size() > 0) {
            for (int i = 0; i < sqlList.size(); ++i) {
                DataSet data = tempDataSet.executeSql((String)sqlList.get(i));
                dataSetList.add(data);
            }
        }
        if (tempDataSet != null) {
            tempDataSet.close();
        }
        if (temp != null) {
            temp.close();
        }
        finish.close();
        return dataSetList;
    }

    private boolean isExists(List<MaterialGAPDto> list, MaterialGAPDto gapDto) {
        List temp = list.stream().filter(dto -> dto.getMaterial().equals(gapDto.getMaterial())).collect(Collectors.toList());
        return temp.size() > 0;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String startdate = null;
        DynamicObject[] splitresults = BusinessDataServiceHelper.load((String)"pm_splitresult", (String)"billno,startdate", (QFilter[])this.getQFilter(filterInfo));
        if (splitresults != null && splitresults.length > 0) {
            startdate = splitresults[0].getString("startdate");
        }
        if (columns != null && columns.size() > 0) {
            for (AbstractReportColumn column : columns) {
                ReportColumn reportColumn = (ReportColumn)column;
                if (!planCalcNum.equals(reportColumn.getFieldKey()) && !KEY_MATERIAL.equals(reportColumn.getFieldKey()) && !"materialnumber".equals(reportColumn.getFieldKey()) && !"materialname".equals(reportColumn.getFieldKey()) && !"type".equals(reportColumn.getFieldKey()) && !"subtype".equals(reportColumn.getFieldKey())) continue;
                reportColumn.setFreeze(true);
            }
        }
        if (startdate == null || "".equals(startdate)) {
            return super.getColumns(columns);
        }
        String datePattern = "yyyy-MM-dd";
        LocalDate localdate = LocalDate.parse(DateHelper.getDateString(DateHelper.getDateByString(startdate, datePattern), datePattern));
        ArrayList<ReportColumn> columns_sum = new ArrayList<ReportColumn>();
        String[] forecastDays = DateHelper.getForecastDays(DateHelper.getDateByString(startdate, datePattern), "MM-dd", "yyyy-MM-dd");
        if (columns == null) {
            columns = new ArrayList<AbstractReportColumn>(forecastDays.length);
        }
        for (int i = 0; i < forecastDays.length; ++i) {
            ReportColumn column;
            StringBuilder key;
            if (i < 28) {
                key = new StringBuilder();
                key.append("day").append(i + 1);
                column = ReportGAPHelper.createDecimalColumn(forecastDays[i], key);
                column.setZeroShow(true);
                column.setFieldType("integer");
                columns.add((AbstractReportColumn)column);
                if (i <= 0 || (i + 1) % 7 != 0) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("week").append(i + 1).append('A');
                ReportColumn column_sum = ReportGAPHelper.createDecimalColumn(localdate.plusDays(i - 6).toString(), sb);
                column_sum.setZeroShow(true);
                column_sum.setFieldType("integer");
                columns_sum.add(column_sum);
                continue;
            }
            if (i == 28) {
                columns.addAll(columns_sum);
            }
            key = new StringBuilder();
            key.append("week").append(i - 27);
            column = ReportGAPHelper.createDecimalColumn(forecastDays[i], key);
            column.setZeroShow(true);
            column.setFieldType("integer");
            columns.add((AbstractReportColumn)column);
        }
        return super.getColumns(columns);
    }

    private String initQueryFields() {
        String tarField;
        String srcField;
        int i;
        StringJoiner selectListFields = new StringJoiner(",", "", "");
        selectListFields.add(planCalcNum);
        selectListFields.add("resultentry.material as material");
        selectListFields.add("org as purorg");
        selectListFields.add("resultentry.type as type");
        selectListFields.add("resultentry.subtype as subtype");
        selectListFields.add("resultentry.mrpentryid as mrpentryid");
        ArrayList<String> selectSeekSum = new ArrayList<String>(7);
        for (i = 1; i < 29; ++i) {
            srcField = "resultentry.day" + i;
            tarField = "day" + i;
            selectListFields.add(srcField.concat(" as ").concat(tarField));
            selectSeekSum.add(srcField);
            if (i % 7 != 0) continue;
            String weekSum = String.join((CharSequence)"+", selectSeekSum);
            selectListFields.add(weekSum.concat(" as ").concat("week" + i + "A"));
            selectSeekSum.clear();
        }
        for (i = 1; i < 76; ++i) {
            srcField = "resultentry.week" + i;
            tarField = "week" + i;
            selectListFields.add(srcField.concat(" as ").concat(tarField));
        }
        return selectListFields.toString();
    }

    private QFilter[] getQFilter(FilterInfo filterInfo) {
        DynamicObject materialbase;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        String plancalculateno = filterInfo.getString("plancalculateno");
        if (plancalculateno != null) {
            filters.add(new QFilter(planCalcNum, "=", (Object)plancalculateno.trim()));
        }
        if ((materialbase = filterInfo.getDynamicObject("materialbase")) != null) {
            filters.add(new QFilter("resultentry.material", "=", materialbase.get("id")));
        }
        return filters.toArray(new QFilter[0]);
    }
}

