/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.business.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static final Log log = LogFactory.getLog(ExcelUtil.class);

    public static List<List<String>> readExcel(InputStream inputStream) {
        XSSFWorkbook workbook1 = null;
        try {
            workbook1 = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            log.error(Arrays.toString(e.getStackTrace()));
        }
        catch (NotOfficeXmlFileException e1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u88ab\u52a0\u5bc6\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8bd5\u3002", (String)"ExcelUtil_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
        }
        if (workbook1 == null) {
            return new ArrayList<List<String>>(10);
        }
        XSSFSheet sheet = workbook1.getSheetAt(0);
        int rowCount = sheet.getPhysicalNumberOfRows();
        int lastCellNum = sheet.getRow(0).getLastCellNum();
        ArrayList<List<String>> rowList = new ArrayList<List<String>>(10);
        for (int rowNum = 0; rowNum <= rowCount; ++rowNum) {
            ArrayList<String> rowString = new ArrayList<String>(10);
            Row rowData = sheet.getRow(rowNum);
            if (rowData == null) continue;
            for (int cellNum = 0; cellNum <= lastCellNum; ++cellNum) {
                Cell cell = rowData.getCell(cellNum, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                String cellValue = "";
                if (cell != null) {
                    CellType cellType = cell.getCellType();
                    switch (cellType) {
                        case STRING: {
                            cellValue = cell.getStringCellValue();
                            break;
                        }
                        case BOOLEAN: {
                            cellValue = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        case BLANK: {
                            break;
                        }
                        case NUMERIC: {
                            cell.setCellType(CellType.STRING);
                            cellValue = cell.toString();
                            break;
                        }
                    }
                }
                rowString.add(cellValue);
            }
            rowList.add(rowString);
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            log.error(Arrays.toString(e.getStackTrace()));
        }
        return rowList;
    }
}

