/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.business.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FastExcelUtils {
    private String handlerType;
    private InputStream in;
    private List<List<String>> exceldata = new ArrayList<List<String>>();
    private static final Log log = LogFactory.getLog(FastExcelUtils.class);

    public static List<List<String>> convertExcelToList(InputStream in) {
        FastExcelUtils fastExcelUtils = new FastExcelUtils();
        try {
            fastExcelUtils = new FastExcelUtils(in, "A");
            fastExcelUtils.parse();
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
        }
        return fastExcelUtils.getExcelData();
    }

    public FastExcelUtils(InputStream in, String handlerType) {
        this.in = in;
        this.handlerType = handlerType;
    }

    public FastExcelUtils() {
    }

    public List<List<String>> getExcelData() {
        return this.exceldata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws Exception {
        OPCPackage pkg = null;
        InputStream sheetInputStream = null;
        try {
            pkg = OPCPackage.open((InputStream)this.in);
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable styles = xssfReader.getStylesTable();
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
            sheetInputStream = (InputStream)xssfReader.getSheetsData().next();
            this.processSheet(styles, strings, sheetInputStream);
        }
        finally {
            if (sheetInputStream != null) {
                sheetInputStream.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (pkg != null) {
                pkg.close();
            }
        }
    }

    private void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws SAXException, IOException {
        XMLReader sheetParser = XMLReaderFactory.createXMLReader();
        sheetParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        sheetParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        sheetParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        sheetParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        if ("A".equals(this.handlerType)) {
            sheetParser.setContentHandler((ContentHandler)new XSSFSheetXMLHandler((Styles)styles, (SharedStrings)strings, (XSSFSheetXMLHandler.SheetContentsHandler)new CustomExcelHandler(), false));
        } else if ("B".equals(this.handlerType)) {
            sheetParser.setContentHandler((ContentHandler)new XSSFSheetXMLHandler((Styles)styles, (SharedStrings)strings, (XSSFSheetXMLHandler.SheetContentsHandler)new SimpleSheetContentsHandler(), false));
        }
        sheetParser.parse(new InputSource(sheetInputStream));
    }

    public class ExcelListener
    extends AnalysisEventListener<List<String>> {
        public void doAfterAllAnalysed(AnalysisContext arg0) {
        }

        public void invoke(List<String> object, AnalysisContext context) {
            if (object != null) {
                FastExcelUtils.this.exceldata.add(object);
            }
        }
    }

    public class CustomExcelHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private int preColNum = -1;
        protected List<String> rows;

        public void startRow(int i) {
            this.preColNum = -1;
            this.rows = new ArrayList<String>(16);
        }

        public void endRow(int i) {
            boolean isAllEmpty = true;
            for (String value : this.rows) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                isAllEmpty = false;
                break;
            }
            if (!isAllEmpty) {
                FastExcelUtils.this.exceldata.add(this.rows);
            }
        }

        public void cell(String cellReference, String formattedValue, XSSFComment xssfComment) {
            short currColNum = new CellReference(cellReference).getCol();
            int missColNum = currColNum - this.preColNum - 1;
            for (int i = 0; i < missColNum; ++i) {
                this.rows.add("");
            }
            this.preColNum = currColNum;
            this.rows.add(formattedValue);
        }

        public void headerFooter(String s, boolean b, String s1) {
        }
    }

    public static class SimpleSheetContentsHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        protected List<String> rowdata = new ArrayList<String>();

        public void startRow(int rowNum) {
            this.rowdata.clear();
        }

        public void endRow(int rowNum) {
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            this.rowdata.add(formattedValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

