/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;

public class AbstractForecastPlanImportFormPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(AbstractForecastPlanImportFormPlugin.class);
    private static final String ATTACHMENTPANEL = "attachmentpanelap";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_VIEW = "btn_view";
    private static final String CACHEKEY_URL = "errorFileUrl";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String CACHEKEY_COMPLETE = "complete";
    private static final String CACHEKEY_EXCEPTION = "exception";
    private static final String CACHEKEY_VALIDATE_ERROR = "validate_error";
    private static final String CACHEKEY_ALL_ROW = "cache_all_row";
    private static final String CACHEKEY_SUCCESS_ROW = "cache_success_row";
    private static final String CACHEKEY_IS_ERROR = "cache_is_error";
    private static final int MAX_COLWIDTH = 18215;
    protected static final int DEFAULT_BATCHSIZE = 100;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_VIEW});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEW});
    }

    public void beforeClick(BeforeClickEvent evt) {
        List<Map<String, Object>> attachmentDataList;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)control.getKey()) && (attachmentDataList = this.getAttachmentData()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"AbstractForecastPlanImportFormPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"AbstractForecastPlanImportFormPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0])));
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.start();
        } else if (BTN_VIEW.equals(key)) {
            String tempUrl = this.getPageCache().get(CACHEKEY_URL);
            IFormView view = this.getView();
            view.download(tempUrl);
            view.setVisible(Boolean.FALSE, new String[]{BTN_VIEW});
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getProgress();
        if (progress == 0) {
            this.setProgress(1);
            this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"AbstractForecastPlanImportFormPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            RequestContext rc = RequestContextCreator.createForThreadPool();
            RequestContextRunnable runnable = new RequestContextRunnable(() -> this.execute(), rc);
            ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), (Runnable)runnable);
            return;
        }
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String exceptionStack = pageCache.get(CACHEKEY_EXCEPTION);
        String validateError = pageCache.get(CACHEKEY_VALIDATE_ERROR);
        String completed = pageCache.get(CACHEKEY_COMPLETE);
        if (exceptionStack != null) {
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            this.removeCache();
            view.hideLoading();
            view.showTipNotification(exceptionStack);
        } else if (validateError != null && !validateError.isEmpty()) {
            List validateErrors = (List)SerializationUtils.fromJsonString((String)validateError, List.class);
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            this.removeCache();
            view.hideLoading();
            StringBuilder errorMsg = new StringBuilder();
            validateErrors.forEach(errorStr -> errorMsg.append((String)errorStr));
            this.getView().showErrorNotification(errorMsg.toString());
        } else if (completed != null) {
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            this.removeCache();
            view.returnDataToParent((Object)completed);
            view.close();
        } else {
            String tip = this.getTip();
            view.showProgressLoading(new LocaleString(tip), progress);
        }
    }

    protected void setProgress(int progress) {
        this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(progress));
    }

    private int getProgress() {
        String str = this.getPageCache().get(CACHEKEY_PROGRESS);
        return StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    protected void setTip(String tip) {
        this.getPageCache().put(CACHEKEY_TIP, tip);
    }

    private String getTip() {
        return this.getPageCache().get(CACHEKEY_TIP);
    }

    protected void setCompleted() {
        this.getPageCache().put(CACHEKEY_COMPLETE, String.valueOf(true));
    }

    protected void setExceptionStack(Exception exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        String message = exception.getMessage();
        String stack = StringUtils.isBlank((CharSequence)message) ? Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")) : message;
        this.getPageCache().put(CACHEKEY_EXCEPTION, String.format(ResManager.loadKDString((String)"\u89e3\u6790EXCEL\u6587\u4ef6\u51fa\u9519 : %1$s", (String)"AbstractForecastPlanImportFormPlugin_3", (String)"scmc-pm-forecast", (Object[])new Object[0]), stack));
    }

    private void execute() {
        try (InputStream inputStream = this.getInputStream();){
            HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(10);
            ArrayList<String> validateErrors = new ArrayList<String>();
            this.dealData(inputStream, result, validateErrors);
            this.getPageCache().put(CACHEKEY_COMPLETE, SerializationUtils.toJsonString(result));
            if (!validateErrors.isEmpty()) {
                this.getPageCache().put(CACHEKEY_VALIDATE_ERROR, SerializationUtils.toJsonString(validateErrors));
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            this.setExceptionStack(e);
        }
    }

    protected void setRowCache(int allRow, int successRow) {
        this.getPageCache().put(CACHEKEY_ALL_ROW, String.valueOf(allRow));
        this.getPageCache().put(CACHEKEY_SUCCESS_ROW, String.valueOf(successRow));
    }

    protected void setAllError(boolean isError) {
        this.getPageCache().put(CACHEKEY_IS_ERROR, String.valueOf(isError));
    }

    private void removeCache() {
        this.getPageCache().remove(CACHEKEY_PROGRESS);
        this.getPageCache().remove(CACHEKEY_EXCEPTION);
        this.getPageCache().remove(CACHEKEY_VALIDATE_ERROR);
        this.getPageCache().remove(CACHEKEY_IS_ERROR);
        this.getPageCache().remove(CACHEKEY_ALL_ROW);
        this.getPageCache().remove(CACHEKEY_SUCCESS_ROW);
    }

    private InputStream getInputStream() {
        List<Map<String, Object>> attachmentDataList = this.getAttachmentData();
        Map<String, Object> attachmentData = attachmentDataList.get(0);
        String fileUrl = (String)attachmentData.get("url");
        Map<String, String> parseUrl = this.parseUrl(fileUrl);
        TempFileCacheDownloadable downLoadCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoadCache.get(parseUrl.get("configKey"), parseUrl.get("id"));
        return content.getInputStream();
    }

    private List<Map<String, Object>> getAttachmentData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        return attachmentPanel.getAttachmentData();
    }

    protected void dealData(InputStream excelInputStream, Map<String, List<Object>> result, List<String> validateErrors) {
    }

    private Map<String, String> parseUrl(String url) {
        String[] pairStr = url.split("\\?");
        String[] pairs = pairStr[1].split("&");
        HashMap<String, String> result = new HashMap<String, String>(2);
        int index0 = 0;
        int index1 = 1;
        for (String pair : pairs) {
            String[] p = pair.split("=");
            result.put(p[index0], p[index1]);
        }
        return result;
    }
}

