/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;

public abstract class AbstractForecastPlanImportPlugin
extends AbstractBillPlugIn {
    private static final String OPKEY_IMPORTENTRY = "importentry";
    private static final String ENTITY_FPIMPORTFORM = "pm_forecasplanimport";
    private static final String CLOSECALLBACK_IMPORT = "import";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String errorMsg;
        super.beforeDoOperation(e);
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        if (OPKEY_IMPORTENTRY.equals(operateKey) && StringUtils.isNotBlank((CharSequence)(errorMsg = this.checkMustInput()))) {
            e.setCancel(true);
            this.getView().showTipNotification(errorMsg);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (OPKEY_IMPORTENTRY.equals(operateKey)) {
            FormShowParameter fsp = new FormShowParameter();
            FormOperate formOperate = (FormOperate)e.getSource();
            Map parameter = formOperate.getParameter();
            if (parameter != null) {
                fsp.getCustomParams().putAll(parameter);
            }
            fsp.setFormId(ENTITY_FPIMPORTFORM);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_IMPORT));
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLOSECALLBACK_IMPORT.equals(actionId)) {
            Object returnData = e.getReturnData();
            if (StringUtils.isBlank((Object)returnData)) {
                return;
            }
            Map importData = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            List valuekeys = (List)importData.get("valuekeys");
            List valuelist = (List)importData.get("valuelist");
            if (valuekeys == null || valuekeys.isEmpty() || valuelist == null || valuelist.isEmpty()) {
                return;
            }
            int idIndex = valuekeys.indexOf("id");
            List<List<Object>> hasIdDataList = this.filterListDataById(idIndex, valuelist, true);
            List<List<Object>> hasNoIdDataList = this.filterListDataById(idIndex, valuelist, false);
            Map<Long, Map<String, Object>> hasErrorEntryId = null;
            if (hasIdDataList.size() > 0) {
                hasErrorEntryId = this.updateBillEntryById(idIndex, valuekeys, hasIdDataList);
            }
            if (hasNoIdDataList.size() > 0 || hasErrorEntryId != null && !hasErrorEntryId.isEmpty()) {
                this.insertBillEntry(idIndex, valuekeys, hasNoIdDataList, hasErrorEntryId);
            }
        }
    }

    protected abstract Map<Long, Map<String, Object>> updateBillEntryById(int var1, List<Object> var2, List<List<Object>> var3);

    protected Map<Long, Map<String, Object>> getEntryIdAndValueList(int idIndex, List<Object> valuekeys, List<List<Object>> hasIdDataList) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(10);
        for (int i = 0; i < hasIdDataList.size(); ++i) {
            List<Object> valueList = hasIdDataList.get(i);
            Long entryId = (Long)valueList.get(idIndex);
            Map<String, Object> oneRowKeyValueMap = this.convertListValueToMapExcludeId(valuekeys, valueList, idIndex);
            result.put(entryId, oneRowKeyValueMap);
        }
        return result;
    }

    protected Map<String, Object> convertListValueToMapExcludeId(List<Object> valuekeys, List<Object> valueList, int idIndex) {
        HashMap<String, Object> oneRowKeyValueMap = new HashMap<String, Object>(valuekeys.size());
        for (int j = 0; j < valuekeys.size(); ++j) {
            String key = (String)valuekeys.get(j);
            if (j == idIndex || StringUtils.isBlank((CharSequence)key)) continue;
            Object value = valueList.get(j);
            oneRowKeyValueMap.put(key, value);
        }
        return oneRowKeyValueMap;
    }

    protected abstract void insertBillEntry(int var1, List<Object> var2, List<List<Object>> var3, Map<Long, Map<String, Object>> var4);

    protected List<List<Object>> filterListDataById(int idIndex, List<Object> valuelist, boolean isHasId) {
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>(10);
        for (int i = 0; i < valuelist.size(); ++i) {
            List oneRowValue = (List)valuelist.get(i);
            Long entryId = Long.parseLong(oneRowValue.get(idIndex).toString());
            if (entryId.equals(0L) && !isHasId) {
                resultList.add(oneRowValue);
                continue;
            }
            if (entryId.equals(0L) || !isHasId) continue;
            resultList.add(oneRowValue);
        }
        return resultList;
    }

    protected String checkMustInput() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("forecastplanscheme");
        Date planStartDate = (Date)this.getModel().getValue("planstartdate");
        String dateColumnJson = (String)this.getModel().getValue("datecolumnjson_tag");
        if (scheme == null || planStartDate == null || StringUtils.isBlank((CharSequence)dateColumnJson)) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u548c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractForecastPlanImportPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0]);
        }
        return null;
    }
}

