/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanBillHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import kd.scmc.pm.forecastplan.common.enums.SupplyTypeEnums;
import kd.scmc.pm.forecastplan.formplugin.AbstractForecastPlanImportPlugin;

public class ForecastPlanBillImportPlugin
extends AbstractForecastPlanImportPlugin {
    private static final String CACHE_KEY_SUPPLYTYPE = "cache_key_supplytype";
    private static final String CACHE_KEY_DATECOLUMN_LIST = "cache_key_datecolumn_list";
    private static final String OPKEY_IMPORTENTRY = "importentry";
    private static final String CACHE_KEY_MUSTINPUT = "mustinput";

    @Override
    public Map<Long, Map<String, Object>> updateBillEntryById(int idIndex, List<Object> valuekeys, List<List<Object>> hasIdDataList) {
        Map<Long, Map<String, Object>> entryIdAndValueList = this.getEntryIdAndValueList(idIndex, valuekeys, hasIdDataList);
        ArrayList<Long> matchEntryIds = new ArrayList<Long>(10);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            Long entryId;
            Map<String, Object> oneRowMap;
            String type = (String)this.getModel().getValue("type", i);
            if (!SupplyTypeEnums.A.getValue().equals(type) || (oneRowMap = entryIdAndValueList.get(entryId = (Long)this.getModel().getValue("entryentity.id", i))) == null) continue;
            for (Map.Entry<String, Object> entry : oneRowMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.getModel().setValue(key, value, i);
            }
            matchEntryIds.add(entryId);
        }
        matchEntryIds.forEach(matchEntryId -> {
            Map cfr_ignored_0 = (Map)entryIdAndValueList.remove(matchEntryId);
        });
        return entryIdAndValueList;
    }

    @Override
    public void insertBillEntry(int idIndex, List<Object> valuekeys, List<List<Object>> hasNoIdDataList, Map<Long, Map<String, Object>> hasErrorEntryId) {
        ArrayList<Map<String, Object>> allInsertValueMap = new ArrayList<Map<String, Object>>(10);
        if (hasErrorEntryId != null) {
            Collection<Map<String, Object>> values = hasErrorEntryId.values();
            for (Map<String, Object> oneRowValue : values) {
                allInsertValueMap.add(oneRowValue);
            }
        }
        for (int i = 0; i < hasNoIdDataList.size(); ++i) {
            List<Object> valueList = hasNoIdDataList.get(i);
            Map<String, Object> oneRowKeyValueMap = this.convertListValueToMapExcludeId(valuekeys, valueList, idIndex);
            allInsertValueMap.add(oneRowKeyValueMap);
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        ComboProp typeComboProp = (ComboProp)dataEntityType.findProperty("type");
        ComboProp publishstatusComboProp = (ComboProp)dataEntityType.findProperty("publishstatus");
        Object defaultType = typeComboProp.getDefValue();
        Object defaultPublishstatus = publishstatusComboProp.getDefValue();
        long[] entryIds = DB.genLongIds((String)"t_pm_fplanentry", (int)(allInsertValueMap.size() * 4));
        int entryIdIndex = 0;
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int rowIndex = entryEntity.size();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("forecastplanscheme");
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList != null && !dateColumnList.isEmpty()) {
            EntryType dateType = null;
            for (int i = 0; i < allInsertValueMap.size(); ++i) {
                DynamicObject row = entryEntity.addNew();
                if (dateType == null) {
                    dateType = (EntryType)row.getDataEntityType();
                }
                Map oneRowValue = (Map)allInsertValueMap.get(i);
                row.set("id", (Object)entryIds[entryIdIndex]);
                row.set("type", defaultType);
                row.set("publishstatus", defaultPublishstatus);
                row.set("seq", (Object)(++rowIndex));
                for (Map.Entry entry : oneRowValue.entrySet()) {
                    String key = (String)entry.getKey();
                    IDataEntityProperty property = dateType.findProperty(key);
                    Object value = entry.getValue();
                    if (property instanceof BasedataProp && value != null) {
                        row.set(key + "_id", value);
                        continue;
                    }
                    row.set(key, value);
                }
                ++entryIdIndex;
                LinkedHashMap<String, BigDecimal> dateQtyMap = new LinkedHashMap<String, BigDecimal>(dateColumnList.size());
                for (String dateColumn : dateColumnList) {
                    BigDecimal qty = row.getBigDecimal(dateColumn);
                    dateQtyMap.put(dateColumn, qty);
                }
                String string = SerializationUtils.toJsonString(dateQtyMap);
                row.set("dateqtyjson_tag", (Object)string);
                List<DynamicObject> addRows = ForecastPlanBillHelper.getAddRows(row, ForecastPlanSchemeHelper.getSupplyTypeList((Long)scheme.getPkValue()), this.getDateColumnListForCacheModel(), true);
                for (DynamicObject addRow : addRows) {
                    addRow.set("seq", (Object)(++rowIndex));
                }
                entryEntity.addAll(addRows);
            }
            this.getModel().updateCache();
            this.getView().updateView("entryentity");
            this.setDateQtyEnable();
        }
    }

    private List<String> getDateColumnListForCacheModel() {
        List<Object> dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            IDataModel model = this.getModel();
            if (model == null) {
                return dateColumnList;
            }
            String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
            if (StringUtils.isNotBlank((CharSequence)dateColumnJson)) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
            } else {
                DynamicObject scheme = (DynamicObject)model.getValue("forecastplanscheme");
                Date date = (Date)model.getValue("planstartdate");
                if (scheme != null && date != null) {
                    Long schemeId = (Long)scheme.getPkValue();
                    dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, SerializationUtils.toJsonString(dateColumnList));
                }
            }
        }
        return dateColumnList;
    }

    private void setDateQtyEnable() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        List<String> dateColumnListForCacheModel = this.getDateColumnListForCacheModel();
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            String type = (String)this.getModel().getValue("type", i);
            if ("A".equals(billStatus) && SupplyTypeEnums.A.getValue().equals(type) || "C".equals(billStatus) && SupplyTypeEnums.C.getValue().equals(type)) {
                this.getView().setEnable(Boolean.TRUE, i, dateColumnListForCacheModel.toArray(new String[0]));
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, dateColumnListForCacheModel.toArray(new String[0]));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (OPKEY_IMPORTENTRY.equals(operateKey)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put(CACHE_KEY_MUSTINPUT, SerializationUtils.toJsonString(ForecastPlanBillHelper.getMustInputField()));
            op.getParameter().putAll(param);
        }
    }
}

