/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanBillHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import kd.scmc.pm.forecastplan.common.enums.PublishStatusEnums;
import kd.scmc.pm.forecastplan.common.enums.SupplyTypeEnums;

public class ForecastPlanBillPlugin
extends AbstractBillPlugIn
implements AfterF7SelectListener,
EntryGridBindDataListener {
    private static final String CACHE_KEY_SUPPLYTYPE = "cache_key_supplytype";
    private static final String CACHE_KEY_DATECOLUMN_LIST = "cache_key_datecolumn_list";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String SAVE = "save";
    private static final String UNSUBMIT = "unsubmit";
    private static final String CACHE_KEY_MUSTINPUT = "mustinput";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static String[] operateKeys = new String[]{"audit", "unaudit", "save", "unsubmit"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        if ("entryentity".equals(((EntryGrid)e.getSource()).getEntryKey())) {
            this.setDateQtyEnable();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDateQtyEnable();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("entryentity".equals(name)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities == null || rowDataEntities.length == 0) {
                return;
            }
            String batchAddRow = this.getPageCache().get("isManualAddRow");
            if (batchAddRow != null && Boolean.TRUE.equals(Boolean.parseBoolean(batchAddRow))) {
                this.getPageCache().remove("isManualAddRow");
                int addRowCount = rowDataEntities.length;
                List<String> dateColumnList = this.getDateColumnListForCacheModel();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                long[] entryPks = DB.genLongIds((String)"t_pm_fplanentry", (int)addRowCount);
                int pkIndex = 0;
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    DynamicObject row = rowDataEntity.getDataEntity();
                    row.set("id", (Object)entryPks[pkIndex]);
                    int seq = row.getInt("seq");
                    Object groupId = row.get("entrygroupid");
                    String supplyType = row.getString("type");
                    if (!SupplyTypeEnums.A.getValue().equals(supplyType) || groupId != null && (Long)groupId != 0L) continue;
                    List<String> typeList = this.getSupplyTypeListForCache();
                    List<DynamicObject> addRows = ForecastPlanBillHelper.getAddRows(row, typeList, dateColumnList, true);
                    for (DynamicObject addRow : addRows) {
                        addRow.set("seq", (Object)(++seq));
                    }
                    entryEntity.addAll(addRows);
                    this.getModel().setDataChanged(false);
                    this.getView().updateView("entryentity");
                    this.setDateQtyEnable();
                    return;
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("material".equals(key)) {
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            if (listSelectedRowCollection == null || listSelectedRowCollection.size() < 2) {
                return;
            }
            List<String> typeList = this.getSupplyTypeListForCache();
            List<String> dateColumnList = this.getDateColumnListForCacheModel();
            DynamicObjectCollection billEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            int addNewStartRowSeq = e.getCurrentRowIndex() + 2;
            int addNewStartRowSeq2 = e.getCurrentRowIndex() + 2;
            int addNewSize = listSelectedRowCollection.size() - 1;
            int addNewEndRowSeq = addNewStartRowSeq + addNewSize - 1;
            int addNewEndRwoIncoludBatchAddROwIndex = addNewEndRowSeq + typeList.size();
            long[] entryPks = DB.genLongIds((String)"t_pm_fplanentry", (int)addNewSize);
            int currentBillEntrySize = billEntry.size();
            int oneGroupSize = listSelectedRowCollection.size();
            int seq = 1;
            int pkIndex = 0;
            for (int i = 1; i <= currentBillEntrySize; ++i) {
                List<DynamicObject> addRows;
                DynamicObject row2 = (DynamicObject)billEntry.get(i - 1);
                int seqNum = row2.getInt("seq");
                if (seqNum < addNewStartRowSeq) {
                    ++seq;
                    continue;
                }
                if (i == addNewStartRowSeq) {
                    seq = oneGroupSize + seq++ + 1;
                    row2.set("seq", (Object)seq++);
                    row2.set("id", (Object)entryPks[pkIndex++]);
                    addRows = ForecastPlanBillHelper.getAddRows(row2, typeList, dateColumnList, true);
                    for (DynamicObject addRow : addRows) {
                        addRow.set("seq", (Object)seq++);
                    }
                    billEntry.addAll(addRows);
                    continue;
                }
                if (i > addNewStartRowSeq && i <= addNewEndRowSeq) {
                    row2.set("seq", (Object)seq++);
                    row2.set("id", (Object)entryPks[pkIndex++]);
                    addRows = ForecastPlanBillHelper.getAddRows(row2, typeList, dateColumnList, true);
                    for (DynamicObject addRow : addRows) {
                        addRow.set("seq", (Object)seq++);
                    }
                    billEntry.addAll(addRows);
                    continue;
                }
                if (i > addNewEndRowSeq && i <= addNewEndRwoIncoludBatchAddROwIndex) {
                    row2.set("seq", (Object)addNewStartRowSeq2++);
                    continue;
                }
                row2.set("seq", (Object)seq++);
            }
            Collections.sort(billEntry, Comparator.comparingInt(row -> row.getInt("seq")));
            this.getView().updateView("unit", e.getCurrentRowIndex() + 1);
            this.getView().updateView("entryentity");
            this.setDateQtyEnable();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate) {
            String key;
            FormOperate operate = (FormOperate)e.getSource();
            switch (key = operate.getOperateKey()) {
                case "newentry": {
                    this.getPageCache().put("isManualAddRow", Boolean.TRUE.toString());
                    break;
                }
                case "deleteentry": {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                    int[] rowIndexs = entryGrid.getSelectRows();
                    if (rowIndexs == null || rowIndexs.length == 0) {
                        return;
                    }
                    ArrayList<Integer> rowIndexList = new ArrayList<Integer>(10);
                    for (int rowIndex : rowIndexs) {
                        rowIndexList.add(rowIndex);
                    }
                    for (int rowIndex : rowIndexs) {
                        String publishStatus = (String)this.getModel().getValue("publishstatus", rowIndex);
                        if (PublishStatusEnums.A.getValue().equals(publishStatus)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u672a\u53d1\u5e03\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"ForecastPlanBillPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    HashSet<Integer> joinRows = this.getJoinRows(rowIndexList);
                    if (joinRows.size() == rowIndexList.size()) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u7236\u884c\u4ee5\u53ca\u6240\u6709\u7684\u5b50\u884c\uff0c\u8fdb\u884c\u5220\u9664\u3002", (String)"ForecastPlanBillPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "exportentry": {
                    this.getPageCache().put(CACHE_KEY_MUSTINPUT, SerializationUtils.toJsonString(ForecastPlanBillHelper.getMustInputField()));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (Arrays.asList(operateKeys).contains(operateKey)) {
            this.setDateQtyEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        block16: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            switch (key) {
                case "material": {
                    Long materialId = newValue instanceof DynamicObject ? (Long)((DynamicObject)newValue).getPkValue() : null;
                    this.setChildRowValue("material", materialId, rowIndex);
                    continue block16;
                }
                case "forecastplanscheme": {
                    this.getPageCache().remove(CACHE_KEY_SUPPLYTYPE);
                    continue block16;
                }
                case "unit": {
                    Long unitId = newValue instanceof DynamicObject ? (Long)((DynamicObject)newValue).getPkValue() : null;
                    this.setChildRowValue("unit", unitId, rowIndex);
                    continue block16;
                }
                case "supplier": {
                    Long supplierId = newValue instanceof DynamicObject ? (Long)((DynamicObject)newValue).getPkValue() : null;
                    this.setChildRowValue("supplier", supplierId, rowIndex);
                    continue block16;
                }
                case "operator": {
                    Long opratorId = newValue instanceof DynamicObject ? (Long)((DynamicObject)newValue).getPkValue() : null;
                    this.setChildRowValue("operator", opratorId, rowIndex);
                    continue block16;
                }
                case "entrycomment": {
                    String entryComment = (String)newValue;
                    this.setChildRowValue("entrycomment", entryComment, rowIndex);
                    continue block16;
                }
                default: {
                    this.changeDateQty(key, rowIndex);
                }
            }
        }
    }

    private void setDateQtyEnable() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        List<String> dateColumnListForCacheModel = this.getDateColumnListForCacheModel();
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            String type = (String)this.getModel().getValue("type", i);
            if ("A".equals(billStatus) && SupplyTypeEnums.A.getValue().equals(type) || "C".equals(billStatus) && SupplyTypeEnums.C.getValue().equals(type)) {
                this.getView().setEnable(Boolean.TRUE, i, dateColumnListForCacheModel.toArray(new String[0]));
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, dateColumnListForCacheModel.toArray(new String[0]));
        }
    }

    private HashSet<Integer> getJoinRows(List<Integer> rowIndexList) {
        HashSet<Integer> joinRows = new HashSet<Integer>(10);
        joinRows.addAll(rowIndexList);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (Integer rowIndex : rowIndexList) {
            int i;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
            String type = entryRowEntity.getString("type");
            if (SupplyTypeEnums.A.getValue().equals(type)) {
                Long id = (Long)entryRowEntity.getPkValue();
                if (id == null || id == 0L) continue;
                for (i = 0; i < entryRowCount; ++i) {
                    Long groupId = (Long)this.getModel().getValue("entrygroupid", i);
                    if (groupId == null || id.longValue() != groupId.longValue()) continue;
                    joinRows.add(i);
                }
                continue;
            }
            Long groupId = entryRowEntity.getLong("entrygroupid");
            if (groupId == null || groupId == 0L) continue;
            for (i = 0; i < entryRowCount; ++i) {
                Long id = (Long)this.getModel().getValue("entryentity.id", i);
                Long chiledGroupId = (Long)this.getModel().getValue("entrygroupid", i);
                if (id != null && id.longValue() == groupId.longValue()) {
                    joinRows.add(i);
                    continue;
                }
                if (chiledGroupId == null || chiledGroupId.longValue() != groupId.longValue()) continue;
                joinRows.add(i);
            }
        }
        return joinRows;
    }

    private void changeDateQty(String key, int rowIndex) {
        IDataModel model = this.getModel();
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList != null && dateColumnList.contains(key)) {
            String type = (String)model.getValue("type", rowIndex);
            if (SupplyTypeEnums.A.getValue().equals(type) || SupplyTypeEnums.C.getValue().equals(type)) {
                this.calDateQty4Gap(rowIndex);
            }
        }
    }

    private void calDateQty4Gap(int rowIndex) {
        List<String> dateColumnList;
        IDataModel model = this.getModel();
        List<String> supplyTypeListForCache = this.getSupplyTypeListForCache();
        if (supplyTypeListForCache != null && supplyTypeListForCache.contains(SupplyTypeEnums.D.getValue()) && (dateColumnList = this.getDateColumnListForCacheModel()) != null) {
            for (String dateColumn : dateColumnList) {
                String preDateColumn = this.getPreDateClumn(dateColumn, dateColumnList);
                BigDecimal req = ZERO;
                BigDecimal supply = ZERO;
                BigDecimal adjust = ZERO;
                BigDecimal gap = ZERO;
                BigDecimal preGap = ZERO;
                int gapIndex = 0;
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(10);
                rowIndexList.add(rowIndex);
                HashSet<Integer> joinRows = this.getJoinRows(rowIndexList);
                for (Integer joinRow : joinRows) {
                    int index = joinRow;
                    String type = (String)model.getValue("type", index);
                    if (SupplyTypeEnums.A.getValue().equals(type)) {
                        req = (BigDecimal)model.getValue(dateColumn, index);
                        continue;
                    }
                    if (SupplyTypeEnums.B.getValue().equals(type)) {
                        supply = (BigDecimal)model.getValue(dateColumn, index);
                        continue;
                    }
                    if (SupplyTypeEnums.C.getValue().equals(type)) {
                        adjust = (BigDecimal)model.getValue(dateColumn, index);
                        continue;
                    }
                    if (!SupplyTypeEnums.D.getValue().equals(type)) continue;
                    gapIndex = index;
                    if (!StringUtils.isNotBlank((CharSequence)preDateColumn)) continue;
                    preGap = (BigDecimal)model.getValue(preDateColumn, index);
                }
                gap = adjust.compareTo(ZERO) == 0 ? supply.subtract(req).add(preGap) : adjust.subtract(req).add(preGap);
                if (gapIndex == 0) continue;
                model.setValue(dateColumn, (Object)gap, gapIndex);
            }
        }
    }

    private String getPreDateClumn(String key, List<String> dateColumnList) {
        String preDateColumn = null;
        if (dateColumnList == null || key == null) {
            return preDateColumn;
        }
        for (String dateColumn : dateColumnList) {
            if (dateColumn != null && dateColumn.equals(key)) {
                return preDateColumn;
            }
            preDateColumn = dateColumn;
        }
        return null;
    }

    private void setChildRowValue(String entryKey, Object entryValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
        String type = entryRowEntity.getString("type");
        Long groupId = entryRowEntity.getLong("entrygroupid");
        Long id = (Long)entryRowEntity.getPkValue();
        if (id == null || id == 0L) {
            return;
        }
        int entryRowCount = model.getEntryRowCount("entryentity");
        if (SupplyTypeEnums.A.getValue().equals(type) && (groupId == null || groupId == 0L)) {
            for (int i = 0; i < entryRowCount; ++i) {
                Long childGroupId = (Long)model.getValue("entrygroupid", i);
                if (id == null || childGroupId == null || id.longValue() != childGroupId.longValue()) continue;
                model.setValue(entryKey, entryValue, i);
            }
        }
    }

    private List<String> getSupplyTypeListForCache() {
        List<Object> result = new ArrayList();
        String cache = this.getPageCache().get(CACHE_KEY_SUPPLYTYPE);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            result = SerializationUtils.fromJsonStringToList((String)cache, String.class);
        } else {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("forecastplanscheme");
            if (scheme != null) {
                Long schemeId = (Long)scheme.getPkValue();
                result = ForecastPlanSchemeHelper.getSupplyTypeList(schemeId);
                this.getPageCache().put(CACHE_KEY_SUPPLYTYPE, SerializationUtils.toJsonString(result));
            }
        }
        return result;
    }

    private List<String> getDateColumnListForCacheModel() {
        List<Object> dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            IDataModel model = this.getModel();
            if (model == null) {
                return dateColumnList;
            }
            String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
            if (StringUtils.isNotBlank((CharSequence)dateColumnJson)) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
            } else {
                DynamicObject scheme = (DynamicObject)model.getValue("forecastplanscheme");
                Date date = (Date)model.getValue("planstartdate");
                if (scheme != null && date != null) {
                    Long schemeId = (Long)scheme.getPkValue();
                    dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, SerializationUtils.toJsonString(dateColumnList));
                }
            }
        }
        return dateColumnList;
    }
}

