/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scmc.pm.forecast.business.helper.DateHelper;
import kd.scmc.pm.forecastplan.business.helper.ForecastPlanSchemeHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ForecastPlanTplExportPlugin
extends AbstractBillPlugIn {
    private static final String CACHE_KEY_DATECOLUMN_LIST = "cache_key_datecolumn_list";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String CACHE_KEY_MUSTINPUT = "mustinput";
    private static String[] noExportKeys = new String[]{"dateqtyjson", "qty", "srcbillentity", "srcbillno", "srcbillid", "srcbillentryseq", "srcbillentryid", "entrymodifier", "entrycreator", "entrycreatetime", "entrymodifytime"};

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String errorMsg;
        super.beforeDoOperation(e);
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        if ("exportentry".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(errorMsg = this.checkMustInput()))) {
            e.setCancel(true);
            this.getView().showTipNotification(errorMsg);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("exportentry".equals(operateKey)) {
            this.batchDealDateQty();
            this.export();
        }
    }

    private void batchDealDateQty() {
        IDataModel model = this.getModel();
        List<String> dateColumnList = this.getDateColumnListForCacheModel();
        if (dateColumnList != null && !dateColumnList.isEmpty()) {
            DynamicObjectCollection billEntrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject row : billEntrys) {
                LinkedHashMap<String, BigDecimal> dateQtyMap = new LinkedHashMap<String, BigDecimal>(dateColumnList.size());
                for (String dateColumn : dateColumnList) {
                    BigDecimal qty = row.getBigDecimal(dateColumn);
                    dateQtyMap.put(dateColumn, qty);
                }
                String dateQtyJson = SerializationUtils.toJsonString(dateQtyMap);
                row.set("dateqtyjson_tag", (Object)dateQtyJson);
            }
        }
    }

    private List<String> getDateColumnListForCacheModel() {
        List<Object> dateColumnList = new ArrayList(16);
        String dateColumnCache = this.getPageCache().get(CACHE_KEY_DATECOLUMN_LIST);
        if (StringUtils.isNotBlank((CharSequence)dateColumnCache)) {
            dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnCache, String.class);
        } else {
            IDataModel model = this.getModel();
            if (model == null) {
                return dateColumnList;
            }
            String dateColumnJson = (String)model.getValue("datecolumnjson_tag");
            if (StringUtils.isNotBlank((CharSequence)dateColumnJson)) {
                dateColumnList = SerializationUtils.fromJsonStringToList((String)dateColumnJson, String.class);
            } else {
                DynamicObject scheme = (DynamicObject)model.getValue("forecastplanscheme");
                Date date = (Date)model.getValue("planstartdate");
                if (scheme != null && date != null) {
                    Long schemeId = (Long)scheme.getPkValue();
                    dateColumnList = ForecastPlanSchemeHelper.getDateColumnList(schemeId, date);
                    this.getPageCache().put(CACHE_KEY_DATECOLUMN_LIST, SerializationUtils.toJsonString(dateColumnList));
                }
            }
        }
        return dateColumnList;
    }

    private String checkMustInput() {
        IDataModel model = this.getModel();
        String dateColumJson = (String)model.getValue("datecolumnjson_tag");
        if (StringUtils.isBlank((CharSequence)dateColumJson)) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9884\u6d4b\u8ba1\u5212\u65b9\u6848\u548c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ForecastPlanTplExportPlugin_6", (String)"scmc-pm-forecast", (Object[])new Object[0]);
        }
        return null;
    }

    private void export() {
        this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa...", (String)"ForecastPlanTplExportPlugin_1", (String)"scmc-pm-forecast", (Object[])new Object[0])), 0);
        try (SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            IFormView entryView = this.getView();
            EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
            List<Control> keys = entryGrid.getItems();
            List<String> enableImportKeys = this.getExportKeys(this.getModel().getDataEntityType(), keys);
            List<String> noExportKeyList = this.getNoExportKeys();
            keys = keys.stream().filter(control -> enableImportKeys.contains(control.getKey()) && !noExportKeyList.contains(control.getKey())).collect(Collectors.toList());
            DynamicObjectCollection entryEntityAll = entryView.getModel().getEntryEntity("entryentity");
            DynamicObjectCollection entryEntity = new DynamicObjectCollection();
            for (DynamicObject entry : entryEntityAll) {
                if (entry.containsProperty("type")) {
                    String type = entry.getString("type");
                    if (!"A".equals(type)) continue;
                    entryEntity.add((Object)entry);
                    continue;
                }
                entryEntity.add((Object)entry);
            }
            String dateColum = (String)this.getModel().getValue("datecolumnjson_tag");
            List dateColumList = (List)SerializationUtils.fromJsonString((String)dateColum, List.class);
            DataEntityPropertyCollection properties = entryEntityAll.getDynamicObjectType().getProperties();
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            SXSSFSheet sheet = sxssfWorkbook.createSheet(dataEntityType.getDisplayName().toString());
            SXSSFRow fristRow = this.initHeadRow(sxssfWorkbook, sheet, properties, dateColumList, keys);
            SXSSFRow secondRow = this.initSercondRow(sxssfWorkbook, sheet, fristRow, dataEntityType, dateColumList);
            CellStyle unlockCellStyle = sxssfWorkbook.createCellStyle();
            unlockCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            unlockCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            unlockCellStyle.setLocked(false);
            CellStyle lockCellStyle = sxssfWorkbook.createCellStyle();
            lockCellStyle.setLocked(false);
            CellStyle cellStyleGAP = sxssfWorkbook.createCellStyle();
            cellStyleGAP.setLocked(false);
            Font font = sxssfWorkbook.createFont();
            font.setColor((short)10);
            cellStyleGAP.setFont(font);
            int entryEntitySize = entryEntity.size();
            for (int i = 0; i < entryEntitySize; ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String dateqtyjson_tag = dynamicObject.getString("dateqtyjson_tag");
                Map qtyMap = new HashMap(10);
                if (StringUtils.isNotBlank((CharSequence)dateqtyjson_tag)) {
                    qtyMap = (Map)SerializationUtils.fromJsonString((String)dateqtyjson_tag, Map.class);
                }
                SXSSFRow row = sheet.createRow(i + 2);
                int lastCellNum = fristRow.getLastCellNum();
                for (int j = 0; j < lastCellNum; ++j) {
                    String obj;
                    SXSSFCell cell1 = fristRow.getCell(j);
                    String stringCellValue = cell1.getStringCellValue();
                    SXSSFCell cell = row.createCell(j, CellType.STRING);
                    if ("id".equals(stringCellValue)) {
                        Object pkValue = dynamicObject.getPkValue();
                        if (pkValue == null) continue;
                        cell.setCellStyle(lockCellStyle);
                        cell.setCellValue(String.valueOf(pkValue));
                        continue;
                    }
                    if (stringCellValue.indexOf(".") > 0) {
                        String[] split = stringCellValue.split("\\.");
                        String s = split[0];
                        String s1 = split[1];
                        DynamicObject baseData = (DynamicObject)dynamicObject.get(s);
                        String cellValue = "";
                        if (baseData != null) {
                            if ("operator".equals(s)) {
                                if ("name".equals(s1)) {
                                    cellValue = baseData.get("operatorname").toString();
                                } else if ("number".equals(s1)) {
                                    cellValue = (String)baseData.get("operatornumber");
                                }
                                cell.setCellValue(cellValue);
                                continue;
                            }
                            if ("name".equals(s1)) {
                                cellValue = baseData.get("name").toString();
                            } else if ("number".equals(s1)) {
                                cellValue = (String)baseData.get("number");
                            }
                        }
                        cell.setCellValue(cellValue);
                        continue;
                    }
                    if (stringCellValue.indexOf("dateqty") != -1) {
                        SXSSFCell dateCell = secondRow.getCell(j);
                        String dateValue = dateCell.getStringCellValue();
                        Object qty = qtyMap.get(dateValue);
                        if (qty == null) continue;
                        cell.setCellType(CellType.STRING);
                        cell.setCellValue(Double.parseDouble(qty.toString()));
                        continue;
                    }
                    if (stringCellValue.indexOf("date") != -1) {
                        Date date = dynamicObject.getDate(stringCellValue);
                        if (date == null) continue;
                        String format = this.sdf.format(date);
                        cell.setCellValue(format);
                        cell.setCellType(CellType.STRING);
                        continue;
                    }
                    IDataEntityProperty property = dataEntityType.findProperty(stringCellValue);
                    String string = obj = dynamicObject.get(stringCellValue) == null ? "" : dynamicObject.get(stringCellValue);
                    if (property instanceof ComboProp && obj instanceof String) {
                        ComboProp comboProp = (ComboProp)property;
                        List comboItems = comboProp.getComboItems();
                        String valueName = "";
                        for (ValueMapItem item : comboItems) {
                            String value = item.getValue();
                            if (!value.equals(obj)) continue;
                            valueName = item.getName().toString();
                            break;
                        }
                        obj = valueName;
                    }
                    cell.setCellValue(obj.toString());
                    cell.setCellType(CellType.STRING);
                }
            }
            this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u8f7d...", (String)"ForecastPlanTplExportPlugin_2", (String)"scmc-pm-forecast", (Object[])new Object[0])), 99);
            this.setColWidth(sheet);
            sxssfWorkbook.write((OutputStream)outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String fileNameTemp = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            String fileName = fileNameTemp + "_".concat(DateHelper.getCurrentDate().concat(".xlsx"));
            String tempUrl = cache.saveAsUrl(fileName, (InputStream)inStream, 7200);
            this.getView().download(tempUrl);
            inStream.close();
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private SXSSFRow initSercondRow(SXSSFWorkbook sxssfWorkbook, SXSSFSheet sheet, SXSSFRow fristRow, MainEntityType dataEntityType, List<String> dateColumList) {
        SXSSFRow secondRow = sheet.createRow(1);
        sheet.createFreezePane(0, 1);
        CellStyle titleStyle = sxssfWorkbook.createCellStyle();
        CellStyle mustInputStyle = this.getMustInputStyle(sxssfWorkbook);
        titleStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setLocked(false);
        int lastCellNum = fristRow.getLastCellNum();
        int dateIndex = 1;
        List<String> mustInPutFieldKey = this.getMustInPutFieldKey();
        for (int i = 0; i < lastCellNum; ++i) {
            SXSSFCell createCell;
            SXSSFCell cell = fristRow.getCell(i);
            String stringCellValue = cell.getStringCellValue();
            if (stringCellValue.indexOf(".") > 0) {
                String[] split = stringCellValue.split("\\.");
                IDataEntityProperty property = dataEntityType.findProperty(split[0]);
                SXSSFCell createCell2 = secondRow.createCell(i, CellType.STRING);
                createCell2.setCellStyle(titleStyle);
                String showName = split[1];
                if ("number".equals(showName)) {
                    showName = String.format(ResManager.loadKDString((String)"%1$s.\u7f16\u7801", (String)"ForecastPlanTplExportPlugin_9", (String)"scmc-pm-forecast", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
                    if (mustInPutFieldKey.contains(property.getName())) {
                        showName = "*" + showName;
                        createCell2.setCellStyle(mustInputStyle);
                    }
                } else if ("name".equals(showName)) {
                    showName = String.format(ResManager.loadKDString((String)"%1$s.\u540d\u79f0", (String)"ForecastPlanTplExportPlugin_8", (String)"scmc-pm-forecast", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
                }
                createCell2.setCellValue(showName);
                continue;
            }
            if (stringCellValue.indexOf("dateqty") != -1) {
                String s = dateColumList.get(dateIndex++ - 1);
                createCell = secondRow.createCell(i, CellType.STRING);
                createCell.setCellStyle(mustInputStyle);
                createCell.setCellValue(s);
                continue;
            }
            if ("id".equals(stringCellValue)) {
                SXSSFCell createCell3 = secondRow.createCell(i, CellType.STRING);
                createCell3.setCellStyle(titleStyle);
                createCell3.setCellValue(ResManager.loadKDString((String)"\u5185\u7801", (String)"ForecastPlanTplExportPlugin_5", (String)"scmc-pm-forecast", (Object[])new Object[0]));
                continue;
            }
            IDataEntityProperty property = dataEntityType.findProperty(stringCellValue);
            if (property == null) continue;
            createCell = secondRow.createCell(i, CellType.STRING);
            createCell.setCellStyle(titleStyle);
            createCell.setCellValue(property.getDisplayName().toString());
        }
        return secondRow;
    }

    private SXSSFRow initHeadRow(SXSSFWorkbook sxssfWorkbook, SXSSFSheet sheet, DataEntityPropertyCollection properties, List<String> dateColumList, List<Control> keys) {
        SXSSFRow headRow = sheet.createRow(0);
        headRow.setHeight(Short.parseShort("0"));
        CellStyle keyStyle = sxssfWorkbook.createCellStyle();
        keyStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        keyStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        keyStyle.setLocked(true);
        SXSSFCell idCell = headRow.createCell(0, CellType.STRING);
        idCell.setCellStyle(keyStyle);
        idCell.setCellValue("id");
        int cellIndex = 1;
        int keyIndex = 0;
        while (keyIndex < keys.size()) {
            Control control = keys.get(keyIndex);
            String key = control.getKey();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
            SXSSFCell createCell = null;
            if (property instanceof BasedataProp) {
                createCell = headRow.createCell(cellIndex++, CellType.STRING);
                String strnumber = property.getName() + ".number";
                createCell.setCellStyle(keyStyle);
                createCell.setCellValue(strnumber);
                SXSSFCell createCell2 = headRow.createCell(cellIndex++, CellType.STRING);
                String strName = property.getName() + ".name";
                createCell2.setCellStyle(keyStyle);
                createCell2.setCellValue(strName);
            } else {
                if (dateColumList.contains(key)) continue;
                createCell = headRow.createCell(cellIndex++, CellType.STRING);
                createCell.setCellStyle(keyStyle);
                createCell.setCellValue(property.getName());
            }
            ++keyIndex;
        }
        for (int i = 0; i < dateColumList.size(); ++i) {
            SXSSFCell createCell = headRow.createCell(cellIndex++, CellType.STRING);
            createCell.setCellStyle(keyStyle);
            createCell.setCellValue("dateqty" + i);
        }
        return headRow;
    }

    private CellStyle getMustInputStyle(SXSSFWorkbook sxssfWorkbook) {
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        Font redFont = sxssfWorkbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(redFont);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private List<String> getNoExportKeys() {
        ArrayList<String> list = new ArrayList<String>(10);
        Collections.addAll(list, noExportKeys);
        return list;
    }

    private List<String> getExportKeys(MainEntityType dataEntityType, List<Control> keys) {
        ArrayList<String> importKeys = new ArrayList<String>();
        for (Control control : keys) {
            BasedataProp fieldProp;
            boolean exportable;
            String key = control.getKey();
            IDataEntityProperty property = dataEntityType.findProperty(key);
            if (property instanceof BasedataProp && (exportable = (fieldProp = (BasedataProp)property).isExportable())) {
                importKeys.add(key);
            }
            if (property instanceof QtyProp) {
                fieldProp = (QtyProp)property;
                exportable = fieldProp.isExportable();
                if (!exportable) continue;
                importKeys.add(key);
                continue;
            }
            if (property instanceof DateTimeProp) {
                fieldProp = (DateTimeProp)property;
                exportable = fieldProp.isExportable();
                if (!exportable) continue;
                importKeys.add(key);
                continue;
            }
            if (property instanceof ComboProp) {
                fieldProp = (ComboProp)property;
                exportable = fieldProp.isExportable();
                if (!exportable) continue;
                importKeys.add(key);
                continue;
            }
            if (property instanceof DateProp) {
                fieldProp = (DateProp)property;
                exportable = fieldProp.isExportable();
                if (!exportable) continue;
                importKeys.add(key);
                continue;
            }
            if (!(property instanceof TextProp) || !(exportable = (fieldProp = (TextProp)property).isExportable())) continue;
            importKeys.add(key);
        }
        return importKeys;
    }

    protected void setColWidth(SXSSFSheet sheet) {
        int maxColumn = sheet.getRow(sheet.getLastRowNum()).getPhysicalNumberOfCells();
        IntStream.range(0, maxColumn).forEach(columnNum -> sheet.setColumnWidth(columnNum, 5111));
    }

    private List<String> getMustInPutFieldKey() {
        List<String> list = new ArrayList<String>();
        String mustInputString = this.getPageCache().get(CACHE_KEY_MUSTINPUT);
        if (StringUtils.isBlank((CharSequence)mustInputString)) {
            return list;
        }
        list = (List)SerializationUtils.fromJsonString((String)mustInputString, List.class);
        return list;
    }
}

