/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.forecastplan.formplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ForecastPlanTplListExportPlugin
extends AbstractListPlugin {
    private static final String OPKEY_EXPORT = "export";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList control;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OPKEY_EXPORT.equalsIgnoreCase(operateKey) && ((selectedRows = (control = (BillList)this.getControl("billlistap")).getSelectedRows()).isEmpty() || selectedRows.size() > 1)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"ForecastPlanTplListExportPlugin_0", (String)"scmc-pm-forecast", (Object[])new Object[0]));
            return;
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] bills = e.getQueryValues();
        if (bills == null || bills.length == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        String fromId = null;
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            if (fromId == null) {
                fromId = bill.getDataEntityType().getName();
            }
            Long pkValue = (Long)bill.getPkValue();
            ids.add(pkValue);
        }
        if (!ids.isEmpty()) {
            this.getPageCache().put("billid", SerializationUtils.toJsonString(ids));
            this.getPageCache().put("entityId", fromId);
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        if (file != null) {
            String billid = this.getPageCache().get("billid");
            String entityId = this.getPageCache().get("entityId");
            ArrayList<DynamicObject> dy = null;
            if (StringUtils.isNotEmpty((String)billid) && StringUtils.isNotEmpty((String)entityId)) {
                List ids = (List)SerializationUtils.fromJsonString((String)billid, List.class);
                dy = new ArrayList<DynamicObject>(Arrays.asList(BusinessDataServiceHelper.load((String)entityId, (String)"datecolumnjson,datecolumnjson_tag,entryentity.dateqtyjson,entryentity.dateqtyjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})));
            }
            if (dy == null || dy.isEmpty()) {
                return;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook oldWb = new XSSFWorkbook((InputStream)fis);
                XSSFSheet oldSheet = oldWb.getSheetAt(0);
                XSSFCellStyle cellStyle = oldWb.createCellStyle();
                List<String> attrList = this.loadExcelAttr(oldSheet);
                Map<String, Integer> dateNodeMap = this.appendDateNode2Sheet((Sheet)oldSheet, cellStyle, dy);
                this.writeSheet(oldWb, oldSheet, attrList, dateNodeMap, dy);
                FileOutputStream out = new FileOutputStream(file);
                oldWb.write((OutputStream)out);
                out.close();
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode("ForecastPlanBillLTplistExportPlugin", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)), new Object[0]);
            }
        }
    }

    private void writeSheet(XSSFWorkbook oldWb, XSSFSheet oldSheet, List<String> attrList, Map<String, Integer> dateNodeMap, List<DynamicObject> dy) {
        int rowIndex = 4;
        int rowCount = oldSheet.getPhysicalNumberOfRows();
        List<DynamicObject> bills = dy;
        XSSFCellStyle cellStyle = oldWb.createCellStyle();
        Map<Long, DynamicObject> entryIdAndEntryInfoMap = this.rebuildBillInfo(bills);
        int entryidIndex = attrList.indexOf("entryentity_id");
        if (entryidIndex == -1) {
            return;
        }
        oldSheet.setColumnHidden(entryidIndex, true);
        for (int i = rowIndex; i < rowCount; ++i) {
            String dateqtyjson_tag;
            XSSFRow row = oldSheet.getRow(i);
            XSSFCell entryIdCell = row.getCell(entryidIndex);
            Long entryid = Long.parseLong(entryIdCell.getStringCellValue());
            DynamicObject rowInfo = entryIdAndEntryInfoMap.get(entryid);
            if (rowInfo == null || StringUtils.isBlank((String)(dateqtyjson_tag = rowInfo.getString("dateqtyjson_tag")))) continue;
            Map map = (Map)SerializationUtils.fromJsonString((String)dateqtyjson_tag, Map.class);
            for (Map.Entry<String, Integer> entry : dateNodeMap.entrySet()) {
                String dateString = entry.getKey();
                Integer cellIndex = entry.getValue();
                XSSFCell cell = row.createCell(cellIndex.intValue(), CellType.STRING);
                Object qtyObj = map.get(dateString);
                BigDecimal qty = BigDecimal.ZERO;
                if (qtyObj == null) continue;
                if (qtyObj instanceof BigDecimal) {
                    qty = (BigDecimal)qtyObj;
                } else if (qtyObj instanceof Integer) {
                    qty = new BigDecimal((Integer)qtyObj);
                }
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(qty.toPlainString());
            }
        }
    }

    private Map<Long, DynamicObject> rebuildBillInfo(List<DynamicObject> bills) {
        HashMap<Long, DynamicObject> entryIdAndRowInfoMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) continue;
            for (DynamicObject row : entrys) {
                Long pkValue = (Long)row.getPkValue();
                entryIdAndRowInfoMap.put(pkValue, row);
            }
        }
        return entryIdAndRowInfoMap;
    }

    private Map<String, Integer> appendDateNode2Sheet(Sheet sheet, XSSFCellStyle cellStyle, List<DynamicObject> dy) {
        String datecolumnjson = (String)dy.get(0).get("datecolumnjson_tag");
        if (StringUtils.isBlank((String)datecolumnjson)) {
            return null;
        }
        String[] dateArray = datecolumnjson.replace("[", "").replace("]", "").replaceAll("\"", "").split(",");
        HashMap<String, Integer> dateNodeMap = new HashMap<String, Integer>(256);
        Row attrNameRow = sheet.getRow(3);
        Row attrNoRow = sheet.getRow(2);
        int cellIndex = attrNameRow.getPhysicalNumberOfCells();
        boolean flag = true;
        while (flag) {
            Cell cell = attrNameRow.getCell(--cellIndex);
            flag = StringUtils.isEmpty((String)this.getCellString(cell));
        }
        CellStyle style = attrNameRow.getCell(cellIndex).getCellStyle();
        attrNameRow.getCell(cellIndex).setCellStyle(style);
        int qtyIndex = 0;
        for (String dateStr : dateArray) {
            Cell cell = attrNameRow.createCell(++cellIndex, CellType.STRING);
            cell.setCellValue(dateStr);
            cell.setCellStyle(style);
            Cell cell2 = attrNoRow.createCell(cellIndex, CellType.STRING);
            cell2.setCellStyle((CellStyle)cellStyle);
            cell2.setCellValue("dateqty" + qtyIndex++);
            sheet.setColumnWidth(cellIndex, 4096);
            dateNodeMap.put(dateStr, cellIndex);
        }
        return dateNodeMap;
    }

    private String getCellString(Cell xssfCell) {
        if (xssfCell == null) {
            return "";
        }
        if (xssfCell.getCellType() == CellType.NUMERIC) {
            NumberFormat n = NumberFormat.getInstance();
            double d = xssfCell.getNumericCellValue();
            return n.format(d).replace(",", "");
        }
        if (xssfCell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(xssfCell.getBooleanCellValue());
        }
        return xssfCell.getStringCellValue();
    }

    private List<String> loadExcelAttr(XSSFSheet sheet) {
        ArrayList<String> attrList = new ArrayList<String>();
        XSSFRow attrCodeRow = sheet.getRow(2);
        int attrSize = attrCodeRow.getPhysicalNumberOfCells();
        for (int i = 0; i < attrSize; ++i) {
            String attrCode;
            XSSFCell attrCodeCell = attrCodeRow.getCell(i);
            if (attrCodeCell == null || !StringUtils.isNotEmpty((String)(attrCode = this.getCellString((Cell)attrCodeCell)))) continue;
            attrList.add(attrCode);
        }
        return attrList;
    }
}

